	PROGRAM RECALLABLE_DTR
C
C This program gives command line recall within Datatrieve by
C using SMG routines for command line recall and passing them
C to Datatrieve via the Call Interface.
C
C It was written by Dana Schwartz
C
C (re-formatted by B. Z. Lederman with some comments)
C
C This version has improvements over the first release:
C	specifically, it works with 132 column screens.
C
	IMPLICIT NONE
C
C Get the Datatrieve Access Block definitions.
C
	INCLUDE 'DTR$LIBRARY:DAB.FOR'
C
C Define variables to be used
C
	INTEGER*4 KEYBOARD, TABLE, INIT_OPTIONS, OPTIONS, TERM,
     1	      REC_LENGTH
C
C Note type of return from some DTR call points
C
	INTEGER*4 DTR_STATUS, DTR$DTR
C
C Define character buffers.  Note that, although the DAB defines
C a message and an auxiliary buffer, they aren't long enough for
C 132 column screens so replacements are defined here.
C
	CHARACTER LINE*255, MSG_BUFFER*132, AUX_BUFFER*132
C
C Note external call resolution.
C
	EXTERNAL DTR$_EXIT, SMG$K_TRM_CTRLZ, SMG$K_TRM_CR
C
C Initialize SMG
C
	CALL SMG$CREATE_VIRTUAL_KEYBOARD ( KEYBOARD )
	CALL SMG$CREATE_KEY_TABLE ( TABLE )
C
C Initialize Datatrieve
C
	INIT_OPTIONS = DTR$K_SEMI_COLON_OPT + DTR$K_UNQUOTED_LIT +
     1	       DTR$K_SYNTAX_PROMPT
	CALL DTR$INIT ( DAB, 100, MSG_BUFFER, AUX_BUFFER, INIT_OPTIONS )
C
C Check to see if DTR is up and O.K.
C
	OPTIONS = DTR$M_OPT_CONTROL_C + DTR$M_OPT_STARTUP +
     1	      DTR$M_OPT_FOREIGN   + DTR$M_OPT_BANNER  + DTR$M_OPT_CMD
	DTR_STATUS = DTR$DTR ( DAB, OPTIONS )
C
C Now: get input from the user.  If the user has not typed a
C Control-Z (meaning it's time to quit) and Datatrieve has
C not indicated it's time to quit (user typed in EXIT);
C get input from the user, pass it to Datatrieve,
C then retrieve anything DTR sends back and pass it to the user.
C
	TERM = %LOC(SMG$K_TRM_CR)
	DO WHILE (  ( DTR_STATUS .NE. %LOC(DTR$_EXIT)       )  .AND.
     1	      ( TERM       .NE. %LOC(SMG$K_TRM_CTRLZ) )  )
C
	    CALL SMG$READ_COMPOSED_LINE ( KEYBOARD, TABLE, LINE,
     1		  MSG_BUFFER(:DAB$W_MSG_LEN), REC_LENGTH,,,,,,, TERM )
C
	    CALL DTR$COMMAND ( DAB, LINE(:REC_LENGTH) )
C
	    DTR_STATUS = DTR$DTR ( DAB, OPTIONS )
C
	ENDDO
C
C Clean up and leave.
C
	CALL DTR$FINISH ( DAB )
C
	END
