	Subroutine SET_TERMINAL_CHARACTERISTICS (CHANNEL,
	1	CLASS, TYPE, WIDTH,
	2	BASIC, EXTENDED)

C	Title:	Set Terminal Characteristics
C
C	Version: 1.0
C
C	Functional Description:
C		Terminal characteristics are set depending upon which
C		bits are set in the longwords BASIC and EXTENDED.
C		Reference the Terminal Driver section of the VAX/VMS
C		I/O Reference manual.
C
C	CREATED 1986,	WARNER-LAMBERT COMPANY
C			CONSUMER HEALTH PRODUCTS GROUP
C			MILFORD CONN 06460
C
C	Author: Donald E. Stern, Jr.		Creation date: 16-Jan-1986
C
C
C
C	Modification History:
C
C	Ver.		Author		Date		Reason for change
C
C
C	Execution Enviroment:
C		VAX/VMS
C
C	Functions and Subroutines Called:
C		SYS$QIOW	- Reference System Services Manual
C		LIB$SIGNAL
C

C	I/O Operations Definitions
	INCLUDE		'($IODEF)'

C	QIO Status Block
	STRUCTURE 	/IOSTAT_BLOCK/
	     INTEGER*2	IOSTAT		!Return Status
	     BYTE	TRANSMIT,
	1		RECIEVE,
	2		CRFILL,
	3		LFFILL,
	4		PARITY,
	5		ZERO
	END STRUCTURE
	RECORD	/IOSTAT_BLOCK/ IOSB

C	Characteristics buffer passed to the QIOW system service
	STRUCTURE /CHARACTERISTICS/
	     BYTE	CLASS,
	1		TYPE
	     INTEGER*2	WIDTH
	     INTEGER*4	BASIC
	     INTEGER*4	EXTENDED
	END STRUCTURE
	RECORD /CHARACTERISTICS/ CHARBUF

C	Characteristics arguments passed to this subroutine
	INTEGER*2	CHANNEL		Channel of terminal to set
	BYTE		CLASS,
	1		TYPE
	INTEGER*2	WIDTH
	INTEGER*4	BASIC,
	1		EXTENDED


C	Subprograms
	INTEGER*4	SYS$QIOW

	INTEGER*4	STATUS			!Return status
	
C	Set the appropriate characteristics
	CHARBUF.CLASS    = CLASS
	CHARBUF.TYPE     = TYPE
	CHARBUF.WIDTH    = WIDTH
	CHARBUF.BASIC    = BASIC
	CHARBUF.EXTENDED = EXTENDED

C	Set the new terminal characteristics

	STATUS = SYS$QIOW(,
	1		  %VAL(CHANNEL),		!I/O Channel Number
	2		  %VAL(IO$_SETMODE),		!Sensemode Function Code
	3		  IOSB,,,			!I/O Status Block
	4		  CHARBUF,			!Characteristics buffer
	5		  %VAL(12),,,,)			!Buffer Size
	IF (.NOT. STATUS) CALL LIB$SIGNAL(%VAL(STATUS))
	IF (.NOT. IOSB.IOSTAT) CALL LIB$SIGNAL(%VAL(IOSB.IOSTAT))

	RETURN
	END
