$! Do some daily operations on the system.  Normally, comments would
$! be at the end, but I've put most of them into the file as it's
$! intended to be an example.
$!
$! This command file runs daily at midnight and resets some information
$! files.  At the end it invokes some Datatrieve procedures (see
$! DECUServe.DTR) to report on what happened on the system for
$! the previous day.
$!
$! B. Z. Lederman
$!
$ SHOW TIME
$!
$! Clean up some system things and repeat.
$!
$  yday = F$CVTIME( "YESTERDAY", "ABSOLUTE", "DAY")
$  ymon = F$CVTIME( "YESTERDAY", "ABSOLUTE", "MONTH")
$  tday = F$CVTIME( "TODAY", "ABSOLUTE", "DAY")
$  tmon = F$CVTIME( "TODAY", "ABSOLUTE", "MONTH")
$  host = F$GETSYI("NODENAME")
$!
$ SET NOON
$!
$! The following should be done (only) if you have PSI running.
$!
$  WRITE SYS$OUTPUT "Set new PSI accounting file"
$!
$ @PSIACCOUNTING on psiaccounting.'tday''tmon'
$!
$! Next, the System Accounting file is reset.
$!
$  WRITE SYS$OUTPUT "Set new System accounting file"
$!
$ SET ACCOUNTING/NEW_FILE
$ file = F$SEARCH("ACCOUNTNG.DAT;-1")
$ IF file .EQS. "" THEN file = F$SEARCH("ACCOUNTING.DAT;-1")
$ IF file .EQS. "" THEN GOTO errlog
$ RENAME 'file' accounting.'yday''ymon'
$!
$ errlog:
$!
$! Reset the error log to a new file each day.
$!
$  WRITE SYS$OUTPUT "Set new Error Log file"
$!
$ file = F$SEARCH("SYS$ERRORLOG:ERRLOG.SYS")
$ IF file .EQS. "" THEN GOTO oper
$!
$ RENAME 'file' SYS$ERRORLOG:errlog.'yday''ymon'
$!
$ oper:
$!
$! I'd really also like OPERATOR.LOG to be reset this day, but for
$! some reason the VMS developers won't allow this to be done
$! in batch.
$!
$ IF F$MODE() .NES. "INTERACTIVE" THEN GOTO nooper
$ REPLY/ENABLE	! unfortunately, won't work in batch
$ REPLY/LOG
$ file = F$SEARCH("SYS$MANAGER:OPERATOR.LOG;-1")
$ IF file .EQS. "" THEN GOTO nooper
$ RENAME 'file' OPERATOR.'yday''ymon'
$ REPLY/DISABLE
$!
$ nooper:
$!
$! Resubmit this batch job so everything keeps going on a daily basis.
$! Note that it runs in the SYSTEM account.  If you have a cluster,
$! you may want the node specific batch queue in the first (disabled)
$! line, others will want the generic SYS$BATCH.
$!
$! SUBMIT /KEEP /NOPRINT /USER=SYSTEM /AFTER:TOMORROW /QUEUE='host'_BATCH -
$ SUBMIT /KEEP /NOPRINT /USER=SYSTEM /AFTER:TOMORROW -
		SYS$MANAGER:DAILY.COM
$!
$! If you have the X.400 Message Router Gateway (MRX) you will probably
$! want to set new log files for that as well.
$!
$!  WRITE SYS$OUTPUT "Set new MRX Log file"
$!
$! RENAME mrx$:mrx$log.log.* mrx$:mrx$log_old.'yday''ymon'
$!
$! I find there are lots of files that "pile up" and aren't really
$! needed.
$!
$  WRITE SYS$OUTPUT "Purge some log files"
$!
$ PURGE SYS$MANAGER:DAILY.LOG
$ PURGE/LOG/KEEP=3 SYS$SYSDEVICE:[*...]NETSERVER.LOG, VOTS*.LOG
$ PURGE/LOG/KEEP=2 SYS$MANAGER:TLXSETUP.LOG, DDS$START.LOG, -
	MAILBUS_START.LOG, EVL.LOG
$!
$! Now I backup my user disk and system disks to spares which are
$! always kept on-line.  This may seem extravagant, but if you
$! consider what a system manager's time is worth, and what it
$! costs to replace lost work/data if a disk fails, the cost of
$! an extra disk on-line is really quite cheap.  Since the
$! device names and unit numbers will be installation specific,
$! the commands are commented out.
$!
$! Daily backup of user disk
$!
$! MOU/NOASSIST $1$DUA5: USERDISK1A
$! show time
$! BACKUP/FAST/VERIFY/LOG -
$!    USER$DEVICE:[*...]*.*/SINCE=BACKUP/RECORD -
$!    $1$DUA5:[*...]*.*/REPLACE/TRUNCATE/OWNER
$! show time
$! PURGE/NOLOG/KEEP=2 $1$DUA5:[*...]*.*
$! show time
$! DISMOUNT/NOUNLOAD $1$DUA5:
$!
$! Backup system disk
$!
$! MOU/NOASSIST $1$DUA1: VAXVMSRL4 BACKUPSYS
$! show time
$! BACKUP/FAST/VERIFY/LOG -
$!    SYS$SYSDEVICE:[*...]*.*/SINCE=BACKUP/RECORD/IGNORE=(INTER, NOBACKUP) -
$!    $1$DUA1:[*...]*.*/NEW_VERSION/TRUNCATE/OWNER
$! show time
$! PURGE/NOLOG/KEEP=2 $1$DUA1:[*...]*.*
$! show time
$! DISMOUNT/NOUNLOAD $1$DUA1:
$!
$! Now a program is used to convert the System Accounting file
$! to a read-able format.  I happen to put the converted file out
$! onto another disk.
$!
$! Process the accounting file.
$!
$ SET COMMAND SYS$MANAGER:ACC_CONVERT
$ ACC_CONVERT/OUT=$1$DUA9:[ACCOUNTING]ACCFIX.'yday''ymon accounting.'yday''ymon'
$ SET PROTECTION=WO:RE $1$DUA9:[ACCOUNTING]ACCFIX.'yday''ymon'
$!
$! At this point, unless the original accounting file is going to
$! be processed with the accounting utility, it can be deleted. Just
$! about everything wanted from System Accounting (except, at the
$! moment, print jobs) can be obtained from the converted file
$! and Datatrieve.
$!
$! A Logical name is assigned so that the current accounting
$! file can be found.
$!
$ ASSIGN/SYSTEM $1$DUA9:[ACCOUNTING]ACCFIX.'yday''ymon' ACCOUNTING_FILE
$!
$! I happen to have the definitions for doing the processing I want
$! in a particular dictionary, so..
$!
$ DEFINE CDD$DEFAULT "CDD$TOP.DTR$USERS.SYSTEM.LOGIN"
$!
$! Now the accounting file can be processed to extract useful information.
$! First, we update the login history file. (Reports are done later
$! on demand.)
$!
$ DTR; :LOGIN_HISTORY_FROM_ACC
$!
$! Produce a report of yesterday's login failures.
$!
$ DTR; :LOGFAIL_REPORT
logfail.rpt
$ RENAME logfail.rpt logfail'yday''ymon'.rpt
$!
$! Convert the day's traffic to a new MOD (Minute of Day) file
$! for traffic studies.
$!
$ DTR; :MOD_FROM_ACC
$!
$! Produce a report of yesterday's traffic.
$!
$ DTR; :MOD_ERLANG_REPORT
erlang.rpt
$ RENAME erlang.rpt erlang'yday''ymon'.rpt
$!
$! At this point, the reports can be copied or renamed to the
$! appropriate user, or mailed to them. The converted accounting
$! file can be saved or deleted at this point.
$!
$! The process can also be done for PSI accounting.
$!
$ EXIT
$!
$! B. Z. Lederman	28-Jan-1988 Example file.
