	!**********************************************************************
	!			CONSTANTS
	!**********************************************************************

	DECLARE WORD CONSTANT &
		TRUE = -1%, &
		FALSE = 0%, &
		MAX_MBX_SIZE = 128%,	!size of mailbox buffer &
		BRDCST_BUF_SIZE = MAX_MBX_SIZE - 22%, &
		MAX_BUF_CNT = 9%, 	!(number - 1) of input buffers &
		MAX_BUF_SIZE = 79%,	!(size - 1) of input buffers &
		MAX_LOG_SIZE = 511%,	!(size - 1) of log file buffer &
		MAX_LOG_SSIZE = MAX_LOG_SIZE + 1%,	!size of log file buf &
		IOSB_STATUS = 0%,	!IOSB offset for status word &
		IOSB_BUF_LEN = 1%,	!IOSB offset for buffer length &
		IOSB_TERM = 2%,		!IOSB offset for terminator &
		IOSB_TERM_SIZE = 3%	!IOSB offset for terminator size

	DECLARE LONG CONSTANT &
		LOG_FILE = 1%, 		!file # for log file &
		MENU_FILE = 2%,		!file # for menu file &
		PORTS_FILE = 3%,	!file # for ports file &
		RECORD_FILE = 4%,	!file # for record file &
		SCRIPT_FILE = 5%	!file # for script files (must be
					!highest #)

	!**********************************************************************
	!			RECORDS
	!**********************************************************************

	RECORD QUAD
	       	VARIANT
			CASE
				LONG	LOW_LONGWORD
				LONG	HIGH_LONGWORD
			CASE
				WORD	FIRST_WORD
				WORD	SECOND_WORD
				WORD	THIRD_WORD
				WORD	FOURTH_WORD
			CASE
				BYTE	SINGLE_BYTE(7)
		END VARIANT
	END RECORD

	RECORD PORT_INP_REC	!layout of a port input buffer...
		BYTE	BUF_FER(MAX_BUF_SIZE)	!input buffer itself
		WORD	BUF_IN_USE		!true if buffer in use
		WORD	BUF_PTR			!pointer to byte in buffer
		WORD	BUF_CNT			!number of bytes in buffer
		WORD	IOSB(3)			!IO status block
	END RECORD

	RECORD MBX_REC		!layout for mailbox input buffer...
		WORD	MBX_TYPE		!message type
		WORD	MBX_UNIT		!unit number
		BYTE	MBX_CTRL_LEN		!controller name length
		STRING	MBX_CTRL = 15		!controller name
		WORD	MBX_MSG_LEN		!broadcast message length
		STRING	MBX_MSG = BRDCST_BUF_SIZE !broadcast message
	END RECORD

	!**********************************************************************
	!			COMMONS
	!**********************************************************************

	COMMON (DEVICE_MODE_COM) &
		LONG	OLD_PORT_MODE(2),	!port mode on entry &
		LONG	OLD_TERM_MODE(2),	!terminal mode on entry &
		LONG	PORT_MODE(2),		!new port mode &
		LONG	TERM_MODE(2)		!new terminal mode 

	COMMON (MENU_SELECTION_COM) &
		STRING	FACILITY_CODE = 20,	!code for facility &
		STRING	FACILITY_NAME = 80,	!display name of facility &
		STRING	NODE_NAME = 20,		!name of node &
		STRING	PORT_NAME = 10,		!name of selected port &
		STRING	MODEM_CLASS = 20,	!class of modem &
		STRING	MODEM_TYPE = 20		!type of modem

	COMMON (PORT_READ_COM) &
		WORD	TERM_CHAN,	!channel for terminal &
		WORD	PORT_CHAN,	!channel for modem port &
		WORD	MBX_CHAN,	!channel for mailbox &
		MBX_REC	MBX_BUF,	!mailbox buffer &
		WORD	MBX_IOSB(3),	!IOSB for mailbox &
		PORT_INP_REC	PORT_BUF(MAX_BUF_CNT),	!input buffers &
		LONG	CURRENT_BUF,	!current input buffer &
		WORD	BUFS_USED,	!# of buffers in use &
		WORD	BUF_ATTEMPTS,	!# attempts to get a buffer &
		WORD	VIEW_FLAG,	!T to copy input to terminal &
		WORD	ECHO_FLAG,	!T to copy output to terminal &
		WORD	CONT_FLAG	!T to continue 

	COMMON (LOGFILE_COM) &
		WORD	LOG_FLAG,	!T to log the received text &
		WORD	LOG_PTR	 	!pointer into log buffer

	!**********************************************************************
	!			MAPS
	!**********************************************************************

	MAP (LOG_BUF_MAP) &
		BYTE	LOG_BUF(MAX_LOG_SIZE)	!log file buffer

	MAP (LOG_BUF_MAP) &
		STRING	LOG_BUF_S = MAX_LOG_SSIZE
