10	SUB EXT_CONNECT_LOOP
	!======================================================================
	!PROGRAM---------------------VERSION-------------------LANGUAGE--------
	!EXT_CONNECT_LOOP		1			BASIC
	!
	!DESCRIPTION-----------------------------------------------------------
	!routine to transfer characters from keyboard to port
	!
	!======================================================================

	%TITLE "Main online loop"
	%IDENT "EXT_CONNECT_LOOP  88.02.18"
	%SBTTL "DOCUMENTATION SECTION"

	!**********************************************************************
	!			OPTIONS
	!**********************************************************************

	OPTION	TYPE = EXPLICIT			! Explicit declarations only

100	!**********************************************************************
	!			DOCUMENTATION SECTION
	!**********************************************************************
	!
	!======================================================================
	!			MODIFICATION HISTORY
	!======================================================================
	!VERSION--------AUTHOR------------------DATE------------APPROVAL-------
	!   1		Keith Walker		88.02.18	1723
	!
	!======================================================================
	!			COMPILE/LINK INSTRUCTIONS
	!======================================================================
	!$BASIC EXT_ONLINE_LOOP
	!$LINK/NOTRACE EXTERNAL,-
	!EXT_UNSOL_MBX_AST, EXT_READ_PORT_AST,-
	!EXT_PROC_BUF_AST, EXT_WRITE_TERM_AST,-
	!EXT_SCRIPT_INTERP, EXT_SCREEN_HDR,-
	!EXT_MENU, EXT_CONNECT_LOOP, CHKRDB
	!======================================================================

	!**********************************************************************
	!			FILES ACCESSED
	!**********************************************************************
	!     NAME	    MODE    CHANNEL		  DESCRIPTION
	!--------------	   ------   -------	-------------------------------
	!
	!**********************************************************************

	%PAGE
	%SBTTL "DECLARATION SECTION"
200	!======================================================================
	!			DECLARATION SECTION
	!======================================================================

	!**********************************************************************
	!			DECLARATIONS FROM %INCLUDE FILES
	!**********************************************************************

	%INCLUDE "EXT_COMMON.BAS"

	!**********************************************************************
	!			CONSTANTS
	!**********************************************************************

	!**********************************************************************
	!			RECORDS
	!**********************************************************************

	!**********************************************************************
	!			MAPS
	!**********************************************************************

	!**********************************************************************
	!			COMMONS
	!**********************************************************************

	!**********************************************************************
	!			VARIABLES
	!**********************************************************************

	DECLARE WORD &
		TERM_BUF, &
		TERM_IOSB(3)

	DECLARE LONG &
		JUNK, &
		TERM_READ_CODE

	!**********************************************************************
	!			ARRAYS
	!**********************************************************************

	!**********************************************************************
	!			FUNCTIONS
	!**********************************************************************

	!**********************************************************************
	!			EXTERNAL CONSTANTS
	!**********************************************************************

	EXTERNAL LONG CONSTANT &
		IO$_READVBLK, &
		IO$_WRITEVBLK, &
		IO$M_NOECHO

	!**********************************************************************
	!			EXTERNAL FUNCTIONS
	!**********************************************************************

	EXTERNAL LONG FUNCTION &
		SYS$QIOW

	!**********************************************************************
	!			EXTERNAL SUBPROGRAMS
	!**********************************************************************

	%PAGE
	%SBTTL "INITIALIZATION SECTION"
300	!======================================================================
	!			INITIALIZATION SECTION
	!======================================================================

	ON ERROR GOTO ERROR_HANDLING

	!**********************************************************************
	!			PRINT USING FORMATS
	!**********************************************************************

	!**********************************************************************
	!			VARIABLES
	!**********************************************************************

	!**********************************************************************
	!			FILE OPENS
	!**********************************************************************

	%PAGE
	%SBTTL "MAIN LOGIC SECTION"
1000	!======================================================================
	!			MAIN LOGIC SECTION
	!======================================================================

	IF ECHO_FLAG THEN	!echo might be switched on by script
	  TERM_READ_CODE = IO$_READVBLK
	ELSE
	  TERM_READ_CODE = IO$_READVBLK OR IO$M_NOECHO
	END IF

	!now loop to copy stuff from terminal to port...
 ONLINE_LOOP:
 	JUNK = SYS$QIOW(!efn!, TERM_CHAN BY VALUE,		&
	     			TERM_READ_CODE BY VALUE,	&
				TERM_IOSB(0) BY REF,,,	&
				TERM_BUF BY REF,		&
				1% BY VALUE,,,,)
	GOTO ONLINE_DONE IF (TERM_BUF AND 127%) = 28%	!exit loop on ^\

	JUNK = SYS$QIOW(!efn!, PORT_CHAN BY VALUE,	&
	     			IO$_WRITEVBLK BY VALUE,	&
				TERM_IOSB(0) BY REF,,,	&
				TERM_BUF BY REF,		&
				1% BY VALUE,,,,)

	GOTO ONLINE_LOOP

 ONLINE_DONE:
	GOTO END_OF_PROGRAM

	%PAGE
	%SBTTL "SUBROUTINE DEFINITION SECTION"
15000	!======================================================================
	!			SUBROUTINE DEFINITION SECTION
	!======================================================================

	%PAGE
	%SBTTL "FUNCTION DEFINITION SECTION"
20000	!======================================================================
	!			FUNCTION DEFINITION SECTION
	!======================================================================

	%PAGE                                                                  
	%SBTTL "ERROR HANDLING SECTION"
25000	!======================================================================
	!			ERROR HANDLING SECTION
	!======================================================================

 ERROR_HANDLING:
	ON ERROR GOTO 0

	!======================================================================
	!			END OF PROGRAM
	!======================================================================

 END_OF_PROGRAM:

32767	END SUB
