10	SUB EXT_READ_PORT_AST(LONG DUM1, DUM2, DUM3, DUM4, DUM5)
	!======================================================================
	!PROGRAM---------------------VERSION-------------------LANGUAGE--------
	!EXT_READ_PORT_AST		1			BASIC
	!
	!DESCRIPTION-----------------------------------------------------------
	!AST routine to queue a read from the port.  If no buffer space is
	!available, waits for a buffer (although this means that data might be
	!lost).
	!
	!======================================================================

	%TITLE "Port read AST"
	%IDENT "EXT_READ_PORT_AST  88.02.08"
	%SBTTL "DOCUMENTATION SECTION"

	!**********************************************************************
	!			OPTIONS
	!**********************************************************************

	OPTION	TYPE = EXPLICIT			! Explicit declarations only

100	!**********************************************************************
	!			DOCUMENTATION SECTION
	!**********************************************************************
	!
	!======================================================================
	!			MODIFICATION HISTORY
	!======================================================================
	!VERSION--------AUTHOR------------------DATE------------APPROVAL-------
	!   1		Keith Walker		88.02.08	1723
	!
	!======================================================================
	!			COMPILE/LINK INSTRUCTIONS
	!======================================================================
	!$BASIC EXT_READ_PORT_AST
	!$LINK/NOTRACE EXTERNAL,-
	!EXT_UNSOL_MBX_AST, EXT_READ_PORT_AST,-
	!EXT_PROC_BUF_AST, EXT_WRITE_TERM_AST,-
	!EXT_SCRIPT_INTERP, EXT_SCREEN_HDR,-
	!EXT_MENU, EXT_CONNECT_LOOP, CHKRDB
	!======================================================================

	!**********************************************************************
	!			FILES ACCESSED
	!**********************************************************************
	!     NAME	    MODE    CHANNEL		  DESCRIPTION
	!--------------	   ------   -------	-------------------------------
	!		
	!**********************************************************************

	%PAGE
	%SBTTL "DECLARATION SECTION"
200	!======================================================================
	!			DECLARATION SECTION
	!======================================================================

	!**********************************************************************
	!			DECLARATIONS FROM %INCLUDE FILES
	!**********************************************************************

	%INCLUDE "EXT_COMMON.BAS"

	!**********************************************************************
	!			CONSTANTS
	!**********************************************************************

	!**********************************************************************
	!			RECORDS
	!**********************************************************************

	!**********************************************************************
	!			MAPS
	!**********************************************************************

	!**********************************************************************
	!			COMMONS
	!**********************************************************************

	!**********************************************************************
	!			VARIABLES
	!**********************************************************************

	DECLARE LONG &
		FUNC_STAT,	!function status &
		NEXT_BUF

	DECLARE QUAD &
		RESCHED_TIME	!time to reschedule read

	!**********************************************************************
	!			ARRAYS
	!**********************************************************************

	!**********************************************************************
	!			FUNCTIONS
	!**********************************************************************

	DECLARE WORD FUNCTION &
		GET_A_BUF		!gets a buffer

	!**********************************************************************
	!			EXTERNAL CONSTANTS
	!**********************************************************************

	EXTERNAL LONG CONSTANT &
		IO$_READVBLK, &
		IO$M_NOECHO, &
		IO$M_TIMED, &
		SS$_NORMAL, &
		SS$_ABORT

	!**********************************************************************
	!			EXTERNAL FUNCTIONS
	!**********************************************************************

	EXTERNAL LONG FUNCTION &
		LIB$STOP, &
		SYS$BINTIM, &
		SYS$QIO, &
		SYS$SETIMR

	EXTERNAL LONG &
		EXT_PROC_BUF_AST, &
		EXT_READ_PORT_AST

	!**********************************************************************
	!			EXTERNAL SUBPROGRAMS
	!**********************************************************************

	%PAGE
	%SBTTL "INITIALIZATION SECTION"
300	!======================================================================
	!			INITIALIZATION SECTION
	!======================================================================

	ON ERROR GOTO ERROR_HANDLING

	!**********************************************************************
	!			PRINT USING FORMATS
	!**********************************************************************

	!**********************************************************************
	!			VARIABLES
	!**********************************************************************

	!**********************************************************************
	!			FILE OPENS
	!**********************************************************************

	%PAGE
	%SBTTL "MAIN LOGIC SECTION"
1000	!======================================================================
	!			MAIN LOGIC SECTION
	!======================================================================

	FUNC_STAT = GET_A_BUF	!get us a buffer
	GOTO NO_BUFFER IF (FUNC_STAT AND 1%) = 0%	!none available

	!read the data from the port...
	FUNC_STAT = SYS$QIO(!efn!, &
		PORT_CHAN BY VALUE, &
		(IO$_READVBLK OR IO$M_NOECHO OR IO$M_TIMED) BY VALUE, &
		PORT_BUF(CURRENT_BUF)::IOSB(IOSB_STATUS) BY REF, &
		EXT_PROC_BUF_AST BY REF, CURRENT_BUF BY VALUE, &
		PORT_BUF(CURRENT_BUF)::BUF_FER(0) BY REF, &
		MAX_BUF_SIZE BY VALUE, &
		0% BY VALUE, &
		!p4!, !p5!, !p6!)
	IF (FUNC_STAT AND 1%) = 1% THEN
	  BUF_ATTEMPTS = 0%
 	  GOTO END_OF_PROGRAM
	END IF

 NO_BUFFER:
	!if no buffer is available, we schedule ourselves to try again in half
	!a second...
	BUF_ATTEMPTS = BUF_ATTEMPTS + 1%

	!delta time of .5 sec...
	FUNC_STAT = SYS$BINTIM("0 0:00:00.5", RESCHED_TIME)
	FUNC_STAT = SYS$SETIMR(!efn!, RESCHED_TIME, EXT_READ_PORT_AST, !astprm!)
	IF (FUNC_STAT AND 1%) = 0% THEN
	  !if we can't set a timer, we may as well give up...
	  FUNC_STAT = LIB$STOP(FUNC_STAT BY VALUE)
	END IF

	!success...
	GOTO END_OF_PROGRAM

	%PAGE
	%SBTTL "SUBROUTINE DEFINITION SECTION"
15000	!======================================================================
	!			SUBROUTINE DEFINITION SECTION
	!======================================================================

	%PAGE
	%SBTTL "FUNCTION DEFINITION SECTION"
20000	!======================================================================
	!			FUNCTION DEFINITION SECTION
	!======================================================================

	!**********************************************************************
	!Get a buffer.  Returns SS$_NORMAL or SS$_ABORT.  If successful,
	!updates CURRENT_BUF and BUFS_USED.
	!**********************************************************************

	DEF WORD GET_A_BUF

	NEXT_BUF = CURRENT_BUF + 1%
	NEXT_BUF = 0% IF NEXT_BUF > MAX_BUF_CNT
	IF (BUFS_USED > MAX_BUF_CNT) OR &
		PORT_BUF(NEXT_BUF)::BUF_IN_USE THEN	!no buffers available
	  GET_A_BUF = FUNC_STAT	!return an error
	  GOTO GOT_A_BUF
	END IF

	!grab the next buffer...
	BUFS_USED = BUFS_USED + 1%
	CURRENT_BUF = NEXT_BUF
	PORT_BUF(CURRENT_BUF)::BUF_IN_USE = TRUE
	PORT_BUF(CURRENT_BUF)::BUF_CNT = 0%
	PORT_BUF(CURRENT_BUF)::BUF_PTR = 0%
	GET_A_BUF = SS$_NORMAL	      		!return OK status

 GOT_A_BUF:
	END DEF

	%PAGE                                                                  
	%SBTTL "ERROR HANDLING SECTION"
25000	!======================================================================
	!			ERROR HANDLING SECTION
	!======================================================================

 ERROR_HANDLING:
	ON ERROR GOTO 0

	!======================================================================
	!			END OF PROGRAM
	!======================================================================

 END_OF_PROGRAM:

32767	END SUB
