10	SUB EXT_SCREEN_HDR(STRING HDR_FACILITY, HDR_MESSAGE)
	!======================================================================
	!PROGRAM---------------------VERSION-------------------LANGUAGE--------
	!EXT_SCREEN_HDR			1			BASIC
	!
	!DESCRIPTION-----------------------------------------------------------
	!Routine to display a message at the top of the screen in a
	!non-scrolling area.  Disables viewing of incoming data while it writes
	!message, to prevent incoming text being mixed in with message.
	!
	!======================================================================

	%TITLE "Screen Header Display"
	%IDENT "EXT_SCREEN_HDR  88.02.11"
	%SBTTL "DOCUMENTATION SECTION"

	!**********************************************************************
	!			OPTIONS
	!**********************************************************************

	OPTION	TYPE = EXPLICIT			! Explicit declarations only

100	!**********************************************************************
	!			DOCUMENTATION SECTION
	!**********************************************************************
	!
	!======================================================================
	!			MODIFICATION HISTORY
	!======================================================================
	!VERSION--------AUTHOR------------------DATE------------APPROVAL-------
	!   1		Keith Walker		88.02.11	1723
	!
	!======================================================================
	!			COMPILE/LINK INSTRUCTIONS
	!======================================================================
	!$BASIC EXT_SCREEN_HDR
	!$LINK/NOTRACE EXTERNAL,-
	!EXT_UNSOL_MBX_AST, EXT_READ_PORT_AST,-
	!EXT_PROC_BUF_AST, EXT_WRITE_TERM_AST,-
	!EXT_SCRIPT_INTERP, EXT_SCREEN_HDR,-
	!EXT_MENU, EXT_CONNECT_LOOP, CHKRDB
	!======================================================================

	!**********************************************************************
	!			FILES ACCESSED
	!**********************************************************************
	!     NAME	    MODE    CHANNEL		  DESCRIPTION
	!--------------	   ------   -------	-------------------------------
	!
	!**********************************************************************

	%PAGE
	%SBTTL "DECLARATION SECTION"
200	!======================================================================
	!			DECLARATION SECTION
	!======================================================================

	!**********************************************************************
	!			DECLARATIONS FROM %INCLUDE FILES
	!**********************************************************************

	%INCLUDE "EXT_COMMON"

	!**********************************************************************
	!			CONSTANTS
	!**********************************************************************

	!**********************************************************************
	!			RECORDS
	!**********************************************************************

	!**********************************************************************
	!			MAPS
	!**********************************************************************

	!**********************************************************************
	!			COMMONS
	!**********************************************************************

	!**********************************************************************
	!			VARIABLES
	!**********************************************************************

	DECLARE STRING &
		HEADER_FMT	!print using format

	DECLARE WORD &
	       	SAVE_VIEW_FLAG	!saved view flag

	!**********************************************************************
	!			ARRAYS
	!**********************************************************************

	!**********************************************************************
	!			FUNCTIONS
	!**********************************************************************

	!**********************************************************************
	!			EXTERNAL CONSTANTS
	!**********************************************************************

	!**********************************************************************
	!			EXTERNAL FUNCTIONS
	!**********************************************************************

	!**********************************************************************
	!			EXTERNAL SUBPROGRAMS
	!**********************************************************************

	%PAGE
	%SBTTL "INITIALIZATION SECTION"
300	!======================================================================
	!			INITIALIZATION SECTION
	!======================================================================

	ON ERROR GOTO ERROR_HANDLING

	!**********************************************************************
	!			PRINT USING FORMATS
	!**********************************************************************

	HEADER_FMT = "'LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL "+&
		"'RRRRRRRRRRRRRRRRRRRRRRRRR"

	!**********************************************************************
	!			VARIABLES
	!**********************************************************************

	!**********************************************************************
	!			FILE OPENS
	!**********************************************************************

	%PAGE
	%SBTTL "MAIN LOGIC SECTION"
1000	!======================================================================
	!			MAIN LOGIC SECTION
	!======================================================================

	!disable display of incoming text on the terminal...
	SAVE_VIEW_FLAG = VIEW_FLAG
	VIEW_FLAG = FALSE

	PRINT CHR$(27); "7";		!save cursor
	PRINT CHR$(27); "[2;24r";	!scroll all but 1st line
	PRINT CHR$(27); "[H";		!top
	PRINT CHR$(27); "#5";		!single width, single height
	PRINT CHR$(27); "[0;4m";	!underline on
	PRINT USING HEADER_FMT; HDR_FACILITY; HDR_MESSAGE;	!message
	PRINT CHR$(27); "[0m"		!underline off
	PRINT CHR$(27); "8";		!restore cursor

	!restore view flag...
	VIEW_FLAG = SAVE_VIEW_FLAG

	GOTO END_OF_PROGRAM

	%PAGE
	%SBTTL "SUBROUTINE DEFINITION SECTION"
15000	!======================================================================
	!			SUBROUTINE DEFINITION SECTION
	!======================================================================

	%PAGE
	%SBTTL "FUNCTION DEFINITION SECTION"
20000	!======================================================================
	!			FUNCTION DEFINITION SECTION
	!======================================================================

	%PAGE                                                                  
	%SBTTL "ERROR HANDLING SECTION"
25000	!======================================================================
	!			ERROR HANDLING SECTION
	!======================================================================

 ERROR_HANDLING:
	IF ERR = 28% THEN	!^C trap
	  RESUME END_OF_PROGRAM
	END IF
	ON ERROR GOTO 0

	!======================================================================
	!			END OF PROGRAM
	!======================================================================

 END_OF_PROGRAM:

32767	END SUB
