10	SUB EXT_UNSOL_MBX_AST(LONG DUM1, DUM2, DUM3, DUM4, DUM5)
	!======================================================================
	!PROGRAM---------------------VERSION-------------------LANGUAGE--------
	!EXT_UNSOL_MBX_AST		1			BASIC
	!
	!DESCRIPTION-----------------------------------------------------------
	!AST to read unsolicited input mailbox and fire up a QIO to read the
	!data from the input buffer
	!
	!======================================================================

	%TITLE "Unsolicited input mailbox read AST"
	%IDENT "EXT_UNSOL_MBX_AST  88.02.04"
	%SBTTL "DOCUMENTATION SECTION"

	!**********************************************************************
	!			OPTIONS
	!**********************************************************************

	OPTION	TYPE = EXPLICIT			! Explicit declarations only

100	!**********************************************************************
	!			DOCUMENTATION SECTION
	!**********************************************************************
	!
	!======================================================================
	!			MODIFICATION HISTORY
	!======================================================================
	!VERSION--------AUTHOR------------------DATE------------APPROVAL-------
	!   1		Keith Walker		88.02.04	1723
	!
	!======================================================================
	!			COMPILE/LINK INSTRUCTIONS
	!======================================================================
	!$BASIC EXT_UNSOL_MBX_AST
	!$LINK/NOTRACE EXTERNAL,-
	!EXT_UNSOL_MBX_AST, EXT_READ_PORT_AST,-
	!EXT_PROC_BUF_AST, EXT_WRITE_TERM_AST,-
	!EXT_SCRIPT_INTERP, EXT_SCREEN_HDR,-
	!EXT_MENU, EXT_CONNECT_LOOP, CHKRDB
	!======================================================================

	!**********************************************************************
	!			FILES ACCESSED
	!**********************************************************************
	!     NAME	    MODE    CHANNEL		  DESCRIPTION
	!--------------	   ------   -------	-------------------------------
	!		
	!**********************************************************************

	%PAGE
	%SBTTL "DECLARATION SECTION"
200	!======================================================================
	!			DECLARATION SECTION
	!======================================================================

	%INCLUDE "EXT_COMMON.BAS"

	!**********************************************************************
	!			CONSTANTS
	!**********************************************************************

	!**********************************************************************
	!			RECORDS
	!**********************************************************************

	!**********************************************************************
	!			MAPS
	!**********************************************************************

	!**********************************************************************
	!			COMMONS
	!**********************************************************************

	!**********************************************************************
	!			VARIABLES
	!**********************************************************************

	DECLARE LONG &
		FUNC_STAT	!function return status

	!**********************************************************************
	!			ARRAYS
	!**********************************************************************

	!**********************************************************************
	!			FUNCTIONS
	!**********************************************************************

	!**********************************************************************
	!			EXTERNAL CONSTANTS
	!**********************************************************************

	EXTERNAL LONG CONSTANT &
		IO$_READVBLK, &
		IO$M_NOECHO, &
		IO$M_TIMED, &
		MSG$_TRMBRDCST, &
		MSG$_TRMHANGUP, &
		MSG$_TRMUNSOLIC, &
		SS$_ABORT, &
		SS$_NORMAL

	!**********************************************************************
	!			EXTERNAL FUNCTIONS
	!**********************************************************************

	EXTERNAL LONG &
		EXT_UNSOL_MBX_AST, &
		EXT_READ_PORT_AST

	EXTERNAL LONG FUNCTION &
		SYS$DCLAST, &
		SYS$QIO

	!**********************************************************************
	!			EXTERNAL SUBPROGRAMS
	!**********************************************************************

	%PAGE
	%SBTTL "INITIALIZATION SECTION"
300	!======================================================================
	!			INITIALIZATION SECTION
	!======================================================================

	ON ERROR GOTO ERROR_HANDLING

	!**********************************************************************
	!			PRINT USING FORMATS
	!**********************************************************************

	!**********************************************************************
	!			VARIABLES
	!**********************************************************************

	!**********************************************************************
	!			FILE OPENS
	!**********************************************************************

	%PAGE
	%SBTTL "MAIN LOGIC SECTION"
1000	!======================================================================
	!			MAIN LOGIC SECTION
	!======================================================================

	!check for errors...
	FUNC_STAT = MBX_IOSB(0%)
	GOTO REQUEUE_MYSELF IF (FUNC_STAT AND 1%) = 0%

	SELECT MBX_BUF::MBX_TYPE	!what was the message?...
	  CASE = MSG$_TRMUNSOLIC	!unsolicited input
	    !read the unsolicited data from the port...
	    BUF_ATTEMPTS = 0%
	    FUNC_STAT = SYS$DCLAST(EXT_READ_PORT_AST, !astprm!, !acmode!)
	    GOTO REQUEUE_MYSELF IF (FUNC_STAT AND 1%) = 0% 	!trouble

	    !------------------------------------------------------------------
	    !If we have successfully queued a port read, there is no need to
	    !requeue ourselves.  The port read routine will take care of
	    !reading the port as long as there is data arriving.  When the data
	    !stops coming in, the port read routine will requeue us. 
	    !------------------------------------------------------------------
	    GOTO END_OF_PROGRAM

	  CASE = MSG$_TRMHANGUP		!hangup
	  CASE = MSG$_TRMBRDCST		!broadcast message received
	  CASE ELSE			!garbage
	END SELECT

 REQUEUE_MYSELF:
	!if we are continuing, queue up another mailbox read...
	GOTO END_OF_PROGRAM IF NOT CONT_FLAG
	FUNC_STAT = SYS$QIO(!efn!, &
		MBX_CHAN BY VALUE, &
		IO$_READVBLK BY VALUE, &
		MBX_IOSB(0%) BY REF, &
		EXT_UNSOL_MBX_AST BY REF, , &
		MBX_BUF BY REF, &
		MAX_MBX_SIZE BY VALUE, , , , )

	GOTO END_OF_PROGRAM

	%PAGE
	%SBTTL "SUBROUTINE DEFINITION SECTION"
15000	!======================================================================
	!			SUBROUTINE DEFINITION SECTION
	!======================================================================

	%PAGE
	%SBTTL "FUNCTION DEFINITION SECTION"
20000	!======================================================================
	!			FUNCTION DEFINITION SECTION
	!======================================================================

	%PAGE                                                                  
	%SBTTL "ERROR HANDLING SECTION"
25000	!======================================================================
	!			ERROR HANDLING SECTION
	!======================================================================

 ERROR_HANDLING:
	ON ERROR GOTO 0

	!======================================================================
	!			END OF PROGRAM
	!======================================================================

 END_OF_PROGRAM:

32767	END SUB
