10	SUB EXT_WRITE_TERM_AST (LONG MY_BUFFER_PAR, DUM2, DUM3, DUM4, DUM5)
	!======================================================================
	!PROGRAM---------------------VERSION-------------------LANGUAGE--------
	!EXT_WRITE_TERM_AST		1			BASIC
	!
	!DESCRIPTION-----------------------------------------------------------
	!AST routine to clean up after writing buffer to terminal.  Copies the
	!buffer to the log file, if requested, then releases the buffer.
	!
	!======================================================================

	%TITLE "Output AST"
	%IDENT "EXT_WRITE_TERM_AST  88.02.05"
	%SBTTL "DOCUMENTATION SECTION"

	!**********************************************************************
	!			OPTIONS
	!**********************************************************************

	OPTION	TYPE = EXPLICIT			! Explicit declarations only

100	!**********************************************************************
	!			DOCUMENTATION SECTION
	!**********************************************************************
	!
	!======================================================================
	!			MODIFICATION HISTORY
	!======================================================================
	!VERSION--------AUTHOR------------------DATE------------APPROVAL-------
	!   1		Keith Walker		88.02.05	1723
	!
	!======================================================================
	!			COMPILE/LINK INSTRUCTIONS
	!======================================================================
	!$BASIC EXT_WRITE_TERM_AST
	!$LINK/NOTRACE EXTERNAL,-
	!EXT_UNSOL_MBX_AST, EXT_READ_PORT_AST,-
	!EXT_PROC_BUF_AST, EXT_WRITE_TERM_AST,-
	!EXT_SCRIPT_INTERP, EXT_SCREEN_HDR,-
	!EXT_MENU, EXT_CONNECT_LOOP, CHKRDB
	!======================================================================

	!**********************************************************************
	!			FILES ACCESSED
	!**********************************************************************
	!     NAME	    MODE    CHANNEL		  DESCRIPTION
	!--------------	   ------   -------	-------------------------------
	!xxxxxxxx	   WRITE LOG_FILE_CHAN	log file
	!		
	!**********************************************************************

	%PAGE
	%SBTTL "DECLARATION SECTION"
200	!======================================================================
	!			DECLARATION SECTION
	!======================================================================

	!**********************************************************************
	!			DECLARATIONS FROM %INCLUDE FILES
	!**********************************************************************

	%INCLUDE "EXT_COMMON.BAS"

	!**********************************************************************
	!			CONSTANTS
	!**********************************************************************

	!**********************************************************************
	!			RECORDS
	!**********************************************************************

	!**********************************************************************
	!			MAPS
	!**********************************************************************

	!**********************************************************************
	!			COMMONS
	!**********************************************************************

	!**********************************************************************
	!			VARIABLES
	!**********************************************************************

	DECLARE LONG &
		FUNC_STAT,	!function return status &
		I,		!counter &
		MY_BUFFER,	!buffer number &
		XON		!ascii value for XON

	!**********************************************************************
	!			ARRAYS
	!**********************************************************************

	!**********************************************************************
	!			FUNCTIONS
	!**********************************************************************

	!**********************************************************************
	!			EXTERNAL CONSTANTS
	!**********************************************************************

	EXTERNAL LONG CONSTANT &
		IO$_WRITEVBLK

	!**********************************************************************
	!			EXTERNAL FUNCTIONS
	!**********************************************************************

	EXTERNAL LONG FUNCTION &
		SYS$QIO

	!**********************************************************************
	!			EXTERNAL SUBPROGRAMS
	!**********************************************************************

	%PAGE
	%SBTTL "INITIALIZATION SECTION"
300	!======================================================================
	!			INITIALIZATION SECTION
	!======================================================================

	ON ERROR GOTO ERROR_HANDLING

	!**********************************************************************
	!			PRINT USING FORMATS
	!**********************************************************************

	!**********************************************************************
	!			VARIABLES
	!**********************************************************************

	MY_BUFFER = LOC(MY_BUFFER_PAR)
	XON = 17%

	!**********************************************************************
	!			FILE OPENS
	!**********************************************************************

	%PAGE
	%SBTTL "MAIN LOGIC SECTION"
1000	!======================================================================
	!			MAIN LOGIC SECTION
	!======================================================================

	FOR I = 0 TO PORT_BUF(MY_BUFFER)::BUF_CNT - 1%
	  SELECT PORT_BUF(MY_BUFFER)::BUF_FER(I)

	    CASE = 0%		!NUL
	      !ignore nulls

	    CASE = 10%		!LF
	      LOG_BUF(LOG_PTR) = PORT_BUF(MY_BUFFER)::BUF_FER(I)
	      LOG_PTR = LOG_PTR + 1%
	      IF LOG_PTR > 80% THEN
	        !------------------------------------------------------------
	        !To minimize disk I/O, we only write to the file if we have
	        !filled more than 80 characters.  It is still highly probable
	        !that we will get another LF before the buffer fills, so this
	        !will not affect the content of the file...
	        !------------------------------------------------------------
	        GOSUB OUTPUT_BUF
	      END IF

	    CASE = 19%		!XOFF
	      !-----------------------------------------------------------------
	      !oops... we have just sent an XOFF to the terminal, so the
	      !poor user can't type anything.  Anything the user types will be
	      !buffered by the terminal or lost.  We can fix things by quickly
	      !sending an XON...
	      !-----------------------------------------------------------------
	      IF VIEW_FLAG THEN
	        !send an XON to the terminal...
	        FUNC_STAT = SYS$QIO(!efn!, &
	  		TERM_CHAN BY VALUE, &
			IO$_WRITEVBLK BY VALUE, &
			!iosb!, &
			!astadr!, !astprm!, &
			XON BY REF, &
			1% BY VALUE, &
			!p3!, !p4!, !p5!, !p6!)
	      END IF
	      !...and don't bother logging the XOFF

	    CASE ELSE
	      LOG_BUF(LOG_PTR) = PORT_BUF(MY_BUFFER)::BUF_FER(I)
	      LOG_PTR = LOG_PTR + 1%
	      !we don't let the buffer get more than 85% full...
	      IF LOG_PTR > 0.85 * MAX_LOG_SIZE THEN
	        GOSUB OUTPUT_BUF
	      END IF
	  END SELECT
	NEXT I

 RELEASE_BUF:
	PORT_BUF(MY_BUFFER)::BUF_IN_USE = FALSE
	BUFS_USED = BUFS_USED - 1%

	GOTO END_OF_PROGRAM

	%PAGE
	%SBTTL "SUBROUTINE DEFINITION SECTION"
15000	!======================================================================
	!			SUBROUTINE DEFINITION SECTION
	!======================================================================

 OUTPUT_BUF:
	!**********************************************************************
	!dump log buffer to log file if requested...
	!**********************************************************************

	IF LOG_FLAG THEN
	  PUT #LOG_FILE, COUNT LOG_PTR
	END IF
	LOG_PTR = 0%

	RETURN

	%PAGE
	%SBTTL "FUNCTION DEFINITION SECTION"
20000	!======================================================================
	!			FUNCTION DEFINITION SECTION
	!======================================================================

	%PAGE                                                                  
	%SBTTL "ERROR HANDLING SECTION"
25000	!======================================================================
	!			ERROR HANDLING SECTION
	!======================================================================

 ERROR_HANDLING:
	ON ERROR GOTO 0

	!======================================================================
	!			END OF PROGRAM
	!======================================================================

 END_OF_PROGRAM:

32767	END SUB
