$! This command procedure was written by Charles Brown.
$!
$! Comments were added by Alta M. Paul in Nov. 1987.
$!
$! This file will need to be edited carefully to distinguish
$! between test and production versions.  
$!
$! Execution of the procedure occurs at 3a.m. each day from the
$! queue nrl3_quickbatch.
$!
$!
$ set noon
$ set message/nofacility/noidentification/noseverity/text
$!
$  set default dua104:[CCF_BITNET]
$!
$ submit/after="tomorrow+03:00"/log=dua104:[CCF_BITNET]bb$newmail3.log -
  /nonotify/noprinter/queue=nrl3_quickbatch -
  dua104:[CCF_BITNET]bb$newmail3
$!
$!
$ mail                              !enter mail 
set file mail.mai                   !use the mail file in test area
select newmail                      !open newmail folder
file/all/noconfirm mail             !move all new messages to the mail folder
exit                                !in test area and then exit
$!
$!
$ assign/user mail.tmp sys$output   !subsequent output written to mail.tmp
$!
$!
$ mail
set file mail.mai
select mail                         !causes entry in mail.tmp about number
exit                                !of messages selected
$!
$!
$ on error then $ goto finish
$ open/read mail_output mail.tmp
$ read mail_output line             !read the message from mail in mail.tmp
$ close mail_output                 !and store message in "line"
$!
$!
$ set noon
$ delete mail.tmp;*                              !mail.tmp no longer needed
$ num_messages=f$integer(f$element(0," ",line))  !extract integer read from
$ if (num_messages.eq.0) then $ goto finish      !mail.tmp.  If none, stop.
$!
$!
$ set noverify
$ on error then $ goto finish
$ open/write mail_input mail.com                 !creating a com file
$ write mail_input "$ assign/user _nla0: sys$output"
$ write mail_input "$ mail"
$!
$ write mail_input "set file mail.mai"
$!
$ write mail_input "select mail"
$!
$!
$! set up a loop to extract the mail messages into individual files in
$! the userservices area.
$!
$ num_output=0
$ loop1:
$ num_output=num_output+1                           !count messages extracted
$ write mail_input num_output    !this number will cause mail to select message
$ write mail_input "extract/header bb$mail.txt"     !extract selected message
$ if (num_output.lt.num_messages) then $ goto loop1 
$!
$!
$ write mail_input "delete/all"      !more lines for the com file
$ write mail_input "exit"            !messages are deleted from mail since
$ write mail_input "$ exit"          !they now reside in the bb or in
$ close mail_input                   !BB$BAD_MAIL.TXT files
$ set noon
$!
$!
$ @mail                         !execute the com file then delete it
$ delete mail.com;*    
$!
$!
$! try to add each file extracted from mail to the bb.
$!
$ loop2:
$ file=f$search("bb$mail.txt;*")       !retrieve next version of bb$mail.txt
$ if (file.eqs."") then $ goto finish  !quit when all files examined
$ assign/user 'file' mail$file         !next bb$mail.txt gets new name
$!
$ run/nodebug arpa3                    !ARPA actually does bb add
mail$file
$!
$ if ($status) then $ goto okay    !ARPA decides if add was successful.
$ rename 'file' bb$bad_mail.txt;0  !if not, rename and retain file
$ goto loop2
$!
$!
$! file was successfully added to bb so we can delete the file
$!
$ okay:
$ delete 'file'
$ goto loop2
$ !
$ finish:
$ set verify
$!
$ RUN BB$COUNT_MESSAGES
$ !
$ purge/keep=30/log bb$newmail3.log 
$! PURGE/KEEP=30/LOG BB$MAIL.LOG   !BB$MAIL.LOG FILES ARE RETAINED 30 DAYS
$ !                                !IN USERSERVICES
$ exit
