[inherit('sys$library:starlet','lib$spawn','smgdefs','smg$repaint_line',
'BB.PEN')]
module delete_topic;

[global] 
procedure delete_topic;

{Manager may delete one or more topics with this procedure.  The topic
 does not have to be empty to delete it.  If there are messages in the
 topic, it will take quite a while to finish the deletion.  The module
 will query the manager to make sure that deleting is the real intention
 before erasing the messages and then the topic.}

var
  answer : string;
  topic : packed array [1..topic_length] of char;
  select_number : integer;
  convert_line : string;
  ch : char;

begin

  open(bbwrtfile,file_location+chosen_file,history:=old,
       access_method:=keyed,organization:=indexed,sharing:=readwrite,
       error:=continue);
  if (status(bbwrtfile) > 0) then
    write_error('Unable to open database.');

  resetk(bbwrtfile,0);
  if not ufb(bbwrtfile) then
    begin
      t_menu := false;  {Flag for topic menu box erased}

      repeat
        {Query for topic to delete and check validity of entry}
        write_menu('','Topic number to delete <CR> | <CR> for previous menu: ');
        readstr(line);
        smg$unpaste_virtual_display(error_display,pasteboard);

        if (length(line) <> 0) and (line <> key_exit) then
          begin
            ch := line[1];
	    if (ch in ['1'..'9']) and (length(line) < 3 ) then
              begin
                convert_line := line;
                readv(convert_line,select_number);

                if (select_number in [1..topic_counter]) then
                  begin   {Locate topic to delete}
                    if (topic_root^.next <> nil) then
                      topic_list := topic_root^.next;
                      while (select_number <> topic_list^.number) and 
                            (topic_list^.next <> nil) do
          	        topic_list := topic_list^.next;
                        if (topic_list <> nil) then 
                          topic := topic_list^.topic;
                  end;
              end;

            {Locate the topic to delete in the data base}
      	    findk(bbwrtfile,1,topic+null_date,eql,error:=continue);
            if ufb(bbwrtfile) then
              write_error('Topic does not exist.')
            else
              begin
                answer := 'Y';
                get(bbwrtfile,error:=continue);
                if not eof(bbwrtfile) then
                  if (bbwrtfile^.topic = topic) then
                    begin                    
                      write_menu('','All messages under this topic will '+
                                 'be deleted. Do you want to do this? ');
                      readstr(answer);
                    end;

                if (answer = 'Y') or (answer = 'y') then
                  begin
                    adjust := true;  {Flags to adjust list after deletes.}
                    write_menu('','Deleting topic from bulletin board...');
                    findk(bbwrtfile,1,topic+null_date,eql,error:=continue);

                    {Remove records for this topic.}
                    repeat   
                      delete(bbwrtfile);
                      get(bbwrtfile,error:=continue);
                      if not eof(bbwrtfile) then current_record:=bbwrtfile^;
                    until (current_record.topic <> topic) or eof(bbwrtfile);

                  end;
              end;
          end;
        resetk(bbwrtfile,0);
      until (length(line) = 0) or (line = key_exit) or ufb(bbwrtfile);
    end
  else
    write_error('No topics exist.');

  close(bbwrtfile,error:=continue);
end;           

end.
