[inherit('sys$library:starlet','lib$spawn','smgdefs','smg$repaint_line',
'BB.PEN')]
module get_message_info;

[global] 
procedure get_message_info;

{If the user is sending a message to a poster or to the Bulletin Board,
 build the message header information from the current message data nodes.
 Otherwise, query user for message header information.}

var
  message_date : timetype;

begin
  with current_record do
    begin
      {Set the subject field}
      if (message_option = 'S') then
        if ((index(dir_curr^.subject,'RE:') = 0) or
            (index(dir_curr^.subject,'re:') = 0)) then
          line := 'RE: '+dir_curr^.subject
        else
          line := dir_curr^.subject
      else
        begin
          write_menu('','Subject <CR>: ');
          readstr(line);
        end;

      if (length(line) <= subject_length) then
        subject := line
      else
        subject := substr(line,1,subject_length);
     
      {Set the other fields}
      $gettim(message_date);
      date := invert(message_date);
      date_posted := date;
      topic := current_topic;
      poster := user_id;
      continuation := false;
    end;

end;
end.
