[INHERIT('BB.PEN')]
module messages;

[global] 
procedure messages;

{This procedure is called from topic_menu when a topic is selected.  This
 routine handles calling the other modules needed to create a topic list
 of messages.}

var
  total_mess : string; 			{the total_messages for the topic}
  new_mess : string;			{the new_messages for the topic}
  mcs : string;
  nmcs : string;

begin						
  select_topic;
  if (length(line) <> 0) and (line <> key_exit) then
    begin
      t_menu := false;
      write_menu('','Loading messages from '+substr(current_topic,1,
                                        index(current_topic,' '))+'...');
      create_message_dir_list;
      writev(total_mess,abs(topic_list^.message_counters.total_message):4);
      writev(new_mess,abs(topic_list^.message_counters.new_message):4);
      write_error(total_mess+' messages selected, '+new_mess+' new messages',
                  error_condition:=false);

      write_message_directory;
      message_menu;
      update_topic_info;  {This is to update the info on the dates,& numbers
                           related to this current topic}
    end;
end;

end.
