[INHERIT('smgdefs','BB.PEN')]
module previous_message;

[global] procedure previous_message;

{Displays the previous message to the one currently displayed.  If no
 message is displayed it displays the number that is prior to the one
 at the top of the list if there is one.}

begin
  if (dir_curr^.previous = dir_root) or (dir_curr = dir_root) then
    begin
      write_error('Top of message list.');
      smg$set_physical_cursor(pasteboard,23,79);
    end
  else
    begin
      dir_curr := dir_curr^.previous;
      dir_start := dir_curr;
      dir_list := dir_curr;
      if (dir_curr^.number > 0) then
        begin
          create_message_data_list;
          if message_option in ['P'] then
            data_curr := data_root
          else
            data_curr := data_curr^.previous;
          write_message_data;
        end
      else
        previous_message;
      dir_list := dir_curr;
    end;
end;

end.
