[inherit('sys$library:starlet','lib$spawn','smgdefs','smg$repaint_line',
'BB.PEN')]

module protected_topic_board;

[global] procedure protected_topic_board;

{This module checks to see if user has correct UIC codes to change a 
protected board.  If the user has the privilege, the variable PROTECTED
is set to false, otherwise PROTECTED is set to true}

const
   invalid_uic = -1111;
   group_size = 10;

type
  group_char = varying[group_size] of char;

var
   manager : packed array [1..topic_length] of char;
   temp : topic_uic;
   temp_group : group_char;
   temp_member : group_char;
   temp_invalid : group_char;

begin
  $setprv(1,prv$m_sysprv);
  manager := 'BB_MANAGER';

  open(tu,file_location+'topic_users.dat',access_method:=keyed,
       organization:=indexed,history:=readonly,error:=continue);

  if (status(tu) > 0) then
    begin
      write_menu('','All topic boards are protected. '+
                    'Press any key to continue...');
      getchar;
      protected := true;
    end
  else
    begin
      temp.topic := current_topic;
      temp.user_group := user_group;
      temp.member_group := member_group;

      {Internal writes change from integer to correct character format stored 
      in the TU file}
      writev(temp_group,temp.user_group);
      writev(temp_member,temp.member_group);
      writev(temp_invalid,invalid_uic);

      temp.key := temp.topic+temp_invalid+temp_invalid;
      findk(tu,0,temp.key,eql);
      if (not ufb(tu)) then           {BOARD AVAILABLE TO ANYONE}
        protected := false
      else
        begin                         {CHECK FOR BB_MANAGER}
          temp.key := manager+temp_group+temp_member;
          findk(tu,0,temp.key,eql);
          if (not ufb(tu)) then       {USER IS VALID BB_MANAGER}
            protected := false
          else 
            begin                     {CHECK FOR VALID UIC}
              temp.key := temp.topic+temp_group+temp_member;
              findk(tu,0,temp.key,eql);
              if (not ufb(tu)) then   {USER HAS VALID UIC}
                protected := false
              else                    {ELSE BOARD IS PROTECTED}
                protected := true;
            end;
        end;
    end;

  close(tu,error:=continue);
  $setprv(0,prv$m_sysprv);
end;

end.
