$!	DS200DEF.COM -	Set up DECserver command key definitions for a VT200
$!			series terminal.
$!
$	SAVERIFY = F$VERIFY(0)	! Save and turn off verification
$	SET TERMINAL/INQUIRE	! Make sure we're using a VT200 series terminal.
$	IF F$GETDVI("TT:","TT_DECCRT2") THEN GOTO START
$	WRITE SYS$OUTPUT -
		"Sorry, but this procedure works only on VT2xx terminals."
$	GOTO FINISHED
$ START:
$	SET SYMBOL/SCOPE=NOGLOBAL ! Don't want global symbol defs to interfere.
$	ESC[0,8] = 27
$	CR[0,8] = 13
$	NCP = "$NCP"
$	TYPE SYS$INPUT

You must have already run SYS$SYSROOT:[DECSERVER]DSVCONFIG.COM and set up the
server definitions there.  This procedure assumes server names of DSVR0x where
x is a one digit number.  If you name your servers otherwise, you will want to
edit this command procedure to change the default names.

This procedure assumes that you will set up a service called VAX in the LTLOAD
command procedure:      CREATE SERVICE VAX /IDENT="ANY VAX" /NOLOG

After you have defined all the server ports and edited LTLOAD.COM to be the
way you want it, you should do two things: 1) Re-boot the VAX system, and
2) Initialize the DECservers (unplug them and plug them back in).

You have the option of giving this service as dedicated or preferred.  With a
dedicated service, the terminal can only connect to the VAX service.  With the
preferred service, the terminal automatically connects to the VAX service, but
can get to the Local> prompt at the server and do other things.  If you do not
set the port for one of these, the users will have to connect to the service
manually when they log in.

$	INQUIRE PORTPASS "DECserver port password [ACCESS]"
$	IF PORTPASS .EQS. "" THEN PORTPASS = "ACCESS"
$	INQUIRE PRIVPASS "DECserver privileged password [SYSTEM]"
$	IF PRIVPASS .EQS. "" THEN PRIVPASS = "SYSTEM"
$	INQUIRE DEDSER "Do you want to set ports for DEDICATED service [N]"
$	PRESER = "NO"
$	IF .NOT. DEDSER THEN -
	INQUIRE PRESER "Do you want to set ports for PREFERRED service [N]"
$	SERTYPE = ""
$	IF DEDSER THEN SERTYPE = "BRE DIS DED SER VAX AUTOC ENA "
$	IF PRESER THEN SERTYPE = "BRE LOC PRE SER VAX AUTOC ENA "
$	GOSUB DEFINE_KEYNUMBERS		! Define the key names and numbers.
$!
$!*****************************************************************************
$! Define key strings here. Use the function key names (F6-F14,HELP,DO,F17-F20)
$! Example:   $ F14 := SHOW SYSTEM
$!*****************************************************************************
$!
$!	Load keys to get into server
$	F6 = "NCP CONNECT NODE DSVR0"
$	F7 = "''PORTPASS'''CR'"
$	F8 = "SET PRIVILEGED''CR'"
$	F9 = "''PRIVPASS'''CR'"
$!
$!	Define server name
$	F10 = "DEFINE SERVER NAME DSVR0"
$!
$!	Define port characteristics
$!	Do F11, (F12 or F13)
$	F11 = "DEF POR "
$!	> interactive port characteristics
$	F12 = " ACC LOC AUTOB ENA ALT SPE NON ''SERTYPE'INA LOG ENA''CR'"
$!	> printer port characteristics
$	F13 = " ACC REM AUTOB DIS ALT SPE NON BRE DIS DED SER NON PRE SER NON AUTOC DIS INA LOG ENA''CR'"
$!
$!	Finished
$	F14 = "LOGOUT''CR'"
$!
$!*****************************************************************************
$!
$!		 Load the above keys into the VT2xx terminal
$	I = 0
$ LOOP:
$	P1 = F$EDIT(F$EXTRACT(I,4,KEYDEF),"TRIM")	! Get the key name.
$	IF F$TYPE('P1') .EQS. "" THEN GOTO TRY_NEXT	! Has it been defined?
$	P2 = 'P1'					! Get the string.
$	KEYNUM = F$EXTRACT(I+4,2,KEYDEF)		! Get the key number.
$	GOSUB CONVERT_STR_TO_HEX			! Convert string to HEX.
$	WRITE SYS$OUTPUT "''ESC'P1;1|''KEYNUM'/''HEXSTR'''ESC'\" ! Do it.
$	WRITE SYS$OUTPUT "Shift ''P1' defined as " + P2	! Tell what we did.
$ TRY_NEXT:
$	I = I + 6				! Index to next key in KEYDEF.
$	IF I .GT. 84 THEN GOTO FINISHED		! Are we finished yet?
$	GOTO LOOP				! Go do another one.
$!
$!	Subroutine to convert string P2 to it's hex representation HEXSTR
$ CONVERT_STR_TO_HEX:
$	LEN = F$LENGTH(P2)			! Get the length of the string.
$	X = 0					! Initialize offset into string.
$	HEXSTR = ""				! Initialize hex representation.
$ CVT_LOOP:
$	CHR = F$EXTRACT(X,1,P2)			! Get the next character.
$	HEX = F$FAO("!XB",F$CVUI(0,8,CHR))	! Get the hex equivalent.
$	HEXSTR = HEXSTR + HEX		! Add it to the hex representation.
$	X = X + 1				! Increment offset.
$	IF X .GE. LEN THEN RETURN		! Finished string yet?
$	GOTO CVT_LOOP				! Go convert next character.
$!
$!			Define the key names and numbers
$ DEFINE_KEYNUMBERS:
$	KEYDEF[00,4] := F6	! 4 character maximum for key name
$	KEYDEF[04,2] := 17	! 2 character maximum for key number
$	KEYDEF[06,4] := F7
$	KEYDEF[10,2] := 18
$	KEYDEF[12,4] := F8
$	KEYDEF[16,2] := 19
$	KEYDEF[18,4] := F9
$	KEYDEF[22,2] := 20
$	KEYDEF[24,4] := F10
$	KEYDEF[28,2] := 21
$	KEYDEF[30,4] := F11
$	KEYDEF[34,2] := 23
$	KEYDEF[36,4] := F12
$	KEYDEF[40,2] := 24
$	KEYDEF[42,4] := F13
$	KEYDEF[46,2] := 25
$	KEYDEF[48,4] := F14
$	KEYDEF[52,2] := 26
$	KEYDEF[54,4] := HELP
$	KEYDEF[58,2] := 28
$	KEYDEF[60,4] := DO
$	KEYDEF[64,2] := 29
$	KEYDEF[66,4] := F17
$	KEYDEF[70,2] := 31
$	KEYDEF[72,4] := F18
$	KEYDEF[76,2] := 32
$	KEYDEF[78,4] := F19
$	KEYDEF[82,2] := 33
$	KEYDEF[84,4] := F20
$	KEYDEF[88,2] := 34
$	RETURN
$!
$ FINISHED:
$	SAVERIFY = F$VERIFY(SAVERIFY)	! Restore verification
$	EXIT
$!
$!  DIRECTIONS FOR USING THE KEYS DEFINED IN THIS COMMAND PROCEDURE:
$!
$!  1:  Press <SHIFT-F6> and [1,2,3,4,etc], then press <RETURN>.
$!      This runs NCP to connect you to a DECserver.
$!
$!  2:  Press <RETURN>, the system will beep and display the "#" sign.
$!
$!  3:  Press <SHIFT-F7>.  This enters the server password.
$!
$!  4:  Type anything for the username, and press <RETURN>.
$!
$!  5:  Press <SHIFT-F8>.  This enters the "SET PRIVILEGED" command.
$!
$!  6:  Press <SHIFT-F9>.  This enters the privileged password.
$!
$!  7:  Press <SHIFT-F10> and [1,2,3,4,etc] (enter the same thing you did
$!      in step 1), then press <RETURN>.  This tells the server what his
$!      name is.
$!
$!  8:  Press <SHIFT-F11> and the port number.  Do NOT press <RETURN>.   
$! 
$!  9:  If the device on the port is a CRT press <SHIFT-F12>,
$!      If the device on the port is a printer press <SHIFT-F13>.
$!
$! 10:  Define the port baud rate if it is different from the default value.
$!      You may use <SHIFT-F11>, the port number, and "SPEED n" where n is
$!      the baud rate you want to use.  The default value is 9600bps.
$!
$! 11:  Repeat steps 8 through 10 for each port (1-8).  This defines the port
$!      characteristics.
$!
$! 12:  Press <SHIFT-F14>.  This will log you out of the server.
$!
$! 13:  Press <CTRL-D>.  This will return you to the VMS prompt.
$!
$! 14:  Repeat steps 1 through 13 for each terminal server.
$!
$! Note that the server power must be unplugged and plugged back in before
$! these server and port definitions will have any effect.  Also, the VAX
$! system will need to be re-booted with an edited LTLOAD before any printer
$! ports or dedicated or preferred service will work.
