$!	READTAPE.COM - Procedure to read a foreign tape using ETAPE
$!
$	SAVERIFY = F$VERIFY(0)
$	COPY/NOLOG SYS$INPUT SYS$OUTPUT

This program aids in using ETAPE to read unlabeled ASCII or EBCDIC tapes.

The output files will be of the form:  FIn.ETP  where n is an integer which
begins with 1 and is incremented for each file read.  You will need to rename
the files.

There is no check for valid answers in this procedure.  Any garbage you enter
will be passed along to ETAPE, which will probably cause a fatal error.

$	IF P1 .NES. "" THEN GOTO START
$	INQUIRE P1 "Device (MFA0: or MFA1:)
$	IF P1 .EQS. "" THEN GOTO FINISHED
$ START:
$	INQUIRE NUMFILES "Number of files"
$	IF NUMFILES .EQ. 0 THEN GOTO FINISHED
$	INQUIRE BLKSIZ "Blocksize"
$	IF BLKSIZ .EQ. 0 THEN GOTO FINISHED
$	INQUIRE RECLEN "Logical record length"
$	IF RECLEN .EQ. 0 THEN GOTO FINISHED
$	INQUIRE TRANS "Translate from EBCDIC (Y/N) <Y>"
$	IF TRANS .EQS. "" THEN TRANS = "YES"
$	DEFDIR = F$ENVIRONMENT("DEFAULT")
$	INQUIRE OUTDIR "Output directory <''DEFDIR'>"
$	IF OUTDIR .EQS. "" THEN OUTDIR = DEFDIR
$!
$	CREATE/DIR 'OUTDIR'			! Make sure directory exists
$	OPEN/WRITE COMFIL ETAPEGETFIL.COM	! Create command file with ETAPE
$	PC = "WRITE COMFIL"			!  commands to execute
$	PC "$! Temporary command file for READTAPE.COM"
$	PC "$ SET VERIFY"
$	PC "$ ALLOCATE ''P1' TAPE"
$	PC "$ MOUNT/FOREIGN TAPE"
$	PC "$ DEFINE/USER_MODE ET ''OUTDIR'"
$	PC "$ RUN UTIL:ETAPE"
$	IF .NOT. TRANS THEN PC "UT"
$	PC "BL ''BLKSIZ'"
$	PC "LR ''RECLEN'"
$	TIMES = 1
$ GETFIL:
$	PC "FI ET:FI''TIMES'.ETP"
$	PC "TF"
$	TIMES = TIMES + 1
$	IF TIMES .LE. NUMFILES THEN GOTO GETFIL
$	PC "QU"
$	PC "$ DISMOUNT/UNLOAD TAPE"
$	PC "$ DEALLOCATE TAPE"
$	PC "$ DEASSIGN TAPE"
$	PC "$ SET NOVERIFY"
$	CLOSE COMFIL
$!
$	@ETAPEGETFIL.COM			! Now execute the command file
$	DELETE ETAPEGETFIL.COM;*		!  and delete it.
$ FINISHED:
$	SAVERIFY = F$VERIFY(SAVERIFY)
$	EXIT
