$!	REVIEW.COM - Review files in a directory
$!
$!	P1 = Directory to review (defaults to current)
$!
$	SAVERIFY = F$VERIFY(0)
$	SET NOON
$	TYPE/NOPAGE SYS$INPUT

     This command procedure is used to review the files in a directory.

     Valid review options (may be abbreviated to the first letter):
     TYPE      Type the file on your terminal (only recommended for text)
     EDIT      Edit the file on your terminal (in read-only mode)
     DELETE    Delete the file from this directory
     MOVE      Copy the file to another directory and then delete it
     COMMAND   Enter any DCL command
     NEXTFILE  Go review the next file (the default response)
     QUIT      Stop this review

$	IF P1 .EQS. "" THEN P1 = F$ENVIRONMENT("DEFAULT")
$!	PURGE/LOG 'P1'
$	DEVICE = F$PARSE(P1,,,"DEVICE","SYNTAX_ONLY")
$	P1 = F$PARSE(P1,"*.*;*",,,"SYNTAX_ONLY")
$	EXI*T = "GOTO REVIEW"
$	STO*P = "GOTO REVIEW"
$!
$ OPTION_N:
$	FILNAM = F$SEARCH(P1)
$	IF FILNAM .EQS. "" THEN GOTO FINISHED
$	DIRANDNAME = FILNAM - DEVICE
$	IF F$LOCATE(".DIR;1",FILNAM) .EQ. F$LENGTH(FILNAM) THEN GOTO REVIEW
$	WRITE SYS$OUTPUT "''DIRANDNAME' being skipped (directory file)"
$	GOTO OPTION_N
$ REVIEW:
$	INQUIRE OPTION "''DIRANDNAME' (Type,Edit,Del,Move,Com,Next)"
$	OPTION = F$EXTRACT(0,1,F$EDIT(OPTION,"COMPRESS"))
$	IF OPTION .EQS. "" THEN OPTION = "N"
$	IF F$LOCATE(OPTION,"TEDMCN") .EQ. 6 THEN GOTO QUIT
$	GOTO OPTION_'OPTION'
$!
$ OPTION_T:
$	TYPE/PAGE 'FILNAM'
$	GOTO REVIEW
$!
$ OPTION_E:
$	DEFINE/USER_MODE SYS$INPUT SYS$COMMAND
$	EDIT 'FILNAM'/READ
$	GOTO REVIEW
$!
$ OPTION_D:
$	ON ERROR THEN GOTO DEL_ERR
$	SET PROTECTION=W:RWED 'FILNAM'
$	SET FILE/ACL/DELETE 'FILNAM'
$	DELETE/LOG 'FILNAM'
$	GOTO OPTION_N
$ DEL_ERR:
$	SET NOON
$	WRITE SYS$OUTPUT "%REVIEW-F-ERRDEL, Error deleting ''FILNAM'"
$	GOTO REVIEW
$!
$ OPTION_C:
$	READ/PROMPT="DCL Command: " SYS$COMMAND COMMAND
$	'COMMAND'
$	SET NOVERIFY
$	GOTO REVIEW
$!
$ OPTION_M:
$	INQUIRE NEWPLACE "Destination"
$	IF NEWPLACE .EQS. "" THEN GOTO REVIEW
$	ON WARNING THEN GOTO COP_ERR
$	COPY/LOG/NOCONFIRM 'FILNAM' 'NEWPLACE'
$	SET NOON
$	GOTO OPTION_D
$ COP_ERR:
$	SET NOON
$	WRITE SYS$OUTPUT -
		"%REVIEW-W-ERRCOPY, Error copying ''FILNAM' to ''NEWPLACE'"
$	GOTO OPTION_M
$!
$ QUIT:
$	INQUIRE STOP_NOW "Do you wish to quit <No>"
$	IF STOP_NOW THEN GOTO FINISHED
$	GOTO REVIEW
$ FINISHED:
$	EXIT = "EXIT"
$	WRITE SYS$OUTPUT "%REVIEW-I-FINISH, Review of ''P1' finished."
$	SAVERIFY = F$VERIFY(SAVERIFY)
$	EXIT
