
	program Profilometer


C	SECTION 1

c---
c  variable declarations  ( Group screen )

        Integer*2 GRow, GCol, GCurField, GTermKeys(30)
        Integer*2 GNumberOfFields, GLastKey, GFirstFld, GLastFld
        Logical*1 GNext, GPrevious, GExit, GRefresh

        character* 4    Version
        character* 9    Date
        character* 6    GroupID
        character* 3    Operator
        character*65    Description(3)
        integer*2       ScanRate
        character* 6    StageVelocity


C	SECTION 2

c---
c  variable declarations  ( Specimen screen )

        Integer*2 SRow, SCol, SCurField, STermKeys(30)
        Integer*2 SNumberOfFields, SLastKey, SFirstFld, SLastFld
        Logical*1 SNext, SPrevious, SExit, SRefresh

        character* 6    SpecimenID
        character*12    Orientation


C	SECTION 3

c---
c Misc variables
	integer*2 Abort, FieldNumber
	logical*1 More, Valid

C	SECTION 4

c---
c Variable initialization

	data Abort /141/

	data GRow /1/ , GCol /1/ , SRow /11/ , SCol /39/

c---
c immediate termination on F1 key
        data GTermKeys/ 0, 1, 141, 27*0 /

        data STermKeys/ 30*0 /

        Version = '1.00'
        call Today( Date )
        GroupID = ' '
        Operator = ' '
        Description(1) = ' '
        Description(2) = ' '
        Description(3) = ' '
        ScanRate = -1
        StageVelocity = '1.0'
	SpecimenID = ' '
	Orientation = 'Transverse'


c---
c Total number of screen parameters

        GNumberOfFields = 9
	GFirstFld = 1
	GLastFld = 9

        SNumberOfFields =   2
	SFirstFld = 1
	SLastFld = 2


C	SECTION 5

c--	Initialize Terminal Routines
	call TTYinit
	call EchoOff
	call KpdOn

c--	Display Specimen Group Information

100	continue

C	SECTION 6
	GCurField = 3

150	continue

C	SECTION 7
        call GroupClear( GRow, GCol )

C	SECTION 8
        call GroupTextDsp( GRow, GCol )

C	SECTION 9
        call GroupDataDsp( GRow, GCol, GFirstFld, GLastFld
     1 , Version, Date, GroupID, Operator, Description, ScanRate
     1 , StageVelocity
     1   )

C	SECTION 10

c--	repeat
200	continue

c--	  Get Specimen Group Information

C	SECTION 11
300       call GroupEdit( GRow, GCol, GFirstFld, GLastFld, GCurField
     1   , GTermKeys, Version, Date, GroupID, Operator, Description
     1   , ScanRate, StageVelocity
     1   , GNext, GPrevious, GExit, GRefresh, GLastKey )

C	SECTION 11 [A]
	  if( GLastKey .eq. Abort ) then
	    call KpdOff
	    call ClrScr
	    stop '[Program Aborted]'

C	SECTION 11 [B]
	  else if( GNext ) then
	    GCurField = 3

C	SECTION 11 [C]
	  else if( GPrevious ) then
	    GCurField = GNumberOfFields

C	SECTION 11 [D]
	  else if( GRefresh ) then
	    goto 150

	  end if

C	SECTION 11 [E]
	  if( .not. GExit ) goto 300


c--	  Validate Specimen Group Information

C	SECTION 12
          call GroupValidate( GFirstFld, GLastFld
     1   , Version, Date, GroupID, Operator, Description, ScanRate
     1   , StageVelocity
     1   , Valid, FieldNumber )

	  if( .not. Valid ) then
	    GCurField = FieldNumber
	    goto 300
	  end if


390	  continue

C	SECTION 13
	  SCurField = 1

C	SECTION 14
c--	  repeat
400	  continue

c--	    Display and get Specimen Information

C	SECTION 15
            call SpecClear( SRow, SCol )

C	SECTION 16
            call SpecTextDsp( SRow, SCol )

C	SECTION 17
            call SpecDataDsp( SRow, SCol, SFirstFld, SLastFld
     1     , SpecimenID, Orientation
     1       )

C	SECTION 18
500         call SpecEdit( SRow, SCol, SFirstFld, SLastFld, SCurField
     1     , STermKeys, SpecimenID, Orientation
     1     , SNext, SPrevious, SExit, SRefresh, SLastKey )

C	SECTION 18 [A]
            if( SNext ) then
	      SCurField = 1

C	SECTION 18 [B]
	    else if( SPrevious ) then
	      SCurField = SNumberOfFields

C	SECTION 18 [C]
	    else if( SRefresh ) then
              call GroupClear( GRow, GCol )
              call GroupTextDsp( GRow, GCol )
              call GroupDataDsp( GRow, GCol, GFirstFld, GLastFld
     1       , Version, Date, GroupID, Operator, Description, ScanRate
     1       , StageVelocity
     1         )
	      goto 400

	    end if

C	SECTION 18 [D]
	    if( .not. SExit ) goto 500

C	SECTION 19
c--	    Collect and Plot Test Data
	    call DoTest

C	SECTION 20
c--	    More Specimens?
	    call MoreSpecs( More )

C	SECTION 21
c--	      if Yes then Display Specimen Group Information
	      if( More ) then
                call GroupClear( GRow, GCol )
                call GroupTextDsp( GRow, GCol )
                call GroupDataDsp( GRow, GCol, GFirstFld, GLastFld
     1         , Version, Date, GroupID, Operator, Description, ScanRate
     1         , StageVelocity
     1           )
	      end if

C	SECTION 22
c--	  until no more specimens
	  if( More ) goto 390

C	SECTION 23
c--	  Another Specimen Group?
	  call MoreGroups( More )

C	SECTION 24
c--	until no more specimen groups
	if( More ) goto 100

C	SECTION 25
	call KpdOff
	call ClrScr
	stop '[Normal Program Termination]'

c--	program end
	end
