	SUBROUTINE LOADCOMMANDS( CMDLIST , NUMCOMMANDS , PNTR ,
     1 CMDLENGTH , NOFCHRSFORUNIQUEID , IER )

	INTEGER*2 NUMCOMMANDS, PNTR( 2 , NUMCOMMANDS ),
     1   CMDLENGTH( NUMCOMMANDS ), NUMCMDSFOUND,
     1   NOFCHRSFORUNIQUEID( NUMCOMMANDS ) , I1 , I2 ,
     1   IER , SCNERR , LOC, L4, L1, L2, L3

	CHARACTER*(*) CMDLIST
	CHARACTER*1 SEPARATORS
	CHARACTER*1 QUOTE
	CHARACTER*132 TOKEN

	common /LdCmd/ NumCmdsFound

C
CC--
CC Constant initialization    ( only blanks are separators )
CC--

	DATA SEPARATORS / ' ' /


CC--
CC Variable initialization
CC--

	SCNERR = 0
	IER = 0
	QUOTE = CHAR(0)

CC--
CC Convert command list to upper case
CC--

	CALL CVTTOUPCASE( CMDLIST )

CC--
CC Call PARSE to set up pointer and length info
CC--

	CALL PARSE( CMDLIST , ' ' , QUOTE , SEPARATORS ,
     1   NUMCOMMANDS , PNTR , CMDLENGTH , NUMCMDSFOUND ,
     1   SCNERR )

	IF( SCNERR .NE. 0 ) THEN

	  IER = 1

	ELSE IF( NUMCMDSFOUND .EQ. 0 ) THEN

	  IER = 2

	ELSE
C

CC--
CC Determine number of characters for unique identification for each command
CC--

	  DO 100 I1 = 1 , NUMCMDSFOUND

	    TOKEN = ' '
	    L1 = CMDLENGTH(I1)+1
	    L2 = PNTR(1,I1)
	    L3 = PNTR(2,I1)
	    TOKEN(2:L1) = CMDLIST( L2:L3 )

CC--
CC Change 1st character of current token to a ^A so it will
CC not be found by search
CC--

	    CMDLIST( L2:L2 ) = CHAR(1)

CC--
CC Search CMDLIST for occurence of command starting with 1 character
CC and continuing through all characters
CC--

	    I2 = 1
	    LOC = 1

C	    DO WHILE( LOC .NE. 0 .AND. I2 .LE. CMDLENGTH(I1) )
10	    IF( LOC .NE. 0 .AND. I2 .LE. CMDLENGTH(I1) ) GOTO 30
	    GOTO 40

30	    CONTINUE

	      L4 = I2+1
	      LOC = INDEX( CMDLIST , TOKEN(1:L4) )
	      IF( LOC .NE. 0 ) I2 = I2 + 1

C	    END DO
	    GOTO 10
40	    CONTINUE

CC--
CC Replace 1st character in token to its original value
CC--

	    CMDLIST( L2:L2 ) = TOKEN(2:2)

CC--
CC Record the "number of characters for unique identification" for command I1
CC--

	    NOFCHRSFORUNIQUEID( I1 ) = MIN0( I2 , CMDLENGTH(I1) )

100	  CONTINUE


	END IF


	RETURN
	END
C

	SUBROUTINE DECODECMD( CMDLIST, NUMCOMMANDS, INCMD, PNTR,
     1   CMDLENGTH, NofChrsForUniqueId, OUTCMD, CMDINDEX, IER )

	INTEGER*2 NUMCOMMANDS, PNTR( 2 , NUMCOMMANDS ),
     1   CMDLENGTH( NUMCOMMANDS ), NUMCMDSFOUND,
     1   NOFCHRSFORUNIQUEID( NUMCOMMANDS ) , CMDINDEX ,
     1   LNTH , ICMD , ICHR , IER , TOKENLENGTH, L5, L6, L7

	INTEGER*2 LENGTH

	CHARACTER*(*) CMDLIST , INCMD , OUTCMD
	CHARACTER*132 TOKEN

	LOGICAL*1 MATCH

	common /LdCmd/ NumCmdsFound

CC--
CC Search command list for a unique identification.
CC
CC Error code, IER = 1 if no such command
CC		  = 2 if ambiguious command
CC
CC If command is found, OUTCMD will hold the full command
CC--


CC--
CC Variable initialization
CC--

	IER = 0
	OUTCMD = ' '
	CMDINDEX = 0

CC--
CC Get length of input command
CC--

	LNTH = LENGTH( INCMD )
	IF( LNTH .EQ. 0 ) THEN
	  IER = 1
	  RETURN
	END IF

CC--
CC Copy input command into TOKEN
CC--

	TOKEN = ' '
	TOKENLENGTH = MIN0( 132 , LNTH )
	TOKEN( 1 : TOKENLENGTH ) = INCMD( 1 : TOKENLENGTH )
CC--
CC Convert TOKEN to upper case
CC--

	CALL CVTTOUPCASE( TOKEN( 1 : TOKENLENGTH ) )
C

CC--
CC Search all commands
CC--

	DO 200 ICMD = 1 , NUMCMDSFOUND

CC-- If length of input command > length of command then not a match

	  IF( LNTH .LE. CMDLENGTH( ICMD ) ) THEN

	    ICHR = 1
	    MATCH = .TRUE.
C	    DO WHILE( ICHR .LE. LNTH .AND. MATCH )
110	    IF( ICHR .LE. LNTH .AND. MATCH ) GOTO 130
	    GOTO 140

130	    CONTINUE

	      L5 = PNTR(1,ICMD)+ICHR-1
	      IF( TOKEN(ICHR:ICHR) .NE. CMDLIST( L5:L5 ) )
     1       MATCH = .FALSE.

	      ICHR = ICHR + 1

C	    END DO
	    GOTO 110
140	    CONTINUE

	    IF( MATCH ) THEN
	      L6 = PNTR(1,ICMD)
	      L7 = PNTR(2,ICMD)
	      IF( LNTH .GE. NOFCHRSFORUNIQUEID( ICMD ) ) THEN
	        OUTCMD = CMDLIST( L6:L7 )
	        CMDINDEX = ICMD
	      ELSE
	        IER = 2
	      END IF
	      RETURN
	    END IF

	  END IF

200	CONTINUE

CC--
CC No match was found
CC--

	IER = 1

	RETURN


	END
   
