
/*  useful structure  */

	  struct my_register
	  {
	    unsigned int low:8;
	    unsigned int high:8;
	  };

	  union copies
	  {
	    struct my_register word;
	    int n;
	  };


/*  produces sound on PC speaker  */
	far fortran Sound( freq )
	  int *freq;
	{
	  union copies a;
	  static int Init = -1,
	             sc = 2,
	             rl = 3,
	             mode = 3,
	             bcd = 0;
	  int control_word, divisor;

	  if( Init )
	  { control_word = sc*0x40 + rl*0x10 + mode*0x2 + bcd;
	    outp( 0x43, control_word );
	    Init = 0;
	  }

	  divisor = *freq;
	  a.n = 1193182 / divisor;

	  outp( 0x42, a.word.low );
	  outp( 0x42, a.word.high );

	  a.word.low = inp( 0x61 );
	  a.word.low = a.word.low | 3;
	  outp( 0x61, a.word.low );

	}


	far fortran NoSound()
	{
	  union copies a;

	  a.word.low = inp( 0x61 );
	  a.word.low = a.word.low & 0xfc;
	  outp( 0x61, a.word.low );
	}
