	page ,132

;-------------------------------------------------------------------------

DATA	SEGMENT	PUBLIC	'DATA'
		DB	'CCTRAP  '
SP_SAVE		DW	0
		DD	CCTRAP
		DD	0


Int23_offset	DW	?
Int23_segment	DW	?

ESCAPE	EQU	01Bh
CR	EQU	00Dh
LF	EQU	00Ah

MESSAGE	DB	ESCAPE,"[m"	; set attribute to normal
	DB	ESCAPE,"[2J"	; clear the screen
	DB	ESCAPE,"[7m"	; set attribute to reverse
	DB	"[Image aborted by user]",CR,LF
	DB	ESCAPE,"[m"	; set attribute back to normal
	DB	"$"

PROMPT	DB	ESCAPE,"(B"	; set character set to normal
	DB	ESCAPE,"[5m"	; set attribute to blink
	DB	ESCAPE,"[23;1H"	; move to row-23 and col-1
	DB	"Exit? (Y/N)"	; display the prompt
	DB	"$"

PCLR	DB	ESCAPE,"[m"	; set attribute to normal
	DB	ESCAPE,"[23;1H"	; move to row-23 and col-1
	DB	"Type ^R to repaint screen"
	DB	"$"

DATA	ENDS

;-------------------------------------------------------------------------

;	PARAMETER LIST CONTROL BLOCK

FRAME	STRUC

	PARM1	DD	?	;Ctrl-C trapping flag
				; 0-disable trapping
				; 1-enable trapping

FRAME	ENDS
;-------------------------------------------------------------------------


;-------------------CODE SEGMENT DEFINITION FOR PROFORT-------------------

CODE	SEGMENT	PARA	PUBLIC	'CODE'
	ASSUME	CS:CODE,DS:DATA			;required by RMFORT
	DW	SEG DATA			;required by RMFORT
;-------------------------------------------------------------------------
PUBLIC	CCTRAP
CCTRAP	PROC	FAR
	ASSUME	CS:CODE			;
	MOV	AX,DATA			;standard preamble, only CS,
	MOV	DS,AX			;SS, and SP must be maintained
	MOV	SP_SAVE,SP		;for PROFORT. Module address is

	LDS	SI,ES:PARM1[BX]
	MOV	CX,[SI]
	MOV	AX,DATA
	MOV	DS,AX

	CMP	CX,0
	JNE	ENABLE

DISABLE:
; if the interupt vector has not been changed then just return
	MOV	AX,Int23_offset
	CMP	AX,0
	JE	RETURN

; restore old interupt vector
	MOV	AX,Int23_segment
	MOV	DX,Int23_offset
	MOV	DS,AX
	MOV	AH,25h
	MOV	AL,23h
	INT	21h
	JMP	RETURN

ENABLE:
; save the old interupt vector for later
	MOV	AH,35h
	MOV	AL,23h
	INT	21h
	MOV	AX,ES
	MOV	Int23_segment,AX
	MOV	Int23_offset,BX

; set vector to our service routine
	MOV	AX,SEG $TRAP
	MOV	DX,OFFSET $TRAP
	MOV	DS,AX
	MOV	AH,25h
	MOV	AL,23h
	INT	21h

RETURN:
	MOV	AX,DATA
	MOV	DS,AX
	MOV	SP,SP_SAVE
	RET

CCTRAP	ENDP

;-------------------------------------------------------------------------
PUBLIC	$TRAP
$TRAP	PROC	FAR
	PUSH	DS
	PUSH	AX
	PUSH	DX
	ASSUME	CS:CODE
	MOV	AX,DATA
	MOV	DS,AX

; get the response from the user
	MOV	DX,OFFSET PROMPT		; display the prompt
	MOV	AH,009h
	INT	21h

	MOV	AH,8				; get the response
	INT	21h				; from user
	XOR	AH,AH				; char is in AL

	CMP	AL,059h				; is it a 'Y'
	JE	EXIT				; yes, then exit program

	CMP	AL,079h				; is it a 'y'
	JNE	CONT				; no then return and continue program

EXIT:
; clear the screen, set the attribute and display message
	MOV	DX,OFFSET MESSAGE
	MOV	AH,009h
	INT	21h

	STC				; abort the program-carry set
	POP	DX
	POP	AX
	POP	DS
	RET

CONT:
; clear the prompt from the screen before exit and restore the cursor
	MOV	DX,OFFSET PCLR
	MOV	AH,009h
	INT	21h

	POP	DX
	POP	AX
	POP	DS
	IRET

$TRAP	ENDP

;-------------------------------------------------------------------------
CODE	ENDS
	END
