	Title RunIt
	page ,132

	include util.mac
	include ifthen.mac
	include while.mac

;-------------------------------------------------------------------------

Data	segment

		db	'RUNIT   '
SP_Save		dw	0
		dd	RUNIT
		dd	0

SS_Save		dw	0

FileName	db	81 dup (0)

CmdLine		db	83 dup (0)

FCB1		db	44 dup (0)
FCB2		db	44 dup (0)

ParamBlk	equ	$
EnvSeg		DW	0
CmdBufPtr	DW	offset CmdLine	; offset of command line input
		DW	Data		; segment of command line input
FCB1Ptr		DW	offset FCB1
		DW	Data
FCB2Ptr		DW	offset FCB2
		DW	Data

NonBlankLnth	dw	?

DATA	ENDS

;-------------------------------------------------------------------------

;	FORTRAN parameter block

Frame	struc

	Parm1	DD	?	; FileName (character*80)
	Parm2	DD	?	; Command line input (character*80)

Frame	ends

;-------------------------------------------------------------------------


;-------------------CODE SEGMENT DEFINITION FOR RM/FORT-------------------

Code	segment	para	public	'CODE'
	assume	cs:Code,ds:Data			;required by RMFORT
	dw	seg Data			;required by RMFORT
;-------------------------------------------------------------------------
public	RunIt
RunIt	proc far

	mov ax, Data			;standard preamble, only CS,
	mov ds, ax			;SS, and SP must be maintained
	mov SS_Save, ss			;for RMFORT.
	MOV SP_Save, sp

	push es				; Save frame pointer
	push bx

;	Copy file name ( 1st parameter ) into FileName and make it ASCIZ

	lds si,es:Parm1[bx]		; DS:SI points to the FORTRAN character
					; string

	mov cx, ds:[si]			; cx holds the allocated length
	if$ cx, g, 80			; ( clamp to 80 )
	  mov cx, 80
	endif$

	les si,ds:[si+2]		; es:si now points to the text of the
					; string
	mov bx, cx
	dec bx
	mov al, byte ptr es:[si+bx]
	while al, e, 32			; find non-blank length of text
	  dec bx			; and place in bx
	  mov al, es:[si+bx]
	endwhile
	inc bx
	if$ bx, l, 0
	  mov bx, 0
	endif$

	mov ax, data			; restore addressability
	mov ds, ax

	mov NonBlankLnth, bx	

	mov di, offset FileName

	mov bx, 0			; perform the copy
	while bx, l, NonBlankLnth
	  mov al, byte ptr es:[si+bx]
	  mov byte ptr ds:[di+bx], al
	  inc bx
	endwhile

	mov byte ptr ds:[di+bx], 0	; Make it ASCIZ


;	Copy command line ( 2nd parameter ) to CmdLine+2

;	Note: CmdLine holds the length of the text ( including the space at
;						     CmdLine+1 )
;	      CmdLine+1 holds a space

	pop bx				; restore frame pointer
	pop es

	lds si, es:Parm2[bx]		; DS:SI points to the FORTRAN character
					; string

	mov cx, ds:[si]			; cx holds the allocated length
	if$ cx, g, 80			; ( clamp to 80 )
	  mov cx, 80
	endif$

	les si, ds:[si+2]		; es:si now points to the text of the
					; string

	mov bx, cx
	dec bx
	mov al, byte ptr es:[si+bx]
	while al, e, 32			; find non-blank length of text
	  dec bx			; and place in bx
	  mov al, byte ptr es:[si+bx]
	endwhile
	inc bx
	if$ bx, l, 0
	  mov bx, 0
	endif$

	mov ax, data			; restore addressability
	mov ds, ax

	mov NonBlankLnth, bx	

	mov di, offset CmdLine
	inc bx
	mov ds:[di], bx			; Length of cmd line = nb lnth + 1
					;   ( for the extra space character )

	mov byte ptr ds:[di+1], 32	; add a space

	mov bx, 0			; perform the copy
	while bx, l, NonBlankLnth
	  mov al, byte ptr es:[si+bx]
	  mov byte ptr ds:[di+bx+2], al
	  inc bx
	endwhile

	mov byte ptr ds:[di+bx+2], 13	; add a carriage return
					; Notice that the length does not
					; account for the carriage return...
					; ...interesting.


;	It is not necessary to modify allocated memory since the RM FORTRAN
;	compiler generates start-up code that modifies memory when the
;	program runs.


;	Execute new program

	mov ax, data			; restore addressability
	mov ds, ax

	mov dx, offset FileName		; ds:dx points to ASCIZ file name

	mov ax, ds
	mov es, ax
	mov bx, offset ParamBlk		; es:bx points to param block

	mov ax, 4b00h
	int 21h				; execute the program

	mov ax, data
	mov ds, ax
	mov ss, SS_Save
	mov sp, SP_Save

	ret

RunIt	endp

;-------------------------------------------------------------------------

Code	ends


Stack	segment word stack 'STACK'
	db 10 dup (?)
Stack	ends

	end

