      subroutine FDNAMPackage


      integer*2 NF, NI, NR, NC, NT, NdimT, NdimC
      integer*2 NdimH, IEle, L, I

      parameter ( NF=  1,NI=  1,NR=  1,NC=  1,NT=  2 )
      parameter ( NdimT=   18,NdimC=   32,NdimH=    1 )

      integer*2 Row, Col, StartField, TermKeys(30), LastKey
      integer*2 First, Last
      logical*1 Next, Previous, Exit, Refresh
      character*80 ScrHelpLine
      integer*2 FieldNumber
      logical*1 Valid

      character*   32 C1  

      character*1 Text(NdimT)
      character*1 Char(NdimC)
      character*1 Help(NdimH)

      character*7 Formats(NF)

      integer*2 TextTable(5,NT), FldTable(7,NF), IntArray(5,NI)
      integer*2 CharTable(2,NC), HelpTable(4,NF)
      real RealArray(5,NR) 

      data ScrHelpLine(1:40) /
     1   '                                        '/
      data ScrHelpLine(41:80) /
     1   '                                        '/

 
      data (TextTable(I,  1),I=1,5) /    1,17, 1, 1, 0/
      data (Text(I),I=    1,   17) /
     1   'N','e','w',' ','f','i','e','l','d',' ','n','a','m','e',':',
     1   ' ',
     1   '[' /
 
      data (TextTable(I,  2),I=1,5) /   18, 1, 1,50, 0/
      data (Text(I),I=   18,   18) /
     1   ']' /
 
      data (FldTable(I,    1),I=1,7) / 3,    1,1,32, 1,18,0 /
      data (CharTable(I,    1),I=1,2) /     1,0 /
      data (HelpTable(I,    1),I=1,4) /     0,    0,    0,    0 /
      data Formats(    1) / 'A32    '/


      entry FDNAMClear( Row, Col )


      call ClearScrn( Row, Col, 50,  1 )

      return



      entry FDNAMTextDsp( Row, Col )

      call DsplyText( Row, Col,
     1   NT, TextTable, NdimT, Text )

      return


      entry FDNAMDataDsp( Row, Col, First, Last,
     1   C1
     1   )
 
      IEle = FldTable(2,  1)
      L = FldTable(4,  1)
      call ANtoA1( C1  , NdimC, Char, CharTable(1,IEle), L )

      call DsplyData( Row, Col, First, Last,
     1   NF, FldTable,
     1   NI, IntArray, NR, RealArray, NC, CharTable, NdimC, Char,
     1   Formats )

      return


      entry FDNAMValidate( First, Last,
     1   C1
     1  , Valid, FieldNumber )
 
      IEle = FldTable(2,  1)
      L = FldTable(4,  1)
      call ANtoA1( C1  , NdimC, Char, CharTable(1,IEle), L )

      call VldWholeScreen( First, Last, NF, FldTable,
     1   NI, IntArray, NR, RealArray, NC, CharTable, NdimC, Char,
     1   'FDNAM', Valid, FieldNumber )

      return


      entry FDNAMEdit( Row, Col, First, Last, StartField, TermKeys,
     1   C1  ,
     1   Next, Previous, Exit, Refresh, LastKey )
 
      IEle = FldTable(2,  1)
      L = FldTable(4,  1)
      call ANtoA1( C1  , NdimC, Char, CharTable(1,IEle), L )

      call EditScrn( 'FDNAM', Row, Col, First, Last, StartField,
     1   ScrHelpLine, TermKeys, NF, FldTable,
     1   NI, IntArray, NR, RealArray, NC, CharTable, NdimC, Char,
     1   Formats, HelpTable, NdimH, Help, Next, Previous, Exit,
     1   Refresh, LastKey )
 
      IEle = FldTable(2,  1)
      L = FldTable(4,  1)
      call A1toAN( NdimC, Char, CharTable(1,IEle), L, C1   )

      return
      end


      integer*2 function FDNAMInd( Name )

      integer*2 I
      character*(*) Name
      character*32 LocName
      character*32 FldName(  1)
      data FldName(  1) /'TFIELDNAME'/

      LocName = Name
      call CvtToUpCase( LocName )
      do 100 I = 1 ,   1
        if( FldName(I) .eq. LocName ) then
          FDNAMInd = I
          return
        end if
100   continue

      FDNAMInd = 0

      end
