

C ========================================================================
C
C	THIS ROUTINE RETURNS A POINTER TO THE LAST CHAR IN FIELD
C	BEGINNING AT THE CURRENT COL LOCATION, and replaces any
C	trailing blanks with nulls.
C	It leaves the pointer at the last char. in the field.
C
C ========================================================================

	SUBROUTINE EFIELD(ROW,COL,EPOS)

	INTEGER*2 ROW,COL,EPOS,MAP(21,80,3)

	COMMON /BLK1/MAP

	EPOS=COL+1

100	if  ( Epos.GE.80)  THEN
	   return
	elseif (Epos.le.Col) then
	   return
	elseif (map(Row,Epos,1) .ne. 6) then
	   if ( map(Row,Epos,1).EQ.0 ) then
	      Epos=Epos-1
	      if (map(Row,Epos,1).eq.32.and.map(Row,Epos,2).eq.0) then
	         map(Row,Epos,1)=0
	         map(Row,Epos,2)=0
	         Epos=Epos-1
	         goto 100
	      else
	         return
	      endif
	   endif
	else
	   if (map(Row,Epos-1,1) .ne. 6) then
	      epos=epos-1
	      return
	   end if
	end if

        Epos=Epos+1
        goto 100

	END


C ========================================================================
C
C	this routine finds the beginning of the next field in the
C	screen map on the current row (line) and also replaces
C	any leading blanks with nulls.
C
C ========================================================================

	subroutine bfield(row,col,spos)

	integer*2 map(21,80,3),row,col,spos

	common /blk1/map

	spos=col

100	if (spos.ge.80) then
	   spos=80
	   return
	elseif (map(Row,spos,1) .ne. 6) then
	   if ( map(row,spos,1) .eq. 0 ) then
	      spos=spos+1
	      goto 100
	   elseif( spos .gt. col .and. map(row,spos,1) .eq. 32
     1      .and. map(Row,spos,2) .eq. 0 ) then
	      map(row,spos,1)=0
	      map(row,spos,2)=0
	      spos=spos+1
	      goto 100
	   else
	      return
	   endif
	else
	   if (map(Row,spos,1) .ne. 6) then
	      return
	   endif
	endif

	end


C ========================================================================
C
C	this routine gets the field definition information
C 	from the user.
C
C ========================================================================


	subroutine DefFld ( TwoPage,Number,Frow,Fcol,Lenth,Attr,
     &   New,Clear )

	integer*2 MaxFields
	parameter ( MaxFields=250 )

	integer*2 Row, Col, CurField, TermKey(30), LastKey, Attr, Lenth
	integer*2 map(21,80,3),Frow,Fcol,Number,L,Item,Key,FieldType
	integer*2 I,II1,II2
	logical*1 Next, Last, Exit, Refresh, New, Abort, TwoPage, Clear

c--
c functions
	integer*2 Length

C ---	Arrays for field definition storage
	character*32 FieldName(MaxFields)
	character*9 Type(MaxFields)
	character*6 Form(MaxFields)
	character*6 Just(MaxFields)
	character*45 Limits(MaxFields)
	character*25 Dattr(MaxFields), DisAttr(8)
	character*79 Htext1(MaxFields),Htext2(MaxFields),Menu
	character*1 FKey

C ---	Arrays for Field Screen Interface
	character*    9 C1
	character*    6 C2,CC2
	character*    6 C3,CC3
	character*   45 C4
	character*   25 C5, CC5
	character*   79 C6
	character*   79 C7
	character*   32 C8

	integer*2 LenOfFld

	common /blk1/map

C ---	DECODE DATA
	integer*2 Wk1(2,20),Wk2(20),Wk3(20),Ptnr(2,20),CmdNo
	integer*2 NoWords,Error,WordLength(20)
	character*1 Blank,Quote,Separators
	character*135 CmdList
	character*10 Word

C ---	Common block for Field data arrays
	common /field1/FieldName,Type,Just,Limits,Dattr
	common /field12/Htext1,Htext2,Menu,Form

C ---	Definitions
	Blank=' '
	Quote=char(0)

C ---   No chars cause termination during screen entry after input validation
	TermKey(1)=0

C ---   1 char ( ascii 141 ) for immediate termination during screen entry
	TermKey(2)=2
	TermKey(3)=141
	TermKey(4)=25

	data Separators /','/

C ---	Text table for display attributes
	data	DisAttr(1)/'NORMAL'/
	data	DisAttr(2)/'REVERSE'/
	data	DisAttr(3)/'INTENSE'/
	data	DisAttr(4)/'REVERSE,INTENSE'/
	data	DisAttr(5)/'BLINK'/
	data	DisAttr(6)/'REVERSE,BLINK'/
	data	DisAttr(7)/'INTENSE,BLINK'/
	data	DisAttr(8)/'REVERSE,INTENSE,BLINK'/

C ---	Default Responses to the Field Definition Prompts
	C1 = ' '
	C2 = ' '
	C3 = 'NONE'
	C4 = ' '
	C5 = 'REVERSE'
	C6 = ' '
	C7 = ' '
	C8 = ' '

C ---	Command list for DeCode
	CmdList = ' '
	CmdList(1:52)=
     1  ' NONE CENTER LEFT RIGHT NORMAL REVERSE INTENSE BLINK '

C ---	load the Command list
	call LoadCommands( CmdList , 8 , Wk1 ,
     1   Wk2 , Wk3 , Error )


C ---	if a previous field is being edited load previous values
	if ( .not. New ) then

	   C1=Type( Number )
	   L = Length(Form( Number ))
	   if( L .lt. 2 ) L = 2
	   C2=Form( Number )(2:L)
	   C3=Just( Number )
	   C4=Limits( Number )
	   C5=Dattr( Number )
	   C6=Htext1( Number )
	   C7=Htext2( Number )
	   C8=FieldName( Number )

c---
c get the field type code to initialize the menu pointer
	   FKey = C1(1:1)

	   if ( FKey .eq. 'I' ) then
	     Item = 1
	   else if ( FKey .eq. 'R' ) then
	     C2 = Form( Number )
	     Item = 2
	   else if ( FKey .eq. 'C' ) then
	     Item = 3
	   else if ( FKey .eq. 'M' ) then
	     Item = 4
	   else if ( FKey .eq. 'L' ) then
	     Item = 5
	   else if ( FKey .eq. 'D' ) then
	     Item = 6
	   end if

	else

	  Item = 1

	end if

	Clear = .false.

c---
c Get the Field Type

	call DspAttribute(2)
	call Menu1( 24, 'Integer Real Character Menu Label Date',
     1   'IRCMLD', Item, Key, Abort )
	if( Abort ) then
	  call DspAttribute(0)
	  Number = 0
	  return
	end if

	if( TwoPage ) call SelPage(2)

	if ( Key .eq. ichar('I') ) then
	  C1 = 'INTEGER'
	  FieldType = 1
	  goto 10
	else if	( Key .eq. ichar('R') ) then
	  C1 = 'REAL'
	  FieldType = 2
	  goto 20
	else if	( Key .eq. ichar('C') ) then
	  C1 = 'CHARACTER'
	  FieldType = 3
	  goto 30
	else if	( Key .eq. ichar('L') ) then
	  C1 = 'LABEL'
	  FieldType = 4
	  goto 40
	else if	( Key .eq. ichar('D') ) then
	  C1 = 'DATE'
	  FieldType = 5
	  goto 50
	else if	( Key .eq. ichar('M') ) then
	  C1 = 'MENU'
	  FieldType = 6
	  goto 60
	endif


10	continue

C ---	Pull down the screen to get the INTEGER Field information
	Row = 1
	Col = 1
	call IntgClear ( Row, Col )
	call IntgTextDsp ( Row, Col )
	call IntgDataDsp( Row, Col, 1, 100, C8,C2,C3,C4,C5,C6,C7 )

	CurField=1

1010	continue

	Clear = .true.

	call IntgEdit( Row, Col, 1, 100, CurField, TermKey,
     1   C8,C2,C3,C4,C5,C6,C7,
     1   Next, Last, Exit, Refresh, LastKey )

	if( Next ) then
	  CurField = 1
	  goto 1010
	else if( Last ) then
	  CurField = 7
	  goto 1010
	else if( Refresh ) then
	  call ClrScr
	  call IntgTextDsp ( Row, Col )
	  call IntgDataDsp ( Row, Col, 1, 100, C8,C2,C3,C4,C5,C6,C7 )
	  goto 1010
	else if ( LastKey .eq. 25 ) then
	  call FpSpawn
	  call KpdOn
	  call DspAttribute(0)
	  call ClrScr
	  call IntgTextDsp ( Row, Col )
	  call IntgDataDsp ( Row, Col, 1, 100, C8,C2,C3,C4,C5,C6,C7 )
	  goto 1010
	else if ( LastKey .eq. 141 ) then
	   Abort = .true.
	   Number=0
	   return
	end if

	CC2 = C2
	C2 = 'I'//CC2

	goto 1111

20	continue

C ---	Pull down the screen to get the REAL Field information
	Row = 1
	Col = 1
	call RealClear ( Row, Col )
	call RealTextDsp ( Row, Col )
	call RealDataDsp( Row, Col, 1, 100, C8,C2,C3,C4,C5,C6,C7 )

	CurField=1

1020	continue

	Clear = .true.

	call RealEdit( Row, Col, 1, 100, CurField, TermKey,
     1   C8,C2,C3,C4,C5,C6,C7,
     1   Next, Last, Exit, Refresh, LastKey )

	if( Next ) then
	  CurField = 1
	  goto 1020
	else if( Last ) then
	  CurField = 7
	  goto 1020
	else if( Refresh ) then
	  call ClrScr
	  call RealTextDsp ( Row, Col )
	  call RealDataDsp ( Row, Col, 1, 100, C8,C2,C3,C4,C5,C6,C7 )
	  goto 1020
	else if ( LastKey .eq. 25 ) then
	  call FpSpawn
	  call KpdOn
	  call DspAttribute(0)
	  call ClrScr
	  call RealTextDsp ( Row, Col )
	  call RealDataDsp ( Row, Col, 1, 100, C8,C2,C3,C4,C5,C6,C7 )
	  goto 1020
	else if ( LastKey .eq. 141 ) then
	   Abort = .true.
	   Number=0
	   return
	end if

	CC2 = C2

	goto 1111

30	continue

C ---	Pull down the screen to get the CHARACTER Field information
	Row = 1
	Col = 1
	call CharClear ( Row, Col )
	call CharTextDsp ( Row, Col )
	call CharDataDsp ( Row, Col, 1, 100, C8,C2,C3,C4,C5,C6,C7 )

	CurField=1

1030	continue

	Clear = .true.

	call CharEdit( Row, Col, 1, 100, CurField, TermKey,
     1   C8,C2,C3,C4,C5,C6,C7,
     1   Next, Last, Exit, Refresh, LastKey )

	if( Next ) then
	  CurField = 1
	  goto 1030
	else if( Last ) then
	  CurField = 7
	  goto 1030
	else if( Refresh ) then
	  call ClrScr
	  call CharTextDsp ( Row, Col )
	  call CharDataDsp ( Row, Col, 1, 100, C8,C2,C3,C4,C5,C6,C7 )
	  goto 1030
	else if ( LastKey .eq. 25 ) then
	  call FpSpawn
	  call KpdOn
	  call DspAttribute(0)
	  call ClrScr
	  call CharTextDsp ( Row, Col )
	  call CharDataDsp ( Row, Col, 1, 100, C8,C2,C3,C4,C5,C6,C7 )
	  goto 1030
	else if ( LastKey .eq. 141 ) then
	   Abort = .true.
	   Number=0
	   return
	end if

	CC2 = C2
	C2 = 'A'//CC2

	goto 1111

40	continue

C ---	Pull down the screen to get the LABEL Field information
	if ( Frow .ge. 10 ) Row = 1
	if ( Frow .lt. 10 ) Row = 11
	Col = 39

	if( TwoPage ) then
	  Row = 1
	  Col = 1
	end if

	CurField=1
	if( .not. TwoPage ) call LablClear ( Row, Col )
1039	call LablTextDsp ( Row, Col )
	call LablDataDsp ( Row, Col, 1, 100, C8,C2,C3,C5 )

1040	continue

	Clear = .false.

	call LablEdit( Row, Col, 1, 100, CurField, TermKey,
     1   C8,C2,C3,C5,
     1   Next, Last, Exit, Refresh, LastKey )

	if( Next ) then
	  CurField = 1
	  goto 1040
	else if( Last ) then
	  CurField = 7
	  goto 1040
	else if( Refresh ) then
	  call ClrScr
	  call LablTextDsp ( Row, Col )
	  call LablDataDsp ( Row, Col, 1, 100, C8,C2,C3,C5 )
	  goto 1040
	else if ( LastKey .eq. 25 ) then
	  call FpSpawn
	  call KpdOn
	  call DspAttribute(0)
	  call ClrScr
	  call LablTextDsp ( Row, Col )
	  call LablDataDsp ( Row, Col, 1, 100, C8,C2,C3,C5 )
	  goto 1040
	else if ( LastKey .eq. 141 ) then
	   Abort = .true.
	   Number=0
	if( .not. TwoPage ) call LablClear ( Row, Col )
	   return
	end if

	if( .not. TwoPage ) call LablClear ( Row, Col )

	CC2 = C2
	C2 = 'A'//CC2

	goto 1111

50	continue

C ---	Pull down the screen to get the DATE Field information
	if ( Frow .ge. 10 ) Row = 1
	if ( Frow .lt. 10 ) Row = 11
	Col = 39

	if( TwoPage ) then
	  Row = 1
	  Col = 1
	end if

	C2 = '9'
	CurField=1
	if( .not. TwoPage ) call DateClear ( Row, Col )
1049	call DateTextDsp ( Row, Col )
	call DateDataDsp ( Row, Col, 1, 100, C8,C2,C3,C5,C4 )

1050	continue

	Clear = .false.

	call DateEdit( Row, Col, 1, 100, CurField, TermKey,
     1   C8,C2,C3,C5,C4,
     1   Next, Last, Exit, Refresh, LastKey )

	if( Next ) then
	  CurField = 1
	  goto 1050
	else if( Last ) then
	  CurField = 7
	  goto 1050
	else if( Refresh ) then
	  call ClrScr
	  call DateTextDsp ( Row, Col )
	  call DateDataDsp ( Row, Col, 1, 100, C8,C2,C3,C5,C4 )
	  goto 1050
	else if ( LastKey .eq. 25 ) then
	  call FpSpawn
	  call KpdOn
	  call DspAttribute(0)
	  call ClrScr
	  call DateTextDsp ( Row, Col )
	  call DateDataDsp ( Row, Col, 1, 100, C8,C2,C3,C5,C4 )
	  goto 1050
	else if ( LastKey .eq. 141 ) then
	   Abort = .true.
	   Number=0
	if( .not. TwoPage ) call DateClear ( Row, Col )
	   return
	end if

	if( .not. TwoPage ) call DateClear ( Row, Col )

	CC2 = C2
	C2 = 'A'//CC2

	goto 1111


60	continue

C ---	Pull down the screen to get the MENU Field information
	Row = 1
	Col = 1
	call MenuClear ( Row, Col )
	call MenuTextDsp ( Row, Col )
	call MenuDataDsp ( Row, Col, 1, 100, C8,C2,C3,C5,C6,C7 )

	CurField=1

1060	continue

	Clear = .true.

	call MenuEdit( Row, Col, 1, 100, CurField, TermKey,
     1   C8,C2,C3,C5,C6,C7,
     1   Next, Last, Exit, Refresh, LastKey )

	if( Next ) then
	  CurField = 1
	  goto 1060
	else if( Last ) then
	  CurField = 6
	  goto 1060
	else if( Refresh ) then
	  call ClrScr
	  call MenuTextDsp ( Row, Col )
	  call MenuDataDsp ( Row, Col, 1, 100, C8,C2,C3,C5,C6,C7 )
	  goto 1060
	else if ( LastKey .eq. 25 ) then
	  call FpSpawn
	  call KpdOn
	  call DspAttribute(0)
	  call ClrScr
	  call MenuTextDsp ( Row, Col )
	  call MenuDataDsp ( Row, Col, 1, 100, C8,C2,C3,C5,C6,C7 )
	  goto 1060
	else if ( LastKey .eq. 141 ) then
	   Abort = .true.
	   Number=0
	   return
	end if

	CC2 = C2
	C2 = 'A'//CC2

	goto 1111


1111	continue

C ---	Get the Field Type

	Type(Number) = C1


C ---	Get the Field length

	Form(Number)=C2

	Lenth = LenOfFld( Form( Number )  )
	if( Lenth .lt. 1 ) then
	  call ErrMsg('Illegal Field Length')
	  if( FieldType .ne. 2 ) C2 = C2(2:6)
	  CurField=2
	  goto (1010,1020,1030,1039,1049,1060) FieldType
	end if


	do 13 I=Fcol,Fcol+Lenth-1

	   if ( map(Frow,I,1) .eq. 6 ) then

             if ( map(Frow,I,3) .ne. Number .or. I .gt. 79) then
	        call ErrMsg('Field Length too Large')
	        if( FieldType .ne. 2 ) C2 = C2(2:6)
	        CurField=2
	        goto (1010,1020,1030,1039,1049,1060) FieldType
	     end if

	   else

	     if ( ( map(Frow,I,1) .ne. 0 .and. map(Frow,I,1)
     1       .ne. 32 ) .or. I .gt. 79 ) then
	         call ErrMsg('Field Length too Large')
	         if( FieldType .ne. 2 ) C2 = C2(2:6)
	         CurField=2
	         goto (1010,1020,1030,1039,1049,1060) FieldType
	     end if

	   endif

13	continue

C ---	Get the Justification word
	call DeCodeCmd(CmdList,8,C3,Wk1,Wk2,Wk3,CC3,CmdNo,Error)

	Just(Number) = CC3

	if ( Error .ne. 0 ) then
	   call ErrMsg('Invalid Justification')
	   C2 = CC2
	   CurField=3
	   goto (1010,1020,1030,1039,1049,1060) FieldType
	endif

C ---	Get the Field Limits
	Limits(Number) = C4

C ---	Get the Field Attribute
	call Parse( C5 , BLANK , QUOTE , Separators,
     1   20 , Ptnr , WORDLENGTH , NoWords , ERROR )

	Attr=0

	do 100 I=1,NoWords

	   II1 = Ptnr(1,I)
	   II2 = Ptnr(2,I)
	   CC5 = C5(II1:II2)
	   call DeCodeCmd(CmdList,8,CC5,Wk1,Wk2,Wk3,Word,CmdNo,Error)

	   if (Error .ne. 0 .and. CC5 .ne. ',') then
	      if( FieldType .lt. 4 ) then
	        CurField=5
	      else
	        CurField=4
	      end if
	      C2 = CC2
	      call ErrMsg('Invalid Attribute Word')
	      goto (1010,1020,1030,1039,1049,1060) FieldType
	   elseif (Word.eq.'NORMAL') then
	      Attr=Attr+0
	   elseif (Word.eq.'REVERSE') then
	      Attr=Attr+1
	   elseif (Word.eq.'INTENSE') then
	      Attr=Attr+2
	   elseif (Word.eq.'BLINK') then
	      Attr=Attr+4
	   endif

100	continue

	Dattr(Number)=DisAttr(Attr+1)


c---
c Get the FIeldNAme
	FieldName(Number) = C8


C ---	Get the Help text

	Htext1(Number)=C6
	Htext2(Number)=C7

	end



C ========================================================================
C
C	this routine finds the field number and starting row,col
C	of a field where the cursor is. if no field there then
C	the field number=0.
C
C ========================================================================

	subroutine GetFN(Number,Row,Col)

	Integer*2 Number,Row,Col,map(21,80,3)

	common /blk1/map

C ---	first see if the crusor is in a field
	if (map(Row,Col,1) .ne. 6) then
	   Number=0
	   return
	endif

	Number=map(Row,Col,3)

C ---	it is a field, find start and field number
100	if (map(Row,Col,1) .eq. 6 .and.
     1     map(Row,Col,3) .eq. Number) then
	   Col=Col-1
	   if ( Col .lt. 1 ) then
	      Col=1
	      return
	   end if
	   goto 100
	else
	   Col=Col+1
	endif

	end


C ========================================================================
C
C	this routine inserts a data field into the screen map and
C	updates the video screen.
C
C ========================================================================

	subroutine InsrtField ( Row, Col, Attr, Len, Number )

	integer*2 Row,Col,Attr,Len,map(21,80,3),Number,OldNumber,I

	common /blk1/map

C ---	check if replaces a field
	call GetFN ( OldNumber, Row, Col )
	if ( OldNumber .ne. 0 ) then
	    I=Col
10	    if (map(Row, I, 1 ) .ne. 6
     1       .or. map(Row,I,3) .ne. OldNumber) then
	      goto 50
	    else
	      map(Row,I,1)=0
	      map(Row,I,2)=0
	      map(Row,I,3)=0
	      I=I+1
	      goto 10
	    endif
	endif

50	do 100 I=Col, Col+Len-1

	   map( Row, I, 1 )=6
	   map( Row, I, 2 )=Attr
	   map( Row, I, 3 )=Number

100	continue

	end


C ========================================================================
C
C	this routine finds the next field, with attribute
C	sensitivity.
C
C ========================================================================

	subroutine GetField ( Row, Col, Scol, Attr, Text )

	integer*2 Row,Col,Attr,map(21,80,3),Scol,Ptr
	character*79 Text

	common /blk1/map

	Text = ' '
	Ptr=1
	Scol=-1

C ---	Find the first printable char
100	if ( (map(Row,Col,1) .eq. 0 .and. map(Row,Col,2) .eq. 0)
     1    .or. map(Row,Col,1) .eq. 6 ) then
	   Col=Col+1
	   if (Col.gt.79) then
	      Col=80
	      return
	   endif
	   goto 100
	endif

	Text(Ptr:Ptr) = char( map(Row,Col,1) )
	Attr=map(Row,Col,2)
	Scol=Col

200	Col=Col+1

	if (Col .gt. 79 ) then
	   return
	endif

	Ptr=Ptr+1

	if ( map(Row,Col,1) .ne. 0 .and.
     1    map(Row,Col,1) .ne. 6 .and.
     1    map(Row,Col,2) .eq. map(Row,Col-1,2) ) then
	   Text(Ptr:Ptr)=char( map(Row,Col,1) )
	   goto 200
	else
	   return
	endif

	end


C ========================================================================
c
c	this rouitine deltes a data field
c
C ========================================================================

	subroutine DelField ( Row, Col )

	integer*2 MaxFields
	parameter ( MaxFields=250 )

	integer*2 Row, Col, map(21,80,3)
	integer*2 Orig(MaxFields,3), fcount, Number, Len, OldRow, OldCol
	character*32 FieldName(MaxFields)
	character*6 Form ( MaxFields  )
	character*9 Type(MaxFields)
	character*6 Just(MaxFields)
	character*45 Limits(MaxFields)
	character*25 Dattr(MaxFields)
	character*79 Htext1(MaxFields), Htext2(MaxFields), Menu

	integer*2 LenOfFld, I

	common /blk1/map

C ---	Common block for Field data arrays
	common /field1/FieldName,Type,Just,Limits,Dattr
	common /field12/Htext1,Htext2,Menu, Form
	common /field2/ Orig, Fcount

C ---	return if fcount = 0 (no data fields)
	if (fcount .eq. 0) return

	call GetFN( Number, Row, Col )

	if ( Number .eq. 0 ) then
	   call Beep
	   return
	endif

c---
c need to change this

	Len = LenOfFld( Form(Number) )

	do 100 I=Col,Col+Len-1
	   map( Row, I, 1 ) = 0
	   map( Row, I, 2 ) = 0
	   map( Row, I, 3 ) = 0
100	continue

c--
c Since we're moving the last field into the field being deleted,
c change the field number in the map from fcount ( the last field )
c to Number ( the field being deleted ).
c--
	OldCol = Orig( fcount, 2 )
	OldRow = Orig( fcount, 1 )
101	continue
	if( map( OldRow, OldCol, 3 ) .ne. fcount ) goto 102
	  map( OldRow, OldCol, 3 ) = Number
	  OldCol = OldCol + 1
	  if( OldCol .eq. 80 ) goto 102
	  goto 101
102	continue

	call DspStr( Row, Col, Col+Len-1 )

	Orig( Number,1 ) = Orig( fcount,1 )
	Orig( Number,2 ) = Orig( fcount,2 )

c --- don't copy Orig( fcount,3 ) because we're changing the field number
c     to the one being deleted

	FieldName(Number) = FieldName(fcount)
	Type(Number) = Type(fcount)
	Form(Number) = Form(fcount)
	Just(Number) = Just(fcount)
	Limits(Number) = Limits(fcount)
	Dattr(Number) = Dattr(fcount)
	Htext1(Number) = Htext1(fcount)
	Htext2(Number) = Htext2(fcount)

	fcount=fcount-1

	end
    
