
C ========================================================================
C
C 	this routine loads a screen file from disk, if it does not
C	exist then it just returns.
C
C ========================================================================

	subroutine LoadFile ( Fname,Swidth,Slen)

	integer*2 MaxFields
	parameter ( MaxFields=250 )

	character*5 Fname
	character*80 line
	character*82 Text
	character*1 Tmp
	character*79 Menu
	character*30 AttrData(16),AttrText

	character*6 Temp

	integer*2 Row, Col, map(21,80,3),I,J,Attr,Swidth,Slen
	logical*1 Yes, OldVer


C ---	Arrays for field definition storage
	character*32 FieldName(MaxFields)
	character*9 Type(MaxFields)
	character*6 Form(MaxFields)
	character*6 Just(MaxFields)
	character*45 Limits(MaxFields)
	character*25 Dattr(MaxFields)
	character*79 Htext1(MaxFields),Htext2(MaxFields)
	integer*2 Orig(MaxFields,3),fcount

	integer*2 LenOfFld, Number, N, Len

c--
c functions

	integer*2 Length


C ---	Common block for Field data arrays
	common /field1/FieldName,Type,Just,Limits,Dattr
	common /field12/Htext1,Htext2,Menu, Form
	common /field2/Orig,fcount

C ---	Common block for screen map
	common /blk1/map

C ---	Text table for display attributes
	data	AttrData(1)/'NORMAL'/
	data	AttrData(2)/'REVERSE'/
	data	AttrData(3)/'INTENSE'/
	data	AttrData(4)/'REVERSE,INTENSE'/
	data	AttrData(5)/'BLINK'/
	data	AttrData(6)/'REVERSE,BLINK'/
	data	AttrData(7)/'INTENSE,BLINK'/
	data	AttrData(8)/'REVERSE,INTENSE,BLINK'/
	data	AttrData(9)/'NORMAL,LINE'/
	data	AttrData(10)/'REVERSE,LINE'/
	data	AttrData(11)/'INTENSE,LINE'/
	data	AttrData(12)/'REVERSE,INTENSE,LINE'/
	data	AttrData(13)/'BLINK,LINE'/
	data	AttrData(14)/'REVERSE,BLINK,LINE'/
	data	AttrData(15)/'INTENSE,BLINK,LINE'/
	data	AttrData(16)/'REVERSE,INTENSE,BLINK,LINE'/


C ---	check for the file first
	inquire ( file=Fname//'.scr',exist=Yes)

	if ( .not. Yes ) then
	   return
	end if

C ---	file does exist so we must load it

C ---	open the file
	open(21,file=Fname//'.scr',access='sequential',
     &   status='unknown')

c---
c   load text fields first
c---

c ---   Make sure the version is 3.00 or greater
	read(21,105) line
	call ChkVersion( Line, 3.00, OldVer )

c ---	get the screen size
	read(21,55) Swidth,Slen
55	format(I2,1X,I2)

c ---	read one line and discard
	read (21,105) line
105	format(a)

c ---	now readin the menu line (79 chars)
	read (21,105) Menu

c ---	another blank line
	read(21,105) line

c ---	now the number of text fields
	read(21,115) Number
115	format(I3)

	do 400 I=1,Number


c ---	another blank
	read(21,105) line

c ---	read the position on the screen and the attribute(s)
	read(21,125) Row,Col,AttrText
125	format(I2,1X,I2,1X,A)

	do 100 J=1,16

	if ( AttrText .eq. AttrData(J) ) then
	   Attr=J-1
	   goto 200
	end if

100 	continue

200	read(21,135) Text
135	format(1x,A)

c ---	load the screen map
	N=0
	do 300 J=Col,Col+Length(Text)-2
	   N=N+1
	   Tmp = Text(N:N)
	   map(Row,J,1)=ichar(Tmp)
	   map(Row,J,2)=Attr
300	continue

400	continue


C ------
C ---	now the data fields
C ------


c ---	another blank
	read(21,105) line

c ---	the number of data fields
	read(21,505) fcount
505	format(I3)

	do 590 I=1,fcount

c ---	another blank
	read(21,105) line

c ---	get the field type
	read(21,515) Type(I)
515	format( A )

c ---	get the field name
	if ( OldVer ) then
	  FieldName(I) = 'OldVersion'
	else
	  read(21,514) FieldName(I)
514	  format( A )
	end if

c ---	get the field length
	read(21,525) Form(I)
525	format( A )

	if( OldVer ) then
	  Temp = ' '
	  if ( Type(I) .eq. 'REAL' ) then
	    Temp = 'G'//Form(I)
	  else if ( Type(I) .eq. 'INTEGER' ) then
	    Temp = 'I'//Form(I)(1:index(Form(I),'.')-1)
	  else if ( Type(I) .eq. 'CHARACTER' ) then
	    Temp = 'A'//Form(I)(1:index(Form(I),'.')-1)
	  else if ( Type(I) .eq. 'LABEL' ) then
            Temp = 'A'//Form(I)(1:index(Form(I),'.')-1)
	  else if ( Type(I) .eq. 'DATE' ) then
            Temp = 'A'//Form(I)(1:index(Form(I),'.')-1)
	  else if ( Type(I) .eq. 'MENU' ) then
	    Temp = 'A'//Form(I)(1:index(Form(I),'.')-1)
	  end if
	  Form(I) = Temp
	end if

c ---	get the justification
	read(21,515) Just(I)


c ---	get the limits
	read(21,515) Limits(I)

	if( Limits(I) .eq. 'NULL ALLOWED' ) then
	  Limits(I) = 'Y'
	else if( Limits(I) .eq. 'NULL NOT ALLOWED' ) then
	  Limits(I) = 'N'
	end if

c ---	get the position and attribute(s)
	read(21,535) Row,Col,Dattr(I)
535	format(I2,1X,I2,1X,A)

	Orig(I,1)=Row
	Orig(I,2)=Col
	Orig(I,3)=I

	do 510 J=1,16

	if ( Dattr(I) .eq. AttrData(J) ) then
	   Attr=J-1
	   goto 520
	end if

510 	continue

520	continue

	Len = LenOfFld( Form(I) )
c	Len=int(Form(I))

	call InsrtField( Row, Col, Attr, Len, I )

c ---	get the help text
	read(21,105) Htext1(I)
	read(21,105) Htext2(I)

590	continue

	close(21)

	end
