	program MakScr
C * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C *                                                                 *
C *                             INTERFACE                           *
C *                         INFORMATION BLOCK                       *
C *                                                                 *
C * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C *      ROUTINE NAME: MakScr
C *           VERSION: MakScr.for  5.03  16-Jul-87
C *            AUTHOR: Mark Geib
C *           PURPOSE: Generate Fortran 77 Input/Output Screen File
C *         ARGUMENTS: none
C *     COMMON BLOCKS: none
C *           ENTRIES: none
C *         EXTERNALS: TTYinit,EchoOff,MClear,CsrPos,ShowMode,Mmenu,
C *		       FPGetChar,Paint,FPDelete,Insert,Beep,OvrW,EchoOn
C *		       GetFN,DefFld,InsrtField,LoadFile
C *     REFERENCED BY: USER
C *          FILENAME: MakScr.for[100,115,fpaint]
C *      MODIFICATION: 1-April-86 Mark Geib
C *
C * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	integer*2 MaxFields
	parameter ( MaxFields=250 )

	integer*2 Row,Col,IIchar,Flag,FAttr,AttrTable(8),Error1,Error2
	integer*2 Attr,fcount,FieldNumber,Len,TLen,Key,Item,LastKey
	integer*2 TermKeys(30),Field,map(21,80,3),TFAttr
	integer*2 TempFieldNo
	character*10 ScratchName
	character*5 Fname
	character*80 AttrMenu
	character*8 AttrValues
	logical*1 New,Abort,Next,Last,ReFresh,Exit,Ordering,Source,
     1   Clear, ChrRdy, TwoPage

C ---	Arrays for field definition storage
	character*9 Type(MaxFields),TType
	character*32 Name(MaxFields),TName
	character*6 Form(MaxFields), TForm
	character*6 Just(MaxFields),TJust
	character*45 Limits(MaxFields),TLimits
	character*25 Dattr(MaxFields),TDattr
	character*79 Htext1(MaxFields),Htext2(MaxFields),THtxt1,THtxt2
	character*79 Text,Menu
	character*85 Line
	integer*2 Orig(MaxFields,3),Swidth,Slen,Scol
	character*30 DisAttr(16)

C ---   For version number
	character*6 Version

	integer*2 ErrCode

c --- misc

	integer*2 LineAttr, IKey, Number, Istr, L1, I, J, L2, L3
	integer*2 L4, L5, L6, L7, L8, L


c --- functions

	integer*2 Length


C ---	Common block for Field data arrays
	common /field1/Name,Type,Just,Limits,Dattr
	common /field12/Htext1,Htext2,Menu,Form
	common /field2/Orig,fcount

	common /templt/TName,TType,TJust,TLimits,TDattr,
     1   THtxt1,THtxt2, TForm
	common /templt2/TLen,TFAttr


	common /blk1/map

	TType = ' '

C ---	Text table for display attributes
	data	DisAttr(1)/'NORMAL'/
	data	DisAttr(2)/'REVERSE'/
	data	DisAttr(3)/'INTENSE'/
	data	DisAttr(4)/'REVERSE,INTENSE'/
	data	DisAttr(5)/'BLINK'/
	data	DisAttr(6)/'REVERSE,BLINK'/
	data	DisAttr(7)/'INTENSE,BLINK'/
	data	DisAttr(8)/'REVERSE,INTENSE,BLINK'/
	data	DisAttr(9)/'NORMAL,LINE'/
	data	DisAttr(10)/'REVERSE,LINE'/
	data	DisAttr(11)/'INTENSE,LINE'/
	data	DisAttr(12)/'REVERSE,INTENSE,LINE'/
	data	DisAttr(13)/'BLINK,LINE'/
	data	DisAttr(14)/'REVERSE,BLINK,LINE'/
	data	DisAttr(15)/'INTENSE,BLINK,LINE'/
	data	DisAttr(16)/'REVERSE,INTENSE,BLINK,LINE'/

	data AttrMenu(1:49)
     1  /'1_Norm 2_Rev 3_Bold 4_Blink 5_Rev/Bold 6_Rev/Blin'/
	data AttrMenu(50:79)
     1  /'k 7_Bold/Blink 8_Rev/Bold/Blink'/

	data AttrValues/'12345678'/

	data AttrTable/ 0,1,2,4,3,5,6,7 /

	data TermKeys/ 0,2,25,141, 26*0 /


	call TTYinit
	call KpdOn
	call StNoCtlY
	call StNoCtlT

 	Row=1
	Col=1
	Flag=1
	Attr=0
	fcount=0
	Swidth=80
	Slen=24
	Menu(1:47)= '      Up-Previous Field         Down-Next Field'
	Menu(48:79)='       Ctrl-Z End              '


C ---	get the file to edit
	call FileName (Fname,Source,TwoPage)

c--
c load the control c handler
	call CCTrap(1)

c--
c if twopage mode then init 2nd page of crt
	if( TwoPage ) then
	  call SelPage(2)
	  call ClrScr
	  call DspAttribute(0)
	  call SelPage(1)
	end if

	call FPStartBuffer

C ---	load the file from disk
	call LoadFile( Fname,Swidth,Slen )

C ---	intialize the tty

	call EchoOff

	call CsrPos(Row,Col)

	call Paint(Row,Col)

	call DspAttribute( 0 )

	call ShowMode(Attr,Flag)

        call Mmenu

100    	if( .not. chrrdy(0) ) call snooze(100)
	if ( .not. chrrdy(0) ) call PosReport( Row, Col )

	call CsrPos( Row, Col )


101	call FPGetChar(IIchar)


	if( IIchar .eq. 2 ) then
	   call Block( Row, Col )
	   call DspAttribute( 0 )
	   call EraseRegion( 23,1,24,80 )
	   call ShowMode(Attr,Flag)
	   call Mmenu
	   call DspAttribute( Attr )
	elseif (IIchar.eq.128) then
	   Row=Row-1
	   if (Row.lt.1) then
	      Row=21
	   endif
C	   call CsrPos(Row,Col)
	elseif (IIchar.eq.129) then
	   Row=Row+1
	   if (Row.gt.21) then
	      Row=1
	   endif
C	   call CsrPos(Row,Col)
	elseif (IIchar.eq.130) then
	   Col=Col-1
	   if (Col.lt.1) then
	      Col=80
	   endif
C	   call CsrPos(Row,Col)
	elseif (IIchar.eq.131) then
	   Col=Col+1
	   if (Col.ge.80) then
	      Col=1
	   endif
C	   call CsrPos(Row,Col)
	elseif (IIchar.eq.13) then
	   Col=1
	   Row=Row+1
	   if (Row.gt.21) then
	      Row=1
	   endif
C	   call CsrPos(Row,Col)
	elseif (IIchar.eq.23) then
	   Flag=Flag*(-1)
	   call ShowMode(Attr,Flag)
	elseif (IIchar.eq.18) then
	   call DspAttribute( 0 )
	   call Paint(Row,Col)
	   call ShowMode(Attr,Flag)
	   call Mmenu
	   call DspAttribute( Attr )
	elseif (IIchar.eq.127) then
	   call FPDelete(Row,Col)
	elseif (IIchar.eq.8) then
           if (Col.gt.1) then
              Col=Col-1
	      call ttyo(8)
              call FPDelete(Row,Col)
           else
              call Beep
	      call FlushBuffer
           endif
	elseif (IIchar.eq.1) then
	   LineAttr = Attr
	   call DspAttribute(2)
	   Item=1
           call Menu1 ( 23, AttrMenu, AttrValues, Item, key, Abort )
	   if ( .not. abort ) then
	     Attr=AttrTable(Key-48)
	     if( LineAttr .gt. 7 ) Attr = Attr + 8
	     call ShowMode(Attr,Flag)
	   endif


	else if (IIchar.eq.12) then
	  if( Attr .gt. 7 ) then
	   call LnMdOff
	   Attr = Attr - 8
	   call ShowMode(Attr, Flag)
	  else
	   call LnMdOn
	   Attr = Attr + 8
	   call ShowMode(Attr, Flag)
	  end if
	  call DspAttribute( Attr )

	elseif (IIchar.eq.26) then
	   call DspAttribute( 0 )
	   goto 499

	elseif (IIchar .eq. 4 ) then
	   call DelField(Row,Col)

	elseif (IIchar .eq. 22 .or. IIchar .eq. 143 ) then
 	   call GetFN( TempFieldNo, Row, Col )
	   if (TempFieldNo .ne. 0) then
	      call LoadTemplate( TempFieldNo )
	   else
	      call Beep
	   end if


	elseif (IIchar .eq. 7 .or. IIchar .eq. 144 ) then
	   call GetFn( TempFieldNo, Row, Col )
	   if ( TempFieldNo .ne. 0 .or.
     1	     TType .eq. ' ' ) then
	      call Beep
	   else
	      fcount = fcount + 1
	      call WriteTemplate( Row, Col, fcount, Error1 )
	      if( Error1 .eq. 0 ) then
	        Orig(fcount,1) = Row
	        Orig(fcount,2) = Col
	        Orig(fcount,3) = fcount
	        call InsrtField ( Row, Col, TFAttr, TLen, fcount )
	        call DspStr( Row, Col, Col+Tlen-1 )
	     else
	        fcount = fcount - 1
c --- show write mode which has been erased by an error message
	        call ShowMode(Attr,Flag)
	     end if
	   end if


	elseif (IIchar.eq.6) then
	   call GetFN(FieldNumber,Row,Col)
	   if (FieldNumber.eq.0) then
	      fcount=fcount+1
	      FieldNumber=fcount
	      Orig(FieldNumber,1) = Row
	      Orig(FieldNumber,2) = Col
	      Orig(FieldNumber,3) = FieldNumber
	      New = .true.
	   else
	      Orig(FieldNumber,1)=Row
	      Orig(FieldNumber,2)=Col
	      New = .false.
C	      call CsrPos(Row,Col)
	   endif

	   call DefFld( TwoPage, FieldNumber, Row, Col, Len, FAttr,
     &      New, Clear )
	   if ( FieldNumber .ne. 0 ) then
	      call InsrtField ( Row, Col, FAttr, Len, FieldNumber )
	   else
	      if ( New ) fcount=fcount-1
	   endif

	   if( TwoPage ) then

	     call ClrScr
	     call SelPage(1)
	     if(FieldNumber.ne.0) call PaintOne( Row, Col, FAttr, Len )

	   else

	     if( Clear ) then
	       call Paint( Row, Col )
	     else
	       call EraseRegion( 23,1, 24,80 )
	       call PaintNoClr( Row, Col )
	     end if

	     call ShowMode(Attr,Flag)
	     call Mmenu

	   end if

	elseif ( IIchar .eq. 9 ) then
	   if (Mod(Col-1,8) .eq. 0) then
	      Col=Col+8
	   else
	      Col=Col-mod(Col-1,8)+8
	   endif
	   if (Col .gt. 79) Col=1

	elseif ( IIchar .eq. 132 ) then
	   if (Mod(Col-1,8) .eq. 0) then
	      Col=Col-8
	   else
	      Col=Col-mod(Col-1,8)
	   endif
	   if (Col .lt. 1) Col=79

	elseif ( IIchar .eq. 27 ) then
c	   ignore it

	else if( IIchar .eq. 142 ) then
	  if(Row .gt. 17 ) then
	    call HelpClear( 2,1 )
	    call HelpTextDsp( 2,1 )
	  else
	    call HelpClear( 17,1 )
	    call HelpTextDsp( 17,1 )
	  end if

	else if( IIchar .eq. 11 ) then
	  if(Row .gt. 12 ) then
	    if( Col .gt. 40 ) then
	      call KeyPdClear( 1,4 )
	      call KeyPdTextDsp( 1,4 )
	    else
	      call KeyPdClear( 1,60 )
	      call KeyPdTextDsp( 1,60 )
	    end if
	  else
	    if( Col .gt. 40 ) then
	      call KeyPdClear( 13,4 )
	      call KeyPdTextDsp( 13,4 )
	    else
	      call KeyPdClear( 13,60 )
	      call KeyPdTextDsp( 13,60 )
	    end if
	  end if

	else if( IIchar .eq. 25 ) then
	  call FpSpawn
	  call KpdOn
	  call DspAttribute( 0 )
	  call Paint(Row,Col)
	  call ShowMode(Attr,Flag)
	  call Mmenu
	  call DspAttribute( Attr )

	else
	   if ( IIchar .ge. 32 ) then
	      if (Flag.eq.1) then
	         call Insert(IIchar,Attr,Row,Col)
	      else
	         call OvrWrt(IIchar,Attr,Row,Col)
	      endif
	   else
	      call Beep
	      goto 101
	   end if
	endif

	goto 100

499	continue

	if( TwoPage ) then
	  call SelPage(2)
	end if

500	Field = 1

	if( .not. ChrRdy(0) ) call snooze(300)
	call NextChar(ikey)
	if( ikey .eq. 26 ) then
	  call FlushBuffer
	  goto 520
	end if

	call ClrScr

	call NextChar(ikey)
	if( ikey .eq. 26 ) then
	  call FlushBuffer
	  goto 520
	end if
	call ExScrTextDsp( 1, 1 )
	call NextChar(ikey)
	if( ikey .eq. 26 ) then
	  call FlushBuffer
	  goto 520
	end if
	call ExScrDataDsp( 1, 1, 1, 100, Fname, Swidth, Slen, Menu )
	call NextChar(ikey)
	if( ikey .eq. 26 ) then
	  call FlushBuffer
	  goto 520
	end if
501	call ExScrEdit ( 1, 1, 1, 100, Field, TermKeys, Fname, Swidth,
     1   Slen, Menu, Next, Last, Exit, ReFresh, LastKey )

	if ( ReFresh ) then
	   goto 500
	elseif ( Next .or. Last ) then
	   goto 501
	elseif ( LastKey .eq. 25 ) then
	  call FpSpawn
	  call KpdOn
	  goto 500
	elseif ( LastKey .eq. 141 ) then
	  if( TwoPage ) then
	    call ClrScr
	    call SelPage(1)
	  else
	    call Paint ( Row, Col )
	    call Mmenu
	    call ShowMode( Attr, Flag )
	  end if
	  goto 100
	elseif ( Exit ) then
	   goto 520
	else
	   goto 501
	endif

520	continue
	if( TwoPage ) then
	  call ClrScr
	  call SelPage(1)
	  call DspAttribute( 0 )
	else
	  call DspAttribute( 0 )
	  call Paint ( 1,1 )
	  call Mmenu
	end if

	call CTmpNam( 'SC1', ScratchName )
	call OpenSeq( 21, ScratchName, 'Unknown', ErrCode )

	call CTmpNam( 'SC2', ScratchName )
	call OpenSeq( 20, ScratchName, 'Unknown', ErrCode )

	Number=0

	Row=1
	Col=1

550	call GetField ( Row,Col,Scol,Attr,Text )

	if ( Scol .ne. -1 ) then
           write(21,535) Row,Scol,DisAttr(Attr+1)
535        format(I2,',',I2,',',a)
	   Istr = Col-Scol
           write(21,536) Text(1:Istr)
536        format('"',a,'"',/)
	   Number=Number+1
	end if

 	if (Row.eq.21.and.Col.eq.80) goto 590

	if ( Col .gt. 79 ) then
	      Row=Row+1
	      Col=1
	endif

	goto 550

590	continue

c --- Write version in file
	call GetVersion( Version )

	L1 = Length(Version)
	if( L1 .eq. 0 ) L1 = 1
	write(20,514) Version(1:L1)
514	format( '[Generated by Fpaint version ',a,']')


	write(20,515) Swidth , Slen
515	format(I2,',',I2,/)

	write(20,523) Menu
523	format(A79,/)


	write(20,525) Number
525	format(I3,/)


	close(21)
	call CTmpNam( 'SC1', ScratchName )
	call OpenSeq( 21, ScratchName, 'Old', ErrCode )

533	read(21,537,end=560) Line
537	format(a)

	L1 = Length(Line)
	if( L1 .eq. 0 ) L1 = 1
	write(20,538) Line(1:L1)
538	format(a)

	go to 533

560	continue

	close(21,status='delete')

	write(20,545) fcount
545	format(I3,/)

C ---	let the user order the data fields if he chosses

	Row=1
	Col=1
	Field=0
	call Mmenu


	if( Fcount .le. 1 ) then

	  Ordering = .false.

	else

	  call CsrPos( 23,1 )
	  call DspAttribute(2)
          call OutString('Re-Order the Data Fields?')
	  Item = 2
113	  call Menu1( 24, 'Yes  No', 'YN', Item, Key, Abort )
	  if( Abort ) goto 113
	  if ( Key .eq. ichar('Y') ) then
	     Ordering = .true.
	  else
	     Ordering = .false.
	  endif

	end if


	DO 510 I=1,fcount

	if ( .not. Ordering ) then
	   Field = I
	   goto 710
	end if


	write(Line,690) I
690	format('Move Cursor to Data Field ',I3,
     1   ' and Press F1')
	call CsrPos(23,1)
	call DspAttribute(0)
	call OutString(Line)


700 	continue
	call CsrPos( Row, Col )
	call FPGetChar(IIchar)

	if (IIchar.eq.128) then
	   Row=Row-1
	   if (Row.lt.1) then
	      Row=21
	   endif
	elseif (IIchar.eq.129) then
	   Row=Row+1
	   if (Row.gt.21) then
	      Row=1
	   endif
	elseif (IIchar.eq.130) then
	   Col=Col-1
	   if (Col.lt.1) then
	      Col=80
	   endif
	elseif (IIchar.eq.131) then
	   Col=Col+1
	   if (Col.ge.80) then
	      Col=1
	   endif
	elseif (IIchar.eq.13) then
	   Col=1
	   Row=Row+1
	   if (Row.gt.21) then
	      Row=1
	   endif
	elseif (IIchar .eq. 18 ) then
	   call Paint( Row,Col)
	   call Mmenu
	elseif ( IIchar .eq. 9 ) then
	   if (Mod(Col-1,8) .eq. 0) then
	      Col=Col+8
	   else
	      Col=Col-mod(Col-1,8)+8
	   endif
	   if (Col .gt. 79) Col=1
	elseif ( IIchar .eq. 132 ) then
	   if (Mod(Col-1,8) .eq. 0) then
	      Col=Col-8
	   else
	      Col=Col-mod(Col-1,8)
	   endif
	   if (Col .lt. 1) Col=79
	elseif (IIchar .eq. 141) then
	   call GetFN( Field, Row, Col )
	   if ( Field .eq. 0  ) then
	      call beep
	      goto 700
	   else
	      J=Col
10	      if ( map(Row, J, 1 ) .eq. 6 .and.
     1             map(Row, J, 3 ) .eq. Field ) then
	        map(Row,J,1)=0
	        map(Row,J,2)=0
	        map(Row,J,3)=0
	        J=J+1
	        goto 10
	      endif
	      call DspStr (Row,Col,J-1)
	      goto 710
	   endif
	endif
	goto 700

710    continue

	if( Type(Field).eq.'CHARACTER' .or. Type(Field).eq.'DATE' ) then
   	  if ( Limits(Field).eq.'Y' .or. Limits(Field).eq.'y' ) then
	     Limits(Field)='NULL ALLOWED'
	  else
	     Limits(Field)='NULL NOT ALLOWED'
	  endif
	end if

	L1 = Length(Type(Field))
	if( L1 .eq. 0 ) L1 = 1
	L2 = Length(Just(Field))
	if( L2 .eq. 0 ) L2 = 1
	L3 = Length(Limits(Field))
	if( L3 .eq. 0 ) L3 = 1
	L4 = Length(Dattr(Field))
	if( L4 .eq. 0 ) L4 = 1
	L5 = Length(Htext1(Field))
	if( L5 .eq. 0 ) L5 = 1
	L6 = Length(Htext2(Field))
	if( L6 .eq. 0 ) L6 = 1
	L7 = Length(Name(Field))
	if( L7 .eq. 0 ) L7 = 1
	L8 = Length(Form(Field))
	if( L8 .eq. 0 ) L8 = 1

	  write(20,504) Type(Field)(1:L1),
     1      Name(Field)(1:L7),
     1      Form(Field)(1:L8),
     1      Just(Field)(1:L2),
     1      Limits(Field)(1:L3),
     1      Orig(Field,1),
     1      Orig(Field,2),
     1      Dattr(Field)(1:L4),
     1      Htext1(Field)(1:L5),
     1      Htext2(Field)(1:L6)

504	  format(A,/,A,/,A,/,A,/,A,/,
     1    I2,',',I2,',',A
     1    ,/,A,/,A/)


510	continue

	write(20,555)
555	format('[End of File]')

	close(20)


	call DelFil( Fname//'.scr', Error2 )

	call CTmpNam( 'SC2', ScratchName )
	call RenFile( ScratchName, Fname//'.scr', Error1 )

	call CsrPos( 1,1 )
	call DspAttribute( 0 )
	call ClrScr
	call EchoOn

	call TTYinit
	call KpdOff

	if( Error1 .ne. 0 ) then
	  call OutString( 'Rename of temp file ' )
	  L = Length(ScratchName)
	  if( L .eq. 0 ) L = 1
	  call OutString( ScratchName(1:L) )
	  call OutString( ' failed' )
	end if

	if( Error2 .ne. 0 .and. Error2 .ne. 2 ) then
	  call OutString( 'Deletion of file ' )
	  call OutString( Fname//'.scr' )
	  call OutString( ' failed' )
	end if

c--
c Now run the program "BLDSCR" to generate the FORTRAN source
c--

	if( .not. Source ) FName = '/NOS'

 	call PutFileName( FName, 23 )

c--
c unload the control c handler
	call CCtrap(0)

	call ChainSYS( 'BLDSCR' )

	stop '[End of Fpaint]'

	end





	subroutine Mmenu
C * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C *                                                                 *
C *                             INTERFACE                           *
C *                         INFORMATION BLOCK                       *
C *                                                                 *
C * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C *      ROUTINE NAME: Mmenu
C *           VERSION: MakScr.for  1.0  16-Sept-85
C *            AUTHOR: Mark Geib
C *           PURPOSE: Display the Main Menu
C *         ARGUMENTS: none
C *     COMMON BLOCKS: none
C *           ENTRIES: none
C *         EXTERNALS: Csrpos,CsrSave,DspAttribute,OutString,CsrRestore
C *     REFERENCED BY: MakScr.for
C *          FILENAME: MakScr.for[100,123,scr]
C *      MODIFICATION: 16-Sept-85 Mark Geib
C *
C * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	character*80 OutPut

	call SaveAttribute

	call CsrPos(22,1)
	OutPut(1:41)='  ^Z:Exit Screen ^W:Ins/OvrWrt ^L:Line/Nm'
	OutPut(42:80)='l ^F:Def Fld ^R:Repaint Screen PF2:Help  '

	call DspAttribute(3)
  	call OutString(OutPut(1:80))

	call RstAttribute

	end



	subroutine ShowMode(Attr,Flag)
C * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C *                                                                 *
C *                             INTERFACE                           *
C *                         INFORMATION BLOCK                       *
C *                                                                 *
C * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C *      ROUTINE NAME: ShowMode
C *           VERSION: MakScr.for  1.0  16-Sept-85
C *            AUTHOR: Mark Geib
C *           PURPOSE: Display Editting Mode with Attributes
C *         ARGUMENTS: Attr-current video display attribute
C *		       Flag-Insert/Overwrite flag 0-Insert
C *						  1-Overwrite
C *     COMMON BLOCKS: none
C *           ENTRIES: none
C *         EXTERNALS: CsrPos,CsrSave,DspAttribute,OutString,CsrRestore
C *     REFERENCED BY: MakScr.for
C *          FILENAME: MakScr.for[100,123,scr]
C *      MODIFICATION: 16-Sept-85 Mark Geib
C *
C * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	integer*2 Attr,Flag

	call SaveAttribute

        if (Flag.gt.0) then
	   call DspAttribute(0)
	   call CsrPos(24,65)
	   call OutString('               ')
	   if( Attr .gt. 7 ) then
	     Attr = Attr - 8
	     call DspAttribute(Attr)
             call CsrPos(24,68)
             call OutString('Line  Insert')
	     Attr = Attr + 8
	   else
	     call DspAttribute(Attr)
             call CsrPos(24,74)
             call OutString('Insert')
	   end if
        elseif (Flag.lt.0) then
	   call DspAttribute(0)
	   call CsrPos(24,65)
	   call OutString('               ')
	   if( Attr .gt. 7 ) then
	     Attr = Attr - 8
	     call DspAttribute(Attr)
             call CsrPos(24,65)
             call OutString('Line Overwrite')
	     Attr = Attr + 8
	   else
	     call DspAttribute(Attr)
             call CsrPos(24,71)
             call OutString('Overwrite')
	   end if
        endif

	call RstAttribute

	end


	subroutine PosReport( Row, Col )

	integer*2 Row,Col

	call SaveAttribute

	call DspAttribute( 0 )

	call CsrPos(24,1)

	if (Row/10 .ge. 1) then
	  call ttyo((Row/10)+48)
	else
	  call ttyo(32)
	end if
	call ttyo(mod(row,10)+48)

	call ttyo(47)

	if (col/10 .ge. 1) then
	  call ttyo((col/10)+48)
	else
	  call ttyo(32)
	end if
	call ttyo(mod(col,10)+48)

	call RstAttribute

	end

