
C ========================================================================
C
C	THIS ROUTINE INSERTS THE IICHAR AT THE CURSOR POSITION (ROW,COL)
C	AND UPDATES THE SCREEN MAP AND SCREEN BEFORE RETURN
C
C 	LIKE DELETE, INSERT MAITAINS THE FIELDS SEPARATED BY NULLS
C	BUT TREATS FIELDS SEPARATED BY BLANKS AS ONE FIELD.
C
C ========================================================================

	SUBROUTINE INSERT(IICHAR,ATTR,ROW,COL)

	INTEGER*2 IICHAR,ATTR,ROW,COL,MAP(21,80,3),FCHAR
	INTEGER*2 EPOS,I

	LOGICAL*1 InsideField

	COMMON /BLK1/MAP

	   if( Attr .gt. 7 ) then
	     if( IICHAR .eq. 164 ) then
	       IICHAR = 108
	     else if( IICHAR .eq. 165 ) then
	       IICHAR = 119
	     else if( IICHAR .eq. 166 ) then
	       IICHAR = 107
	     else if( IICHAR .eq. 161 ) then
	       IICHAR = 116
	     else if( IICHAR .eq. 163 ) then
	       IICHAR = 117
	     else if( IICHAR .eq. 158 ) then
	       IICHAR = 109
	     else if( IICHAR .eq. 159 ) then
	       IICHAR = 118
	     else if( IICHAR .eq. 160 ) then
	       IICHAR = 106
	     else if( IICHAR .eq. 167 ) then
	       IICHAR = 113
	     else if( IICHAR .eq. 170 ) then
	       IICHAR = 120
	     else if( IICHAR .eq. 162 ) then
	       IICHAR = 110
	     else if( IICHAR .gt. 126 ) then
	       call beep
	       call FlushBuffer
	       return
	     end if
	   else if( IICHAR .gt. 126 ) then
	     call beep
	     call FlushBuffer
	     return
	   end if


C ---	if inside a data field then only permit a space to move cursor right
	if (map(Row,Col,1) .eq. 6) then
	   if( IICHAR .eq. 32 ) then
 	     if( Col .gt. 79 ) then
	       call beep
	       call FlushBuffer
	       return
	     else
	       Col = Col + 1
	       return
	     end if
	   else
	     call beep
	     call FlushBuffer
	     return
	   end if
	end if


c ---   if Inside a text string then set "InsideField"
	if (map(Row,Col,1) .ne. 0 ) then
	   InsideField = .true.
	else
	   InsideField = .false.
	end if

C ---	UPDATE THE SCREEN MAP
	if ( .not. InsideField .and. map(Row,Col+1,1) .ne. 0 ) then
	  Epos = Col - 1
	else
	  CALL EFIELD(ROW,COL,EPOS)
	end if

	IF (MAP(ROW,EPOS+1,1).EQ.0
     1   .AND.EPOS.LT.79) THEN
	   DO 100 I=EPOS,COL,-1
	      MAP(ROW,I+1,1)=MAP(ROW,I,1)
	      MAP(ROW,I+1,2)=MAP(ROW,I,2)
100	   CONTINUE
	   MAP(ROW,COL,1)=IICHAR
	   MAP(ROW,COL,2)=ATTR
	ELSE
	   CALL BEEP
	   call FlushBuffer
	   RETURN
	ENDIF

C ---	NOW WRITE TO THE SCREEN IF PRINTABLE

C ---	OUTPUT THE NEW CHARACTER FIRST
	CALL DspAttribute(ATTR)
	IF (MAP(ROW,COL,1).EQ.6) THEN
	   FCHAR=95
	ELSE
	   FCHAR=MAP(ROW,COL,1)
	ENDIF

	CALL TTYO(FCHAR)
	COL=COL+1

C ---	NOW REDISPLAY THE REST OF THE FIELD
	if( InsideField ) call DspStr(row,col,epos+1)

	END

C ========================================================================
C
C	THIS ROUTINE DELETES A CHARACTER AT THE CURSOR POSITION (ROW,COL)
C	AND UPDATES THE SCREEN MAP AND SCREEN BEFORE RETURN.
C
C	THE ROUTINE DOES NOT DISTURB FIELD SEPARATED BY NULLS,
C	BUT DOES THOSE SEPARATED BY BLANKS.
C
C	FOR CORRECT OPERATION, THE CURSOR MUST BE AT ROW,COL WHEN THIS
C	ROUTINE IS CALLED.
C
C ========================================================================

	SUBROUTINE FPDELETE(ROW,COL)

	INTEGER*2 ROW,COL,MAP(21,80,3),epos,i

	COMMON /BLK1/MAP

C ---	if cursor in data field then return
	if ( map( row, col, 1 ) .eq. 6 ) return

c ---   Special case when next column is a null
	if( col .ne. 80 ) then
	  if( map(row,col+1,1) .eq. 0 ) then
	    map(row,col,1)=0
	    map(row,col,2)=0
	    call DspAttribute(0)
	    call ttyo(32)
	    call ttyo(8)
	    return
	  end if
	end if

C ---	find the end of the next field on this line
	call efield(row,col,epos)

C ---	delete the charactor from the map
	map(row,col,1)=0
	map(row,col,2)=0

C ---	move the reset of the field one place to left
	do 100 i=col+1,epos
	   map(row,i-1,1)=map(row,i,1)
	   map(row,i-1,2)=map(row,i,2)
100	continue

C ---	insert a null at epos
	map(row,epos,1)=0
	map(row,epos,2)=0

C ---	display new field
	call DspStr(row,col,epos)

C ---	reposition the cursor
	call CsrPos(row,col)

	end

C ========================================================================
C
C	this routine displays the string from the screen map
C	at row,start col, end col.  the routine leaves the cursor
C	at the position following the last char in the string.
C
C ========================================================================

	subroutine DspStr(row,scol,ecol)

	integer*2 row,ecol,scol,fchar,i,map(21,80,3),OldAttr

	common /blk1/map

	OldAttr=-1

      call CsrPos(row,scol)

	do 100 i=scol,ecol

	   if (map(row,i,1).eq.6) then
	      fchar=95
	   elseif (map(row,i,1).lt.32) then
	      fchar=32
	   else
	      fchar=map(row,i,1)
	   endif

	   if ( map(Row,I,2) .ne. OldAttr ) then
	      call DspAttribute( map(Row,I,2) )
	      OldAttr = map(Row,I,2)
	   end if

	call ttyo(fchar)

100	continue

	end

C ========================================================================
C
C	THIS ROUTINE DISPLAYS THE IICHAR AT THE CURSOR POSITION (ROW,COL)
C	AND UPDATES THE SCREEN MAP AND SCREEN BEFORE RETURN
C
C ========================================================================

	SUBROUTINE OVRWRT(IICHAR,ATTR,ROW,COL)

	INTEGER*2 IICHAR,ATTR,ROW,COL,MAP(21,80,3),FCHAR

	COMMON /BLK1/MAP

	   if( Attr .gt. 7 ) then
	     if( IICHAR .eq. 164 ) then
	       IICHAR = 108
	     else if( IICHAR .eq. 165 ) then
	       IICHAR = 119
	     else if( IICHAR .eq. 166 ) then
	       IICHAR = 107
	     else if( IICHAR .eq. 161 ) then
	       IICHAR = 116
	     else if( IICHAR .eq. 163 ) then
	       IICHAR = 117
	     else if( IICHAR .eq. 158 ) then
	       IICHAR = 109
	     else if( IICHAR .eq. 159 ) then
	       IICHAR = 118
	     else if( IICHAR .eq. 160 ) then
	       IICHAR = 106
	     else if( IICHAR .eq. 167 ) then
	       IICHAR = 113
	     else if( IICHAR .eq. 170 ) then
	       IICHAR = 120
	     else if( IICHAR .eq. 162 ) then
	       IICHAR = 110
	     else if( IICHAR .gt. 126 ) then
	       call beep
	       call FlushBuffer
	       return
	     end if
	   else if( IICHAR .gt. 126 ) then
	     call beep
	     call FlushBuffer
	     return
	   end if


C ---	if inside a data field then only permit a space to move cursor right
	if (map(Row,Col,1) .eq. 6) then
	   if( IICHAR .eq. 32 ) then
 	     if( Col .gt. 79 ) then
	       call beep
	       call FlushBuffer
	       return
	     else
	       Col = Col + 1
	       return
	     end if
	   else
	     call beep
	     call FlushBuffer
	     return
	   end if
	end if

C ---	if at Col 80 then return
	if (Col .gt. 79) then
	   call Beep
	   call FlushBuffer
	   return
	endif

C ---	UPDATE THE SCREEN MAP
	   MAP(ROW,COL,1)=IICHAR
	   MAP(ROW,COL,2)=ATTR

C ---	NOW WRITE TO THE SCREEN IF PRINTABLE

C ---	OUTPUT THE NEW CHARACTER FIRST
	CALL DspAttribute( ATTR )
	IF (MAP(ROW,COL,1).EQ.6) THEN
	   FCHAR=32
	ELSE
	   FCHAR=MAP(ROW,COL,1)
	ENDIF

	CALL TTYO(FCHAR)
	COL=COL+1

	END

   
