
	subroutine WriteTemplate( Row, Col, Number, Error )

	integer*2 MaxFields
	parameter ( MaxFields=250 )

	integer*2 Row, Col, Error

	integer*2 Number,TLen,TFAttr, map(21,80,3), I, Attr

	character*32 FieldName(MaxFields),TFieldName
	character*9 Type(MaxFields),TType
	character*6 Form(MaxFields), TForm
	character*6 Just(MaxFields),TJust
	character*45 Limits(MaxFields),TLimits
	character*25 Dattr(MaxFields),TDattr
	character*79 Htext1(MaxFields),Htext2(MaxFields),THtxt1,THtxt2
	character*79 Menu

	character*32 Buffer
        integer*2 CurField, TermKeys(30), LastKey, Subscript, I1, I2
        logical*1 Next, Previous, Exit, Refresh, Valid

c-- functions
	integer*2 Length
	logical*1 ValidInt

C ---	Common block for Field data arrays
	common /field1/FieldName,Type,Just,Limits,Dattr
	common /field12/Htext1,Htext2,Menu, Form

	common /templt/TFieldName,TType,TJust,TLimits,TDattr,
     1   THtxt1,THtxt2,TForm
	common /templt2/TLen,TFAttr

	common /blk1/ Map

        data TermKeys/ 30*0 /


c--
c Make sure field does not collide with anything on screen or fall
c off edge of screen.
c--

	do 13 I=Col,Col+TLen-1

	   if ( map(Row,I,1) .eq. 6 ) then

             if ( map(Row,I,3) .ne. Number .or. I .gt. 79 ) then
	        call ErrMsg('Field Length to Large')
		Error = 1
	        return
	     end if

	   else

	     if ( ( map(Row,I,1) .ne. 0 .and. map(Row,I,1)
     1       .ne. 32 ) .or. I .gt. 79 ) then
	         call ErrMsg('Field Length to Large')
		Error = 1
	        return
	     end if

	   endif

13	continue

	Error = 0

c--
c if picked field name has a subscript, increment it

	I1 = index( TFieldName, '(' ) + 1
	I2 = index( TFieldName, ')' ) - 1

	if( I1 .gt. 1 .and. I2 .ge. I1 ) then

	  if( ValidInt( TFieldName(I1:I2) ) ) then
	    call GetInteger( TFieldName(I1:I2), Subscript )
	    Subscript = Subscript + 1
	    if( Subscript .gt. MaxFields ) Subscript = MaxFields
	    if( Subscript .lt. 1 ) Subscript = 1
	    TFieldName = TFieldName(1:I1-1)
	    write( Buffer, 12345 ) SubScript
12345	    format( i5 )
	    call LeftJustify( Buffer )
	    TFieldName = TFieldName(1:Length(TFieldName)) //
     &        Buffer(1:Length( Buffer)) // ')'
	  end if

	end if

c--
c allow user to edit the field name

	call DsablHelpText
	call DsablScrnHelpLine
	call GetAttribute( Attr )
	call DspAttribute(0)
	call EraseRegion( 23, 1, 23, 80 )

100	CurField = 1
	call FdNamTextDsp( 23, 1 )
	call FdNamEdit( 23, 1, 1, 1, CurField, TermKeys
     1, TFieldName
     1, Next, Previous, Exit, Refresh, LastKey )
	if( LastKey .ne. 13 ) goto 100

	call EnablHelpText
	call EnablScrnHelpLine
	call EraseRegion( 23, 1, 23, 80 )
	call DspAttribute( Attr )

c--
c load the template values from the field arrays
c--

	FieldName( Number )=TFieldName
	Type( Number ) = TType
	Form( Number ) = TForm
	Just( Number ) = TJust
	Limits( Number ) = TLimits
	Dattr( Number ) = TDattr
	Htext1( Number ) = THtxt1
	Htext2( Number ) = THtxt2

	end

