$ vfl = f$verify(0+f$trnlnm("debug$dcl"))
$!
$! Manage OA$SHARE logicals and directories.  The objective is to keep the
$! size of these directories below the threshold for reasonable performance.
$! Currently the VMS/RMS limit is 128 blocks per directory file.
$!
$! Author:  Robert L. Boyd, GE Microelectronics Center, rlb@rtpark.ge.com
$! Date:    October 1988
$!
$! For further documentation on this procedure, please see the end of this
$! file.
$!
$! Parameters:
$!
$! 	p1 -- function, STARTUP or SCAN(default)
$!	p2 -- control data file
$!		contains previous definitions for OA$SHARE_{low,high,max}
$!		OA$SHARE_ROOT, and OA$SHARE<n>(1..max)
$!	p3 -- MAX for STARTUP if not already in data file
$!	p4 -- OA$SHARE_ROOT -- root for creating new share directories
$!		if not supplied will be taken from the control file.
$!		if supplied the control file will be updated to include it.
$!	p5 -- OA$SHARE_EXPAND -- flag for controlling decision to expand 
$!		range or not.  
$!		-1 = DON'T EXPAND EVER, 
$!		 0 = EXPAND only if NECESSARY,	
$!		 1 = ALWAYS EXPAND if current bracket is full.
$!
$! Use/Create a control file that lists the total number of shared directories.
$! 
$! Use OA$SHARE_LOW and OA$SHARE_HIGH to point to the beginning and end of
$! the range.   
$! 
$! At regular intervals run this procedure to update these logical names to
$! control the distribution of files throughout the range of available shared
$! directories.
$!
$! Algorithm:
$!
$!  look at the directory files from current LOW to HIGH.  
$!  If the average size is > OA$DIR_AVE_THRESHOLD or 
$!  if a single directory file is > OA$DIR_MAX_THRESHOLD 
$!  then look for a new range of directory files to point to.  
$!
$!  If no range can be found that is free enough, then 
$!  create a new range.
$!
$!  When done, update the control file to contain the new MAX, LOW and HIGH
$!  values.  Then update the logical names.  In any case, don't update the
$!  active configuration until the control file is written.
$!
$!
$! Beginning of the code
$!
$ set noon
$ testmode = 0  ! change to a 1 to see what it will do without REALLY doing all
$ null =""
$ comma = ","
$ dollar = "$"
$ say = "write sys$output "
$ defsys == "define/system/executive_mode/name=no_alias" 
$!
$! 
$! To see what the procedure will do without letting it actually 
$! modify the current system logical names uncomment the following:
$!
$ if testmode then $ defsys == "define/job/executive_mode/name=no_alias" 
$!
$ write_ctl_flag == 0
$ update_logicals_flag = 0
$!
$! All names must be constructed in the form <prefix>$<suffix>.  For 
$! every parameter name there must also be a DEF$<suffix>.  
$!
$ control_parameters = "OA$SHARE_ROOT,OA$OWNER,"+-
	"OA$SHARE_MAX,OA$SHARE_LOW,OA$SHARE_HIGH,"+ -
	"OA$SHARE_EXPAND,OA$DIR_MAX_SIZE,"+ -
	"OA$DIR_AVE_THRESHOLD,OA$DIR_MAX_THRESHOLD,"+-
	"OA$DIR_START_THRESHOLD,OA$DIR_START_AVE_THRESHOLD,"+ -
	"OA$SHARE_BRACKET_SIZE,OA$SHARE_BRACKET_MIN,OA$SHARE_DIR_FORMAT,"+ -
	"OA$MANAGER,OA$SHARE_ABSOLUTE_MAX"
$!
$ def$manager = "SYSTEM"
$ def$owner = "ALLIN1"
$ def$share_root = "RTP$USER17:[ALLIN1]"
$ def$share_max = 10		! Initial number of directories to set up
$ def$share_absolute_max = "99" ! Real limit of A1 is 999 at release V2.2
$ def$share_expand = 0		! Default to allow expansion
$ def$share_low = 1
$ def$share_high = 10
$ def$share_bracket_min = "4"   ! Minimum allowable # of dirs per bracket
$ def$share_bracket_size = 10	! number of directories per bracket
$ def$share_dir_format = "SHARE!3ZL"	! FAO rule for building directory names
$!
$! Parameters to control how big directories will be allowed to grow.
$! Performance goes down the tubes when a single directory gets too big.
$!
$ def$dir_max_size = 128	! Absolute maximum for any directory 
$!
$! If a bracket reaches one of these cutoff criteria then the current
$! range will be switched to another bracket.  They are percentages of the
$! OA$DIR_MAX_SIZE parameter.
$!
$ def$dir_ave_threshold = 80	! The cutoff % for the mean directory size
$ def$dir_max_threshold = 90	! The cutoff % for a single directory
$!
$! Parameters to measure candidate directories for re-use.  These are also
$! used as percentages of the OA$DIR_MAX_SIZE parameter.
$! 
$ def$dir_start_threshold = 60	! Only pick an existing bracket if less full
$				! than this percentage of MAX
$ def$dir_start_ave_threshold = 50! Average size of directories maximum to start
$!
$! Process all input controls:
$!  1. Use parameters to the procedure.
$!  2. Get any current OA$SHARE* logical names
$!  3. Process the control file
$!  4. Provide any missing parameters from the defaults set up above.
$!
$ mode = p1
$ if mode.eqs.null then $ mode = "SCAN"
$ control_file = p2
$ if p2.eqs.null then $ control_file = "SYS$MANAGER:OA$SHARE.CTL"
$ new_share_max == p3
$! If there isn't a new max, then base it on something.
$ new_share_root = p4
$ new_share_expand = p5
$ if new_share_expand.nes.null then $ OA$SHARE_EXPAND = new_share_expand
$! Get all of the currently defined logicals into symbols
$ gosub A1_SHARE_LNM_GET
$! Read in the parameter control file
$ if f$search(control_file).eqs.null then $ write_ctl_flag == 1
$ gosub A1_SHARE_CTL_READ
$! 
$! Fill in any that were left out from the defaults.
$!
$ gosub A1_SHARE_DEF_CHECK
$!
$! Make sure we have the most current root definition before creating
$! any new stuff.
$!
$ if f$type(oa$share_root).nes.null then $ goto SHARE_ROOT_DEFINED
$!
$! If there is no parameter for this, then calculate it from the
$! last OA$SHAREn logical's translation.
$!
$ call dir_2_file oa$share'oa$share_max' share_root_x
$ oa$share_root = share_root_x - f$parse(share_root_x,,,"name") - -
		 f$parse(share_root_x,,,"version") - ".DIR"
$SHARE_ROOT_DEFINED:
$ if new_share_root.eqs.null then $ goto A1_ROOT_DONE
$ if new_share_root.nes.oa$share_root then $ goto A1_ROOT_DONE
$! The new root is different, so replace the parameter and set the write flag
$ oa$share_root = new_share_root
$ write_ctl_flag == 1
$A1_ROOT_DONE:
$!
$ if new_share_max .eqs.null then $ new_share_max = def$share_bracket_size
$!
$! See if the latest parameters indicate expanding the range
$! If new_share_max > old_share_max then create the new range
$!
$ if new_share_max.le.OA$SHARE_MAX then goto SHARE_MAX_DONE
$	next_share = oa$share_max+1
$	OA$SHARE_MAX = new_share_max
$	call A1_SHARE_CREATE 'next_share' 'new_share_max'
$	write_ctl_flag == 1
$	
$SHARE_MAX_DONE:
$!
$ if f$ver() then $ show symbol/local/all
$ if f$ver() then $ show symbol/global/all
$!
$!====================================================================
$! scan the current low->high range to see if it meets the requirements to
$! stay current.
$!
$! First we'll calculate the numerical thresholds from the 
$! control parameters for this scan.
$!
$! Average requirement for the bracket.
$ ave_threshold   = OA$DIR_MAX_SIZE*OA$DIR_AVE_THRESHOLD/100
$!
$! maximum allowed for any single directory
$ max_threshold   = OA$DIR_MAX_SIZE*OA$DIR_MAX_THRESHOLD/100
$!
$! Maximum allowed to start using a directory.
$ start_threshold = OA$DIR_MAX_SIZE*OA$DIR_START_THRESHOLD/100
$!
$! Maximum average to use a bracket of directories.
$ start_ave_threshold = OA$DIR_MAX_SIZE*OA$DIR_START_AVE_THRESHOLD/100
$!
$! Initialize pointers for the scan of the current bracket.
$!
$ share_n = OA$SHARE_LOW
$ share_max = OA$SHARE_HIGH
$ tot_blocks = 0
$ 
$A1_SHARE_SCAN:
$
$CUR_SCAN_LOOP:
$ nxt_share = OA$SHARE'share_n'
$! Translate the dir spec to a file spec
$ call DIR_2_FILE 'nxt_share' dir$share'share_n'
$! If necessary create the directory
$ if dir$share'share_n' .eqs. null then $ call A1_SHARE_CREATE 'nxt_share'
$! Determine how large the directory file is
$ if f$type(blocks'share_n').eqs.null then -
$ blocks'share_n' == f$file_attributes(dir$share'share_n',"EOF")
$ tot_blocks = blocks'share_n'+tot_blocks
$! Is this directory file too big?
$ if blocks'share_n' .ge. max_threshold then $ goto CUR_SCAN_FAIL
$ share_n = 1+share_n
$ if share_n .le. share_max then $ goto CUR_SCAN_LOOP
$CUR_SCAN_END:
$ range_size = share_max-OA$SHARE_LOW+1
$! Is the average size too big?
$ ave_blocks = tot_blocks/range_size
$ if tot_blocks.lt. range_size*ave_threshold then $ goto WRITE_CHECK
$!
$!====================================================================
$! A single directory blew it or the average blew it.
$!
$! So now we look at the directories from OA$SHARE1 to OA$SHARE_LOW-1
$! and from OA$SHARE_HIGH+1 to OA$SHARE_MAX.  We look at the oldest 
$! ones first since it is more likely that they will have been cleaned
$! out by the janitor.
$!
$CUR_SCAN_FAIL:
$! If the expand flag is > 0 then do not re-examine the old ranges.
$ if OA$SHARE_EXPAND .gt. 0 then $ goto EXTEND_RANGE
$! 2 possibilities for scanning -- from the beginning to LOW
$! & from HIGH to MAX.
$!
$ good_bracket_found == 0
$ low_max = share_n-1
$ high_min = share_n+1
$! is there even room to look at the low end?
$! If LOW  < BRACKET_SIZE then skip the low portion
$ if low_max .lt. OA$SHARE_BRACKET_SIZE then $ goto SCAN_HIGH
$SCAN_LOW:
$ call OA_SHARE_SCAN_RANGE -
	1 'low_max' new_low new_high good_bracket_found
$ if good_bracket_found then $ goto UPDATE_PREP
$SCAN_HIGH:
$! is there even room to look at the high end?
$! If HIGH > MAX-BRACKET_SIZE+1 then skip the high portion
$ if high_min+OA$SHARE_BRACKET_SIZE .gt. OA$SHARE_MAX then -
$	goto EXTEND_RANGE
$ call OA_SHARE_SCAN_RANGE -
	'high_min' 'OA$SHARE_MAX' new_low new_high good_bracket_found
$ if .not.good_bracket_found then $ goto EXTEND_RANGE
$!====================================================================
$! we found a usable bracket of directories.  update control file and 
$! update logicals.
$UPDATE_PREP:
$ write_ctl_flag == 1
$ if f$ver() then $ say f$fao("New_LOW: !SL, New_HIGH: !SL",new_low,new_high)
$ OA$SHARE_LOW = new_low
$ OA$SHARE_HIGH = new_high
$ update_logicals_flag = 1
$ goto FINAL_CHECKS
$!
$!====================================================================
$!
$! With things set the way they are, we couldn't find any suitable range.
$! Also, the setting for OA$SHARE_EXPAND requires that we DO NOT extend 
$! the range any more.
$!
$! Attempt to increase the thresholds to see if we can find some suitable
$! bracket that is not as full as the current one.
$! If we bump up the thresholds enough times we'll hit the thresholds that
$! disqualified the current bracket.  If that happens then try the next 
$! workaround -- Shrink the bracket size.
$!
$RECOMPUTE_THRESHOLDS:
$ OA$DIR_START_THRESHOLD = 10+OA$DIR_START_THRESHOLD
$ if OA$DIR_START_THRESHOLD .ge. OA$DIR_MAX_THRESHOLD then $ GOTO SHRINK_BRACKET
$ OA$DIR_START_AVE_THRESHOLD = 10+OA$DIR_START_AVE_THRESHOLD
$ if OA$DIR_START_AVE_THRESHOLD.ge.OA$DIR_AVE_THRESHOLD then $ GOTO SHRINK_BRACKEt
$ write_ctl_flag == 1
$ goto CUR_SCAN_FAIL
$!
$! Last gasp attempt -- try resetting to defaults thresholds and shrinking the
$! bracket size to attempt to find a usable range.
$!
$! If this fails, then quit and send a MAIL message to the user(s) 
$! listed in OA$MANAGER.
$!
$SHRINK_BRACKET:
$  test_bracket = OA$SHARE_BRACKET_SIZE-1
$  if f$type(span_max).nes.null then -
$  if span_max .lt. test_bracket then $ test_bracket = span_max
$  if test_bracket .lt. OA$SHARE_BRACKET_MIN then $ goto CANT_DOIT
$  OA$SHARE_BRACKET_SIZE = test_bracket
$  OA$DIR_START_THRESHOLD = DEF$DIR_START_THRESHOLD
$  OA$DIR_START_AVE_THRESHOLD = DEF$DIR_START_AVE_THRESHOLD
$  write_ctl_flag == 1
$  goto CUR_SCAN_FAIL
$!
$!====================================================================
$!
$! We can't find a good range and we can't expand -- we're hosed!
$! Send a message to the manager(s) and get out.
$!
$CANT_DOIT:
$ mail = "mail"
$ mail sys$input: 'OA$manager'/subject="All-In-1 OA$SHARE* DIRECTORIES are FULL"

All of the OA$SHARE* directories are filled beyond the thresholds specified in
the SYS$MANAGER:OA$SHARE.CTL file.  The range cannot be extended due to
OA$SHARE_EXPAND = -1 and/or OA$SHARE_MAX has gone past OA$SHARE_ABSOLUTE_MAX. 

This condition will shortly lead to a SERIOUS performance problem.

Please:

1. Make sure the A1 Janitor has been run recently.  This should be the case
   since normally this procedure is called from the Janitor command procedure.

2. Shut Down All-In-1

3. Compress the disk(s) with A1 SHARE directories on them.  Be sure to use
   the /TRUNCATE and /RECORD on the restore operation.

4. Edit the control file:

   A. Increase OA$SHARE_ABSOLUTE_MAX (but not past999) 

   B. Change OA$SHARE_EXPAND to 0 or 1. 

   C. Reset OA$SHARE_BRACKET_SIZE, 

   D. Reset OA$DIR_START_THRESHOLD, and 

   E. Reset OA$DIR_START_AVE_THRESHOLD

5. Restart All-In-1

6. Re-run the Janitor.

$ goto WRITE_CHECK
$!
$!====================================================================
$!
$! Attempt to extend the range of directories. 
$EXTEND_RANGE: 
$! Are we allowed to do an EXPAND ?  If not, try recomputing thresholds.
$!
$ if OA$SHARE_EXPAND.lt.0 then $ goto RECOMPUTE_THRESHOLDS 
$ new_share_low = OA$SHARE_MAX+1 
$ OA$SHARE_MAX = OA$SHARE_MAX+OA$SHARE_BRACKET_SIZE 
$ if OA$SHARE_MAX.lt.OA$SHARE_ABSOLUTE_MAX then $ goto EXTEND_WITHIN_LIMITS 
$!
$! We've hit the maximum allowable number of directories so top it off.
$! Set the expand flag so that we won't attempt to expand any more.
$!
$	OA$SHARE_MAX = OA$SHARE_ABSOLUTE_MAX 
$	OA$SHARE_EXPAND = -1 
$EXTEND_WITHIN_LIMITS: 
$ OA$SHARE_LOW = new_share_low
$ OA$SHARE_HIGH = OA$SHARE_MAX
$ WRITE_CTL_FLAG == 1
$ update_logicals_flag = 1
$!====================================================================
$!
$! get ready to finish up
$!
$FINAL_CHECKS:
$ if update_logicals_flag then -
$	CALL A1_SHARE_CREATE 'OA$SHARE_LOW' 'OA$SHARE_HIGH'
$!
$! Do we need to write a new copy of the control file.
$!
$WRITE_CHECK: 
$ if write_ctl_flag then $ call A1_SHARE_CTL_WRITE 
$A1_SHARE_EXIT: 
$ if f$trnlnm("CTL","LNM$PROCESS").nes.null then $ close ctl
$!====================================================================
$ if f$ver() then $ show symbol/local/all
$ if f$ver() then $ show symbol/global/all
$!====================================================================
$ exit  ! 'f$ver(vfl)'
$ 
$!
$!
$! gosub routine to "read" all of the existing logical names 
$!
$A1_SHARE_LNM_GET: 
$ share_index = 1
$A1_SHARE_LNM_LOOP: 
$ oa$share'share_index' = f$trnlnm("OA$SHARE''share_index'") 
$ if oa$share'share_index' .eqs.null then $
goto A1_SHARE_LNM_END 
$ share_index = 1+share_index 
$ goto A1_SHARE_LNM_LOOP
$A1_SHARE_LNM_END: 
$ del/symbol/local oa$share'share_index' 
$ OA$SHARE_MAX = share_index-1 
$ oa$share_low = f$trnlnm("OA$SHARE_LOW") 
$ if oa$share_low.eqs.null then 
$ oa$share_low = 1 
$ oa$share_high = f$trnlnm("OA$SHARE_HIGH") 
$ if oa$share_high.eqs.null then $ oa$share_high = oa$share_max 
$ return 
$!
$! 
$! Go through the control parameters and fill in any that were not supplied 
$! by the parameters or by the control file.  If any of the parameters is 
$! supplied from a default the write flag is turned on. 
$!
$A1_SHARE_DEF_CHECK: 
$ ctl_i = 0 
$A1_SHARE_PRM_GET_LOOP: 
$ nxt_ctl_parm = f$edit(f$element(ctl_i,comma,control_parameters),"trim") 
$! are we done? 
$ if nxt_ctl_parm .eqs.comma then $ goto A1_SHARE_PRM_GET_END 
$ ctl_i = 1+ctl_i 
$! is this element empty ? 
$ if nxt_ctl_parm.eqs.null then $ goto A1_SHARE_PRM_GET_LOOP 
$ if f$type('nxt_ctl_parm').nes.null then $ goto A1_SHARE_PRM_GET_LOOP 
$	'nxt_ctl_parm' = def$'f$element(1,dollar,nxt_ctl_parm)
$	write_ctl_flag == 1 
$ goto A1_SHARE_PRM_GET_LOOP 
$A1_SHARE_PRM_GET_END:
$ return 
$!
$! 
$! read the control file in
$!
$A1_SHARE_CTL_READ: 
$ open/read/share=read ctl 'control_file'/error=A1_SHARE_CTL_ERROR 
$A1_SHARE_CTL_LOOP: 
$ read/end=A1_SHARE_CTL_END ctl ctl_rec 
$ 'ctl_rec' 
$ goto A1_SHARE_CTL_LOOP
$A1_SHARE_CTL_END: 
$ close ctl 
$ return 
$A1_SHARE_CTL_ERROR: 
$ say "Error opening ",control_file,-
	"OA$SHARE logicals cannot be created or scanned"
$ exit_status = 0 
$ return 
$!
$! 
$! create a new range of A1 SHARE directories and associated logicals
$! p1 -- directory name or number 
$! p2 -- if present must be a number 
$!
$A1_SHARE_CREATE: subroutine 
$ share_cnt = 0+p1 
$ if p2.nes.null then $ goto A1_SHARE_CREATE_RANGE 
$ p2 = share_cnt 
$ if share_cnt.ne.0 then $ goto A1_SHARE_CREATE_RANGE 
$! create the named directory 
$ if f$parse(p1).eqs.null then -
$ create/directory/owner='OA$OWNER' 'p1'/prot=(s:rwe,o:rwe,g:rwe,w:re) 
$ exit
$! create a numbered range
$A1_SHARE_CREATE_RANGE: 
$ share_end = p2 
$A1_SHARE_CREATE_LOOP: 
$ if f$type(oa$share'share_cnt').nes.null then $ goto OA_SHARE_DIR_EXISTS
$OA_SHARE_DIR_BUILD: 
$	oa$share'share_cnt' == oa$share_root-"]"+"."+ -
		f$fao(oa$share_dir_format,share_cnt)+"]" 
$OA_SHARE_DIR_EXISTS: 
$ if oa$share'share_cnt'.eqs.null then $ goto OA_SHARE_DIR_BUILD 
$ nxt_share = oa$share'share_cnt' 
$ if f$ver() then $ show symbol nxt_share 
$!
$! If disk quotas are enabled on the new disk then we should make sure there
$! at least is a quota for OA$OWNER 
$!
$ show quota/user='OA$OWNER'/disk='f$parse(nxt_share,,,"device")'
$ mess = f$message($status)
$ if f$loc("QFNOTACT",mess).lt.f$len(mess) then $ goto CREATE_IT
$ if f$loc("NODISKQUOTA",mess).ge.f$len(mess) then $ goto CREATE_IT
$! There's no quota so try to create some before trying to create the
$! directory(s)
$ open/write tmp sys$Login:quota_add.tmp
$ write tmp "$ run sys$system:diskquota"
$ write tmp "use ",f$parse(nxt_share,,,"device")
$ write tmp "add ",OA$OWNER,"/perm=500000/over=5000"
$ close tmp
$ @sys$login:quota_add.tmp
$ delete sys$login:quota_add.tmp;*/nolog
$!
$CREATE_IT:
$ if f$parse(nxt_share).eqs.null then -
$ create/directory/owner='OA$OWNER' 'nxt_share'/prot=(s:rwe,o:rwe,g:rwe,w:re) 
$ status = $status
$ if .not.status then $ goto A1_SHARE_CREATE_FAIL
$ defsys oa$share'share_cnt' 'nxt_share' 
$ share_cnt = share_cnt+1 
$ if share_cnt.le.share_end then $ goto A1_SHARE_CREATE_LOOP 
$ defsys oa$share_low 'oa$share_low' 
$ defsys oa$share_high 'oa$share_high'
$ exit
$A1_SHARE_CREATE_FAIL:
$ mail sys$input: 'OA$MANAGER'-
	/subj="Failure trying to create A1 Shared directory ''nxt_share'"

 While attempting to create an A1 Shared Directory an error occurred.  Please
 check the log file for the nature of the problem.

 Not all of the relevant logical names have been updated.  Particularly, 
 OA$SHARE_LOW and OA$SHARE_HIGH are still pointing at their old values.
 Please be sure to check the control file for corrections.
$
$! disable the write since there was an error.
$ write_ctl_flag == 0
$ exit 'status'
$endsubroutine ! A1_SHARE_CREATE 
$!
$! 
$! Scan a range of directories for usability 
$! parameters: 
$!	p1 -- starting value (DEF = 1)
$!	p2 -- ending value (DEF = OA$SHARE_MAX)
$!	p3 -- symbol to point to beginning (DEF = SHARE_BEG)
$!	p4 -- symbol to point to end (DEF = SHARE_END)
$!	p5 -- flag to return indication of success or failure (DEF = SCAN_FLAG)
$!
$OA_SHARE_SCAN_RANGE: subroutine 
$ scan_begin = p1
$ scan_end = p2
$ share_beg_symb = p3
$ share_end_symb = p4
$ scan_status_symb = p5
$ if scan_begin.eqs.null then $ scan_begin = 1
$ if scan_end.eqs.null then $ scan_end = OA$SHARE_MAX
$ if share_beg_symb.eqs.null then $ share_beg_symb = "SHARE_BEG"
$ if share_end_symb.eqs.null then $ share_end_symb = "SHARE_END"
$ if scan_status_symb.eqs.null then $ scan_status_symb = "SCAN_FLAG"
$ 
$ retry_counter = -1
$OA_SHARE_SCAN_RESTART:
$ retry_counter = 1+retry_counter
$! if we have retried too many times, do not try any more
$ if retry_counter .gt. 20 then $ goto SHARE_SCAN_ABORT
$! if the range is too small to work, don't even bother.
$ if scan_end-scan_begin+1.lt.OA$SHARE_BRACKET_SIZE then $ goto SHARE_SCAN_ABORT
$ scan_ptr = scan_begin
$ tot_blocks = 0
$ range_max_blocks = 0
$ range_max_ptr = scan_begin
$ scan_counter = 0
$OA_SHARE_SCAN_LOOP:
$ nxt_share = OA$SHARE'scan_ptr'
$ if f$type(dir$share'scan_ptr').eqs.null then -
$ call DIR_2_FILE 'nxt_share' dir$share'scan_ptr'
$ if dir$share'scan_ptr' .eqs. null then $ call A1_SHARE_CREATE 'nxt_share'
$ if f$trnlnm("OA$SHARE''scan_ptr'").eqs.null then -
$ 	defsys OA$SHARE'scan_ptr' 'nxt_share'
$ if f$type(blocks'scan_ptr').eqs.null then -
$ blocks'scan_ptr' == f$file_attributes(dir$share'scan_ptr',"EOF")
$ tot_blocks = blocks'scan_ptr'+tot_blocks
$ if blocks'scan_ptr' .ge. start_threshold then $ goto SHARE_SCAN_FAIL
$ if blocks'scan_ptr'.le. range_max_blocks then $ goto SHARE_INC
$ range_max_blocks = blocks'scan_ptr'
$ range_max_ptr = scan_ptr
$SHARE_INC:
$ scan_ptr = scan_ptr+1
$ scan_counter = 1+scan_counter
$ if scan_counter.ge.OA$SHARE_BRACKET_SIZE then $ goto SHARE_AVE_CHECK
$ if scan_ptr.le. scan_end then $ goto OA_SHARE_SCAN_LOOP
$ goto SHARE_SCAN_ABORT
$!
$! reset the begin pointer to after the failing directory.
$! and save a record of the maximum number of consecutive usable directories
$!
$SHARE_SCAN_FAIL:
$ span_length = scan_ptr-scan_begin
$ if f$type(SPAN_MAX).eqs.null then $ SPAN_MAX == span_length
$ if span_length .gt. SPAN_MAX then $ SPAN_MAX == span_length
$ scan_begin = scan_ptr+1
$ goto OA_SHARE_SCAN_RESTART
$SHARE_AVE_CHECK:
$ ave_blocks = tot_blocks/scan_counter
$ if tot_blocks.lt. scan_counter*ave_start_threshold then $ goto SHARE_SCAN_GOOD
$! the average was too high, so reset the beginning to the largest directory+1
$ old_scan_begin = scan_begin
$ scan_begin = range_max_ptr+1
$ goto OA_SHARE_SCAN_RESTART
$!
$! We've  searched without finding a bracket with enough room in
$! the directory files.  Return failure condition
$SHARE_SCAN_ABORT:
$ 'scan_status_symb' == 0
$ exit 0
$!
$! We found an acceptable range to point to.  Set symbols and exit
$SHARE_SCAN_GOOD:
$ 'share_beg_symb' == scan_begin
$ 'share_end_symb' == scan_ptr
$ 'scan_status_symb' == 1
$ exit
$endsubroutine ! OA_SHARE_SCAN_RANGE
$!
$! 
$! write a new copy of the control file 
$!
$A1_SHARE_CTL_WRITE: subroutine 
$ open/write ctl 'control_file' 
$ ctl_i = 0 
$! Write a time stamp to mark the file
$ write ctl "! Last generated at ",f$time()
$ write ctl "! If you update this file manually please update the time stamp"
$A1_SHARE_PRM_WRT_LOOP: 
$ nxt_ctl_parm = f$edit(f$element(ctl_i,comma,control_parameters),"trim") 
$ if nxt_ctl_parm .eqs.comma then $ goto A1_SHARE_PRM_WRT_END 
$ ctl_i = 1+ctl_i 
$ if nxt_ctl_parm.eqs.null then $ goto A1_SHARE_PRM_WRT_LOOP 
$ if f$type('nxt_ctl_parm').eqs.null then - 
$	'nxt_ctl_parm' == def$'f$element(1,dollar,nxt_ctl_parm) 
$ write ctl " ",nxt_ctl_parm," = """,'nxt_ctl_parm',"""" 
$ goto A1_SHARE_PRM_WRT_LOOP 
$A1_SHARE_PRM_WRT_END: 
$ share_cnt = 1 
$ share_fao = " OA$SHARE!SL = ""!AS"" !! Current Size: !3SL"
$A1_SHARE_WRT_LOOP: 
$ nxt_share = oa$share'share_cnt'
$ if f$type(oa$share'share_cnt').eqs.null then $ goto A1_SHARE_WRT_END 
$ if f$type(blocks'share_cnt').nes.null then $ goto A1_SHARE_WRT_REC
$ if f$type(dir$share'share_cnt').eqs.null then -
$ call DIR_2_FILE 'nxt_share' dir$share'share_cnt'
$ if dir$share'share_cnt' .eqs. null then $ call A1_SHARE_CREATE 'nxt_share'
$ blocks'share_cnt' = f$file_attributes(dir$share'share_cnt',"EOF")
$A1_SHARE_WRT_REC:
$ write ctl f$fao(share_fao,share_cnt,nxt_share,blocks'share_cnt')
$ share_cnt = 1+share_cnt 
$ if share_cnt.le.oa$share_max then $ goto A1_SHARE_WRT_LOOP 
$A1_SHARE_WRT_END: 
$ if f$trnlnm("ctl","lnm$process").nes.null then $ close ctl 
$! Make sure we clean house occasionally 
$ if f$search(control_file+";-20").nes.null then -
$  purge 'control_file'/keep=7/log
$ exit 
$endsubroutine ! A1_SHARE_CTL_WRITE 
$!
$! convert a directory specification to a file specification 
$!		   return value to global symbol 'p2' 
$! parameters 
$! p1 -- input directory 
$! p2 -- if present -- gets input dir dirfile spec 
$DIR_2_FILE: subroutine 
$  vfl = f$ver(0) 
$  save_dir = f$environment("default")
$  if p1.nes.null then $ set default 'p1' 
$  prev_dir_lev = f$parse("[-]")-".;" 
$ if prev_dir_lev .eqs.null then -
$	prev_dir_lev = f$log(f$parse(null,,,"device")-":")-".]"+"]" 
$  cur_dir = f$parse(null,,,"DIRECTORY") 
$  prev_dir = f$parse(prev_dir_lev,,,"DIRECTORY") 
$ if f$Loc(prev_dir-"]",cur_dir).lt.f$len(cur_dir) then $ goto NOT_ROOTED 
$ cur_dir_spec = prev_dir_lev+(cur_dir-"["-"]")+".DIR" 
$  goto CUR_DIR_SPEC 
$NOT_ROOTED: 
$  cur_dir_spec = prev_dir_lev+(cur_dir-(prev_dir-"]")-"]"-".")+".DIR" 
$CUR_DIR_SPEC: 
$  if p2.eqs.null then $ show sym cur_dir_spec 
$  if p2.nes.null then $ 'p2' == cur_dir_spec 
$DIR_2_FILE_EXIT: 
$  set default 'save_dir' 
$  vfl = f$ver(vfl) 
$  exit 
$
$endsubroutine ! dir_2_file 
$! 
$! decision logic: 
$! 
$! get existing logical names into symbols 
$! if control file exists, read it, if not => set flag to create it. 
$! if any control parameters are missing, define them from the defaults and set 
$!	the write flag.. 
$! evaluate current low->high range of directories. 
$! if a change is required: 
$!	set file update flag 
$!	look at other existing brackets until either: 
$!		no more exist: create a new bracket and update pointers 
$!		an acceptable one is found: update pointers 
$! if the file needs to be updated/created, then rewrite it. 
$! if any directories don't exist, create them. 
$! If in startup mode or there have been any changes at all: 
$!	(change in pointers or new dirs or new root) 
$!	then update logical names. 
$! 
$! Bob Boyd                     Usenet:    rlb@rtpark.ge.com
$! GE Microelectronics Ctr.     Internet:  rlb%rtpark.ge.com@mcnc           
$! POB 13049, MS 7T3-01         BitNet:    rlb%rtpark.ge.com@relay.cs.net
$! RTP, NC 27709-3049           Voice:     (919)549-3627 
$! GE DECnet: RTPARK::RLB       GE DIALCOMM:  8*565-3627  PROFS: SSAVRNA,MECRLBT
$!Last Modified:   4-NOV-1988 10:38:28.73, By: RLB 
