$! announce.com -- system startup announce builder
$! Author:  R.L. Boyd, GE Microelectronics Center
$! p1 -- optional -- type of announcement to post
$! implicit inputs:
$! 	logical name STARTUP$INTERACTIVE_LOGINS -- if set to 0 will
$!      cause an extra message to be added saying logins are restricted
$!      if P1=DONE then it will also cause a SET LOGINS to be executed
$ vfl = f$VER(0+f$TRNLNM("debug$startup"))
$ mode = "DONE"
$ if f$LOC(p1,"STARTUP").le.1 then $ mode = "STARTUP"
$ purge = "PURGE"
$ define/proc sys$manager sys$specific:[sysmgr]
$! get necessary info
$ version = f$EDIT(f$GETSYI("VERSION"),"trim")
$ node = f$GETSYI("Nodename")
$ if node.eqs."" then $ node = F$TRNLNM("sys$node","lnm$system")-"_"-"::"
$ boot_time = f$GETSYI("BOOTTIME")
$ boot_time =" on "+f$EXTRACT(0,11,boot_time)+" at "+f$EXTRACT(12,99,boot_time)
$!
$ alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
$ cpu = f$GETSYI("cpu")
$ cpu_string = f$GETSYI("node_hwtype")
$ cpu_name = cpu_string
$ if f$LOC(f$EXT(0,1,cpu_string),alpha).ge.f$LEN(alpha) then $ goto NUMBER
$ cpuv780 = "11/780"
$ cpuv750 = "11/750"
$ cpuv730 = "11/730"
$ cpuvuv1 = "uVAX I"
$ cpuvuv2 = "uVAX II"
$ cpu_name = cpu'cpu_string'
$NUMBER:
$ call file_open sys$manager:announce.txt
$! initial banner during startup processing
$ if mode.eqs."STARTUP"
$ then 
$ 	start_mess = " Startup in Progress (since "+f$GETSYI("boottime")+")"
$	call file_add start_mess
$	call file_line_add "========================"
$	call file_line_add "| Please Wait to Login |"
$	call file_line_add "========================"
$ endif
$! show boot time
$ boot_mess = "VAX/VMS "+version+" on node "+-
		node+"("+cpu_name+") booted"+boot_time
$ call file_add boot_mess
$! cluster membership (if applicable)
$ if f$GETSYI("cluster_member") .or. f$trnlnm("fake_cluster").nes.""
$ then 
$ 	cluster_ftime = f$GETSYI("cluster_ftime")
$ 	cluster_ftime = " on "+f$EXTRACT(0,11,cluster_ftime)+ -
		  " at "+f$EXTRACT(12,99,cluster_ftime)
$ 	cluster_mess = "Member of GE, RTP VAXCluster formed"+cluster_ftime
$ 	call file_add cluster_mess
$ endif
$! MultiProcessing check
$ if f$getsyi("multiprocessing")
$ then
$	no_cpus = f$getsyi("activecpu_cnt")
$	mp_mess = f$fao("Multiprocessing enabled with !SL cpu!%S active",no_cpus)
$	call file_add mp_mess
$ endif
$! determine accessibility
$ logins = f$trnlnm("startup$interactive_logins")
$ if logins.eqs."" then $ logins = f$getsyi("IJOBLIM")
$ if (logins.eqs."") .or. (logins.le.0 )
$ then 
$	call file_line_add "Access is DISABLED for maintenance"
$ else if mode.eqs."DONE"
$ then
$	set logins/interactive='logins'
$	reply/user/bell "''node' has booted and is available "
$ endif
$ endif
$! Post a sign -- NO TRESPASSING
$ call file_line_add "Authorized Use Only"
$ call file_close
$ define/sys/exec sys$announce "@sys$manager:announce.txt"
$ define/sys/exec sys$welcome " " ! "@sys$manager:welcome.txt"
$BROADCAST:
$ if f$TRNLNM("sys$manager","lnm$process").nes."" then $ deassign/proc sys$manager
$EXIT:
$ exit ! 'f$VER(vfl)'
$! center a line of text
$! p1 -- global symbol to return it to
$! p2 -- symbol containing the string to be centered
$CENTER: subroutine
$ if f$TYPE('p2').eqs.""
$ then $ 'p1' == ""
$ else
$ 	if p1.nes."" .and. p2.nes."" then -
$	'p1' == f$FAO("!#AS!AS",(80-f$LEN('p2'))/2," ",'p2')
$ endif
$endsubroutine
$! OPEN, ADD, or CLOSE -- message file subroutine
$!
$FILE_LINE_ADD: subroutine
$ temp = p1
$ call file_add temp
$endsubroutine
$FILE_ADD: subroutine
$	line = 'p1'
$	if line.eqs."" then $ exit
$ 	if f$trnlnm("announce_file").eqs."" then $ call FILE_OPEN 'p2'
$ 	call center line_centered line
$ 	write announce_file line_centered
$endsubroutine
$FILE_OPEN: subroutine
$	announce_file == p1
$ 	if f$trnlnm("announce_file").eqs.""
$	then
$		if announce_file.eqs."" then -
$ 		announce_file = "SYS$MANAGER:ANNOUNCE.TXT"
$		open/write announce_file 'announce_file'
$	else
$		call file_close
$	endif
$endsubroutine
$FILE_CLOSE: subroutine
$ if f$trnlnm("announce_file","lnm$process").nes."" then -
$ 	close announce_file
$ if f$type(announce_file).nes."" 
$ then
$  	if f$SEARCH(announce_file+";-7").nes."" then -
$		purge/keep=3 'announce_file'
$	delete/symbol/global announce_file
$ endif
$endsubroutine
$!Last Modified:  30-OCT-1987 09:25:18.90, By: RLB 
