$! uptime/downtime logger/report generator
$!   
$! PARAMETERs
$!
$! P1:
$!	null 	MODE="OTHER" -- exec algorithm
$!		Else -- same as p1=START
$!	START	Create DETACHED process
$!	REPORT	Update DOWNTIME_REPORT
$! P2:  
$!	if not null then this is the start date for the report
$! P3:
$!	if not null then this specifies the end date for report
$! P4:
$!	if p1=REPORT then this overrides the default report file name
$!
$!-------------------------------------------------------------
$! EFFECTS:	maintains 2 files
$! 	UPTIME -- NODE,LAST TIME RECORDED
$! 	DOWNTIME_LOG -- NODE, TIME1, TIME2
$! REPORTs to a 3rd file
$! 	DOWNTIME_REPORT
$!-------------------------------------------------------------
$! suggested use:
$!      Place in your SYSTARTUP procedure(s), near the end:
$!	@<wherever>UPTIME START
$! dependencies:
$!	FERMILAB TIME utility for computing delta between 2 absolutes
$ vfl= f$VER(0+f$TRNLNM("debug$dcl"))
$ set noon
$ on error then $ goto EXIT
$ on control_Y then $ goto EXIT
$!
$! no privileges are actually required, just normally needed to 
$! write in the places where the files ought to be kept.  If
$! you want, you can remove all of the unusual privilege stuff
$! by changing the following 2 symbol definitions
$!
$ detach_privs = "noall,tmpmbx,NETMBX,EXQUOTA,SYSPRV"
$ req_privs = "tmpmbx,SYSPRV"
$ save_privs = f$SETPRV(req_privs)
$ if .not. f$PRIV(req_privs) then $ goto NO_PRIVS
$!
$ delta = "0:5:0.0"	! interval between time stamps
$ minimum_down = "0:10:0.0"	! length of time we have to be down to count
$ null = ""
$ contact = "SYSTEM"	! list of name(s) to send MAIL to
$ mail_flag = 1		! flag to determine if MAIL is sent or not
$!
$! find out where we live nowadays, but select the latest version
$!
$ proc = f$PARSE(";0",f$ENVIRONMENT("procedure"))
$ proc_dir = proc-(f$PARSE(proc,,,"name")+f$PARSE(proc,,,"type")+";0")
$!
$! where the files go -- if the name specified doesn't exist, then
$! use the directory that the procedure is located in.  Makes good
$! sense to me!
$!
$ file_dir = f$PARSE("QUECOM:",proc_dir)-".;"
$!
$! files created by this procedure
$!
$ say = "write sys$output"
$ closeout = "call CLOSEOUT"
$ work_file_name = file_dir+"DOWNTIME_WORK.DAT"
$ history_file_name = file_dir+"DOWNTIME_LOG.DAT"
$ key_file_name = file_dir+"UPTIME.DAT"
$ report_file_name = file_dir+"DOWNTIME_REPORT.DAT"
$! must have the node name we're running on
$ if f$TYPE(my_node).eqs.null then $ call GET_NODE my_node
$ log_file = file_dir+my_node+"_UPTIME.LOG"
$!
$! other symbols we need
$!
$ b = " "
$ comma = ","
$ stop = "STOP"
$ process_name = "Uptime_Stamp"
$!
$! see what we're supposed to be doing this time
$!
$ if p1.eqs.null then $ p1 = "RUN"
$ p1 = f$EDIT(p1,"UPCASE,TRIM")
$ if f$LOC(p1,"STARTUP").le.1 then $ goto STARTUP
$ if f$LOC(p1,"REPORT").le.1 then $ goto REPORT
$! Assume that it is STARTUP if mode is not OTHER
$ if f$MODE().nes."OTHER" then $ goto STARTUP
$! tell what & where we're at 
$ write sys$output f$FAO("Executing !AS",f$ENV("procedure"))
$ write sys$output f$FAO("At Level !2SL @ !%D",f$ENV("depth"),0)
$ if f$ENVIRONMENT("depth").lt.1 
$ then 
$! recurse to make sure that we've got the most recent version
$	@'proc'
$	goto EXIT
$ endif
$ set default sys$manager:
$! clean out old log files
$ if f$SEARCH(log_file+";-7").nes.null then $ purge 'log_file'/keep=3
$ set output_rate=0:0:15.0
$! Get Basic Processor Info
$ my_node = f$FAO("!6AS",my_node)
$ hardware_type = f$GETSYI("node_hwtype")
$ if f$MODE().eqs."OTHER" then $ show symbol hardware_type
$! set things up for formats
$! node, time, cputype
$ key_format = my_node+",!%D,!AS"
$ if f$MODE().eqs."OTHER" then $ show symbol key_format
$! node, downtime, uptime, cputype
$ history_format = my_node+",!22AS,!%D,!AS"
$! see if we have the key file 
$ open/read/write/share=write key_file 'key_file_name'/err=NO_KEY_FILE
$! well, the file is there, see if the record exists
$ update = null
$ read/timeout=30/index=0/key='my_node'/err=ADD_NODE key_file key_rec
$ update = "/update"
$! let's see how long it's been since the last record was written for this node
$ last_time = f$ELEMENT(1,comma,key_rec)
$! 
$ if f$CVTIME(last_time).gts.f$CVTIME("-"+minimum_down) then $ goto LOOP
$!
$! Looks like we've been down!  Time to write a record to the log file
$! telling all about it.
$!
$UPDATE_HIST: ! 'f$VER(1)'
$! see if the history file exists
$ open/append/error=NO_HIST_FILE history_file 'history_file_name'
$! add the new record
$ write history_file f$FAO(history_format,last_time,0,hardware_type)
$ closeout history_file
$! send somebody some mail about it
$ if mail_flag  
$ then 
$	mess="UPTIME-I-DOWNTIME, "+-
	f$FAO("!AS was down from !AS to !%D",my_node,last_time,0)
$	mailxx NLA0:X.Y 'contact'/subj="''mess'"
$ endif
$ goto LOOP
$! To add a node, just write a record
$ADD_NODE:
$! 
$! update the key file
$LOOP:
$ write/ERR=ERR_KEY_UPDATE'update' key_file f$FAO(key_format,0,hardware_type)
$ closeout key_file ! 'f$VER(0)'
$! see if a shutdown is pending -- exec mode check only
$ shut_time = f$TRNLNM("shutdown$time","lnm$system","EXECUTIVE")
$ if shut_time.nes.null 
$ then 
$ 	say "System Shutdown in progress @ ",-
		f$TIME(),"-- scheduled for ",shut_time
$	! see if we need to quit
$	if f$CVTIME("+"+delta).ges.f$CVTIME(shut_time) then $ goto EXIT
$ endif
$!'f$VER(0)'
$! go to sleep for a little while -- until time for next time stamp
$ wait 'delta'
$LOOP_OPEN:
$! open and see if the file still exists
$ open/read/write/share=write key_file 'key_file_name'/err=NO_KEY_FILE
$ update = null
$!
$! In order to update we must read the record.  If it doesn't exist
$! then the record will be written without the /UPDATE qualifier
$!
$ read/timeout=30/index=0/key='my_node'/err=ADD_NODE key_file key_rec
$! set the UPDATE qualifier
$ update = "/update"
$ goto LOOP
$!
$! clean up before exiting
$!
$EXIT:
$ if f$TYPE(shut_time).nes.null then -
$ 	if shut_time.nes.null then -
$		say "Exiting due to pending shutdown"
$ closeout key_file,history_file,report_file
$ if save_privs.nes.null then $ save_privs = f$SETPRV(save_privs)
$ EXIT ! 'f$VER(vfl)'
$!
$REPORT:
$! wish list -- use min and max to compute overlapped times
$! sort the records by node / date for presentation
$! find out the date to start with
$ end_report_date = f$TIME()
$ if p3.nes.null then $ end_report_date = p3
$ end_report_date = f$EXT(0,17,f$CVTIME(end_report_date,"absolute"))
$ if f$LOC("-",end_report_date).lt.2 then -
$ 	end_report_date = "0"+f$EXT(0,16,end_report_date)
$ end_compare = f$CVTIME(end_report_date)
$ if p4.nes.null then $ report_file_name = p4
$ wrep = "write report_file "
$ line = F$FAO("!#*=",75)
$ cvtime == "$util_root:[fermilab]time"
$ last_report_date = p2 ! default to supplied start date
$ no_last = 0
$ if last_report_date.eqs.null 
$ then 
$! no date supplied -- try to get it from previous report file
$ 	no_last = 1
$! see if there was a previous report generated
$ if f$SEARCH(report_file_name+";").nes.null
$	then 
$		last_report_date = f$FILE_ATTRIBUTE(report_file_name,"CDT")
$	endif
$ endif
$! open the history file, allowing for updates from another node
$REP_OPEN_HIST:
$ if f$VER() then $ show symbol last_report_date
$ if last_report_date.nes.null then -
$	last_compare = f$CVTIME(last_report_date)
$ no_last = last_report_date.eqs.null
$ if f$VER() then $ show symbol last_compare
$ open/read/error=EXIT history_file 'history_file_name'/share=write
$! read history records until we find a good starting date
$REP_ST_LOOP:
$ read/end=EXIT history_file hist_rec
$ up_time = f$ELEMENT(2,comma,hist_rec)
$ if .not.no_last
$ then 
$ 	if f$CVTIME(up_time).lts.last_compare then $ goto REP_ST_LOOP
$! we've found the record to begin with, start on the report
$ endif
$ wrwk = "write work_file"
$ open/write work_file 'work_file_name'
$ open/write report_file 'report_file_name'
$ wrep "Downtime Report -- prepared @ ",f$TIME()
$ if no_last 
$ then -
$	wrep "This report will cover all outages since recording began"
$ else
$	wrep "This report covers all outages from ",last_report_date," to ",-
	end_report_date
$ endif
$ wrep line
$ node_list = null
$ node_cnt = 0
$ rec_cnt = 0
$ all_down_tot == 0
$ write sys$output "Processing downtime history records"
$! process the history records until we're done
$REP_LOOP:
$ rec_cnt = rec_cnt+1
$! see if we've reached the end yet
$ down_time = f$EXT(0,17,f$CVTIME(f$ELEMENT(1,comma,hist_rec),"absolute"))
$ if f$CVTIME(down_time).gts.end_compare then $ goto REP_END
$ node = f$ELEMENT(0,comma,hist_rec)
$! see if we've seen this node before
$ if f$LOC(node,node_list).ge.f$LEN(node_list) 
$ then 
$! we need to initialize a few things, and update the node list
$  node_cnt = 1+node_cnt
$  node_list = node_list+comma+node
$  'node'_tot = 0
$  'node'_rec = 0
$ endif
$REP_OLD:
$ if f$LOC("-",down_time).lt.2 then $ down_time = f$EXT(0,17,b+down_time)
$ up_time = f$EXT(0,17,f$CVTIME(f$ELEMENT(2,comma,hist_rec),"absolute"))
$ if f$LOC("-",up_time).lt.2 then $ up_time = f$EXT(0,17,b+up_time)
$ cvtime/sym=down_minutes 'up_time'(-)'down_time'(/)0-0:1:0.0
$ 'node'_type = f$ELEM(3,comma,hist_rec)
$! update node totals and compute the hours down from the minutes
$ 'node'_tot = down_minutes+'node'_tot
$ 'node'_rec = 1+'node'_rec
$ 'node'_down = down_time
$ 'node'_up = up_time
$ down_hours = down_minutes/60
$ down_hours = f$FAO("!4SL.!2ZL",down_hours,100*(down_minutes-60*down_hours)/60)
$! write a detail record to the report file
$ wrwk f$FAO("!6AS down !AS hrs, from !16AS to !16AS",-
	node,down_hours,f$CVTIME(down_time),f$CVTIME(up_time))
$ if node_cnt.gt.1 then $ call OVERLAP all_down_tot
$! get the next history record
$ read/end=REP_END history_file hist_rec
$ up_time = f$ELEMENT(2,comma,hist_rec)
$ goto REP_LOOP
$! write a summary for all the nodes
$REP_END:
$ if all_down_tot .gt. 0 then $ wrep line
$ closeout history_file,work_file,report_file
$! sort the records by node then by date&time
$ sort 'work_file_name' 'work_file_name'-
	/key=(pos:1,size:6)/collat=multi/key=(pos:31,size:16)
$ append 'work_file_name' 'report_file_name'
$ delete 'work_file_name';*
$ open/append report_file 'report_file_name'
$ say "Writing node summary report"
$ wrep line
$ total_format = "!6AS  !8AS   !5SL   !9AS"
$ form_len = f$LEN(f$FAO(total_format,b,b,b,b))
$ wrep " "
$ wrep f$FAO("Totals for each node:")
$ wrep " "
$ wrep f$FAO("!6AS  !8AS   !5AS   !9AS",-
	"Node","Hw Type","  Cnt","Time(hrs)")
$ wrep f$FAO("!#AS",form_len,line)
$ cpuv780 = "11/780"
$ cpuv750 = "11/750"
$ cpuv730 = "11/730"
$ cpuvuv1 = "uVAX I"
$ cpuvuv2 = "uVAX II"
$ alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZ?"
$ down_tot = 0
$ ix = 1
$! the key file tells what type of cpu each is -- open it for reference
$ rep_key = 0
$ open/read/share=write key_file 'key_file_name'/err=REP_POST
$ rep_key = 1
$! 
$! get each node name from the list we've accumulated and write a summary
$! 
$REP_POST:
$ node = f$ELEMENT(ix,comma,node_list)
$ if node.eqs.comma then $ goto REP_POST_END
$ ix = ix+1
$ if node.eqs.null then $ goto REP_POST
$! figure out what type of cpu this node is
$ if f$TYPE('node'_type).eqs.null then $ 'node'_type= comma
$ if 'node'_type.eqs.comma 
$ then 
$ 	'node'_type = "?"
$ 	read/nolock/ind=0/key="''node'"/ERR=REP_NOREC key_file key_rec
$ 	'node'_type = f$ELEMENT(2,comma,key_rec)
$ 	if 'node'_type.eqs.comma then $ 'node'_type = "?"
$ endif
$REP_POST_TYPE:
$! see if it's a special cpu type and get the name
$ cpu_name = 'node'_type
$ if f$LOC(f$EXT(0,1,'node'_type),alpha).lt.f$LEN(alpha) then -
$	cpu_name = cpu'cpu_name'
$REP_NUMBER:
$! convert the total minutes to hours format
$ down_tot = 'node'_tot+down_tot
$ down_hours = 'node'_tot/60
$ down_hours = f$FAO("!4SL.!2ZL",down_hours,100*('node'_tot-60*down_hours)/60)
$ wrep f$FAO(total_format,node,cpu_name,'node'_rec,down_hours)
$ goto REP_POST
$! write a summary of the total
$REP_POST_END:
$ down_hours = down_tot/60
$ down_hours = f$FAO("!5SL.!2ZL",down_hours,100*(down_tot-60*down_hours)/60)
$ wrep " "
$ wrep f$FAO("Total number of outages:  !SL on !SL cpu!%S.",rec_cnt,node_cnt)
$ wrep f$FAO("Total time down(hrs):     !AS",down_hours)
$ down_hours = all_down_tot/60
$ down_hours = f$FAO("!5SL.!2ZL",down_hours,100*(all_down_tot-60*down_hours)/60)
$ wrep f$FAO("Multi-outage tot hrs:     !AS",down_hours)
$ closeout key_file,report_file
$ write sys$output "The downtime report is in ",report_file_name
$ goto EXIT
$!
$! there's no key file there, so let's create one
$! If this ever gets coded in an image, this should be the FDL specification
$! for the call to CREATE_FDL.
$!
$NO_KEY_FILE:
$ create/fdl=sys$input: 'key_file_name'
TITLE	"Uptime Data Records"

FILE
	ORGANIZATION		indexed

RECORD
	CARRIAGE_CONTROL	carriage_return
	FORMAT			variable
	SIZE			60

Sharing
	GET			YES
	PUT			YES
	DELETE			YES
	UPDATE			YES

AREA 0
	ALLOCATION		9
	BEST_TRY_CONTIGUOUS	yes
	BUCKET_SIZE		3
	EXTENSION		3

AREA 1
	ALLOCATION		6
	BEST_TRY_CONTIGUOUS	yes
	BUCKET_SIZE		3
	EXTENSION		3

KEY 0
	CHANGES			no
	DATA_AREA		0
	DATA_FILL		100
	DATA_KEY_COMPRESSION	no
	DATA_RECORD_COMPRESSION	no
	DUPLICATES		no
	INDEX_AREA		1
	INDEX_COMPRESSION	no
	INDEX_FILL		100
	LEVEL1_INDEX_AREA	1
	NAME			"Node Name"
	PROLOG			2
	SEG0_LENGTH		6
	SEG0_POSITION		0
	TYPE			string
$ GOTO LOOP_OPEN
$!
$! Since it seems to not exist, we need to create the history log file 
$! 
$NO_HIST_FILE:
$ create/log/fdl=sys$input: 'history_file_name'
TITLE	"Downtime History Records"

FILE
	ORGANIZATION		Sequential

RECORD
	CARRIAGE_CONTROL	carriage_return
	FORMAT			variable
	SIZE			60
$ goto UPDATE_HIST
$!
$! detach the logging process
$!
$STARTUP:
$! make sure there's not another already running
$ stop "''process_name'"
$! if there was, then wait for it to go away
$ if $status then $ wait 0:0:15
$ write sys$output "Starting UpTime Logger"
$ xvfl = f$VER(1)
$ run/detached	sys$system:loginout-
	/input='proc'-
	/output='log_file'-
	/process_name="''process_name'"-
	/working_set=300/extent=640-
	/privileges=('detach_privs')
$ goto EXIT !'f$VER(xvfl)'
$!
$ERR_KEY_UPDATE:
$ write sys$output f$MESSAGE($STATUS)
$ goto EXIT
$! maximum
$! p1 -- global symbol to return the maximum value to 
$! p2,p3...p8 optional parameters
$! 
$MAXIMUM: subroutine 
$ vfl = f$VER(0)
$ null = ""
$ comp = ".gt."
$ if f$TYPE(p2).nes."INTEGER" then $ comp = ".gts."
$ max_val = p2
$ ix = 3
$MAX_LOOP:
$ if p'ix'.nes.null 
$ then 
$	if p'ix' 'comp' max_val then $ max_val = p'ix'
$	ix = ix+1
$	if ix.lt.9 then $ goto MAX_LOOP
$ endif
$ 'p1' == max_val
$ exit !'f$VER(vfl)'
$endsubroutine
$!
$! Minimum
$! p1 -- global symbol to return the minimum value to 
$! p2,p3...p8 optional parameters
$! 
$MINIMUM: subroutine
$ vfl = f$VER(0)
$ null = ""
$ comp = ".lt."
$ if f$TYPE(p2).nes."INTEGER" then $ comp = ".lts."
$ min_val = p2
$ ix = 3
$MIN_LOOP:
$ if p'ix'.nes.null
$ then 
$	if p'ix' 'comp' min_val then $ min_val = p'ix'
$	ix = ix+1
$	if ix.lt.9 then $ goto MIN_LOOP
$ endif
$ 'p1' == min_val
$ exit !'f$VER(vfl)'
$endsubroutine
$! compute overlap of times
$! p1 -- symbol to return down minutes to 
$OVERLAP: subroutine
$ icnt = 1
$ down_times = ""
$ up_times = ""
$O_LOOP:
$ nxt_node = f$element(icnt,comma,node_list)
$ down_times = down_times+" """+'nxt_node'_down+""""
$ up_times = up_times+" """+'nxt_node'_up+""""
$ icnt=icnt+1
$ if icnt.le.node_cnt then $ goto O_LOOP
$ call maximum down_max 'down_times'
$ call minimum up_min 'up_times'
$ if up_min.lts.down_max then $ exit
$ cvtime/sym=down_mins 'up_min'(-)'down_max'(/)0-0:1:0.0
$ down_hours = down_mins/60
$ down_hours = f$FAO("!5SL.!2ZL",down_hours,100*(down_mins-60*down_hours)/60)
$ if f$type('p1').eqs."" then $ p1 == 0
$ 'p1' == 'p1'+down_mins
$ wrep f$fao("!SL cpus down!AS hrs, from !16AS to !16AS, coincidently",-
	node_cnt,down_hours,f$cvtime(down_max),f$cvtime(up_min))
$ endsubroutine
$!
$! figure out what node we're running on
$GET_NODE: subroutine
$ if p1.eqs."" then $ p1 = "node"
$ node = f$GETSYI("nodename")
$ DECnet_cnt = 0
$ if node.eqs."" then $ node = f$TRNLNM("sys$node","lnm$system")-"_"-"::"
$ if node.eqs."" 
$ then  ! try 10 times to get DECnet node name
$RETRY:
$ wait 0:0:10.0
$ decnet_cnt=decnet_cnt+1
$ node = f$TRNLNM("sys$node","lnm$system")-"_"-"::"
$ if decnet_cnt.lt. 10 .and. node.eqs."" then $ goto RETRY
$ say "UPTIME-I-NODEGET, It took ",decnet_cnt," tries to get the node name."
$ if node.eqs."" then $ node = f$GETSYI("scsnode")
$! if there's nothing else to go on .... use the SID (hmph!)
$ if node.eqs."" then $ node = f$FAO("!8XL",f$GETSYI("sid"))
$ endif
$ node = f$EDIT(node,"trim,compress")
$ 'p1' == node
$ endsubroutine
$CLOSEOUT:subroutine ! close an open file (if it is open)
$ null =""
$ comma = ","
$ pcnt=1
$CLOSE_NEXTP:
$ parm = p'pcnt'
$ if parm.eqs.null then $ EXIT
$ if pcnt.gt.7 then $ EXIT
$ pcnt = pcnt+1
$ ecnt=0
$CLOSE_NEXTE:
$ file = f$ELEMENT(ecnt,comma,parm)
$ if file.eqs.comma then $ goto CLOSE_NEXTP
$ ecnt = ecnt+1
$ if file.eqs.null then $ goto CLOSE_NEXTE
$ if f$TRNLNM(file,"lnm$process").nes."" then $ close 'file'
$ goto CLOSE_NEXTE
$endsubroutine
$!Last Modified:   6-OCT-1987 14:35:24.54, By: RLB
