	PROGRAM RESET_SCREEN

C  This routine demonstrates the use of the VMS screen management services.
C  This routine is generic and will work on any terminal recognised by
C  the VMS operating system.
C	This routine set the following video attributes:
C	  1.  Normal video attributes.  (Inverse video is switched off).
C	  2.  Scrolling region is set to 1,24  (full screen).
C	  3.  Entire screen is erased.
C	  4.  Terminal width set to 80
C	  5.  Cursor is positioned at 1,1
C
C  David Deley  September, 1987

	IMPLICIT     none
	INCLUDE      '($DVIDEF)'
	INTEGER*4    LIB$GETDVI, LIB$PUT_OUTPUT
	INTEGER*4    SMG$GET_TERM_DATA, SMG$INIT_TERM_TABLE_BY_TYPE
	INTEGER*4    Term_type, Term_table_addr, Esc_seq_len, Status
	INTEGER*4    Arg_vector(3)
	CHARACTER    USER_TERMINAL*10 /'SYS$OUTPUT'/, Esc_seq*12
	PARAMETER    max_esc_seq_len = 12
	PARAMETER    SMG$K_BEGIN_NORMAL_RENDITION = 595	!from SYS$LIBRARY:STARLET.MLB module $$SMGTRMPTRDEF
	PARAMETER    SMG$K_SET_SCROLL_REGION = 572	!from SYS$LIBRARY:STARLET.MLB module $$SMGTRMPTRDEF
	PARAMETER    SMG$K_SET_CURSOR_ABS = 570		!from SYS$LIBRARY:STARLET.MLB module $$SMGTRMPTRDEF
	PARAMETER    SMG$K_WIDTH_NARROW = 581		!from SYS$LIBRARY:STARLET.MLB module $$SMGTRMPTRDEF
	PARAMETER    SMG$K_ERASE_WHOLE_DISPLAY = 474	!from SYS$LIBRARY:STARLET.MLB module $$SMGTRMPTRDEF

C	.ENTRY -------------------------------------

	Status = LIB$GETDVI( DVI$_DEVTYPE, , USER_TERMINAL, Term_type)
	If (.not. Status) Return

	Status = SMG$INIT_TERM_TABLE_BY_TYPE(Term_type, Term_table_addr)
	If (.not. Status) Return

C	1.  Normal video attributes.  (Inverse video is switched off).
	Status = SMG$GET_TERM_DATA ( Term_table_addr,
	2				SMG$K_BEGIN_NORMAL_RENDITION,
	3				max_esc_seq_len,
	4				esc_seq_len,
	5				%REF( Esc_seq))
	If (.not. Status) Return
	Status = LIB$PUT_OUTPUT ( Esc_seq(1:esc_seq_len))

C	2.  Scrolling region is set to 1,24  (full screen)
	Arg_vector(1) = 2	!number of args to follow
	Arg_vector(2) = 1	!scroll top margin
	Arg_vector(3) = 24	!scroll bottom margin
	Status = SMG$GET_TERM_DATA ( Term_table_addr,
	2				SMG$K_SET_SCROLL_REGION,
	3				max_esc_seq_len,
	4				esc_seq_len,
	5				%REF( Esc_seq),
	6				Arg_vector)
	If (.not. Status) Return
	Status = LIB$PUT_OUTPUT ( Esc_seq(1:esc_seq_len))

C	3.  Erase entire screen.
	Status = SMG$GET_TERM_DATA ( Term_table_addr,
	2				SMG$K_ERASE_WHOLE_DISPLAY,
	3				max_esc_seq_len,
	4				esc_seq_len,
	5				%REF( Esc_seq))
	If (.not. Status) Return
	Status = LIB$PUT_OUTPUT ( Esc_seq(1:esc_seq_len))

C	4.  Set terminal width to 80
	Status = SMG$GET_TERM_DATA ( Term_table_addr,
	2				SMG$K_WIDTH_NARROW,
	3				max_esc_seq_len,
	4				esc_seq_len,
	5				%REF( Esc_seq))
	If (.not. Status) Return
	Status = LIB$PUT_OUTPUT ( Esc_seq(1:esc_seq_len))

C	5.  Cursor is positioned at (1,1)
	Arg_vector(1) = 2	!number of args to follow
	Arg_vector(2) = 1	!cursor row number
	Arg_vector(3) = 1	!cursor column number
	Status = SMG$GET_TERM_DATA ( Term_table_addr,
	2				SMG$K_SET_CURSOR_ABS,
	3				max_esc_seq_len,
	4				esc_seq_len,
	5				%REF( Esc_seq),
	6				Arg_vector)
	If (.not. Status) Return
	Status = LIB$PUT_OUTPUT ( Esc_seq(1:esc_seq_len))

	END

