$! BUILD CALLABLE EDX EDITOR FOR DEBUGGING
$ IF P1 .EQS. "LINK" THEN GOTO LINK
$! The callable EDX editor allows new external procedures added to
$! file EDX_CALLUSER.MAR to be interactively debugged using the VMS DEBUGGER.
$!
$! CHECK FOR EXISTENCE OF ALL NECESSARY FILES.
$ type sys$input:

     The following files are required to build the CALLABLE EDX editor:

     1.  CALLTPU.MAR           - Main program
     2.  EDX_CALLUSER.MAR      - CALL_USER external source code
     3.  EDX_CALLUSER.OPT      - CALL_USER linker options file
     4.  EDX_COMMANDS.CLD      - CALL_USER command language definition file
     5.  EDX_MESSAGES.MSG      - CALL_USER message file

$eod
$!Reset file search
$ file = f$search("")
$ write sys$output "Checking existence of files in current directory ''f$environment("procedure")' "
$! 1.
$ file = f$search("CALLTPU.MAR")
$ if file .eqs. "" then goto find_error
$ write sys$output "CALLTPU.MAR exists"
$! 2.
$ file = f$search("EDX_CALLUSER.MAR")
$ if file .eqs. "" then goto find_error
$ write sys$output "EDX_CALLUSER.MAR exists"
$! 3.
$ file = f$search("EDX_CALLUSER.OPT")
$ if file .eqs. "" then goto find_error
$ write sys$output "EDX_CALLUSER.OPT exists"
$! 4.
$ file = f$search("EDX_COMMANDS.CLD")
$ if file .eqs. "" then goto find_error
$ write sys$output "EDX_COMMANDS.CLD exists"
$! 5.
$ file = f$search("EDX_MESSAGES.MSG")
$ if file .eqs. "" then goto find_error
$ write sys$output "EDX_MESSAGES.MSG exists"
$!
$ write sys$output "All files found."
$!
$!********************
$! COMPILE THE MAIN PROGRAM CALLTPU.MAR
$ write sys$output " "
$ write sys$output "Compiling CALLTPU.MAR"
$ macro/debug CALLTPU
$!
$!********************
$! COMPILE THE EDX EDITOR EXTERNAL CALL_USER SOURCE CODE
$ write sys$output " "
$ write sys$output "Compiling EDX_CALLUSER.MAR"
$ macro EDX_CALLUSER
$!
$!********************
$! COMPILE THE EDX EDITOR EXTERNAL CALL_USER CLD FILE
$ write sys$output " "
$ write sys$output "Compiling EDX_CALLUSER.CLD"
$ SET COMMAND/OBJECT EDX_COMMANDS
$!
$!********************
$! COMPILE THE EDX EDITOR EXTERNAL CALL_USER MESSAGES
$ write sys$output " "
$ write sys$output "Compiling EDX_CALLUSER.MSG"
$ MESSAGE EDX_MESSAGES
$!
$!********************
$! LINK IT ALL TOGETHER
$LINK:
$ write sys$output " "
$ write sys$output "Linking..."
$ LINK/DEBUG CALLTPU,EDX_CALLUSER,EDX_COMMANDS,EDX_MESSAGES,SYS$INPUT/OPTIONS
SYS$LIBRARY:DCLTABLES/SHARE
$EOD
$!
$!********************
$! SUCCESSFUL COMPILATION
$ type sys$input:

    Building complete.  The output file is CALLTPU.EXE

    The logical TPUSECINI must point to the compiled EDX editor TPU
    section file EDTSCNSEC.TPU$SECTION.  See file BUILD.COM to compile
    the EDX editor section file.

    To use enter the command:
      $ RUN CALLTPU

$EOD
$ EXIT
$!********************
$FIND_ERROR:
$ write sys$output "File ''file' not found in current directory"
$ exit 4
