$! EDX EDITOR BUILD
$!
$ minpgflquo = 21000	!Minimum paging file quota required to compile editor
$!
$! CHECK FOR SUFFICIENT QUOTA
$ if f$getjpi("","PGFLQUOTA") .ge. minpgflquo then goto pgflquo_OK
$ write sys$output "Process paging file quota too low to compile editor."
$ write sys$output "Process paging file quota is ''F$STRING(F$GETJPI("","PGFLQUOTA"))'.  It must be at least ''F$STRING(MINPGFLQUO)'."
$ write sys$output "Change pfglquo parameter in authorize database and login again."
$ exit 44
$!
$PGFLQUO_OK:
$! CHECK FOR EXISTENCE OF ALL NECESSARY FILES.
$ type sys$input:

     The following files are required to build the EDX editor:

     1.  EDTSCNSEC.TPU         - EDX editor TPU section file
     2.  EDTSCNHELP.HLP        - EDX editor help file
     3.  EDX_CALLUSER.MAR      - CALL_USER external source code
     4.  EDX_CALLUSER.OPT      - CALL_USER linker options file
     5.  EDX_COMMANDS.CLD      - CALL_USER command language definition file
     6.  EDX_MESSAGES.MSG      - CALL_USER message file

$eod
$!Reset file search
$ find = f$search("")
$ write sys$output "Checking existence of files in current directory ''f$environment("default")' "
$! 1.
$ file := EDTSCNSEC.TPU
$ find = f$search(file)
$ if find .eqs. "" then goto find_error
$ write sys$output "''file' exists"
$! 2.
$ file := EDTSCNHELP.HLP
$ find = f$search(file)
$ if find .eqs. "" then goto find_error
$ write sys$output "''file' exists"
$! 3.
$ file := EDX_CALLUSER.MAR
$ find = f$search(file)
$ if find .eqs. "" then goto find_error
$ write sys$output "''file' exists"
$! 4.
$ file := EDX_CALLUSER.OPT
$ find = f$search(file)
$ if find .eqs. "" then goto find_error
$ write sys$output "''file' exists"
$! 5.
$ file := EDX_COMMANDS.CLD
$ find = f$search(file)
$ if find .eqs. "" then goto find_error
$ write sys$output "''file' exists"
$! 6.
$ file := EDX_MESSAGES.MSG
$ find = f$search(file)
$ if find .eqs. "" then goto find_error
$ write sys$output "''file' exists"
$!
$ write sys$output "All files found."
$!
$!********************
$! COMPILE THE EDX EDITOR TPU SECTION FILE SOURCE CODE
$! Make check for error compiling
$ write sys$output " "
$ write sys$output "Compiling the TPU section file EDTSCNSEC.TPU"
$ OLDSEC = F$SEARCH("EDTSCNSEC.TPU$SECTION")
$ EDIT/TPU/NOSECTION/NODISPLAY/COMMAND=EDTSCNSEC
$ NEWSEC = F$SEARCH("EDTSCNSEC.TPU$SECTION")
$ IF NEWSEC .EQS. OLDSEC THEN GOTO COMPERR
$ write sys$output " "
$!
$!********************
$! COMPILE THE EDX EDITOR HELP LIBRARY
$ write sys$output " "
$ write sys$output "Compiling the help library EDTSCNHELP.HLP"
$ library/help/create edtscnhelp edtscnhelp
$!
$!********************
$! COMPILE THE EDX EDITOR EXTERNAL CALL_USER SOURCE CODE
$ write sys$output " "
$ write sys$output "Compiling the external source code EDX_CALLUSER.MAR"
$ macro EDX_CALLUSER
$!
$!********************
$! COMPILE THE EDX EDITOR EXTERNAL CALL_USER CLD FILE
$ write sys$output " "
$ write sys$output "Compiling the external source code EDX_COMMANDS.CLD"
$ SET COMMAND/OBJECT EDX_COMMANDS
$!
$!********************
$! COMPILE THE EDX EDITOR EXTERNAL CALL_USER MESSAGES
$ write sys$output " "
$ write sys$output "Compiling the external source code EDX_MESSAGES.MSG"
$ MESSAGE EDX_MESSAGES
$!
$!********************
$! LINK THE EDX EDITOR EXTERNAL CALL_USER SHARED IMAGE
$ write sys$output "Linking EDX_CALLUSER"
$ LINK EDX_CALLUSER/SHARE/OPT
$!
$!********************
$! SUCCESSFUL COMPILATION
$ write sys$output "Building complete"
$ EXIT
$!********************
$FIND_ERROR:
$ write sys$output "File ''file' not found in current directory"
$ exit 44
$COMPERR:
$ write sys$output "If error was 'insufficient virtual memory' then check the following:"
$ write sys$output "    1.  Process paging file quota may be too small."
$ write sys$output "    2.  SYSGEN parameter PAGEFILECNT may be too small."
$ write sys$output "    3.  Physical size of system paging file may be too small."
$ exit 44
