$ !===========================================================
$ ! KITINSTAL for Software Package EDX EDITOR
$ !===========================================================
$ !
$ ! TRAP INTERUPTS AND ERRORS
$ !
$ on control_y then  $ vmi$callback control_y
$ on warning then  $ exit $status
$ !
$ ! DECIDE ACTION TO TAKE - BASED ON P1
$ ! 
$ if p1 .eqs. "VMI$_INSTALL" then  $ goto INSTALL
$ if p1 .eqs. "VMI$_IVP" then  $ goto IVP
$ exit vmi$_unsupported
$ !
$ !===========================================================
$ ! BEGIN INSTALLATION
$ !===========================================================
$ !
$INSTALL:
$ !
$ WRITE SYS$OUTPUT " "
$ WRITE SYS$OUTPUT "Welcome to the EDX EDITOR installation procedure"
$ ! CHECK VERSION OF VMS
$ !
$ product$type = "RELEASED"
$ product$version = "044"
$ vmi_type = f$element( 0, ",", vmi$vms_version )
$ vmi_type = f$element( 0, " ", vmi_type )
$ vmi_version = f$element( 1, ",", vmi$vms_version )
$ !
$ if product$type .nes. vmi_type then  $ goto WRONG_VERSION
$ if f$extract( 0, 2, product$version ) .nes. f$extract( 0, 2, vmi_version ) -
     then  $ goto WRONG_VERSION
$ if f$extract( 2, 1, product$version ) .les. f$extract( 2, 1, vmi_version ) -
     then  $ goto GOOD_VERSION
$ !
$WRONG_VERSION:
$ vmi$callback message e version -
     "This kit must be installed on an existing ''vms_version' system"
$ exit vmi$_failure
$ !
$GOOD_VERSION:
$ !
$ ! COPY THE DOCUMENTATION FILE
$COPY_DOC:
$ write sys$output "Where would you like the EDX editor documentation file copied to?"
$ vmi$callback ask doc_destination "Disk and directory"
$ vmi$callback provide_file doc_file EDTSCNDOC.DOC 'doc_destination' CK
$ !
$COMPILE:
$ ! COMPILE THE SOURCE CODE
$ set default vmi$kwd
$ @build_edx
$ if .not. $severity then exit vmi$_failure
$ !
$ ! DEFINE LOGICAL TPU$CALLUSER
$ write sys$output "Defining system logical TPU$CALLUSER as SYS$LIBRARY:EDX_CALLUSER"
$ define/system tpu$calluser sys$library:edx_calluser
$ !
$ ! MOVE THE FILES TO THE NEW DESTINATION 
$ write sys$output "Files will now be moved to their final destinations"
$ write sys$output "Moving EDX editor TPU section file EDTSCNSEC.TPU$SECTION to SYS$LIBRARY:"
$ vmi$callback provide_file TPU_section_file EDTSCNSEC.TPU$SECTION vmi$root:[syslib]
$ write sys$output "Moving EDX editor help library file EDTSCNHELP.HLB to SYS$HELP:"
$ vmi$callback provide_file help_file EDTSCNHELP.HLB vmi$root:[syshlp]
$ write sys$output "Moving EDX editor external TPU call_user shared image EDX_CALLUSER.EXE "
$ write sys$output " to SYS$LIBRARY:"
$ vmi$callback provide_image calluser EDX_CALLUSER.EXE vmi$root:[syslib]
$ !
$ASK_PURGE:
$ !
$ ! SEE IF USER WANTS TO PURGE
$ !
$ vmi$callback set purge ask
$ !
$ ! FINAL MESSAGE
$ type sys$input:

     This completes the installation of the EDX editor.  There are two
     logical names you must define before you can use the editor:

     DEFINE TPU$CALLUSER SYS$LIBRARY:EDX_CALLUSER
     DEFINE TPUSECINI SYS$LIBRARY:EDTSCNSEC

     The logical name TPU$CALLUSER may be placed in the system wide
     LNM$_SYSTEM logical name table.  Remember to add it to
     SYSTARTUP.COM so the logical will be defined next time the system
     reboots.

     The logical name TPUSECINI should be defined in each user's
     personal login.com file.  It could be placed in the system wide
     LNM$_SYSTEM logical name table if everyone wanted it.  This would
     make EDX the default editor invoked by the $ EDIT/TPU command
     instead of EVE.

$ exit vmi$_success
