	PROGRAM CRCHECK

	IMPLICIT	NONE
	INTEGER*4	N
	INTEGER*4	POLY /'EDB88320'X/
	INTEGER*4	CRC_TABLE(16)
	COMMON /CRCTAB/ CRC_TABLE

	parameter numfiles = 7
	character*(80)  FILE(numfiles)
	integer*4	LENGTH(numfiles), CRC(numfiles)

	data	file(1)   /'SYS$SYSTEM:LOGINOUT.EXE'/
	data	length(1) /'00000DA00'X/
	data	crc(1)	  /'B3500B04'X/

	data	file(2)	  /'SYS$SYSTEM:SHOW.EXE'/
	data	length(2) /'00019400'X/
	data	crc(2)	  /'A69BD17F'X/

	data	file(3)	  /'SYS$SYSTEM:SET.EXE'/
	data	length(3) /'00016000'X/
	data	crc(3)	  /'7D955A9A'X/

	data	file(4)	  /'SYS$SYSTEM:JOBCTL.EXE'/
	data	length(4) /'0000E600'X/
	data	crc(4)	  /'64A1BD57'X/

	data	file(5)	  /'SYS$SYSTEM:DCL.EXE'/
	data	length(5) /'00011E00'X/
	data	crc(5)	  /'BCC5C06C'X/

	data	file(6)	  /'SYS$SYSTEM:SYS.EXE'/
	data	length(6) /'00037800'X/
	data	crc(6)	  /'4FF97942'X/

	data	file(7)	  /'SYS$SYSTEM:F11BXQP.EXE'/
	data	length(7) /'0000F200'X/
	data	crc(7)	  /'9205A443'X/

C	.ENTER
	call lib$crc_table(poly,crc_table) 
	do n=1,numfiles
		call checkfile( file(n), length(n), crc(n) )
	enddo
	call exit
	END
C------------------------------------------------------------------------------
	SUBROUTINE CHECKFILE(FILENAME,LENGTH_CHECK,CRC_CHECK)
	IMPLICIT	NONE
	LOGICAL		PASS
	INTEGER*4	INIT /0/
	INTEGER*4	LIB$CRC
	INTEGER*4	I, LEN, MSGLEN
	INTEGER*4	LENGTH_TOTAL, LENGTH_CHECK
	INTEGER*4	CRC_CALC, CRC_CHECK
	INTEGER*4	CRC_TABLE(16)
	COMMON /CRCTAB/ CRC_TABLE
	CHARACTER*(*)	FILENAME
	INTEGER*4	FNAMLEN
	CHARACTER*80	MSGBUF
	PARAMETER	LINEMAX=500
	CHARACTER*512	LINE(LINEMAX)
100	FORMAT(Q,A)

	parameter bell=7

	character*34 lenmsg1
	data lenmsg1(1:1), lenmsg1(2:34)
	2	/ bell, 'Length check mismatch on file !AS' /

	character*50 lenmsg2
	data lenmsg2(1:50)
	2	/ 'Expected length !XL (hex), actual length !XL (hex)'/

	character*31 crcmsg1
	data crcmsg1(1:1), crcmsg1(2:31)
	2	/ bell, 'CRC check mismatch on file !AS' /

	character*50 crcmsg2
	data crcmsg2(1:50)
	2	/ 'Expected CRC !XL (hex), actual CRC !XL (hex)'/

	character*18 passmsg
	data passmsg(1:18)  / 'File !AS checks OK' /

C	.ENTRY
	open(unit=1,access='sequential',carriagecontrol='none',
	2	file=filename,readonly,organization='sequential',
	3	recordsize=512,status='old')

	length_total = 0
	do i=1,linemax
		line(i) = ' '
	enddo

	do i=1,linemax
		read(1,100,end=1000)len,line(i)
		length_total = length_total + len
	enddo
	print*, 'Maximum file size exceeded.'
	close(unit=1)
	stop 'Unable to complete check'

1000	close(unit=1)
	call str$trim(filename,filename,fnamlen)
	pass = .TRUE.
	if (length_total .NE. length_check) then
		pass = .FALSE.
		call sys$fao(lenmsg1,msglen,msgbuf,filename(1:fnamlen))
		print*, msgbuf(1:msglen)
		call sys$fao(lenmsg2,msglen,msgbuf,
     *			%val(length_check),%val(length_total))
		print*, msgbuf(1:msglen)
		print*, ' '
	endif

	crc_calc = lib$crc(crc_table,init,line)
	if (crc_calc .NE. crc_check) then
		pass = .FALSE.
		call sys$fao(crcmsg1,msglen,msgbuf,filename(1:fnamlen))
		print*, msgbuf(1:msglen)
		call sys$fao(crcmsg2,msglen,msgbuf,
     *			%val(crc_check),%val(crc_calc))
		print*, msgbuf(1:msglen)
		print*, ' '
	endif

	if (pass) then
		call sys$fao(passmsg,msglen,msgbuf,filename(1:fnamlen))
		print*, msgbuf(1:msglen)
	endif
	return

	END
