--------------------------------------------------------------------------------
--
-- Program Build_hyphenation_tables
-- April 1988
--
--                                                                    Greg Janee
--                                                  General Research Corporation
--                                                                 P.O. Box 6770
--                                                  Santa Barbara, CA 93160-6770
--
-- This program builds a set of pattern and exception tables for use  with  sub-
-- routine  Hyphenate.   It  reads  two  files -- a file containing zero or more
-- pattern descriptions and a file containing zero or more  exception  words  --
-- and  produces  a  MACRO-compilable  file  containing the tables.  The default
-- filename for the input files is ".DAT"  and  that  for  the  output  file  is
-- ".MAR".   The  output file defines module HYPHENATION_TABLES; the tables con-
-- tained therein are located in program section $PDATA and  are  identified  by
-- global symbols prefixed by "HYPH$".
--
-- The hyphenation algorithm used by subroutine Hyphenate and this  program  was
-- adapted  from  that used by TeX82, the document compiler written by Donald E.
-- Knuth at Stanford University.  References are "The TeXbook" (Reading,  Mass.:
-- Addison  Wesley, 1984) and "TeX:  The Program" (Reading, Mass.:  Addison Wes-
-- ley, 1986), both by Knuth; and "Word Hy-phen-a-tion by Com-pu-ter"  (Stanford
-- Computer  Science  Report 977, Stanford, California, August 1983) by Franklin
-- Mark Liang.
--
-- The  Build_hyphenation_tables  source must be woven by the Weave preprocessor
-- before it can be compiled.  DATA_STRUCTURES.WEB should be compiled first  and
-- BUILD_HYPHENATION_TABLES.WEB last; the remaining files can be compiled in any
-- order.  Build_hyphenation_tables should be linked /NOTRACEBACK.
--
--------------------------------------------------------------------------------

With Compress_Linked_trie, Load_exception_file,
   Load_pattern_file_into_Linked_trie, Output_tables,
   Pack_Linked_trie_into_Packed_trie;

With Text_IO;
Use  Text_IO;

Procedure Build_hyphenation_tables is

   Exception_file: File_type;
   Output_file: File_type;
   Pattern_file: File_type;

begin

Declare

   Filename: String (1..32767);
   Length: Natural;

begin

   Put( "Pattern file: " ); Get_line( Filename, Length );
   If Col /= 1 then New_line; end if;
   Open( Pattern_file, In_file, Filename (1..Length),
      "FILE; DEFAULT_NAME '.DAT'" );

   Put( "Exception file: " ); Get_line( Filename, Length );
   If Col /= 1 then New_line; end if;
   Open( Exception_file, In_file, Filename (1..Length),
      "FILE; DEFAULT_NAME '.DAT'" );

   Put( "Output file: " ); Get_line( Filename, Length );
   If Col /= 1 then New_line; end if;
   Create( Output_file, Out_file, Filename (1..Length),
      "FILE; DEFAULT_NAME '.MAR'" );

end;

--------------------------------------------------------------------------------

   Load_pattern_file_into_Linked_trie( Pattern_file );
   Compress_Linked_trie;
   Pack_Linked_trie_into_Packed_trie;
   Load_exception_file( Exception_file );

   Output_tables( Output_file, Name( Pattern_file ), Name( Exception_file ) );

   Close( Pattern_file );
   Close( Exception_file );
   Close( Output_file );

end Build_hyphenation_tables;

--------------------------------------------------------------------------------

--------------------------------------------------------------------------------

