--------------------------------------------------------------------------------

-- The final step of this program is the writing of the  pattern  and  exception
-- word  data  structures  to  the  output file, which is performed by procedure
-- Output_tables.  The output file is assumed to be open on  entry  and  is  not
-- closed on return.

With Data_structures, Integer_text_IO, Text_IO;
Use  Data_structures, Integer_text_IO, Text_IO;

Procedure Output_tables ( Output_file: in File_type; Pattern_file_name: in
   String; Exception_file_name: in String ) is


   Tab: Character renames ASCII.HT;

   Procedure P ( S: in String ) is begin
      Put( Output_file, S );
   end;

   Procedure PL ( I: in Integer ) is begin
      Put( Output_file, I, 0 );
      New_line( Output_file );
   end;

   Procedure PL ( S: in String ) is begin
      Put_line( Output_file, S );
   end;

--------------------------------------------------------------------------------

begin

   PL( Tab & ".TITLE" & Tab & "HYPHENATION_TABLES" );
   PL( Tab & ".IDENT" & Tab & "/V1.0/" );
   PL( "; This module was produced by program Build_hyphenation_tables." );
   PL( "; The pattern file was " & Pattern_file_name & "." );
   PL( "; The exception file was " & Exception_file_name & "." );
   PL( Tab & ".PSECT" & Tab &
      "$PDATA,PIC,USR,CON,REL,LCL,SHR,NOEXE,RD,NOWRT,NOVEC,LONG" );

   PL( "HYPH$AL_PACKED_TRIE::" );

   For I in 0 .. Packed_trie_last loop
      P( Tab & ".WORD" & Tab ); PL( Packed_trie(I).Next    );
      P( Tab & ".BYTE" & Tab ); PL( Packed_trie(I).Weights );
      P( Tab & ".BYTE" & Tab ); PL( Packed_trie(I).Char    );
   end loop;

   -- Note that before writing out Weight_location_table we must put  any  legal
   -- values  in  the  (unused) first entry, so that the MACRO compiler will not
   -- choke on garbage values that are too large.  We will do the same  for  Ex-
   -- ception_pool(0) below.

   PL( "HYPH$AL_WEIGHT_LOCATION_TABLE::" );

   Weight_location_table(0) := ( 0, 0, 0 );

   For I in 0 .. Weight_location_table_last loop
      P( Tab & ".BYTE" & Tab ); PL( Weight_location_table(I).Next   );
      P( Tab & ".BYTE" & Tab ); PL( Weight_location_table(I).Weight );
      P( Tab & ".WORD" & Tab ); PL( Weight_location_table(I).Offset );
   end loop;

   P( "HYPH$S_EXCEPTION_TABLE == " ); PL( Exception_table'length );
   PL( "HYPH$AW_EXCEPTION_TABLE::" );

   For I in Exception_table'range loop
      P( Tab & ".WORD" & Tab ); PL( Exception_table(I) );
   end loop;

   PL( "HYPH$AB_EXCEPTION_POOL::" );

   Exception_pool(0) := 0;

   For I in 0 .. Exception_pool_last loop
      P( Tab & ".BYTE" & Tab ); PL( Exception_pool(I) );
   end loop;

   PL( Tab & ".END" );

end Output_tables;

--------------------------------------------------------------------------------

--------------------------------------------------------------------------------

