      INTEGER*4 FUNCTION APPLY_DEFS ( FILNAM, DEFNAM, FLAGS, RESULT )

C     Applies a  default file specification  to a file specification and
C     returns the result.  Note that this routine performs syntax check-
C     ing  and default substitution  only; no checking  is done that any
C     entity -- node, device, directory, or file -- exists.  In particu-
C     lar, this implies  that in  most cases the version number  will be
C     absent and will be represented by a lone semicolon.  The status of
C     the operation is returned as a function value.

C     Greg Janee, 09-AUG-1986

C-----------------------------------------------------------------------

C     Arguments:
C
C     FILNAM    type:      character string
C               access:    read only
C               mechanism: by descriptor, fixed-length descriptor
C
C     The file  specification.  If the string is  longer than 255 bytes,
C     only the first 255 bytes are used.
C
C     DEFNAM    type:      character string
C               access:    read only
C               mechanism: by descriptor, fixed-length descriptor
C
C     The default file specification to  be applied to the file specifi-
C     cation.  If the string is longer than 255 bytes only the first 255
C     bytes are used.
C
C     FLAGS     type:      longword bit mask
C               access:    read only
C               mechanism: by reference
C
C     Option flags.  If  bit 0 is set, a concealed  device logical name,
C     if present, is translated into the physical device name before be-
C     ing  placed in the RESULT  argument.  If  bit 0 is clear concealed
C     device names are left  concealed.  If bit 1 is set,  a password in
C     the access  control string of  a node specification (for  example,
C     the 'HO' in 'NODE1"GUNG HO"::DISK1:[GUNG]FILE.DAT') is replaced by
C     the string 'password'  before it is placed in the RESULT argument.
C     If bit 1 is  clear any password is left alone.  All other bits are
C     ignored.  See  section 6.16 of  the VAX Record Management Services
C     Reference Manual for more information on this argument.
C
C     RESULT    type:      character string
C               access:    write only
C               mechanism: by descriptor, fixed-length descriptor
C
C     The resultant  file specification,  blank-filled to  the length of
C     the character string.  If the operation fails this argument is en-
C     tirely blank.

C=======================================================================

      IMPLICIT  NONE
      INCLUDE   '($FABDEF)'
      INCLUDE   '($NAMDEF)'

      CHARACTER FILNAM*(*)
      CHARACTER DEFNAM*(*)
      INTEGER*4 FLAGS
      CHARACTER RESULT*(*)

      RECORD    /FABDEF/ FAB
      RECORD    /NAMDEF/ NAM
      INTEGER*4 POS

      INTRINSIC JMIN0
      INTRINSIC JZEXT
      INTRINSIC LEN
      EXTERNAL  LIB$INSV
      EXTERNAL  LIB$MOVC5
      EXTERNAL  SYS$PARSE
      INTEGER*4 SYS$PARSE

C-----------------------------------------------------------------------

C     We clear our  FAB and fill  in the necessary fields.  The calls to
C     LIB$INSV are required  because the  string size  fields in the FAB
C     are  unsigned bytes, but in $FABDEF they have been declared  to be
C     signed bytes.

      CALL LIB$MOVC5 ( 0, 0, 0, FAB$C_BLN, FAB )

      FAB.FAB$B_BID = FAB$C_BID
      FAB.FAB$B_BLN = FAB$C_BLN

      FAB.FAB$L_DNA = %LOC(DEFNAM)
      CALL LIB$INSV ( JMIN0( LEN(DEFNAM), 255 ), 0, 8, FAB.FAB$B_DNS )

      FAB.FAB$L_FNA = %LOC(FILNAM)
      CALL LIB$INSV ( JMIN0( LEN(FILNAM), 255 ), 0, 8, FAB.FAB$B_FNS )

      FAB.FAB$L_NAM = %LOC(NAM)

C     Next, we  initialize our NAM block.  Ideally we'd like RMS to give
C     us back the resultant string, but since we're  using SYS$PARSE and
C     only checking syntax we can only get the expanded string.

      CALL LIB$MOVC5 ( 0, 0, 0, NAM$C_BLN, NAM )

      NAM.NAM$B_NOP = NAM$M_SYNCHK

      IF ( (FLAGS .AND. 1) .NE. 0 ) THEN
         NAM.NAM$B_NOP = NAM.NAM$B_NOP .OR. NAM$M_NOCONCEAL
      END IF

      IF ( (FLAGS .AND. 2) .EQ. 0 ) THEN
         NAM.NAM$B_NOP = NAM.NAM$B_NOP .OR. NAM$M_PWD
      END IF

      NAM.NAM$L_ESA = %LOC(RESULT)
      CALL LIB$INSV ( JMIN0( LEN(RESULT), 255 ), 0, 8, NAM.NAM$B_ESS )

      NAM.NAM$B_BID = NAM$C_BID
      NAM.NAM$B_BLN = NAM$C_BLN

C     After the  parsing RMS will put the size of the expanded string in
C     the  ESL field of the  NAM block.  Note  that this  is an unsigned
C     field.

      APPLY_DEFS = SYS$PARSE( FAB )

      IF ( APPLY_DEFS ) THEN
         POS = JZEXT( NAM.NAM$B_ESL )
      ELSE
         POS = 0
      END IF

      RESULT(POS+1:) = ' '
      RETURN

C=======================================================================

      END
