#	include stdio

/*:===============================================================================*/

/*:	This  file  forms  a simple and incomplete C interface to MacroDSA.  Its*/
/*:	only purpose in life is to allow the specification of datasets by  typed*/
/*:	pointers.   We  need only one local variable:  the address of user space*/
/*:	in the current database.*/

	int	(*L_user_space)[];

/*:	And we need two local functions to convert indexes to addresses and vice*/
/*:	versa.  We implement these functions as macros for speed.*/

#	define cvt_to_adr(x) \
	( (x) == 0 ? NULL : (char *) &(*L_user_space)[(x)] )

#	define cvt_to_ind(x) ( ((int) (x) - (int) L_user_space)/4 )

/*:===============================================================================*/

/*:===============================================================================*/

	char	*dsa$create ( length )

	int	length;
{
	int	index;
	int	temp;

	void	create();

/*:-------------------------------------------------------------------------------*/

	create( (temp = (length-1)/4+1, &temp), &index );
	return cvt_to_adr(index);
}
/*:===============================================================================*/

/*:===============================================================================*/

	int	dsa$dspwrd ( dataset )

	char	*dataset;
{
	int	index;
	int	pointer;

	void	dspwrd();

/*:-------------------------------------------------------------------------------*/

	dspwrd( (index = cvt_to_ind(dataset), &index), &pointer );
	return pointer;
}
/*:===============================================================================*/

/*:===============================================================================*/

	char	*dsa$indwrl ( pointer )

	int	pointer;
{
	int	index;

	void	indwrl();

/*:-------------------------------------------------------------------------------*/

	indwrl( &pointer, &index );
	return cvt_to_adr(index);
}
/*:===============================================================================*/

/*:===============================================================================*/

	char	*dsa$next ( node )

	int	*node;
{
	int	index;

	void	next();

/*:-------------------------------------------------------------------------------*/

	next( node, &index );
	return cvt_to_adr(index);
}
/*:===============================================================================*/

/*:===============================================================================*/

	char	*dsa$prev ( node )

	int	*node;
{
	int	index;

	void	prev();

/*:-------------------------------------------------------------------------------*/

	prev( node, &index );
	return cvt_to_adr(index);
}
/*:===============================================================================*/

/*:===============================================================================*/

	void	dsa$putbot ( list, dataset )

	int	*list;
	char	*dataset;
{
	int	index;

	void	putbot();

/*:-------------------------------------------------------------------------------*/

	putbot( list, (index = cvt_to_ind(dataset), &index) );
}
/*:===============================================================================*/

/*:===============================================================================*/

	void	dsa$remove ( list, node )

	int	*list;
	int	node;
{
	int	temp;

	void	remove();

/*:-------------------------------------------------------------------------------*/

	remove( list, (temp = node, &temp) );
}
/*:===============================================================================*/

/*:===============================================================================*/

	void	dsa$switch_db ( database )

	int	database;
{
	int	junk;

	void	dsa$switch();

/*:-------------------------------------------------------------------------------*/

	dsa$switch( &database, &junk, &L_user_space );
}
/*:===============================================================================*/

/*:===============================================================================*/

	char	*dsa$template ( )
{
/*:-------------------------------------------------------------------------------*/

	return cvt_to_adr(1);
}
/*:===============================================================================*/

/*:===============================================================================*/

	char	*dsa$zobtan1 ( list, dir, word, rel, value, dtype )

	int	list;			int	rel;
	int	dir;			char	*value;
	char	*word;			int	dtype;
{
	int	index;
	int	temp;

	void	dsa$obtain();

/*:-------------------------------------------------------------------------------*/

	dsa$obtain( &0, 0, &index, (temp = list, &temp), &dir, 0, &1, word,
		value, &dtype, &rel );

	return cvt_to_adr(index);
}
/*:===============================================================================*/
