$! -------------------------------
$! Produce a list of subprocesses?
$! -------------------------------
$ IF P1 .NES. "*" THEN GOTO attach_parent
$ CONTEXT    =  ""
$ PARENT_PID = F$GETJPI ("0", "MASTER_PID")
$ WRITE SYS$OUTPUT "Current: ''F$PROCESS()'"
$ WRITE SYS$OUTPUT "Parent:                 ''F$GETJPI(PARENT_PID,"PRCNAM")'"
$loop:
$ P = F$PID (CONTEXT)
$ IF P .EQS. "" THEN EXIT
$ OWNER = F$GETJPI (P,"MASTER_PID")
$ IF PARENT_PID .NES. OWNER THEN GOTO loop
$ IF PARENT_PID .EQS. P THEN GOTO loop
$ WRITE SYS$OUTPUT "                                    ''F$GETJPI(P,"PRCNAM")'"
$ GOTO loop
$! -----------------------------
$! Attach to the parent process?
$! -----------------------------
$attach_parent:
$ IF P1 .NES. "" THEN GOTO attach_subprocess
$ PARENT_PID = F$GETJPI ("0", "MASTER_PID")
$ ON WARNING THEN GOTO parent_error
$a1:
$ ATTACH /ID='PARENT_PID
$ EXIT
$! -----------------------------
$! Subprocess control subsection
$! -----------------------------
$attach_subprocess:
$ USERNAME  = F$GETJPI ("0", "USERNAME")
$ USERNAME  = F$EDIT   (USERNAME, "TRIM")
$ PROCESS_NAME_ == USERNAME + "_''P1'"
$!
$ RUN SYS_MANAGER:PP_PRCNAMPID
$ PID_ == F$EDIT (PID_, "trim")
$ IF PID_ .EQS. "-1" THEN GOTO create_subprocess
$	! -----------------
$	! Subprocess exists
$	! -----------------
$ ON WARNING THEN GOTO subp_error
$a2:
$ ATTACH /ID='PID_
$ EXIT
$	! --------------------------------------
$	! Subprocess does not exists. Create one
$	! --------------------------------------
$create_subprocess:
$ STAT = F$TRNLNM ("PRIMARY")
$ NODE = F$TRNLNM ("SYS$NODE") - "_"
$ NODE = F$EXTRACT(3,1,NODE)
$ IF STAT .NES. "YES" THEN NODE = F$EDIT(NODE,"lowercase")
$ PROM = PROCESS_NAME_ + "(" + NODE + ")$ "
$ IF STAT .NES. "YES" THEN PROM = F$EDIT(PROM,"lowercase")
$ SPAWN /PROCESS="''PROCESS_NAME_'" /PROMPT="''PROM'"
$ EXIT
$! ---------------------------
$! Parent attach error handler
$! ---------------------------
$parent_error:
$ PARENT_UIC = F$GETJPI (PARENT_PID, "UIC")
$ IF PARENT_UIC .EQS. F$USER () THEN EXIT
$ WRITE SYS$OUTPUT "...changing subprocess environment to ''PARENT_UIC'"
$ @SYS_MANAGER:ENV 'PARENT_UIC
$ GOTO a1
$! -------------------------------
$! Subprocess attach error handler
$! -------------------------------
$subp_error:
$ SUBP_UIC = F$GETJPI (PID_, "UIC")
$ IF SUBP_UIC .EQS. F$USER () THEN EXIT
$ WRITE SYS$OUTPUT "...changing parent environment to ''SUBP_UIC'"
$ @SYS_MANAGER:ENV 'SUBP_UIC
$ GOTO a2
