$! -------
$! FORTRAN
$! -------
$check_for_fortran:
$ IF P1 .NES. ".FOR" THEN GOTO check_for_pli
$ COMMAND = "FORTRAN "
$ GOTO add_source
$! ----
$! PL/I
$! ----
$check_for_pli:
$ IF P1 .NES. ".PLI" THEN GOTO check_for_macro
$ COMMAND = "PLI "
$ GOTO add_source
$! -----
$! MACRO
$! -----
$check_for_macro:
$ IF P1 .NES. ".MAR" THEN GOTO check_for_c
$ COMMAND = "MACRO "
$ GOTO add_source
$! -
$! C
$! -
$check_for_c:
$ IF P1 .NES. ".C" .AND. P1 .NES. ".H" THEN GOTO check_for_runoff
$ COMMAND = "CC "
$ GOTO add_source
$! -------------------------------------------------------------------------
$! RUNOFF is particularly special, because it uses /OUT (instead of /OBJECT)
$! -------------------------------------------------------------------------
$check_for_runoff:
$ FTYPE = F$EXTRACT (0,3,F$PARSE (P1,,,"TYPE"))
$ IF FTYPE .NES. ".RN" THEN GOTO nothing_left
$ COMMAND = "RUNOFF " + P2 + " /LOG /MES=USER"
$ IF P3 .EQS. "/NOOBJECT" THEN COMMAND = COMMAND + " /OUT=SYS$OUTPUT "
$ GOTO ready
$! -------------------------
$! Nothing else is supported
$! -------------------------
$nothing_left:
$ COMMAND = "????? ...that source file type is not supported"
$ DELETE 'P2
$ GOTO ready
$! -----------------------------
$! Add the source to the command
$! -----------------------------
$add_source:
$ COMMAND = COMMAND + P2
$! ---------------------------------
$! Add the qualifiers to the command
$! ---------------------------------
$add_qualifiers:
$ COMMAND = COMMAND + " ''P3'/LIST=SYS$OUTPUT"
$! ------------------------------------------
$! Return the construct command to the editor
$! ------------------------------------------
$ready:
$ WRITE SYS$OUTPUT COMMAND
$ EXIT
$! ------------------------------------------------------------------------
$! SYS_MANAGER:EDTEM_COMPILE.COM
$! -----------------------------
$! Construct a command suitable for the compilation to be performed
$!
$! This procedure is invoked by EDTEM in preparation for
$! compilation/assembly of the source in its current buffer
$!
$! P1 - file type (.FOR, .PLI, etc.)
$! P2 - source location (filename, SYS$INPUT, etc.)
$! P3 - additional qualifiers
$!
$! M. Latshaw <> 08-MAR-1988
$! ------------------------------------------------------------------------
