$! ------------------------------------------------------------
$! Compensate for any change in default directory and/or device
$! ------------------------------------------------------------
$ LATEST_DEFAULT_SPECIFICATION = F$ENVIRONMENT("DEFAULT")
$ DEFINE /NOLOG /JOB LATEST_DEFAULT_SPECIFICATION 'LATEST_DEFAULT_SPECIFICATION
$!
$! -----------------------------------------------------------------------------
$! See if we have already started our TPU subprocess. It will be called
$! "EDTEM_x", where "x" is the four-digit terminal port (e.g., TXA0).
$! If a process by that name is not found, start one. Remember the environment
$! under which it is started, as it is not possible to reconnect to a subprocess
$! when the parent has altered its UIC group.
$! -----------------------------------------------------------------------------
$ TT        = F$GETDVI ("SYS$COMMAND","DEVNAM") - "_" - "_" - ":"
$ EDIT_NAME = "EDTEM_" + TT
$ PRIV_LIST = F$SETPRV ("NOWORLD, NOGROUP")
$ PID       = 0
$	! ----------------------------------
$	! Search for existent TPU subprocess
$	! ----------------------------------
$loop:
$ PROC = F$GETJPI (F$PID(PID), "PRCNAM")
$ IF PROC .EQS. EDIT_NAME THEN GOTO attach
$ IF PID  .NE.  0         THEN GOTO loop
$	! -------------------------------
$	! None was found, so start up one
$	! -------------------------------
$ EDTEM_PRESENT_GROUP_TABLE == PRESENT_GROUP_TABLE	! Put your code here
$ EDTEM_PRESENT_UIC         == F$USER()
$ PRIV_LIST = F$SETPRV(PRIV_LIST)
$ WRITE SYS$ERROR "[Spawning a new kept editor]"
$ DEFINE /NOLOG SYS$INPUT SYS$COMMAND
$!
$ SPAWN	/PROCESS="''EDIT_NAME'"	-
	/NOLOG 			-
	/NOSYMBOLS		-
					@SYS_MANAGER:EDTEM_SUBP
$ GOTO out
$!
$! -----------------------------------------------------------------
$! An editing process for this user already exists. Re-attach to it.
$! -----------------------------------------------------------------
$attach:
$	! ---------------------------------------------------------------
$	! Make sure we are in the same group as is the editing subprocess
$	! ---------------------------------------------------------------
$ PREVIOUS_GROUP_TABLE == EDTEM_PRESENT_GROUP_TABLE
$ PREVIOUS_UIC         == EDTEM_PRESENT_UIC
$! @SYS_MANAGER:ENV < X					! Put your code here
$	! -----------------------------
$	! Now, attach to the subprocess
$	! -----------------------------
$ PRIV_LIST = F$SETPRV(PRIV_LIST)
$ DEFINE /NOLOG SYS$INPUT SYS$COMMAND
$ ATTACH 'EDIT_NAME
$	! ----------------------------------------------------
$	! Just in case the user was in a different environment
$	! place that person back into it
$	! ----------------------------------------------------
$! @SYS_MANAGER:ENV < X					! Put your code here
$out:
$ WRITE SYS$ERROR "[Returning control to parent process]"
$ EXIT
