$!******************************************************************************
$!
$!  N E W S S K I M :   Perform regular maintenance tasks for the Usenet News
$!
$!  >>>>>>    MUST RUN from    N E W S M G R    account    <<<<<<
$!
$!  Distribution:  NEWS_ROOT:NEWSSKIM.COM on the VAXcluster.
$!
$!------------------------------------------------------------------------------
$!
$!  Author:	Jonathan Ridler, U.C.S., Melbourne University.
$!  Date:	March, 1988.
$!  Origin:	Derived from a similar procedure by Geoff Huston, ANU.
$!
$!******************************************************************************
$
$ show time				!  Just for info.
$ set output_rate = :00:15		!  Allow a close watch to be kept
$
$ set noon
$ set control = (Y,T)
$
$ Run_Times = "01,04,07,10,12,15,18,21"	!  Times when to submit during the day.
$ Convert_Day  = "Sunday"		!  Day  to convert database files.
$ Convert_Hour = "01"			!  Hour to convert database files.
$
$ Batch_Q = "SYSTEM"			!  Batch queue in which NEWSSKIM runs.
$
$ ws := write SYS$OUTPUT		!  Can use REQUEST if prefered.
$
$ Node_Search = 1			!  Search stream id for Post_News
$ File_Search = 2			!  Search stream id for Post_News
$ NNTP_Node_Search = 3			!  Search stream id for Post_News
$ NNTP_File_search = 4
$
$ Now   = f$time ()
$ Hour  = f$extract (12,2,Now)
$ Today = f$cvtime (Now,,"WEEKDAY")
$
$ Add_News	= 0
$ Skim_News	= 0
$ Post_News	= 0
$ Convert_Db	= 0
$ Resubmit	= 1			!  Default = Resubmit.
$
$ set on
$ on error  then  goto  ABORT
$
$ if p1 .eqs. ""  then  goto  'Hour'	!  A normally scheduled run.
$
$!..............................................................................
$!  Something special as a one-off run - handle it separately as specified in
$!  the parameter list.
$
$ gosub  Parse_Params
$ goto  ZOOM
$
$!..............................................................................
$!  Scheduled run - do tasks as indicated below by hour.
$
$01:	gosub ALL_TASKS
$	goto  ZOOM
$
$04:
$07:
$10:
$12:
$15:
$18:
$21:	gosub NORMAL_TASKS
$	goto  ZOOM
$
$00:
$02:
$03:
$05:
$06:
$08:
$09:
$11:
$13:
$14:
$16:
$17:
$19:
$20:
$22:
$23:	goto  ZOOM
$
$!..............................................................................
$ZOOM:
$
$ on error  then  goto  ABORT
$
$ if Add_news   then  gosub  Do_Add_News
$ if Skim_news  then  gosub  Do_Skim_News
$ if Post_news  then  gosub  Do_Post_News
$ if Post_news  then  gosub  Do_NNTP_News
$ if Convert_Db then  gosub  Do_Convert_Db
$
$ if Resubmit   then  gosub  Resubmit_Self
$
$ EXIT
$
$!==============================================================================
$! Sub-Routines follow here:
$!------------------------------------------------------------------------------
$!  Set flags for ALL TASKS - only convert the database once a week.
$
$ALL_TASKS:
$
$ Add_News	= 1
$ Skim_News	= 1
$ Post_News	= 1
$ if (Today .eqs. Convert_Day) .and. -
     (Hour .eqs. Convert_Hour)  then  Convert_Db = 1
$
$ RETURN
$
$!------------------------------------------------------------------------------
$!  Set flags for NORMAL TASKS - usually ones that should happen more than once
$!  a day.
$
$NORMAL_TASKS:
$
$ Add_News	= 1
$ Post_News	= 1
$
$ RETURN
$
$!------------------------------------------------------------------------------
$!  Parse any parameters that exist.  Allow only valid functions as defined
$!  in this DCL procedure.  Parameters may be single or multiple; i.e.
$!   P1 = ADD_NEWS  P2 = POST_NEWS    or    P1 = "ADD_NEWS,POST_NEWS" .
$
$PARSE_PARAMS:
$ Resubmit = 0		!  Must specifically request this when special run.
$ Param = 0
$
$RESTART:
$ Cnt = 0
$ Param = Param + 1
$ if P'Param' .eqs. ""  then  RETURN
$ P'Param' = f$edit (P'Param',"COLLAPSE,UNCOMMENT,UPCASE")
$
$GET_CMD:
$ Cmd = f$element (Cnt,",",P'Param')
$ if Cmd .eqs. ","  then  goto  RESTART
$ if Cmd .eqs. "ADD_NEWS"    then  Add_News   = 1
$ if Cmd .eqs. "POST_NEWS"   then  Post_News  = 1
$ if Cmd .eqs. "SKIM_NEWS"   then  Skim_News  = 1
$ if Cmd .eqs. "CONVERT_DB"  then  Convert_Db = 1
$ if Cmd .eqs. "RESUBMIT"    then  Resubmit   = 1
$ Cnt = Cnt + 1
$ goto  GET_CMD
$
$ RETURN
$
$!------------------------------------------------------------------------------
$!  Extract MAILed items; Process these messages into a Batch file suitable
$!  for Usenet News; ADD the Batch file to NEWS.  Changes may need to be made
$!  to this sub-routine, depending on the mechanism for interchange of news
$!  items between nodes.
$
$DO_ADD_NEWS:
$
$ ws "Extracting mailed News items ..."
$ mail
set folder newmail
move/all temp
y
set folder temp
extract /all /noheaders NEWS_MANAGER:NEWMAIL.MAIL
delete /all
exit
$
$ if f$search ("NEWS_MANAGER:NEWMAIL.MAIL") .nes. ""  then  goto  PROCESS_MAIL
$ if f$search ("NEWS_MANAGER:NEWS.BATCH") .nes. ""    then  goto  ADD_BATCH
$ ws "No news items to add ... skipping ADD to News."
$ RETURN
$
$PROCESS_MAIL:
$!
$! Acivate this if N prepended news
$!
$ !ws "Processing mailed items in the beast ..."
$ !set command D_CC:[NEWSMGR.SOURCE]BEAST
$ !beast
$ news /noscreen
Add /delete NEWS_MANAGER:NEWMAIL.MAIL;*
exit
$
$! set noon
$! rename /log NEWS_MANAGER:NEWMAIL.MAIL;* NEWS_MANAGER:OLDMAIL.MAIL;
$! purge /keep=15 NEWS_MANAGER:OLDMAIL.MAIL
$! set on
$
$ADD_BATCH:
$
$ ws "Adding mailed and forwarded items to news database ..."
$ news /noscreen
Add Batch/delete NEWS_MANAGER:NEWS.BATCH;*
exit
$
$ RETURN
$
$!------------------------------------------------------------------------------
$!  Skim the NEWS database.  ==> skim /items /newsgroups /files /served
$
$DO_SKIM_NEWS:
$
$ ws "Skimming the news database ..."
$ news /noscreen
Skim
exit
$
$ RETURN
$
$!------------------------------------------------------------------------------
$!  Send any News items to DECNet nodes by the appropriate method.
$!  Search for all directories of the form NEWS_MANAGER:POST_<node>.DIR .
$!  Send all batch files in the node-specific directory to the remote node.
$!  Delete each batch file in the directory after successful transfer.
$!  Changes may need to be made to this sub-routine, depending on the
$!  mechanism for interchange of news items between nodes.
$
$DO_POST_NEWS:
$
$ ws "Checking for (and forwarding) news to other sites ..."
$
$DIR_SEARCH:
$ on error  then  goto  ABORT
$ Post_Dir = f$search ("NEWS_MANAGER:POST_*.DIR",Node_Search)
$ if Post_Dir .eqs. ""  then  RETURN
$
$ Node = f$parse (Post_Dir,,,"NAME","SYNTAX_ONLY") - "POST_"
$ News_Agent := 'Node'::NEWSMGR
$ if Node .eqs. "GHOST"  then  goto  DIR_SEARCH		!  Just a pretendy node.
$ if Node .eqs. "BMC1"  then  goto  DIR_SEARCH		!  Just a pretendy node.
$ if Node .eqs. "KULING"  then  News_Agent := IN%"""""""rnews@kuling.uu.se"""""""
$ if News_Agent .eqs. ""  then  goto  DIR_SEARCH	!  Unknown node.
$
$ Post_Files = "NEWS_MANAGER_DEV:[POST_" + Node + "]*.*;*"
$ ws "Checking for News to send to node ''Node' ..."
$
$FILE_SEARCH:
$ Batch_File = f$search (Post_Files,File_Search)
$ if Batch_File .eqs. ""  then  goto  DIR_SEARCH
$
$ on error  then  goto  FILE_SEARCH
$
$ mail/subject="Usenet News Item(s) from BMC"  'Batch_File' 'News_Agent'
$ delete 'Batch_File'
$ goto  FILE_SEARCH
$
$ RETURN
$
$!------------------------------------------------------------------------------
$!  Send any News items to DECNet nodes by the NNTP method.
$!  Search for all directories of the form NEWS_MANAGER:IHAVE_<node>.DIR .
$!  Send all batch files in the node-specific directory to the remote node.
$
$DO_NNTP_NEWS:
$
$ ws "Checking for (and forwarding) NNTP news to other sites ..."
$
$  nntpfeed:==$news_manager_dev:[sys]nntpfeed
$
$DIR_SEARCH_IHAVE:
$ on error  then  goto  ABORT
$ Post_Dir = f$search ("NEWS_MANAGER:IHAVE_*.DIR",NNTP_Node_Search)
$ if Post_Dir .eqs. ""  then  RETURN
$
$ Node = f$parse (Post_Dir,,,"NAME","SYNTAX_ONLY") - "IHAVE_"
$
$ ws "Checking for News to send to node ''Node' ..."
$ Post_Files = f$search ("NEWS_MANAGER_DEV:[IHAVE_"+Node+"]COLLECT.IDS;*",NNTP_File_search)
$ if Post_Files .eqs. ""  then  ws "No News to send"
$ if Post_Files .eqs. ""  then  goto DIR_SEARCH_IHAVE
$
$ on error  then  goto  DIR_SEARCH_IHAVE
$ ws "Send News with NNTP..."
$ nntpfeed 'Node' decnet news_manager_dev:[IHAVE_'Node']COLLECT.IDS 'Node'.log
$ goto  DIR_SEARCH_IHAVE
$
$ RETURN
$
$!------------------------------------------------------------------------------
$!  Convert the News database files to optimize their structure.
$
$DO_CONVERT_DB:
$
$ convert NEWS_ROOT:NEWSGROUPS.V50 NEWS_ROOT:NEWSGROUPS.V50
$ convert /reclaim NEWS_ROOT:NEWSGROUPS.V50
$ purge NEWS_ROOT:NEWSGROUPS.V50
$ convert NEWS_ROOT:NEWSITEMS.V50 NEWS_ROOT:NEWSITEMS.V50
$ convert /reclaim NEWS_ROOT:NEWSITEMS.V50
$ purge NEWS_ROOT:NEWSITEMS.V50
$ convert NEWS_ROOT:HISTORY.V60 NEWS_ROOT:HISTORY.V60
$ convert /reclaim NEWS_ROOT:HISTORY.V60
$ purge NEWS_ROOT:HISTORY.V60
$
$ RETURN
$
$!------------------------------------------------------------------------------
$!  Re-Submit this job at the appropriate time.  Allow a few minutes after the
$!  hour to ensure that any clock discrepencies in the cluster are irrelevant.
$
$RESUBMIT_SELF:
$
$ Hour = f$extract (12,2,f$time())		!  Use current time.
$ Cnt  = 0
$
$GET_NEXT:
$ When = f$element (Cnt,",",Run_Times)
$ if When .nes. ","  then  goto  COMPARE_HOUR
$ When = f$element (0,",",Run_Times)		!  Use first run for tomorrow.
$ goto  SCHEDULER
$
$COMPARE_HOUR:
$ Cnt = Cnt + 1
$ if When .les. Hour  then  goto  GET_NEXT	!  Zip along until ok.
$
$SCHEDULER:
$
$ if When .gts. Hour  then  When = When + ":10"
$ if When .les. Hour  then  When = "Tomorrow+" + When + ":10"
$
$ submit NEWS_MANAGER:NEWSSKIM.COM -
	/noprint -
	/queue = 'Batch_Q' -
	/cputime = infinite -
	/log = NEWS_MANAGER:NEWSSKIM.LOG -
	/name = "News_Skim" -
	/after = "''When'"
$
$ set noon
$ purge /keep=15 NEWS_MANAGER:NEWSSKIM.LOG
$ set on
$
$ RETURN
$
$!------------------------------------------------------------------------------
$!  Come here to die unnaturally.  At the moment, simply give message and exit.
$
$ABORT:
$
$ ws "######  NEWSSKIM terminated ON ABORT  ######"
$
$ EXIT
