$!++
$!  FACILITY:
$!
$!      NNTP_FEED
$!
$!  ABSTRACT:
$!
$!      This module manages the feed from the local site to adjacent sites
$!      using the NNTP protocols. (Note that this is a single-direction feed -
$!      to implement a full bi-directional feed, both sites will need to
$!      to execute this procedure)
$!
$!      The procedure assumes a directory structure as follows:
$!
$!           NEWS_MANAGER:NNTP_<protocol>.DIR
$!
$!         where <protocol> is one of "DECNET", "CMUTCP", "WINTCP" ..
$!
$!           i.e.:
$!              NEWS_MANAGER:NNTP_DECNET.DIR
$!              NEWS_MANAGER:NNTP_CMUTCP.DIR
$!              NEWS_MANAGER:NNTP_WINTCP.DIR
$!
$!      In each of these protocol directories are files which use the name
$!      scheme:
$!
$!              <node>.IDS
$!
$!      Thus the file
$!              NEWS_MANAGER_DEV:[NNTP_CMUTCP]FOO.IDS
$!      will contain a list of message ids which are to be sent to node
$!      "FOO", using the CMU TCP/IP protocol.
$!
$!      The corresponding entry in NEWS.SYS would then be of the form:
$!
$!         foo:world,inet,comp,sci,rec,news,misc,soc,talk,alt:N:\
$!         NEWS_MANAGER_DEV/[NNTP_CMUTCP]FOO.IDS
$!
$!      where the 'N' flag indicates that the ihave/sendme protocol
$!      is to be used, and the file specification indicates that
$!      the CMU TCP/IP transport is to be used for NNTP, and the
$!      destination node is "FOO"
$!
$!      The proceudre must be executed from the NEWSMGR account.
$!
$!  AUTHOR:
$!
$!      Mats Sundvall   (SYS_MS@bmc1.bmc.uu.se)
$!
$!
$!  COPYRIGHT:
$!
$!      Copyright  1988
$!
$!  MODIFICATION HISTORY:
$!
$!      V1.1     5-Oct-1988     GIH
$!                              Include setup comments, and 1 minor bug
$!                              fix. Reformat code
$!--
$   nntp_feed :== $ news_manager:nntp_feed       !  Location of nntp_feed.exe
$   ps = 3
$   ns = 4
$!
$   write sys$output "NNTP_FEED"
$   show time
$!
$ Protocols:
$!
$   on error then goto Finish
$   Proto = f$search ("NEWS_MANAGER:NNTP_*.DIR",ps)
$   Proto = f$parse (Proto,,,"NAME","SYNTAX_ONLY") - "NNTP_"
$   if Proto .eqs. "" then $ goto Finish
$!
$ Nodes:
$!
$    Ihave_File = f$search("NEWS_MANAGER_DEV:[NNTP_"+Proto+"]*.IDS;*",ns)
$    if Ihave_File .eqs. ""  then $ goto Protocols
$    Node = f$parse (Ihave_File,,,"NAME","SYNTAX_ONLY")
$!
$    on error then $ goto Nodes
$    write sys$output "NNTP_FEED: Connecting to ''Node' (using ''Proto') ..."
$    nntp_feed 'Node' 'Proto' 'Ihave_File' news_manager:nntp_feed.log 'Node'.log
$    goto Nodes
$!
$ Finish:
$!
$ write sys$output "NNTP_FEED: complete"
$ show time
$ exit
