@chapter{NEWS Distribution}

The software is distributed in the source and executable formats.

The installation of NEWS requires the definition of a number of site-specific
logical names, and also the modification of a number of template files to suit
local requirements.

@section{Distribution Files}

The following is an annotated directory listing of the NEWS V5.4 distribution
file set:

@subsection{VMS Definition Files}

The implementation of VAX C as shipped is not complete in terms of the
definition of the system services and library routines - the following
definition files are required for NEWS to access these routines.

@begin{description}

CLIMSGDEF.H@\- CLI message definition module.

LNMDEF.H@\- Logical name translation definition module.

SJCDEF.H@\- SYS$SNDJBC item list definition module.

SMGDEFEXTRA.H@\- Sundry SMG definitions missing in VMS C supplied
definition files.

SORTDEF.H@\- Definitions for the callable sort (SOR$) routines.

SYIDEF.H@\- SYS$GETSYI item definition module.

V5MAILDEF.H@\- Definition of callable MAIL item codes and description
of the VMS V5.0 Mail profile file and the MAIL.MAI file.
@end{description}

@subsection{NEWS Include Files}

These are the common include files added to the start of all NEWS source code
modules. Together they implement a consistent compile-time environment for all
modules that are used to build NEWS.

@begin{description}

NEWSDEFINE.H@\- Common constant and macro definitions.

NEWSEXTERN.H@\- Common external variable definition for source modules.

NEWSINCLUDE.H@\- Common include file set for all source modules.

NEWSSITE.H@\- NEWS compile-time constants - may be altered to suit local
requirements.

NEWSVARIABLES.H@\- NEWS global variables definition module.

@end{description}

@subsection{NEWS C Sources}

The following set are the C sources to the main NEWS program. The modules are
split on the basis of the commands that each module implements.

@begin{description}

NEWS.C@\- NEWS entry point and outer control loop.

NEWSADD.C@\- Add command routines.

NEWSCREATE.C@\- Create command routines.

NEWSDELETE.C@\- Delete command routines.

NEWSDIR.C@\- Directory command routines.

NEWSDISPLAY.C@\- Display item text on screen.

NEWSEXTRACT.C@\- Extract/Print command routines.

NEWSFORWARD.C@\- Forward/Reply/Mail command routines.

NEWSHELP.C@\- Help command routines.

NEWSMODE.C@\- Set terminal mode routines.

NEWSPOST.C@\- Post/Followup command routines.

NEWSREAD.C@\- Read command routines.

NEWSREGISTER.C@\- Register/Deregister command routines.

NEWSREMCLIENT.C@\- Utility routines to access remote NNTP Server.

NEWSSEARCH.C@\- Search command routines.

NEWSSELECT.C@\- Select command routines.

NEWSSETSHOW.C@\- Set and Show command routines.

NEWSSITE.C@\- Loading site specific logical name values, and routines for
network distribution of news to adjacent sites.

NEWSSKIM.C@\- Skim command routines.

NEWSSKIP.C@\- SKIP command routines.

NEWSUTILITY.C@\- Various utility routines for NEWS.

ADD_TRANSFORM.C@\- Translation from internet address format to
one acceptable to VMS MAIL.
@end{description}

@subsection{NEWS Command Language}

@begin{description}

NEWSCMD.CLD@\- NEWS command language definition file (NEWS uses the CLI parser
command parsing).
@end{description}
                                                   

@subsection{Compiling NEWS}

@begin{description}
NEWSBUILD.COM@\- DCL procedure to incrementally recompile sources
of NEWS.

OPTIONS_C_LINK.OPT@\Link option file for NEWS

@end{description}

@subsection{Object Files}

Object files are not shipped with NEWS - If you have a C compiler, then
executing the command procedure @b{newsbuild.com} will create the following
object libraries:

All the object modules necessary to re-link news are packaged into object
libraries - this enables a site to write a customised @b{add_transform}
module in any language, insert the object into the libraries, then re-link
NEWS.

@begin{description}

NEWS_LIBRARY.OLB@\- Object library for NEWS.EXE (compiled with /NODEBUG).

NEWS_LIBRARYD.OLB@\- Object library for NEWSDBG.EXE (DEBUG version - compiled
with /DEBUG and /NOOPT)

NEWS.OBJ@\- Object file of main control loop module.

NEWSDBG.OBJ@\- Object file of main control loop module compiled with
/DEBUG/NOOPT

@end{description}                       

@subsection{NNTP Modules}

@begin{description}
                     
NNTP_CLIENT.C@\-- Interactive access to remote NNTP server.

NNTP_DEC.C@\- DECNET driver for NNTP server.

NNTP_DECM.C@\- DECNET driver for NNTP server, with support for
multiple DECnet connections to a single server process.

NNTP_SERVER.C@\- Source for NNTP NEWS Server object.

NNTP_TCPCMU.C@\- TCP driver for NNTP server, for the CMU/Tek
implementation of TCP/IP for VMS.

NNTP_TCPWIN.C@\- TCP driver for NNTP server, for the WIN
implementation of TCP/IP for VMS.

NNTP_TTY.C@\- TTY (interactive access) driver for NNTP server.

NNTP_CLIENT.EXE@\- Interactive connection to remote NNTP server.

NNTP_DEC.EXE@\- NNTP server, implemented as a DECNET object.

NNTP_DECM.EXE@\- NNTP server, implemented as a DECNET object, using
a multi-threaded server process.

NNTP_TCPCMU.EXE@\- NNTP server, implemented as a CMU/Tek TCP/IP server
object.

NNTP_TCPWIN.EXE@\- NNTP server, implemented as a WIN TCP/IP server
object.

NNTP_TTY.EXE@\- NNTP server, implemented as an interactive module
(for testing NNTP_SERVER code).

NNTP_FEED.C@\- NNTP processor for NNTP ihave-based NEWS distribution.

NNTP_FEED.EXE@\- Executable to NNTP-based NEWS distribution.

@end{description}

@subsection{HELP Files}

@begin{description}

NEWS.HLP@\- NEWS Help source.

NEWS.HLB@\- NEWS help library file.

@end{description}

@subsection{Templates of Site-Specific Files}

All the files in this set MUST be edited before installing on the local system.
Each of these files contains detailed descriptions of how the file is to be
edited, and what aspects of NEWS are controlled by the contents of the files.

@begin{description}
                             
MAILPATHS@\- Template of the control file used to generate the internet
addresses of moderators of newsgroups.

NEWS.DISTRIBUTION@\- Template of news distribution control file -- used to
determine the network routing of newsitems between adjacent
news network neighbours.

NEWS.SYS@\- Template of the control file used to determine which newsgroups
and distribution keywords are accepted by the local NEWS site,
and which newsgroups and distribution keywords are accepted by
the local node's adjacent NEWS network neighbours.

SETUP_LOG_EXAMPLE.COM@\- Template file for NEWS logical name definitions.
             
NEWSSKIM.COM@\- Template automatic news management routine (designed for
periodic execution in a batch stream).

NEWSADD.COM@\- Component of NEWSSKIM which handles addition of network batches
and distribution to downstream sites.

NEWSDAILY.COM@\- Component of NEWSSKIM which performs expiration of items
and internal consistency checks on the news database.

NEWSPACK.COM@\- Component of NEWSSKIM which calls CONVERT to compress
the RMS indexed files.
                                                                         
NEWSEDIT_EXAMPLE.COM@\- Template file for invoking any editor from NEWS.

NEWS_ADDRESS.CNF@\- Template file for translation rules to map internet-style
addresses to a form acceptable to the local VMS MAIL system.

NEWS_POST.CC@\- Template file for the automatic generation of carbon copies
of all local postings.

NNTP_FEED.COM@\- Template for passing NEWS distributions to adjacent
nodes using the NNTP protocols.
@end{description}

@subsection{Documentation}
                        
@begin{description}

AAAREADME.TXT@\- Distribution documentation.

NEWS.LATEX@\- LaTeX source of this document.

NEWS.MSS@\- Scribe source of this document.
               
NEWS.DOC@\- Plain formatted version of NEWS.MSS/LATEX.

FILES.MSS@\- Component of NEWS.MSS - description of distribution files and
installation procedures.

FILES.TEX@\- Component of NEWS.LATEX - description of distribution files and
installation procedures

MGR.MSS@\- Component of NEWS.MSS - description of management commands.

MGR.TEX@\- Component of NEWS.LATEX - description of management commands.

USER.MSS@\- Component of NEWS.MSS - description of user commands.

USER.TEX@\- Component of NEWS.LATEX - description of user commands.
             
RFC977.DOC@\- News Network Transfer Protocol standard.

NEWS-STANDARD.DOC@\- Usenet news standard (pre-RFC1036).

NEWS-STANDARD.ANNOTATED@\- Standard, annotated with capabilities and exceptions
related to this version of VMS NEWS.

RFC1036.DOC@\- USENET News standard.

BUGS.TXT@\- Listing of known outstanding bugs.

CHANGES.TXT@\- Listing of changes to NEWS from previous versions.

@end{description}

@subsection{Executables}

@begin{description}
NEWS.EXE@\- Executable of the NEWS program.

NEWSDBG.EXE@\- Executable of the NEWS program compiled and linked
@end{description}

@subsection{Additional Files}

There are a number of other files which have been sent to me, which I am
including in the distribution with the author's permission in each case. These
files may be directly useful to you, or may provide you with some ideas on
useful local software. 

@begin{description}

NEWSCHECK.EXE@\- This program will check on nominated newsgroups and write
a message if there is unread news in the newsgroups - this may be a component
of the login procedure.

NEWSCHECK.PAS@\- NEWSCHECK source - calls newsscan

NEWSSCAN.PAS@\- Second source module for NEWSCHECK

NEWSSKIM_ALT.COM@\Alternate management routine, which may provide some
useful ideas.
@end{description}

@Chapter{Installing NEWS}

The following section describe the necessary steps to install NEWS
on a system. Note that where possible these steps should be performed
in the order as given in this text.

The first section on re-compiling the program may be skipped - NEWS
is now shipped with executables included.

@Section{Re-Compiling NEWS}

If you have the VAX C compiler than you may wish to re-compile NEWS
(Strictly speaking re-compilation is not necessary - only
re-linking with the new address transform procedure). There are
a number of steps that need to be performed to perform this compilation.

To use the supplied make procedure @b(newsbuild.com) you need to set up
a directory which is equivalent to that used in the original compilation:

@begin{enumerate}

Load all files into a directory
@i{device}:[@i{dir}.@b{news.news_src}].

Create the subdirectory @i{device}:[@i{dir}.@b{news.news_build}].

Create the subdirectory @i{device}:[@i{dir}.@b{news.news_dist}].

Set the default directory to [.@b{news_build}]

Execute the @b{newsbuild} command procedure:
@begin{verbatim}
  @@[-.news_src]newsbuild
@end{verbatim}
This procedure rebuilds all executables using minimal re-compilation.
It is the DCL equivalent of a Makefile.

@end{enumerate}

@Section{NEWS Accounts}

Add an account for a NEWS manager (@b{NEWSMGR} if you would like a username
suggestion). This account runs the housekeeping batch
jobs (such as @b{newsskim} if you are using it) and also runs the network
feeds to adjacent NEWS sites (and should have proxy
entries to other DECnet NEWS manager accounts if more than one node will be
running NEWS on the DECnet).

The account normally requires SYSPRV to execute some of the functions
associated with the 'housekeeping' batch jobs. The account may also need a
reasonable disk quota if you are anticipating a large amount of network news
flowing through your system, and you make this account own the news posting
directories.

@Section{Logical Names}

It is intended that much of the local tailoring of NEWS is performed by logical
name translations. For this reason the logical name structure is important when
installing NEWS - please read this section carefully.

@b{NOTE}: It is important that these names be defined before running news for the first
time.

The distribution set includes the following file: @b{setup_log_example.com}
@begin{verbatim}
    $! NEWS logical names as set up at the ANU - the names
    $! are documented in NEWS.DOC
    $!
    $! NOTE SOME OF THESE NAMES ARE EXEC MODE NAMES
    $!
    $! root of news tree
    $!
    $ DEFINE/SYSTEM/EXEC NEWS_ROOT ANU_PKG:[NEWS]
    $ DEFINE/SYSTEM/TRANS=(conc)/EXEC NEWS_DEVICE ANU_PKG:[NEWS.]
    $!
    $! News manager accounts must own this identifier
    $!
    $ DEFINE/SYSTEM/EXEC NEWS_MGR_ID NEWSMANAGER
    $!
    $! the node address is the internet address of the node
    $!
    $ DEFINE/SYSTEM/EXEC NEWS_ADDRESS "CSC.ANU.OZ"
    $!
    $! news_node is either the decnet node name, or the cluster alias
    $!
    $ DEFINE/SYSTEM/EXEC NEWS_NODE CSC
    $!
    $! The name of the organisation
    $!
    $ DEFINE/SYSTEM NEWS_ORGANISATION "CSC, Australian National University"
    $!
    $! The "work directory" for news - normally sys$login of the news manager
    $! account
    $!
    $ DEFINE/EXEC NEWS_MANAGER ANUDISK:[G900.NEWS]
    $ DEFINE/SYSTEM/TRANS=(conc)/EXEC NEWS_MANAGER_DEV ANUDISK:[G900.NEWS.]
@end{verbatim}

Description of names:
@begin{description}

NEWS_ROOT, NEWS_DEVICE@\Both names point to the news files root directory. Both
must be defined in @b{exec} mode. The news data files are placed in
a tree descending from this root - i.e. newsgroup `aus.wanted'
has text files residing in the area @b{news_device:[aus.wanted]}.
The Index files and Help file are placed in the @b{news_root}
directory.

NEWS_MGR_ID@\Translates to the identifier name which must be granted to any
users who require the management functions of NEWS (delete
newsgroup, create newsgroup, etc). The name must be defined in
@b{exec} mode to stop unauthorized users tinkering with NEWS.

NEWS_ADDRESS@\Translates to the internet address of the host node. This is
typically of the form @i{node.site.domain}.

NEWS_NODE@\Translates to the local node name. This is made a logical name
to allow a cluster to operate as a single logical node, using
a cluster alias.
          
NEWS_ORGANIZATION@\Translates to the name of the organisation. This is
to help in identifying the person posting the message to other users
on the net. Users may use a process level logical name to
overide this system value.

NEWS_MANAGER, NEWS_MANAGER_DEV@\This is the work directory of the
NEWSMGR account. All temporary files used in news maintenance
are placed here. NEWS_MANAGER_DEV is the equivalent area,
defined as a concealed device.

NEWS_EDIT, NEWS_VIEW@\[Optional] You may call other editors than TPU,
but they will be called as SPAWNED SUB PROCESSES. To do this, use the logical
names NEWS_EDIT and NEWS_VIEW. These logical names are used in
the same fashion as "MAIL$EDIT": the logical name points to a
DCL command procedure which is used to edit the file. The
procedure will be handed only one parameter, the name of the
file to edit (or to view in the case of NEWS_VIEW). MAIL$EDIT
is a useful place to start when writing your own NEWS_EDIT and
NEWS_VIEW procedures. Included in this distribution set is the
file @b{newsedit_example.com}.
DO NOT DEFINE NEWS_EDIT or NEWS_VIEW as /SYSTEM logical names!
@end{description}

@Section{Global DCL Symbols}

In the system login command add a symbol for NEWS:
@begin{verbatim}
    $ NEWS :== $ location:NEWS
@end{verbatim}


@Section{Install NEWS.EXE}

Copy NEWS.EXE to the location as specified by the DCL symbol for NEWS. Then
install the image with SYSPRV.

@begin{verbatim}
    $ INSTALL
    INSTALL> ADD location:NEWS.EXE/OPEN/HEAD/SHARE/PRIV=SYSPRV
@end{verbatim}
SYSPRV is required to ensure that users who post news items end up NOT owning
the actual news text file, and also is required to successfully initialise the
indexed files on the first-time execution of the program.


@section{Initial Environment}

@begin{itemize}

Using AUTHORIZE, create the NEWSMANAGER identifier (the value of the
logical name NEWS_MGR_ID), and grant the identifier to the user(s) who
will be responsible for the management of NEWS.

Create the directories that have been defined by the logical names
    NEWS_MANAGER and NEWS_ROOT. [Optionally] Add a propagation ACL to the
    NEWS_ROOT directory to allow those users whom you wish to use news to
    access the item files. Ensure that the directories are group and world
    accessible.

Using SYS$EXAMPLES:MAILUAF.COM, add an entry for the address "USENET", with
    a forwarding address to the news manager on your host.

Copy NEWS.HLB to NEWS_ROOT:

@end{itemize}

@Section{NEWS Control Files}

There are six control files -- these files should be read, and then edited to
match the local site requirements.

@begin{description}
NEWS.SYS@\Read (and then EDIT) file NEWS.SYS. This file determines which
            newsgroups you will accept, and which newsgroups your network
            neighbours will accept. The edited version of NEWS.SYS should be
            copied to NEWS_MANAGER:NEWS.SYS. You may wish to include the
            newsgroups "junk" and "control" for local acceptance to store
            reject newsitems for later viewing.

NEWS.DISTRIBUTION@\Read (and then EDIT) the file NEWS.DISTRIBUTION. This file
            determines how news is distributed through your node. If you are an
            'end-node' for NEWS, then this file should be empty. The edited
            version of NEWS.DISTRIBUTION should be copied to
            NEWS_MANAGER:NEWS.DISTRIBUTION.

MAILPATHS@\Read (and then EDIT the file MAILPATHS. This file defines the
            internet addresses of ALL moderators for moderated newsgroups. The
            edited version of MAILPATHS should be copied to
            NEWS_MANAGER:MAILPATHS.

NEWSSKIM.COM@\Read NEWSSKIM.COM modify it to suit your requirements. See
            comments in the code. Then copy the edited file to NEWS_ROOT. This
            file is responsible for the collection and distribution of news
            items to remote sites.

NEWS_ADDRESS.CNF@\Read this file, and also read the file ADD_TRANSFORM.C.
If you are using a local PMDF mail handler, then the default action
may be suitable. Otherwise you will need to edit th the .cnf file,
and copy the file to news_manager:news_address.cnf.

NEWS_POST.CC@\Read this file, and decide if it is relevant. Where
unmoderated newsgroups are fed from a mailing list, then postings
into the newsgroup may not be sent back to the central mailing list address.
You can place entries into this file to force cross mailings of local
postings back to the mailing list address. If necessary, edit this file and
copy it to news_manager:news_post.cc. If not required then do not
copy the file to the news_manager area.
@end{description}

@section{First Time Execution of NEWS}

Once ALL the above steps have been completed, login to an account which has
SYSPRV and has the NEWS_MGR_ID identifier, and run NEWS.EXE.

The first time execution will create the files: NEWS_ROOT:NEWSGROUPS.V50 and
NEWS_ROOT:NEWSITEMS.V50, and also create the file NEWS_MANAGER:NEWS.LICENSE.

Please read the NEWS LICENSE file, edit it as instructed, and return it to the
address shown in the file.

This almost completes the installation of NEWS - the remaining task is the
creation of the necessary newsgroups. Use the CREATE/LOCAL command and create
the newsgroups "control" and "junk". If you are on a news network, obtain a
copy of the most recent "checkgroups" posting, and pass the file to NEWS (using
the ADD command). This will mail a command procedure to the MAIL address
"USENET" which will setup NEWS with the current network newsgroup set. Then add
any local newsgroups to this set using the CREATE/LOCAL command.

@chapter{Upgrading from Previous NEWS Versions}

If you are running NEWS Versions 4.0, 4.1, 4.2 or 4.3 then the upgrade is a two
step process:
@begin{itemize}
Using a SYSPRV account run the program NEWS\_V43\_V44.EXE.

This will create the file NEWS_ROOT:NEWS_V4.GROUPS. Delete the file
    NEWS_ROOT:NEWS.GROUPS.

Edit the file NEWS_MANAGER:MAILPATHS to suit local requirements

Follow the V4.4 to V5.0 instructions.
@end{itemize}

If you are running NEWS V4.4 then:
@begin{itemize}
Using a SYSPRV account run the program NEWS_V44_V50.EXE.

This will create the file NEWS_ROOT:NEWSGROUPS.V50 and
    NEWS_ROOT:NEWSITEMS.V50. Delete the files NEWS_ROOT:NEWS_V4.GROUPS and
    NEWS_ROOT:NEWS.ITEMS.
@end{itemize}

If you are running NEWS V5.0 or NEWS V.51 then:
@begin{itemize}
Execute the command procedure NEWS_V51_V52.COM, then Purge
news_root:newsitems.v50.
@end{itemize}

@Chapter{Installing NNTP NEWS Servers}

There are three node types with respect ot NEWS servers:
Server nodes, where the node acts as a server for remote
clients, Client-only nodes, which use one or
more server nodes, and server/client nodes, where some
newsgroups are served from remote servers, and this node acts
as a server for remote client nodes.

If you wish to install the NNTP NEWS Servers, then follow the steps
as shown for the node types.
You can check the operation of the server by running the NEWSCLIENT program.
This implements an interactive interface to these NEWS servers.
Once these objects have been defined you can then set newsgroups as NNTP served.
See the following documentation on the SET command for details.

@Section{DECNET Server and Server/Client Nodes}

The installation steps required for these node types are:
@begin{itemize}

Copy NEWSSERVER.EXE to a location accessible to the DECNET account.

In the volatile and permanent NCP database insert the following:
@begin{verbatim}
  NCP> SET OBJECT NEWS NUMBER nnn FILE dev:[dir]NEWSSERVER.EXE
  NCP> DEFINE OBJECT NEWS NUMBER nnn FILE dev:[dir]NEWSSERVER.EXE
@end{verbatim}
    On my system I use number 129 - MAKE THE NUMBER NON-ZERO!
@end{itemize}

ENSURE THAT THE NUMBER YOU ALLOCATE TO THE NEWS OBJECT IS THE SAME ON ALL NODES
IN THE DECNET - FOR BOTH NEWSSERVER and NEWSNOSERVER NODES.

@Section{CMU TCP Server and Server/Client Nodes}

The installation steps required for these node types are:
@begin{itemize}

Copy TCPSERVER.EXE to a location accessible to the SYSTEM account.
(this example uses sys$system)

In sys$manager:internet.config insert the following line:
@begin{verbatim}
 ; Define the well-known ports we support and their servers
 ; WKS:port:procname:imagename:status:privs:priority:queuelimit
 ;
 WKS:119:NEWSRV:TCP$NEWSRV:NETWRK:NETMBX,TMPMBX,SYSPRV,PHY_IO:4:5
@end{verbatim}

In sys$manager:ip_startup.com insert the following line:
@begin{verbatim}
 $ define /system tcp$newsrv sys$system:tcpserver.exe
@end{verbatim}
@end{itemize}

@Section{Client Nodes}

The installation steps required for client nodes are:

@begin{itemize}

Copy NEWSNOSERVER.EXE to a location accessible to the DECNET account.

In the volatile and permanent NCP database insert the following:
@begin{verbatim}
  NCP> SET OBJECT NEWS NUMBER nnn FILE dev:[dir]NEWSNOSERVER.EXE
  NCP> DEFINE OBJECT NEWS NUMBER nnn FILE dev:[dir]NEWSNOSERVER.EXE
@end{verbatim}
@end{itemize}

ENSURE THAT THE NUMBER YOU ALLOCATE TO THE NEWS OBJECT IS THE SAME ON ALL NODES
IN THE DECNET - FOR BOTH NEWSSERVER and NEWSNOSERVER NODES.

@chapter{NEWS Feed to a Unix Site}

This section describes some hints as to how to feed new postings from a VMS
NEWS site to an adjacent Unix system.

There are two basic approaches: Using NNTP and TCP/IP on VMS, or using
a VMS/Unix mailer.

The NNTP approach uses the ihave/sendme protocol described in the NNTP
standard.

The first file to modify is the VMS NEWS.SYS:
@begin{verbatim}
    unixnode:world,inet,arp,anu,canb,comp,sci,rec,news,\
    misc,soc,talk,aus,alt:N:\
    NEWS_MANAGER_DEV/[IHAVE_UNIXNODE]COLLECT.IDS
@end{verbatim}

In the skim command procedure the following commands need to be inserted:
@begin{verbatim}
    $ NNTPFEED :== $ dev:[dir]NNTPFEED
    $ SET DEF NEWS_MANAGER_DEV:[IHAVE_UNIXNODE]
    $! Either (Using a DECnet NNTP link)
    $! NNTPFEED unixnode decnet COLLECT.IDS
    $! - or- (using a TCP NNTP link)
    $ NNTPFEED unixnode tcp COLLECT.IDS
@end{verbatim}

If the Unix system is a 'downstream' site you will also have to modify
NEWS.DISTRIBUTION to forward on news batches.


The second approach is based on the existance on a mail link between the two
systems. The first approach is a mail feed:

The NEWS.SYS entry contains the line:
@begin{verbatim}
    unixnode:world,inet,arp,anu,canb,comp,sci,rec,news,\
    misc,soc,talk,aus,alt:B:\
    NEWS_MANAGER_DEV/[POST_UNIXNODE]COLLECT.IDS^BN
@end{verbatim}

In the skim command procedure the following commands need to be changed:
@begin{verbatim}
    $!	Copy news items to other sites
    $distribute:
    $ write sys$output "Copy items to other sites"
    $ set on
    $ search_1:
    $ nodedir = f$search("news_manager:post_*.dir",2)
    $ if nodedir .eqs. "" then goto abort
    $ node = f$parse(nodedir,,,"NAME","SYNTAX_ONLY") - "POST_"
    $ senddir = "news_manager_dev:[post_" + node + "];"
    $ savedfiles = senddir - ";" + "*.*;*"
    $ node = node + "::;"
    $search_2:
    $ file = f$search(savedfiles,3)
    $ if file .eqs. "" then goto search_1
    $ on error then goto no_copy_2
    $ if node .eqs. "UNIXNODE::;" -
     then $ mail 'file' in%"""rnews@@unixnode"""
    $ if node .nes. "UNIXNODE::;" -
     then $ copy/log 'file 'node
    $ delete 'file
    $ no_copy_2:
    $ goto search_2
@end{verbatim}

On the Unix system an entry needs to be inserted in the aliases file:
@begin{verbatim}
    rnews: "|/usr/lib/news/uurec"
@end{verbatim}

Variants of these approaches are possible, such a mailing the 'ihave' list of
message-ids to the unix site, and
relying on the Unix site to respond with 'sendme' control messages.
