@Chapter(NEWS Commands - Manager's Reference)

This chapter describes the set of NEWS commands which may only be executed
by those users who hold the NEWS MANAGER identifier. These commands
are commonly used within batch command procedures, but
may also be executed interactively.

@newpage
@Section{ADD FILE}

Format:
@begin{verbatim}
    ADD FILE filename
@end{verbatim}

ADD FILE is used to load articles into the NEWS database. This command is normally
used to load network news batches onto the local node (locally generated news
is POSTed into NEWS by the user who is executing the POST command). 

If the node is defined as a NEWS network routing node, this command also
generates the batch files to send to the adjacent NEWS nodes. 

ADD FILE scans an input file and breaks the file into one or more articles. Each
article is composed of a number of header lines (or a number of header line
groups) and an article body. The header lines may be generated by a number of
different sources, and a number of these formats may appear at the head of the
article. If VMS Mail is used as the local delivery mechanism, then the the
article will contain the three line Mail-11 headers. If the item was
cross-mailed from an SMTP mailer then the RFC822 header lines may also be
included in the article. If the article was generated by a remote news system
then there will also be a set of NEWS headers included as well. 

The ADD FILE command reads groups of header lines until the first non-valid
header line. The resultant set of headers is filtered, and any non-NEWS
headers (as defined in the relevant standard) are discarded before
the news item header line set is generated. Also local values are inserted
for any required NEWS header lines which were omitted in the item.

[This implies that VMS Mail folders can be readily read into NEWS - for example:
@begin{verbatim}
    MAIL> set folder tcpip
    MAIL> extract/all tcpip.news
    MAIL> exit
    $ NEWS add file tcpip.news/defnews=local.mail_list.tcpip
@end{verbatim}
]            

Each input file may contain one, or a number of news items. The item
delimiter is parsed as either of the following character sequences:
@begin{verbatim}
    "<newline>#! rnews <size>"   - RFC1036
@end{verbatim}
- or -
@begin{verbatim}
    "<formfeed><newline>From: "  - VMS Mail
@end{verbatim}
                    
The item parsing will also automatically recognise the start of an item written
using the leading 'N' format and automatically strip each line before  passing
it to the parser (This format, which inserts a 'N' character in column 1 of the
NEWS item is used by other NEWS implementations when passing extracted NEWS
batchesd into the Mailer for posting.) 

The ADD FILE command takes a single parameter, the name of an input file to parse.
The filename specified may be either a single filename, or may contain
wildcards (which are expanded, and all files so specified are added).

Lists of filenames are not supported in this version of NEWS, however wildcard
characters ('*' and '%') are supported (in the standard VMS fashion).

@subsection{ADD FILE/CREGRP}

The default action of the ADD command is to only accept items into newsgroups
which already exist on the system, rejecting all other newsgroups. This
qualifier directs NEWS to automatically create any new newsgroups which are
specified in the item headers which do not already exist on the local system.
Default is /NOCREGRP.

The reason for the default action of /NOCREGRP is that "checknews" control
messages normally flow through the net, controlling which newsgroups are valid
for a participating NEWS site. These control messages will auto-configure your
node if you are receiving a network news feed.

@subsection{ADD FILE/DELETE}
       
This qualifier directs NEWS to delete the input file after the contents have
been added to NEWS. Default is /NODELETE.

@subsection{ADD FILE/EXECUTE}
             
The standard for USENET news messages defines a number of 'control' messages,
designed to assist all sites in running a common set of newsgroups across
the USENET. Various control messages are designed to delete all occurrences
of a particular newsgroup on all systems, create new newsgroups, or compare
the 'standard' list of newsgroups against the local set of newsgroups.

The default action of NEWS is to not to create or delete newsgroups - if a
control message indicates that a newsgroup should be created or deleted, a DCL
command file to perform the action is sent to address 'USENET'. (This action is
acceptable within the relevant standard). This corresponds to the default
"/NOEXECUTE".

If /EXECUTE is specified, then newsgroup creation messages are executed
immediately, without the requirement for approval by the local news
manager. In the case of newsgroup deletion ("rmgroup" or a "checkgroups"
message) the default action of /EXECUTE is to set the newsgroups which
are to be removed to a 1 week retention period. This default action may
be modified by specifying either "/EXECUTE=LOCAL", in which case any such
newsgroups are set to "/LOCAL" status, or "/EXECUTE=DELETE", in which case
such newsgroups are deleted. In all cases a log of the actions performed 
will be posted to address "USENET".
                                                     
@subsection{ADD FILE/DEFNEWSGROUP=newsgroup}

By default, if a newsitem does not contain a "Newsgroups: " header
line, then "junk" is used as the default value for this
header. 

It is necessary to be able to change this default action to add a
set of related items which no not contain valid NEWS header lines.

A common example example, described in the notes above, is that of VMS Mail
folder items being read into a Newsgroup.

@subsection{ADD FILE/NETFEED}
                    
/NETFEED [default]. The ADD command is commonly used to process a network feed of NEWS - this
implies that the ADD FILE command should also generate the necessary batch files for
subsequent transmission to any downstream sites. /NETFEED 
instructs the ADD FILE command to use the information in the NEWS.SYS and
NEWS.DISTRIBUTION files to generate the batch feed files as required.
                               
/NONETFEED bypasses the generation of a network feed in the ADD command.

@subsection{ADD FILE/JUNK}

/JUNK [default] instructs the ADD FILE command to place any part of the
input file which cannot be correctly parsed, or any news item
which is filtered by the NEWS.SYS file, or where there are no
local newsgroups to hold the item, into the local newsgroup "junk".
This newsgroup is intended as a short-term storage area where
the items can be scanned, and the database altered if neceaasry
to accept such items.

/NOJUNK instructs the ADD FILE command to reject all items which
cannot be added to the local NEWS database.

@subsection{ADD FILE/ACCEPT}

/NOACCEPT [default]. By default all items posted to moderated Newsgroups
required an "Approved: " header line before local NEWS systems can
accept the item. Without this header line the item is either
junked or rejected.

/ACCEPT instructs the ADD FILE command to accept (on the local system only)
unapproved postings to moderated newsgroups.

@subsection{ADD FILE/RETRY}

When a network feed news item is rejected by the local node an attempt is made
to place the item into the "junk" newsgroup. This rejection may take place for
a number of reasons, but the primary one is that the NEWS.SYS file has rejected
this item.                                    

You may wish to make changes to the SYS file and retry adding the item.
Normally such an attempt would be rejected, as the Path: name now contains the
local node name, and this is regarded as a loop in the news. /RETRY directs the
ADD command to ignore the Path: line when checking the news item for addition
into the local node.

@subsection{ADD FILE/MODERATOR}

This qualifier allows a newsgroup moderator to insert items into the
moderated newsgroup. This differs from the POST command in so far as 
the original submitter's address is preserved. This is documented in more
detail in the chapter on moderated newsgroups.

@newpage
@section{CANCEL}

This command deletes the current newsitem (the directory must be at the
newsitem level for this command).

If the user is the news manager then the command inspects the address of the
sender of the newsitem, and will only perform the deletion if the sender's node
address matches that of the user (i.e the news manager may cancel any item that
was originally posted on the local node).

As well as deleting the local copy of the newsitem, a 'cancel' control news
message is sent through the news network to ensure that all copies of the item,
held on all connected NEWS nodes, are deleted.
@newpage
@section{CREATE NEWSGROUP}

Format:
@begin{verbatim}
    CREATE NEWSGROUP newsgroup
@end{verbatim}

Create  is used to create new newsgroups on the local node.

The Newsgroup parameter is the name of the newsgroup to create. If the
newsgroup does not exist on the local node, then the user is prompted to
confirm that the newsgroup should be created.

This parameter can also specify a comma separated list of newsgroup names to
create.
In the case of a list of names the qualifiers
used (if any) refer to ALL newsgroups in the list (positional
qualifiers are NOT supported in this release).

The qualifiers accepted by CREATE are the same as those accepted by the SET
NEWSGROUP command. The qualifiers which refer to remote server newsgroups are
documented with SET NEWSGROUP, but may be used with the CREATE command in the
same fashion. 

@subsection{CREATE NEWSGROUP/HOLD=n}

This qualifier specifies the retention period (in days) of the Newsgroup. This
retention period is defined as the period over which no new items were posted
to the newsgroup, after which the newsgroup is automatically deleted. If not
specified, the system default value is used.

If the value /HOLD=* is used, the newsgroup will NOT be automatically deleted.

The default value of the /HOLD qualifier is normally 60 days.

@subsection{CREATE NEWSGROUP/ITEMHOLD=n}

This qualifier specifies the default retention period (in days) of the items
within this newsgroup. All news items will remain on the system for the
specified period, after which they will be automatically deleted.

If the value /ITEMHOLD=* is used, NO items within the newsgroup will be
automatically deleted.

The default value of the /HOLD qualifier is normally 30 days.

@subsection{CREATE NEWSGROUP/MODERATOR=address}

This qualifier creates a moderated newsgroup. No user may post news items
directly into a moderated newsgroup (unless the user is the actual moderator of
the newsgroup). Any items posted into such newsgroups are redirected into the
mail systems, and are mailed directly to the moderator.

The moderator address should be specified in the internet format
(user@@node.site.domain) - NOT Decnet format (the translation from internet
addresses to the equivalent Decnet addresses is handled internally by NEWS).

@subsection{CREATE NEWSGROUP/LOCAL}

Newsgroups are defined by default to be Network newsgroups - A network
newsgroup is created in response to a network-wide "newgroup" control message,
and is deleted in response to a network-wide "rmgroup" or "checkgroups"
message.

Newsgroups which are local to a this site, or local to a domain within the
wider network are created with the /LOCAL qualifier. This ensures that the
newsgroup will not be deleted by the network control messages.

@subsection{CREATE NEWSGROUP/INQUIRE}

This command is used by client systems to import all, or a subset, of the
newsgroups held on a news server node. The command requires the /SERVE
and /PROTOCOL qualifiers as well (and if they are not specified, then the
user will be prompted to supply the values.

The action of the command is to request the full list of newsgroups on the
target server node. All newsgroups which do not already exist on the local
node are then created, subject to confirmation by the user for each new
newsgroup. The attributes of the created newsgroups are ser to the server
and protocol values as given in the command.

The newsgroup list specified inthe command is the pattern to match when
looking for new newsgroups. The examples illustrate this:

To import all newsgroups defined on the node "unixnode", using the TCP
transport, the command would be:
@begin{Verbatim}
    CREATE NEWSGROUP */SERVE=unixnode/PROTO=TCP/INQUIRE
@end{verbatim}

To import all newsgroups within the tree "anu.*" from the node "vmsnode",
using DECnet:
@begin{verbatim}
    CREATE NEWSGROUP anu.*/SERVE=vmsnode/PROTO=DECNET/INQUIRE
@end{verbatim}

/INQUIRE also supports an additional qualifier, "/SINCE=date", which
restricts the search on the remote system to those newsgroups
created since the specified date.

@newpage
@section{DELETE}

Format:
@begin{verbatim}                                                           
    DELETE NEWSITEMS [note-range]

    DELETE NEWSGROUPS [newsgroup-list]
@end{verbatim}

Delete is used to delete newsgroups or news items. The command accepts a list
of newsgroups to delete, or a list of newsitems.

If no parameters are given to this command, then the actions of Delete are
determined by the current screen context. If the screen is currently displaying
the newsgroup directory, then the delete command is used to delete the current
newsgroup. If the item directory is displayed, then the command refers to the
current news item. 

@subsection{DELETE NEWSITEMS}

This command deletes newsitems from the current newsgroup from the local NEWS
database. The command may be used by the local NEWS manager, or by the local
moderator of a newsgroup.

DELETE ITEMS and DELETE NOTE may also be used to delete newsitems.

By default the current newsitem is deleted, or a list of note numbers may be
specified as a command parameter. The format of this list is a list of numbers,
ranges (start-end), and the keywords "first", "last", "all", "." (current
item), "*" (all items). 

For example, to delete items 3 through to 10, 20 and 22 to 25 the command is:
DELETE 3-10,20,22-25.  To delete all items in a newsgroup the command is:
DELETE *. 

The "/COMFIRM" qualifier is used to prompt for confirmation for each newsitem
to delete. This value is on by default, and is removed by the "/NOCONFIRM"
qualifier.                                                  

The /IDENTIFIER qualifier is used to select a news item with a specified
message identifier string. The format is "/IDENTIFIER=message-id". Note that
the identifier value includes the '<' and '>' characters. If /IDENTIFIER is
used, this excludes the use of a set of news item numbers in the command. 

@subsection{DELETE NEWSGROUPS}

This command deletes newsgroups from the local NEWS database. The command may
be used by the local NEWS manager. Any newsitems held within the specified
newsgroups are also deleted. 
                        
DELETE GROUPS may also be used to delete newsgroups.

If no newsgroup names are specified, then the current newsgroup is deleted.
Otherwise the newsgroups are specified as a list of names, separated by commas.
The '*' wildcard character may also be used to specify a set of newsgroups. 

The "/COMFIRM" qualifier is used to prompt for confirmation for each newsgroup
to delete. This value is on by default, and is removed by the "/NOCONFIRM"
qualifier.                                                  
@newpage
@section{SET}

SET  modifies  the control attributes of a newsgroup or a newsitem. control
attributes include the lifetime of items on the local system, newsgroup
moderator addresses, and whether the newsgroup is served from a remote NNTP
server.

Newsgroups are automatically deleted from the NEWS system if the last new item
in the newsgroup was posted to the group more than n days previously. There are
three levels of default for this value: A global compile-time constant (defined
in the file NEWSSITE.H, normally 60 days), which may be overridden by a dynamic
global value (SET NEWSGROUP */HOLD=n days), which may be overridden for
individual newsgroups by a dynamic newsgroup specific value (SET NEWSGROUP
name/HOLD=n days). The value is specified in units of days, but there is an
additional value, '*' which specifies that the newsgroup is not to be
automatically deleted.

Newsitems records are automatically deleted once they have remained on the
system for a set number of days. This retention period has fours levels of
default: A global compile-time constant (defined in the file NEWSSITE.H,
normally 30 days), which may be overridden by a dynamic global value (SET
NEWSGROUP */ITEMHOLD=n days), which may be overridden for specific newsgroups
by a dynamic newsgroup default value (SET NEWSGROUP name/ITEMHOLD=n days),
which may be overridden for individual news items (SET ITEM number/HOLD=n
days). The value is specified in units of days, but there is an additional
value, '*' which specifies that the newsgroup is not to be automatically
deleted.

There are two SET commands:
@begin{verbatim}
     SET NEWSGROUP newsgroup-name/qualifiers

     SET ITEM item-num/HOLD=n
@end{verbatim}

 
@subsection{SET NEWSGROUP}

Format:
@begin{verbatim}
     SET NEWSGROUP/qualifiers

     SET NEWSGROUP newsgroup-name/qualifiers

     SET NEWSGROUP */quals
@end{verbatim}

If no newsgroup name is given with the command the command assumes the
name of the 'current' newsgroup.
If the newsgroup is specified as '*' then the attributes referred to by
this command are the system defaults.

The qualifiers accepted for the global default ('*') are /ITEMHOLD, /HOLD,
/KEEPREQUEST and /FILEHOLD and in the case where a particular newsgroup is
named, /MODERATOR and /SERVER.

@paragraph{SET NEWSGROUP/HOLD=n}

This command qualifier defines the retention period for newsgroups. The value
of the qualifier is specified in days.
                        
If a 0 value is given, this indicates  that  a  higher  level  default  value
should  be  used.

If a value of '*' is given, this indicates that the retention is PERMANENT --
the newsgroup will never be automatically deleted by the SKIM command.

@paragraph{SET NEWSGROUP/ITEMHOLD=n}

This command qualifier defines the default retention period  for  news items
within a newsgroup. The value of the qualifier is specified in days.

If a 0 value is given, this indicates that a higher level default value should
be used.

If a value of '*' is given as the value for days, this indicates that the
default newsitem retention is PERMANENT.

@paragraph{SET NEWSGROUP/MODERATOR=address}

Format:
@begin{verbatim}
    SET NEWSGROUP/MODERATOR=address

    SET NEWSGROUP/NOMODERATOR
@end{verbatim}

This command sets the newsgroup as a moderated newsgroup, or clears the
moderator condition.

Only the moderator of a moderated newsgroup may post items into that newsgroup
-- all other users who attempt to post to a moderated newsgroup will have the
news posting intercepted and re-directed as e-mail to the moderator address.

The value of the /MODERATOR is an internet-style address of the moderator.

The /NOMODERATOR is used to clear the moderator condition.

@paragraph{SET NEWSGROUP/LOCAL}

Format:
@begin{verbatim}
    SET NEWSGROUP name/LOCAL

    SET NEWSGROUP name/NOLOCAL
@end{verbatim}

Newsgroups are defined by default to be Network newsgroups - A network
newsgroup is created in response to a network-wide "newgroup" control message,
and is deleted in response to a network-wide "rmgroup" or "checkgroups"
message.

Newsgroups which are local to a this site, or local to a domain within the
wider network are created with the /LOCAL qualifier. This ensures that the
newsgroup will not be deleted by such network control messages.

@paragraph{SET NEWSGROUP/SERVER=node}

Format:
@begin{verbatim}
    SET NEWSGROUP name/SERVER=node

    SET NEWSGROUP name/NOSERVER
@end{verbatim}

Newsgroups may be linked to a remote NEWSSERVER via DECNET. The presence of a
remote server for a newsgroup implies that the local site need not keep the
text files of all items within a newsgroup on local storage -- when a user on
the local system reads an item, the remote server passes a copy of the text on
demand.

This configuration can be used to reduce the overall storage demands for NEWS
if a number of decnet-connected systems are all running NEWS. One system may be
nominated as the server for a number of client nodes, or a number of systems
can be used to serve subsets of the total newsgroup set to the clients (i.e. a
node may be configured as a client for some newsgroups, and a server for other
newsgroups).

This qualifier requires a node name as a value -- this name is the decnet node
name of the remote server.

@paragraph{SET NEWSGROUP/KEEPREQUEST}

The /KEEPREQUEST qualifier
is used in conjunction with the /SERVER qualifier. /KEEPREQUEST
is the default value.

If a newsitem is served from a remote system, and a local user requests to view
the contents of that item, the server system copies the text of the item into
the local user's scratch area. By default, a copy of this text is also placed
in the local NEWS database, so that further requests to read the item do not
need to access the remote server.

This retention of the local copy can be inhibited by using the /NOKEEPREQUEST
with the SET command -- in such a case all requests to view the item will
generate remote server requests.

@paragraph{SET NEWSGROUP/FILEHOLD=n}

The /FILEHOLD qualifier
is used in conjunction with the /SERVER qualifier. /FILEHOLD=2
is the default value.

If a newsgroup is served from a remote system, then it is not necessary to keep
local copies of the text of news items for the retention period of the news
item record.

By default, the local text is deleted after 2 days, and any subsequent requests
to view the text of the item will result in a remote server request for the
item text (if /KEEPREQUEST is also enabled then the copy is again retained on
the local system for a further 2 days, and so on).
This text retention period can be set to n days using the /FILEHOLD qualifier.

@paragraph{SET NEWSGROUP/PROTOCOL=p}

The /PROTOCOL qualifier
is used in conjunction with the /SERVER qualifier. Valid values for this
qualifier are "DECNET" or "TCP". The default value is "DECNET".

If a newsgroup is served from a remote system, then either DECNET or TCP
may be used to access the remote system. This qualifier sets the protocol
to use when performing the remote access.

@subsection{SET ITEM item-num}

SET ITEM modifies the newsgroup retention attributes of news items.
                 
The command format is:
@begin{verbatim}
     SET ITEM name/HOLD=val
@end{verbatim}
This requires the number of a newitem (or defaults to the current newsitem in
screen mode).

Only one qualifier is associated with this command, /HOLD.

@paragraph{SET ITEM/HOLD=n}

This command qualifier defines the retention period for news items The value of
the qualifier is specified in days.

If a 0 value is given, this indicates  that  a  higher  level  (newsgroup
based) default  value should  be  used.

If a value of '*' is given, this indicates that the retention is PERMANENT --
the item will never be deleted by the SKIM command.
@newpage
@Section{SHOW}

SHOW displays the control information for newsgroups or for news items in the
News database.

This information includes the retention period, relevant deletion time, and the
moderator address (if moderated).

Format:
@begin{verbatim}
    SHOW NEWSGROUP newsgroup-name

    SHOW NEWSGROUP *

    SHOW ITEM item-num

    SHOW MARK

    SHOW MARK tag

    SHOW KILL
@end{verbatim}
This information is also displayed by default in the header lines of the
newsitem directory screen for each newsgroup.

@Subsection{SHOW NEWSGROUP newsgroup-name}

SHOW NEWSGROUP displays the newsgroup retention attributes of the newsgroup,
the moderator address (if moderated), and the remote server name (if remote
served).

The newsgroup-name may be either a newsgroup name -- to display the specific
information for that newsgroup, or '*' -- to display the system default values,
or not specified -- in which case the current newsgroup attributes are
displayed.

@Subsection{SHOW ITEM item-num}

SHOW ITEM displays the retention period for a specific news item.

If no item number is given, the current newsitem attributes are displayed.

@Subsection{SHOW MARK tag}

Format:
@begin{verbatim}
    SHOW MARK

    SHOW MARK tag
@end{verbatim}

SHOW MARK displays a listing of the set of marked newsitems. If no tag value is
specified, then all mark tag values are displayed. If a tag is used then only
those tag values which match using wildcard matching are displayed.


@subsection{SHOW KILL}
 
Documented in in the User Reference chapter of this document.
                   
@newpage
@Section{SKIM}

SKIM checks aspects of the news database for internal  consistency,  and also
enforces news item and newsgroup expiry time limits.

By  default  the  command will assume the qualifiers /ITEMS (check all news
items), /NEWSGROUPS (check all newsgroups), /SERVED (check all remote servers
for consistency with the local database) and /FILES (check all item text
files). Any inconsistencies found in the local NEWS database are resolved by
this command.

Any of these four phases can be bypassed by using the /NOphase qualifier with
the SKIM command.

Skim optionally accepts one parameter, a list of newsgroups to examine.
If no parameter is given, then all newsgroups are checked. The parameter
is a comma separated list of newsgroup names. Wildcard characters ('*', '?')
may be used to specify a set of newsgroups. e.g. "SKIM aus.*,anu.*"

@subsection{SKIM/ITEMS}

By default the action of the SKIM command includes SKIM/ITEMS. In this phase of
SKIM, the procedure checks all current newsitems held in the local database. If
the item has been held for longer than the locally set retention period, then
the item is deleted, or if the text file cannot be opened the item is deleted.

The items to be deleted can optionally be archived using the /ARCHIVE
qualifier.

This action can be bypassed using the /NOITEMS qualifier with the SKIM command.

@subsection{SKIM/NEWSGROUPS}

By default, the action of the SKIM command includes SKIM/NEWSGROUPS. In this
phase of SKIM, skim checks each newsgroup, updating the newsitem count for the
newsgroup, and deletes any newsgroup which has had no new items posted in the
retention period (see SET NEWSGROUP/HOLD=n for more information on newsgroup
retention).

This action can be bypassed using the /NONEWSGROUPS qualifier on the SKIM
command.

@subsection{SKIM/SERVED}

By default, the action of the SKIM command includes SKIM/SERVED. In this phase
of skim, SKIM collects the item identifiers of all newsitems whose text is held
on the remote NEWSSERVER node. SKIM then connects to the remote server and
collects all item update information from the remote item database. Following
this remote interrogation, the local item database is updated to match that of
the remote node.

This action can be bypassed using the /NOSERVED qualifier on the SKIM command.

@subsection{SKIM/FILES}

By default the action of the SKIM command includes SKIM/FILES. In this phase of
the skim, SKIM examines every .ITM file (newsitem text file) in the news
database, purging  all back  versions  of any file, and deleting any .ITM files
which have no corresponding entry in the item database.

This action can be bypassed using the /NOFILES qualifier on the SKIM command.

@subsection{SKIM/ARCHIVE=filename}

By default this qualifier is not used.

This qualifier can be used in conjunction with the /ITEMS qualifier to archive
a copy of every item that is to be deleted from the News database. The items
are stored using batch format (items are delimited by a line of the form
"#!rnews <size>. The items are appended to the archive file until the archive
file reaches 250k bytes in size, when a new version of the archive file is
opened.
