@chapter {Introduction}

NEWS is a computer-based conferencing system. As such, it has many similarities
to a normal electronic mail system (e-mail), as well as some major differences:
@begin{itemize}
@begin{multiple}
E-mail is typically a person-to-person communication. In such a system
a third party cannot view the mail contents, and the mail is essentially a
transaction between the sender and recipient.

This e-mail model can be extended with the use of mailing lists. In this
situation each user posts a mail item to a list of others, each of whom receive
a copy of the mail. In this model the mail transaction is extended to include a
group of users, but privacy is still intact to the extent that users who are
not on the mail distribution list cannot participate in the mail conversation.
The mailing list can be maintained on a central site, or each user may keep a
copy of the list - the resultant functionality from the user point of view is
essentially unchanged.
@end{multiple}

Bulletin boards take the mailing list model one step further by allowing all
users to have the ability to view all postings, and all postings made by users
are public to all other users of the bulletin board (this is a simplification
of many bulletin boards, which commonly provide functionality which encompasses
all these models of communication, and more). As with mailing lists, the
bulletin board data can be held on a single central system (acting as
a server for client systems), or each system in a
network may hold a copy of the postings. In both cases the functionality is
similar from the user viewpoint.
@end{itemize}

VMS NEWS is an implementation of such a bulletin board. VMS NEWS allows the
user to view all postings made by other users of NEWS, and also allows the user
to contribute to the conference by posting an item into NEWS. News items are
classified by into newsgroups (postings with similar subject matter) and all
postings referring to the same conference are logically grouped together for
presentation within a newsgroup (this is analogous to VMS Mail's use of
folders).

Unlike person-to-person mail, all  items posted into NEWS are readable by ALL
users on the system, so the items in news are intended for general view.
Typically, the local VMS system is linked to a wider network of systems, and
the local node will receive NEWS postings from other nodes on the network, and
local postings will also be sent through the wider network.

NEWS implements the Standard for Interchange of USENET Messages (RFC1036), and
as such has many similarities with the Unix(tm)-based rnews software set.
However NEWS is not a port of this rnews software to VMS and the program
has been designed with the aim of
implementating the functionality of rnews using data and file structures
that can be executed efficiently on a VMS system.

The implementation of this standard under VMS implies that a VMS site can be
configured into the USENET news network, and will accept USENET news batches
from neighbouring USENET sites, and generate batches for transmission to
downstream sites.

NEWS also implements the Network News Transfer Protocol (NNTP), as documented
in RFC977. This implementation uses DECNET as the transport layer, and is
implemented as a DECNET object. The NEWS program can be configured to
automatically access a NNTP server over DECNET, implementing a distributed news
database.  This version also supports the CMU TCP/IP package for VMS, and
allows NNTP client and server implementations on VMS accessing remote
VMS or Unix systems over TCP.

@section {Sources of Further Information}

@begin{itemize}
The HELP command is available within NEWS for help on all NEWS commands.

The information contained in the newsgroups within NEWS are particularly
useful: in particular the items in newsgroup "news.announce.newusers" should be
read, as there are postings in this newsgroups which will detail much
of the structure of the USENET news network. Users should read these
items, particularly those referring to the rules for posting into the
USENET and the network etiquette of posting.
@end{itemize}

@chapter{The User Interface to NEWS}

@Section{Invoking NEWS}

To invoke an interactive session of NEWS, use the command:
@begin{verbatim}
    $ NEWS
@end{verbatim}

NEWS can operate in either line or screen mode. Line mode is intended for use
on printing terminals or within batch command procedures and the user
interface is more restrictive than screen mode. The command "$ NEWS" invokes
screen mode, and the command "$ NEWS/NOSCREEN" starts NEWS in line mode. (You can
switch between line and screen modes within NEWS using the SCREEN and NOSCREEN
commands described below).

NEWS uses the VMS SMG routines as the screen display manager. If your
terminal type is not defined to SMG then NEWS will automatically enter
line mode, and the 'SCREEN' command is disabled.

When starting NEWS your context will be restored to the state when you
last EXITed from NEWS. NEWS will re-establish the previous 'current'
newsgroup and newsitem if possible.

@section{NEWS Context}

When in NEWS you maintain an implicit 'context' within the NEWS
database. This context is made up of three components:
@begin{itemize}
The 'current' newsgroup is the newsgroup indicated by the
cursor (when at the newsgroup directory level). This is the newsgroup
which is 'opened' if you are at the newsitem directory or text
display levels.

The 'current' newsitem  - which is relevant only if the screen display is
either the newsitem directory (in which case the 'current' newsitem is
indicated by the cursor) or newsitem text display.

The screen level - either a newsgroup directory, a directory
of items within a newsgroup, or the text of a newsitem.
@end{itemize}

@section{The Structure of NEWS}
                                                       
NEWS items are stored within NEWSGROUPS (this is analogous to VMS MAIL, where
mail items are stored within FOLDERS). All news items with a similar subject
matter are normally contained in a single newsgroup.

Each news item within a newsgroup has a title and a sequence number.  A
directory of items within a newsgroup displays these titles and sequence
numbers - the sequence number is used to select a particular item from within a
newsgroup. News items contain other control information - these additional
fields will be covered in the section on Posting news items.

@section{NEWS Screen Formats}

There are three different screen display formats used in NEWS. They correspond
to the context level of the user when running NEWS (Newsgroup directory,
Newsitem directory and Newsitem text).

The top three lines on each display describe the current context level, and any
other necessary information for that screen type.

At the base of all three screen formats is a three line window. The first line
shows a command prompt -- commands are entered on this line. The second line is
used to enter any additional parameters required for the command. The third
line is used to display any status or error messages (in reverse video).

@Subsection{NEWSGROUP Directory Screen}

This screen display corresponds to the outer context level of NEWS. The screen
displays the names of the newsgroups held on the system,
the number of news items held in each newsgroup and the number of
items that you have not read.

The top line displays the selection criteria of newsgroups: this may be all
newsgroups, newsgroups in which you are registered, newsgroups with new items
posted into them since a certain date, and so on. The line also displays the
number of newsgroups which have been selected under these selection criteria.

The major section of the screen displays the newsgroup names, their sequence
number, and additional control information.

The following figure explains the various fields shown on the directory screen:
@begin{verbatim,group}

  Number     Newsgroup                           Count Unread

 -->  45  _  comp.os.vms                            23     12

  |   |   |  |                                       |      |
  |   |   |  The name of the group    The total number      |
  |   |   |                           of newsitems  in      |
  |   |   If this character is a '_'  the newsgroup         |
  |   |   then  some  items  in  the                        |
  |   |   newsgroup  are stored on a            The number of
  |   |   remote news server node               newsitems you
  |   |                                         have not seen
  |   The sequence number of the newsgroup
  |
  The 'current' newsgroup pointer
@end{verbatim}

From left to right, the fields are: the cursor arrow, used to select the
current newsgroup (this arrow is moved using the up and down arrows on the
keypad), the newsgroup sequence number, a '_' character (only displayed if this
newsgroup is linked to a remote news server), the newsgroup name, the count of
items in the newsgroup, and the number of unread items in the newsgroup.

Newsgroup names in which you have registered an interest are shown in bolded
video on the screen.

In the leftmost field a cursor is displayed (-->). Pressing the up or down
arrow keys moves the cursor through the newsgroup display. The cursor indicates
the current or selected newsgroup.

@subsection{NEWSITEM Directory Screen}

The second context level is entered from the NEWSGROUP screen by pressing the
select key (or using the 'SELECT' command).
This screen corresponds to the second context level, when a newsgroup is
'opened' to display the news items currently stored within the newsgroup.
An example screen is shown below:
@begin{verbatim,group}

 Newsgroup: anu.news  (1 items: #6 - #6)
 Expry: [10], Mod: anu-news@@fac3.anu.oz, Loc, [Srv: FAC3::, File: 2 ]
          Title                                            Size Date
--> 6   _ Weekly USENET Report, period ending Mon Feb 15   8778 16-Feb-88

@end{verbatim}
These fields are:
@begin{verbatim,group}

 Newsgroup: anu.news  (1 items: #6 - #6)

            |          |
    Newsgroup name   Number of items, and first and last
                     item sequence numbers


  Expry: [10], Mod: anu-news@@fac3.anu.oz, Loc, [Srv: FAC3::, File: 2 ]

  |            |                          |     |            |
  |            Internet address of        |  Decnet  address |
  |            newsgroup moderator        |  of server  node |
  |            [not shown if group        |  [not  shown  if |
  |            is not moderated]          |  newsgroup isn't |
  |                                       |  remote served]  |
  Retention time (days) of item           |                  |
  on local system                 Local newsgroup [not  Retention period
                                  shown   for  network  (days) for local
                                  wide newsgroups]      copy  of  remote
                                                        held newsitem


            Title                                          Size Date
 --> 6   _ Weekly USENET Report, period ending Mon Feb 15  8778 16-Feb-88

 |   |   | |                                               |    |
 |   |   | The title of the item     The size (bytes) of the    |
 |   |   |                           newsitem text.             |
 |   |   If this character is a '_'                             |
 |   |   then this newsitem is held        The date the item was added
 |   |   on the  remote news server        into the newsgroup.
 |   |   node
 |   |
 |   The sequence number of the newsgroup
 |
 The 'current' newsitem pointer                           
@end{verbatim}

This display is similar to the newsgroup display, using 1 line to describe each
newsitem. The screen shows the sequence number, news item title, date the news
item was created on the local system, and the size of the news item. News items
which you have not viewed are shown in bolded video.
As with the newsgroup directory, a cursor is positioned in the leftmost columns of the screen, and the
cursor can be moved within the screen by the up and down arrow keys. The cursor
corresponds to the current or selected news item.

@subsection{NEWS ITEM Text Display}

The third context level is entered by the
'READ' command. This screen corresponds to the third context level, displaying the contents of
the current news item.

The text is displayed in screen sized 'chunks', advancing through the text one
page at a time. The base of the screen shows the current position within the
text as a percentage of the total text size. The up and down arrow keys
are also mapped in this mode, and move the display in single line
movements in the relevant direction. The Prev-Screen and Next-Screen
are also mapped to move the screen in page sized chunks either up or down.
Lastly the commands UP and DOWN with a numeric parameter (e.g. DOWN 150)
will move the specified number of lines. The underlying display buffer is 500
lines in size, and once text rools off the "top"
of this display it cannot be presented back on the screen.

Optionally you may use
an editor (TPU by default, but you may choose another editor) in
read-only mode to display the news item text. This will allow you to scroll up
and down, search for strings, and use other editor search and display operations on the text.
At any stage the text display can be aborted, and you may reset the screen
display to either the news item or newsgroup display screen.

@Chapter(Basic NEWS Commands)

This is the first of three chapters describing the user-level NEWS commands.
This chapter describes those commands which are commonly used, and form the
minimum set of commands necessary to use NEWS. The following chapter describes
those commands which are used to change the NEWS environment, and
the third chapter is a reference chapter for the user command set,
describing in detail all user commands and their qualifiers.

As with VMS DCL commands, all NEWS commands and their qualifiers may
be abbreviated to the minimum unique abbreviation.

@Section{Default Keypad Definitions}

By default, the keypad is configured in the following way:

@begin{verbatim,group}
 +--------+--------+--------+ +--------+--------+--------+--------+
 |find    |insert  |remove  | |pf1     |pf2     |pf3     |pf4     |
 |        |        |        | |        |        |        |SKIP/NEW|
 | SEARCH |REGISTER|DEREGIST| |        |HELP    |SKIP    |-SGROUP |
 +--------+--------+--------+ +--------+--------+--------+--------+
 |select  |prev    |next    | |7       |8       |9       |-       |
 |        |        |        | |        |        |        |        |
 | SELECT | UP 18  |DOWN 18 | | PRINT  |EXTRACT |EXTR/ALL|EXTR/APP|
 +--------+--------+--------+ +--------+--------+--------+--------+
     VT220 EDIT KEY BLOCK     |4       |5       |6       |,       |
                              |        |        |        |        |
                              |  DIR   |DIR/NEW |DIR/REG |DIR/ALL |
                              +--------+--------+--------+--------+
                              |1       |2       |3       |enter   |
                              |        |        |        |        |
                              |READ    |READ/HEA|READ/NEX|        |
                              +--------+--------+--------+        |
                              |0                |.       |        |
                              |                 |READ/FOL|        |
                              |    READ/NEW     |-LOW/NEW|        |
                              +-----------------+--------+--------+
                                VT100/VT220 KEYPAD BLOCK
@end{verbatim}

These defaults may be altered by the user - this is documented in the chapter
on customisation of NEWS.

@section{NEWS Screen Displays}

This set of commands enable you to move your context around the NEWS
database.

@begin{description}
DIRECTORY@\The default action of NEWS is to display the newsgroup directory
screen. This screen has a cursor in the left field, which may be
moved using the arrow keys. The directory of newsitems within the
'pointed' or 'current' newsgroup may be obtained
by the 'DIR/ITEMS' command.

@\When the item screen display is current, the newsgroup directory
may be displayed using the 'DIR/NEWSGROUPS' command.

@\The set of newsgroups displayed in the newsgroup directory may be
modified using qualifiers to the DIRECTORY command:
DIR/ALL displays all newsgroups, DIR/REGISTER displays only
those newsgroups in which you have registered a particular interest,
and DIR/SINCE=date (e.g.: DIR/SINCE=TODAY) displays
only those newsgroups which have received new postings since
the data specified.

UP, DOWN@\The newsgroup and newsitem directory screens use a pointer in the left
field of the display to indicate the 'current' newsgroup
and newsitem. This pointer may be moved up or down using the
UP or DOWN commands. These commands are bound to the arrow keys,
so the more usual way of moving through the screen is via the arrow
keys.

@\Both commands may take a numeric parameter (e.g.: UP 18) to
move a number of lines. On VT220-type terminals the PREV SCREEN
and NEXT SCREEN are bound to the commands 'UP 18' and 'DOWN 18'
respectively.

SELECT@\SELECT is similar to 'DIR/ITEMS' such that the command displays
a newsitem directory of a newsgroup. However, SELECT has a number of
qualifiers which make the selection of newsgroups more powerful.

@\In particular, 'SELECT/NEW' selects the next newsgroup in which you have
registered a particular interest which has received new newsitems.
@end{description}


@Section{Displaying NEWS text}

@begin{description}
READ@\The most common method of displaying the contents of a newsitem
is using the 'READ' command. This displays the news text on a
page-by-page basis (in a similar fashion to the DCL 'TYPE/PAGE'
command.

@\By default, the 'current' newsitem is opened for display, but qualifiers
may be used to combine movement of the 'current' newsitem and display:
READ/NEXT combines the actions of the 'DOWN' and 'READ'
commands. READ/NEW combines the actions of 'SELECT/NEW' (select the next unread
newsitem as the current item) and 'READ'. READ/PARENT selects
the parent newsitem (the item to which the current newsitem
refers) for display. READ/FOLLOWUP selects the next followup
newsitem (a posting which refers to the same subject as the
current item) for display.
@end{description}

@Section{Posting Items into NEWS}

There are two commands which allow the user to create a NEWS
posting: POST and FOLLOWUP. POST implies that the item refers
to a new subject which has not been discussed before: FOLLOWUP
implies that the user is posting a followup item to the
current item.

The default actions of POST and FOLLOWUP are to forward the
item text as far as possible throughout the NEWS network.
Background NEWS server processes are responsible for sending
the item to all adjacent network neighbours. Normally the
distribution of the item is restricted by the set of network
nodes which wish to receive the newsgroups in which the newsitem is posted.
Qualifiers may be used with these commands to restrict this
distribution to a subset of the network (these qualifiers
are described in the reference chapter).

@begin{description}
POST@\invokes a text editor to create a new newsitem (the text
editor may be one of your choosing - see the chapter on
customization). The NEWS system also
prompts for the newsgroup or newsgroup list to which the
item will be posted, and will also prompt for the title
of the posting.

FOLLOWUP@\is similar to POST, with the difference that the
edit buffer is pre-loaded with the text of the current newsitem (the
item to which you are posting the followup). This allows you to
formulate your reply using fragments of the original posting
to help other readers establish what you are replying to.
@end{description}

@Section{Deleting Newsitems}

Deletion of newsitems is not normally a straightforward process -
as the text of the original item may have already been forwarded
to the wider news network, then deletion of a newsitem requires
that a special deletion control message must be sent through the network
to delete all copies of your posting.

@begin{description}
CANCEL@\This command deletes the 'current' newsitem. A chack is performed to ensure
that the item you are attempting to delete was actually
posted by yourself before the deletion is performed. This command also
generates a cancel control message which is forwarded throughout the net.
@end{description}

@Section{NEWS Interface to MAIL}

NEWS supports two commands which interface to VMS MAIL. This
allows users to forward NEWS items to other users via
MAIL and also to send direct person-to-person mail to the original
poster of the newsitem.

@begin{description}
FORWARD, MAIL@\These two commands are synomyns: the 'current' newsitem is extracted
and posted to the addresses you supply. By default the item text
is loaded into an edit buffer for editing before sending the mail - this
edit pass may be omitted by using the '/NOEDIT' qualifier with the command.

REPLY@\This command extracts the From: address (or the Reply-To: address, if specified)
from the current newsitem and invokes the editor to create a reply
which will be directed to the sender of the newsitem.

@\This command differs from the FOLLOWUP command in so far as your response
to the original posting is a private
response between you and the poster, whereas the FOLLOWUP command posts a public
response through the NEWS network.
@end{description}

@Section{Extraction of Newsitems}

Newsitems may be extracted from the NEWS database and kept as a local
file, or printed.

@begin{description}
EXTRACT@\This command extracts the 'current' newsitem and makes a local
copy into a file - you are prompted for a filename to write to.

PRINT@\This commands the 'current' newsitem to a queue of print requests.
When you EXIT from NEWS you are prompted for the queue on which
to print the newsitems.
@end{description}

@Section{Keeping Track of Newsitems}

There are two ways in which NEWS can be used to help you read
particular newsitems - the first is by the concept of
'read' and 'unread' newsitems and the second by the use of
'marks' to enable you to re-read newsitems at a later date.

NEWS maintains for each user a list of all newsitems which
have been considered as 'read' - this is an aid when searching
through the NEWS database for new items which have been posted.
NEWS also maintains for each user a list of newsitems which have been
'marked' by that user, enabling the user to 'mark' a newsitem
with any tag text, and later retrieve that newsitem by specifying that
tag text.

This context information is contained in the file
SYS$LOGIN:NEWS_GROUPS.REGISTER. The file is updated every time NEWS is executed.

@begin{description}
REGISTER, DEREGISTER@\NEWS enables the user to mark particular newsgroups as being of particular
interest. This marking, or 'registering', is used by the READ/NEW,
SELECT/NEW, DIR/NEW and DIR/REGISTER commands to allow fast access
to any new postings in the subset of 'registered' newsgroups.

@\The 'current' newsgroup is added to this registered set by the 'REGISTER'
command, and can be removed from the set by the 'DEREGISTER'
command.

SKIP@\SKIP is used to mark a set of newsitems as having been 'read'
without having to display the item text. The default action
is to mark the current item as 'read' and move the pointer to refer
to the next item.
                            
@\If the display is the newsgroup directory, then SKIP will mark
ALL newsitems in the 'current' newsgroup as read.

@\SKIP may also mark a range of newsitems as 'read' by using qualifiers
with the SKIP command - these are documented in the reference chapter.

MARK, UNMARK@\MARK is used to associate a tag with a newsitem. The common
form of marking is the MARK the 'current' newsitem, and then
retrieve that item at a later date by either the SELECT/MARK
or READ/MARK commands.
If a newsitem has been marked, then a line of the
form "Mark: ..." is included in the header lines of the
text display for that newsitem.

@\A mark may be removed from a newsitem by the UNMARK command.

@\Variants of this command allow the mark to have a text value, allowing
the READ/MARK and SELECT/MARK commands to retrive particular
marked items according to a match on the supplied tag values.
@end{description}

@Section{HELP}

@begin{description}
HELP@\is used to enter the on-line HELP documentation - this documentation
is similar to the reference chapter in this document
@end{description}

@Section{EXITing NEWS}

@begin{description}
EXIT@\performs a normal exit from NEWS - the register file is updated
to reflect all items read during this session, and any print
requests are sent to a nominated print queue

QUIT@\exits from NEWS without the associated update function of EXIT.
This is a more graceful alternative to the Ctrl-Y exit.
@end{description}

@Chapter(Customising the NEWS Environment)

It is possible to customise NEWS in two ways: changing the definitions of keys
on the terminal, and changing the editor invoked by NEWS to one of your choice.
This chapter describes those commands and logical names which perform this
customisation.


@Section{Key Definition}

The default set of key mappings is given in the previous chapter.

These defaults may be altered in two ways: using the 'DEFINE/KEY' command to
bind a news command to a key, or defining  the  logical  name  "NEWS_INI"  to a
file containing a sequence of DEFINE/KEY lines (which will be executed  on
startup of NEWS).

The DEFINE/KEY command is equivalent to it's VMS DCL counterpart - the command
performs a mapping of the nominated key to a command string.

There are six keys which should not be DEFINED from the standard
NEWS values: the four arrow keys and the PREV and NEXT SCREEN
keys (VT220 edit keypad).

@Section{Logical Names}

There are seven logical names which users may define to alter the behaviour of
news:

@begin{description}
NEWS_INI@\This can be defined as a file name which contains a set of
            DEFINE/KEY commands to change the default key binding of news. e.g.
@begin{verbatim}
  $ DEFINE NEWS_INI SYS$LOGIN:NEWSKPD.DEFS
@end{verbatim}

NEWS_EDIT@\This logical name can be used to link an editor to NEWS. The
editor is used to generate new postings, and to edit forwarded mail, and
(optionally) in readonly mode, to scan the item contents (READ/EDITOR).

@\By default NEWS links the TPU editor to NEWS, using the value of the logical
name TPUSECINI as the section to use. If TPUSECINI is not defined, then the EDT
emulator is selected.

@\This logical name is used to either:
@begin{itemize}
Use the TPU editor with a section other than TPUSECINI or the EDT
emulator:
@begin{verbatim}
  $ DEFINE NEWS_EDIT "TPU/SEC=mysection"
@end{verbatim}

Use EDT as the configured editor:
@begin{verbatim}
  $ DEFINE NEWS_EDIT CALLABLE_EDT
@end{verbatim}

Call any other editor using a command procedure in a subprocess:
@begin{verbatim}
  $ DEFINE NEWS_EDIT "@@dev:[dir]my_editor.com"
@end{verbatim}
and NEWS will then SPAWN the command:
@begin{verbatim}
  $ @@dev:[dir]my_editor.com filename
@end{verbatim}
The following section shows an example my_editor.com command procedure.
@end{itemize}

NEWS_VIEW@\This logical name is only required if you are using a local
editor command procedure as NEWS_EDIT. In this case a second procedure is
required which invokes the same editor in read_only mode:
@begin{verbatim}
  $ DEFINE NEWS_VIEW "@@dev:[dir]my_reader.com"
@end{verbatim}
and NEWS will then spawn the command:
@begin{verbatim}
  $ @@dev:[dir]my_reader.com filename
@end{verbatim}

@\When TPU or EDT is configured as the editor, then NEWS will automatically add
the /READONLY to create a readonly version of the editor.

NEWS_SCANSIZE@\NEWS will normally display the text of a newsitem on a
page-by-page basis. When scanning through items it is often useful to only
display the first few lines of an item, to decide whether to view the complete
text.

@\If the logical name NEWS_SCANSIZE is defined as a number (n), then the first n
lines of each new item will be displayed, and you will be prompted if you wish
to see more of this item. Commonly, a value between 8 and 12 is most useful.

MAIL_SIGNATURE@\This logical name may be defined as the name of your mail
signature file. If this logical name is defined, then the contents of this fill
will be automatically appended to all postings and mailings made from within
NEWS.

NEWS_DEFAULT_DIRECTORY@\NEWS will normally remember the last newsgroup directory
               setting across invocations of the program (i.e. If you
               had executed DIR/NEW before exiting NEWS, then when you
               next run NEWS, the initial newsgroup directory state will
               be restored to DIR/NEW. It is possible to specify a
               constant initial directory state by defining this
               logical name as one of the strings:
@begin{verbatim}
 ALL  NEW  REGISTER  SINCE  SINCE=vms_date
@end{verbatim}

NEWS_POST_CC@\This logical name directs NEWS to generate MAIL carbon-
               copies of NEWS postings. The logical name value is
               interpreted by NEWS as the name of a CC control file.
               This file consists of lines of the form:
@begin{verbatim}
newsgroup   address
@end{verbatim}
               The newsgroup name starts in column 1, and may be the
               name of a single newsgroup, or may specify a set of
               newsgroups by including the wildcard match character
               ('*').

@\The address is the address to receive a carbon copy
               of the posting. It is separated from the newsgroup
               name by at least 1 space character. The address may be
               a decnet or internet-format address.

@\The interpretation of the file is such that any postings
               you make into any of the specified newsgroups will also
               generate mail to the matching addresses.
@end{description}

@subsection{NEWS_EDIT Command Procedure}

An example command procedure to invoke an editor from NEWS is as follows:
@begin{verbatim}
 $ !
 $ ! Example command procedure to invoke an editor for NEWS
 $ !
 $ ! Inputs:
 $ !
 $ !     P1 = file name.
 $ !
 $ ! Note that this procedure is run in the context of a subprocess.
 $ ! LOGIN.COM is not executed.  However, all process logical names
 $ ! and DCL global symbols are copied.
 $ !
 $ ! The default directory is the same as the parent process
 $ !
 $ ! Note that this will only be invoked if the user has placed in
 $ ! LOGIN.COM (or similar)
 $ !     $ DEFINE NEWS_EDIT "@@dev:[dir]NEWSEDIT_EXAMPLE.COM"
 $ !
 $ DEFINE /USER SYS$INPUT 'F$TRNLNM("SYS$OUTPUT")'
 $ IF P1 .EQS. "" THEN EXIT
 $ EDIT/EDT 'P1'
 $ EXIT
@end{verbatim}

@Chapter(NEWS Commands - User Reference)

@Section{NEWS}

The NEWS command is the VMS DCL command to invoke NEWS.

@Subsection{Parameters}

Format:
@begin{verbatim}
    $ NEWS command
@end{verbatim}

Any valid NEWS command may be specified as a parameter to the
NEWS command: If such a parameter is used then NEWS will
execute this single command then exit to the VMS DCL level.

For example, the VMS DCL command:
@begin{verbatim}
    $ NEWS POST/NEWSGROUP=local.msg/SUBJECT="Weekly Msgs" weekly.msg
@end{verbatim}
posts the file 'weekly.msg' into NEWS, into newsgroup 'local.msg', with the
title "Weekly Msgs", then returns to DCL.

@subsection{NEWS/SCREEN}

Format:
@begin{verbatim}
    $ NEWS/SCREEN  [Default]
    $ NEWS/NOSCREEN
@end{verbatim}

This qualifier is used to determine whether the initial state of NEWS is
configured to drive a terminal screen or a hardcopy device. The
/NOSCREEN qualifier is used for hardcopy interactive sessions or
Batch or Detached execution of the NEWS program.

@i{See Also} SCREEN, NOSCREEN
@newpage
@section{ADD MARKER}

Format:
@begin{verbatim}
    ADD MARKER [marker-name [item-number]]
@end{verbatim}

ADD MARKER places a mark against the current newsitem. This item can
be selected at a later stage by the READ/MARK or SELECT/MARK commands,
or printed by the PRINT/MARK command.

If no marker-name value is specified then the default value, "mark" is
used. A marker name is a string.

If no item number is specified, the mark is placed against the current
item.

@i{See Also} MARK, UNMARK, CLEAR MARK, DELETE MARKER
@newpage
@section{CANCEL}

This command deletes the current newsitem (the directory must be at the
newsitem level for this command).

This command inspects the address of the sender of the newsitem, and will only
perform the deletion if the sender's address matches that of the user.

As well as deleting the local copy of the newsitem, a 'cancel' control news
message is sent through the news network to ensure that all copies of the item,
held on all connected NEWS nodes, are deleted.

@newpage
@section{CLEAR KILL}

Format:
@begin{verbatim}
    CLEAR KILL

    CLEAR KILL tag
@end{verbatim}

CLEAR KILL removes the kill filters with the matching tag from the kill filter
set. If no tag value is specified then ALL kill filters are cleared.

@i{See Also} KILL, SHOW KILL, MODIFY KILL
         
@newpage
@section{CLEAR MARK}

Format:
@begin{verbatim}
    CLEAR MARK

    CLEAR MARK tag
@end{verbatim}

CLEAR MARK removes all marks of the specified tag from the mark list. If no tag
value is specified then ALL marks are cleared. Otherwise only the specified tag
value is cleared. The wildcard character ('*') can be used in the tag field to
clear a set of related tags.

@i{See Also} MARK, UNMARK

@newpage
@section{DEFINE/KEY}

Format:
@begin{verbatim}
     DEFINE/KEY key-name equivalence-string
@end{verbatim}

This command associates an equivalence string and a set of attributes with a
key on the terminal keyboard.

The key-name
parameter specifies the name of the key that you are defining.  The
following table  gives  the  set of key  names  in  column  one.  The remaining three
columns indicate the key designations on the keyboards for the three different
types  of  terminals  that  allow  key  definitions.

NOTE: that the arrow keys and the PREV SCREEN and NEXT SCREEN keys
should not be re-defined from their default defined values.
@begin{verbatim}
 Key-name       LK201       VT100-type      VT52

 PF1            PF1         PF1             [blue]
 PF2            PF2         PF2             [red]
 PF3            PF3         PF3             [gray]
 PF4            PF4         PF4             -
 KP0,KP1...KP9  0,1...9     0,1...9         0,1...9
 PERIOD         .           .               .
 COMMA          ,           ,               n/a
 MINUS          -           -               n/a
 ENTER          Enter       ENTER           ENTER
 E1             Find        -               -
 E2             Insert Here -               -
 E3             Remove      -               -
 E4             Select      -               -
 HELP           Help        -               -
 DO             Do          -               -
 F17...F20      F17...F20   -               -
@end{verbatim}

The equivalence-string
specifies the string which is to be processed  when  you  press  the key. If
the string contains any spaces, enclose the equivalence string in quotation
marks.

@subsection{DEFINE/KEY/ECHO}

Determines whether or not the equivalence  string  is  displayed  on your
screen  after the key has been pressed.  The default is /ECHO. You cannot use
/NOECHO with the /NOTERMINATE qualifier.


@subsection{DEFINE/KEY/PROTECT}

Determines whether or not the key definition can be changed or deleted
once the definition is performed. /NOPROTECT is the default.


@subsection{DEFINE/KEY/IF_STATE=(state-name,...)}

Specifies a list of one or more states, one of which must be in effect for the
key definition to be in effect. If you omit the /IF_STATE qualifier or use
/NOIF_STATE, the current state is used. The state name is an alphanumeric
string. States are established with the /SET_STATE qualifier or the SET KEY
command. If you specify only one state name, you can omit the parentheses. By
including several state names, you can define a key to have the same function
in all the specified states.

@subsection{DEFINE/KEY/LOCK_STATE}

Specifies that the state set by the /SET_STATE qualifier remain in effect until
explicitly changed. If you use the /NOLOCK_STATE qualifier, the state set by
/SET_STATE is in effect only for the next defineable key that you press or for
the next read terminating character that you type.

The default is /NOLOCK_STATE. The /LOCK_STATE qualifier can only be specified
with the /SET_STATE qualifier.


@subsection{DEFINE/KEY/SET_STATE=state-name}

Causes the specified state-name to be set when the key is pressed. The state
name can be any alphanumeric string.

If you omit the SET_STATE qualifier or use /NOSET_STATE, the current state that
was locked remains in effect. If you have not included this qualifier with a
key definition, you can use the SET KEY command to change the current state.


@subsection{DEFINE/KEY/TERMINATE}

Specifies whether or not the current equivalence string is to be terminated
(that is, processed) when the key is pressed. The default is /NOTERMINATE,
which allows you to press other keys before the equivalence string is
processed. Pressing RETURN has the same effect as using /TERMINATE.

The /NOTERMINATE qualifier allows you to create key definitions that insert
text into command lines, after prompts, or into other text that you are typing.
@newpage
@section{DELETE}

Delete is used to clear marks from newsitems. (Delete may also
be used to delete newsitems and newsgroups - this is documented
in the management command section of this document.)

The command format is: DELETE MARKER

@subsection{DELETE MARKER}

Format:
@begin{verbatim}
    DELETE MARKER [tag]
@end{verbatim}

DELETE MARKER removes all marks of the specified tag from the mark list. If no
tag value is specified then ALL marks are cleared. Otherwise only the specified
tag value is cleared. The wildcard character ('*') can be used in the tag field
to clear a set of related tags. 

@i{See Also} CLEAR MARK, MARK, UNMARK
@newpage
@section{DEREGISTER}

Format:
@begin{verbatim}
    DEREGISTER newsgroup

    DEREGISTER/ALL
@end{verbatim}

This command removes your registration from a newsgroup. The newsgroup may
either be specified as a parameter to the command, or, if not specified, the
current newsgroup is deregistered.

The parameter to the command is the name of the newsgroup to deregister. If no
newsgroup name is specified, the current newsgroup is deregistered.

@i{See Also} REGISTER, DIR/REGISTER, DIR/NEW, SELECT/NEW

@subsection{DEREGISTER/ALL}

The /ALL qualifier removes registration tags from all newsgroups.

@newpage
@section{DIRECTORY}

In screen mode this command is used to move between newsgroup and newsitem
displays, and also to select some subset of the full newsgroup set to display
on the screen.

In line mode, this command, by default lists all the news items in the
currently selected newsgroup, on a page by page basis, displaying the item
number, creation date and item title.

@subsection{DIRECTORY/ALL}

In screen mode this command resets the newsgroup directory to display all
newsgroups held on the local system.

In line mode these newsgroups are listed page by page.

@subsection{DIRECTORY/NEW}

In screen mode this command sets the newsgroup directory screen to only display
those newsgroups in which you are registered, and there are unread newsitems
within those newsgroups.

In line mode these newsgroups are listed page by page.

@subsection{DIRECTORY/REGISTER}

In screen mode this command sets the newsgroup directory screen to only display
those newsgroups in which you are registered.

In line mode these newsgroups are listed page by page.

@subsection{DIRECTORY/SINCE=date}

In screen mode this command sets the newsgroup directory screen to only display
those newsgroups in which new items have been entered since the date specified.
The date is given in VMS time format: e.g. DIR/SINCE=22-FEB.

In line mode these newsgroups are listed page by page.

@subsection{DIRECTORY/ITEMS}

This opens the 'current' newsgroup and displays the newsitem for that
newsgroup. This command is equivalent to the basic 'SELECT'
command.

@subsection{DIRECTORY/NEWSGROUPS}

This command moves the context of NEWS to the newsgroup
directory screen. This command is equivalent to the 'NEWSGROUP' command.

@subsection{DIRECTORY/RESET}

This clears the internal memory copy of the NEWS database, and reads a new copy
of the database from the master index files into memory.

This command is not normally used -- it is relevant only in those situations
where a background process is adding or deleting news items to the database,
and the user encounters 'file not found' errors when attempting to access item
files.

@newpage
@section{DOWN}

Format
@begin{verbatim}
    DOWN

    DOWN Number
@end{verbatim}

In screen mode this moves the current pointer down one line. The command has an
optional numeric parameter, the number of lines to move down.

If no number is specified, 1 is the default value. This command is bound to the
down arrow key on the terminal. The command 'DOWN 18' is bound to the 'next
screen' key in the terminal.

@newpage
@section{EXIT}

EXIT from NEWS. Ctrl-Z is also interpreted as EXIT.

On exit from NEWS a new register file is written out to SYS$LOGIN. This file,
(SYS$LOGIN:NEWS_GROUPS.REGISTER) contains the list of registered newsgroups,
read/unread newsitems, the marked item list and the kill filter lines.

The context file is used to determine which news items are unread, and is also
used to re-establish context on the next invocation of NEWS -- The next
invocation of NEWS will restore the screen displays to the state at which the
'EXIT' command was entered.
On exit the user is prompted for the print queue name if printer requests that
were generated during this NEWS session.

@i{See Also} QUIT

@newpage
@section{EXTRACT}

Format:
@begin{verbatim}
    EXTRACT

    EXTRACT filename
@end{verbatim}
EXTRACT copies the current news item text into an output file. The filename
parameter is optional - if not specified the user is prompted for a name, with
the default value of SYS$LOGIN:NEWS.LIS.

@i{See Also} PRINT

@subsection{EXTRACT/ALL}

This qualifier modifies the EXTRACT command to copy ALL of  the  items in the
current selected newsgroup onto the file.

@subsection{EXTRACT/APPEND}

This  qualifier  modifies  the EXTRACT command to APPEND the output to the
nominated file, rather than the default action of creating  a  new version of
the output file.

@newpage
@section{FOLLOWUP}

FOLLOWUP is used to post a reply to a news item back into NEWS. The followup
item will reference the news item you are following up as the parent of the new
posting.

The editor is invoked to form the new posting, with the edit buffer preloaded
with the text of the original item. The default editor is the TPU EDT emulator,
but this is user definable - see the section on customisation to specify a
different editor to use.

NEWS will fill in all defaulting news headers, and will prompt for all header
items which are non-defaulting (the subject line and the newsgroups to post the
item into).

If the newsgroups for the posting are moderated newsgroups, the posting is
automatically re-directed as mail to the moderator address, and NOT posted back
to NEWS.

@i{See Also} REPLY, POST

@subsection{FOLLOWUP/HEADERS}

Followup will normally prompt for the subject of the posting, and a list of
newsgroups to post the item into. All other header lines of the news item text
will be filled with null values.

The /HEADERS qualifier will force prompting for optional components of the item
header. These fields are:
@begin{description}
Summary:@\A one line summary of the contents of the posting.

Reply-To:@\The (internet) mail address for REPLYing to the item - used if
            replies are to be sent to a mail address OTHER than yourself (as
            the originator of the item.

Distribution:@\A (comma separated) list of keywords designed to limit the
            distribution of a news item to a subset of the network. These
            keywords are site specific, but commonly include the keywords
            "local" (do not forward to the net) and "world" (forward as far as
            possible through the net).

Followup-To:@\The list of newsgroups where followup postings are to be sent.
            This is used to move a discussion to another newsgroup.

Keywords:@\A few relevant, pithy keywords which should indicate to other
            readers if the item is of interest.
@end{description}

@newpage
@section{FORWARD}

Invokes VMS MAIL, to send a copy of the current news item to another user (or
yourself if so inclined).

FORWARD and MAIL are equivalent.

@i{See Also} MAIL

@subsection{FORWARD/TO}
   
Format:
@begin{verbatim}
 FORWARD/TO=user

 FORWARD/TO=(user,user)
@end{verbatim}

Specifies the VMS Mail address of the users to receive the mail (This is one of
the anomalies of NEWS that will be addressed in a future version - the addresses
used here should be internet-style addresses - not VMS Mail addresses -as is currently
the case). This
may be a user name, or a list of names, and may also include a distribution
list file specification.

If this qualifier is not specified, the user is prompted for the /TO value.

@subsection{FORWARD/SUBJECT=subj}

Format:
@begin{verbatim}
 FORWARD/SUBJECT="text string"
@end{verbatim}
Specifies  the  subject  of  the message for the heading.

If not specified, the user is prompted for the /SUBJECT value.

@subsection{FORWARD/NOEDIT}

By default, FORWARD invokes the editor to allow the item text to be edited
before mailing the item. This qualifier sends the news text to the mailer
without modification.

The default editor is the TPU EDT emulator, but this is user definable - see
the chapter on customisation of NEWS.

@subsection{FORWARD/SELF}

Sends a copy of the message back to yourself, as well as those on the /TO list.

@subsection{FORWARD/HEADERS}

By default the news item header lines are stripped off the item text before it
is mailed. This qualifier loads the item header lines into the mail buffer as
well as the body of the text.

@newpage
@section{HELP}

This command invokes the help processor. The  command  can  be  used  with
parameters to specify the command on which you want the help displayed.

@newpage
@section{KILL}

The KILL facility allows the user to filter out all messages of a particular
class - the READ/NEW command will mark such filtered items are having been
read without displaying the text of the item to the user, and search forward
for the next unread item.  This enables the user to skip messages whose subject,
or sender, are of no particular interest.

The KILL filter works on four possible attributes of an item for a match with
the filters: the newsgroup name, the subject line, the sender's address and any
other single item header line. Of these attributes, only the newsgroup name and
a minimum of one of the remaining three filters need be specified (If more than
one item attributed is specified then the logical AND of the filters is the
result of the filter). Thus it is possible to filter all postings by a
particular sender in all newsgroups, or filter a conversation stream from a
particular newsgroup, or filter all postings from a particular sender within a
specified conversation stream.

The KILL command adds entries to the kill filter list. Removing kill filters
is performed by the CLEAR KILL command, and existing kill filters can be
edited using the MODIFY KILL command.

The KILL command has three qualifiers: /SUBJECT, /FROM and /HEADER. The
/SUBJECT qualifier directs NEWS to add the current item's subject line to the
kill filter set, and the /FROM directs NEWS to add the current item's "From:"
line to the kill filter set. The /HEADER qualifier takes a text pattern as a
value, and matches the pattern against a header line. This header line value is
taken as the filter value.

The command will then prompt for the set of newsgroups to which this filter
will be applied. The default value is the current newsgroup however more
newsgroups may be specified using wildcard notation ('*') or a list of
newsgroups.

@i{See Also} SHOW KILL, MODIFY KILL, CLEAR KILL

@subsection{KILL/FROM}

Add the current item's From: address to the kill filter set.

@subsection{KILL/SUBJECT}

Add the current item's Subject line to the kill filter set.

@subsection{KILL/HEADER=text}
The /HEADER qualifier takes a text pattern as a
value, and matches the pattern against a header line. This header line value is
taken as the filter value.

For example, to kill all items with the same set of keywords as the current
item the command would be:
@begin{verbatim}
    KILL/HEADER=keywords:
@end{verbatim}
This command will read the current item, extract the keywords header line, and
use this line as a kill filter.
@newpage
@section{MAIL}

See the section on the FORWARD command: FORWARD and MAIL are equivalent.
@newpage
@section{MARK}

Format:
@begin{verbatim}
    MARK

    MARK tag
@end{verbatim}

MARK places a mark against the current newsitem. This item can be selected at a
later stage by the READ/MARK or SELECT/MARK commands.

If no tag value is specified then the default tag, "mark" is used. Any tag
value may be specified - tag values are words (no space characters) of any
(well less than 80) length.

@i{See Also} UNMARK, CLEAR MARK

@newpage
@section{MODIFY KILL}

Format:
@begin{verbatim}
    MODIFY KILL tag
@end{verbatim}
   
MODIFY kill allows existing kill filters to be edited. The kill filter
with the nominated tag is displayed, then each of the four filter
attributes can be edited (using the command line editor functions).

If all four attributes are cleared then the filter is deleted.

@i{See Also} KILL, SHOW KILL, CLEAR KILL

@newpage
@section{NEWSGROUPS}

In screen mode this pops the display stack back to the newsgroup directory
screen from the newsitem or news text display screens. This command
is a synonym of the 'DIR/NEWSGROUPS' command.

@newpage
@section{NOSCREEN}

This command turns off screen mode and enters line command mode.

@i{See Also} SCREEN

@newpage
@section{POST}

Format:
@begin{verbatim}
    POST

    POST Filename
@end{verbatim}

POST is used to post a new news item into NEWS.
By default, the editor is invoked to form the new posting. The default editor
is the TPU EDT emulator, but this is user definable - see the chapter on
customisation to specify a different editor to use.

NEWS will fill in all defaulting news headers, and will prompt for all header
items which are non-defaulting (the subject line and the newsgroups to post the
item into).

If the newsgroups for the posting are moderated newsgroups, the posting is
automatically re-directed as mail to the moderator address, and NOT posted
directly to NEWS.

If a filename is specified, the editor is loaded with the text of the specified
file, otherwise the editor is invoked to create a new file.

@i{See Also} FOLLOWUP, REPLY, FORWARD

@subsection{POST/NOEDIT}

Bypasses the call to the editor in forming a new item to post. If no post
filename is specified, the editor call is forced.

The default editor is the TPU EDT emulator, but this is user definable.

@subsection{POST/HEADERS}

Post will normally prompt for the subject of the posting, and a list of
newsgroups to post the item into. All other header lines of the news item text
will be filled with null values.
   
The /HEADERS qualifier will force prompting for optional components of the item
header. These fields are:
@begin{description}

Summary:@\A one line summary of the contents of the posting.

Reply-To:@\The (internet) mail address for REPLYing to the item - used if
            replies are to be sent to a mail address OTHER than yourself (as
            the originator of the item.

Distribution:@\A (comma separated) list of keywords designed to limit the
            distribution of a news item to a subset of the network. These
            keywords are site specific, but commonly include the keywords
            "local" (do not forward to the net) and "world" (forward as far as
            possible through the net).

Followup-To:@\The list of newsgroups where followup postings are to be sent.
            This is used to move a discussion to another newsgroup.

Keywords:@\A few relevant, pithy keywords which should indicate to other
            readers if the item is of interest.

@end{description}

@subsection{POST/NEWSGROUPS}

Format:
@begin{verbatim}
 POST/NEWSGROUPS=newsgroup-list
@end{verbatim}

This qualifier specifies the list of newsgroups to receive the posting. If this
qualifier value is not specified, the user is prompted for the newsgroups. The
list is a comma separated list of newsgroup names.

@subsection{POST/SUBJECT=subj}

Format:
@begin{verbatim}
 POST/SUBJECT="text string"
@end{verbatim}

Specifies  the  subject  of  the message for the heading.
If not specified, the user is prompted for the /SUBJECT value.

@newpage
@section{PRINT}

Print appends the current news item to a temporary print file. As more items
are PRINTed, they are appended to this print file.

At the end of the NEWS run the user is prompted  for  the  name  of  the queue
on which the output is to be sent, and the temporary print file deleted once
the print job is complete.

@i{See Also} EXTRACT

@subsection{PRINT/ALL}

This qualifier modifies the PRINT command to copy ALL of the items  in the
current selected newsgroup onto the file. If the newsgroup contains a large
number of items this could seriously affect your disk quota (as well as the
possibility of printer meltdown).

@newpage
@section{QUIT}

QUIT exits from news without updating the user's news register file. Thus, no
changes are made to the set of unread items, nor are any changes made to the
set of marked news items (this is a more graceful means of Ctrl-C or Ctrl-Y!).

@i{See Also} EXIT

@newpage
@section{READ}

This command reads the next item from the current selected  newsgroup, and
displays the item on the screen page-by-page.

The actions of READ can be modified by giving a Newsitem  number,  which will
display that item.

@subsection{READ newsitem_number}

This parameter may be either the number of a news item, a '.' (to
re-read the last read item from the start), or  '*'  to  read  the last item in
the group.

@subsection{READ/HEADER}

Normally  NEWS  will  suppress  the  display  of  all  network routing headers.
This qualifier produces a full display of the item  contents including mail
header lines.

@subsection{READ/NEW}

This  command  will  display the next unread NEWS item from the set of
registered newsgroups. This may cause an implicit SELECT of a different
newsgroup to obtain the next unread item.

@subsection{READ/EDITOR}

This qualifier will use an editor in read-only mode to view the newsitem. This
is  useful when it is required to scroll up and down through the item text, or
extract a part of the text into a file.

The default editor is the TPU EDT emulator, but this is user definable - see
the chapter on customisation of NEWS.

@subsection{READ/TPU}

This qualifier is equivalent to the /EDITOR qualifier.
This qualifier will use an editor in read-only mode to view the newsitem. This
is  useful when it is required to scroll up and down through the item text, or
extract a part of the text into a file.

The default editor is the TPU EDT emulator, but this is user definable - see
the chapter on customisation of NEWS.

@subsection{READ/NEXT}

When reading a news item this command causes the remainder of the text display
to be skipped, and the next item to be displayed.

@subsection{READ/LAST}

When reading a news item this command causes the remainder of the text display
to be skipped, and the previous item to be displayed.

@subsection{READ/BACK}

This qualifier is equivalent to the /LAST qualifier.
When reading a news item this command causes the remainder of the text display
to be skipped, and the previous item to be displayed.

@subsection{READ/PARENT}

NEWS items may reference a previous item that has been posted. In such a case
the text of the item commonly begins with the line:

    "In article {<identifier>}, {username} writes:"

When a news item references previous items, the header includes the identifier
of the parent item. READ/PARENT will display the parent item referenced by the
current item.

@subsection{READ/IDENTIFIER=id}

All NEWS items are identified by a unique message identification string. (This
identifier can be displayed using the READ/HEADER command, and noting the
"Message-Id: ..." line).

An item to be displayed can be selected by providing the identifier of the
item. e.g.:
@begin{verbatim}
    READ/IDENTIFIER="<243@@csc.anu.oz>"
@end{verbatim}

@subsection{READ/ROT13}

Some news items are posted using a basic encryption method (rot13). This
qualifier uses the decryption algorithm to display the message contents.

@subsection{READ/MARK}

Format:
@begin{verbatim}
    READ/MARK

    READ/MARK=tag
@end{verbatim}

This command displays the text of the NEXT newsitem marked with the specified
tag value. If no tag value is specified than the next item marked with any tag
is used.

@subsection{READ/FOLLOWUP}

This command scans the current newsgroup for the next newsitem with a
subject field which matches that of the current newsitem subject (within the
current newsgroup).
In this way the responses (if any) to the current newsitem can be viewed.

@subsection{READ/PREV}

NEWS maintains a history of the last 10 items read. READ/PREV pops the most
recent item index off this history stack and displays the item. Repeated calls
to READ/PREV will continue to pop the stack until the history stack is emptied.

@newpage
@section{REFRESH}

In screen mode this command repaints the screen. This command is (by default)
bound to the Ctrl-W key.

@newpage
@section{REGISTER}

Format:
@begin{verbatim}
    REGISTER

    REGISTER Newsgroup-name
@end{verbatim}

Adds newsgroups into the user's register file. Registering into a newsgroup
implies that NEWS will automatically keep track of which items in the newsgroup
have been read, and the user can view only the unread news items with repeated
READ/NEW commands.

The newsgroup-name parameter specifies the name of the newsgroup to register.
If the parameter is not specified, the current newsgroup is added to the
register file.

@i{See Also} DEREGISTER

@subsection{REGISTER/ALL}

This qualifier will register  the  user  for  ALL  newsgroups  on  the system.
On a system with a high quantity of network news this must be considered a
brave act!

@subsection{REGISTER/NEW}

This  qualifier  will  register the user for all newsgroups created on the
system since the last time a REGISTER/ALL or REGISTER/NEW command was  given.
Thus, the user is automatically registered into all recent newsgroups, and can
then elect to deregister from some of those newsgroups.

@subsection{REGISTER/PRIORITY=n}

This qualifier assigns a read priority to the newsgroup. This is particularly
useful if you are registered in a number of newsgroups, and would like to view
new items (using READ/NEW) in a particular order of newsgroups. The value is a
number (between 1 and 255), increasing with priority.

For example, if you have new items in net.a and net.b and the priority of net.b
is greater then net.a, unread items in net.b will be displayed first (when using
READ/NEW.

@newpage
@section{REPLY}

REPLY posts  a  MAIL reply directly to the sender of a news item. This is used
to respond directly to the poster of an item without the item appearing on the
net.

News will pre-load the edit buffer with the text of the item to which the reply
is being sent, then invoke the editor. The default editor is the TPU EDT
emulator, but this is user definable - see the section on customisation of
NEWS.

On a normal exit from the editor the item is posted via VMS Mail to the sender
(The sender's address is mapped into the equivalent VMS Mail address by site
specific address transformation rules).

@i{See Also} FORWARD, FOLLOWUP

@subsection{REPLY/HEADERS}

By default the news item headers are stripped off the item text before it is
mailed. This qualifier loads the item header lines into the mail buffer as well
as the body of the text.

@subsection{REPLY/SUBJECT=subj}

This specifies the subject header of the mail reply. If not specified, NEWS
will prompt for a "Subject:" field for the mail.

@subsection{REPLY/SELF}

This is a mail qualifier which will forward a copy of the outgoing mail item
back to the sender.

@newpage
@section{SEARCH}

Format:
@begin{verbatim}
    SEARCH [target string]
@end{verbatim}

This  command  directs  NEWS  to  locate  a  newsitem  which  contains a
specified text string.  The next item which contains the  text string is
displayed on the screen. Repeated calls to SEARCH  (without specifying a text
string) will locate successive occurrences in other news items that are in the
specified newsgroups.

If no target string is specified, the search is resumed using the previous
target string.

The search is usually case-insensitive,  but this may be  reversed (made case
sensitive) by specifying a mixed-case string  (i.e. upper case only and lower
case only target  strings are case-insensitive).  To specify a mixed-case
string you must enclose  the string in  "  characters (e.g. SEARCH "String").

As this involves examining the contents of all specified item files, this
command may take a reasonably long time. The search may be interrupted by
pressing the RETURN key. This will call up a NEWS input prompt, and the search
may either be resumed (with another RETURN) or a new command may be given.

@subsection{SEARCH/NEWSGROUPS=newsgroups}

By default the search is limited to the current newsgroup. This can be modified
by specifying the newsgroups which should be searched.

The wildcard character ('*') may be used to include a set of newsgroups.

A number of newsgroups may be specified with the usual list notation (comma
separated list).

For example:
@begin{verbatim}
    SEARCH/NEWSGROUPS=(aus.*,anu.*) "Wombats"
@end{verbatim}

@subsection{SEARCH/EDIT}

This qualifier will use an editor in read-only mode to view the newsitem. This
is  useful when it is required to scroll up and down through the item text, or
extract a part of the text into a file.

The default editor is the TPU EDT emulator, but this is user definable - see
the section on customisation.

@subsection{SEARCH/TPU}

This qualifier is equivalent to the /EDIT qualifier.
This qualifier will use an editor in read-only mode to view the newsitem. This
is  useful when it is required to scroll up and down through the item text, or
extract a part of the text into a file.

The default editor is the TPU EDT emulator, but this is user definable - see
the section on customisation.

@subsection{SEARCH/HEADER}

Normally  NEWS  will  suppress  the  display  of  all  network routing headers.
This qualifier produces a full display of the item  contents including mail
header lines.

@subsection{SEARCH/NODISPLAY}

If this qualifier is used, the screen directory will be positioned on the item
which contains the target string, but item text will not be displayed.

@newpage
@section{SCREEN}

This  enters  NEWS  screen  display  mode (the default mode). This command is
normally given sometime after a NOSCREEN command.

@i{See Also} NOSCREEN

@newpage
@section{SELECT}

Format:
@begin{verbatim}
    SELECT

    SELECT newsgroup
@end{verbatim}

SELECT  changes newsgroup context to the nominated newsgroup.  If no newsgroup
is given, the command selects the 'current' newsgroup. Otherwise the specified
newsgroup is opened.

For example, "SELECT test" opens newsgroup 'test'.

@subsection{SELECT/NEW}

This qualifier is used to  select  the  next registered  newsgroup which
contains unread news items. If the current newsgroup contains unread items,
then no action is performed.

@subsection{SELECT/MARK}

Format:
@begin{verbatim}
    SELECT/MARK

    SELECT/MARK=tag
@end{verbatim}

This command moves the current item pointer to the NEXT newsitem marked with
the specified tag value. If no tag value is specified than the next item marked
with any tag is used.

@newpage
@section{SHOW}

@subsection{SHOW KILL}

This command displays the current KILL filter set on the screen.

@subsection{SHOW MARK}

Format:
@begin{verbatim}
    SHOW MARK

    SHOW MARK tag
@end{verbatim}

SHOW MARK displays a listing of the set of marked newsitems. If no tag value is
specified, then all mark tag values are displayed. If a tag is used then only
those tag values which match using wildcard matching are displayed.

@i{See Also} MARK, UNMARK, CLEAR MARK

@newpage
@section{SKIP}

SKIP is used to mark individual newsitems or all newsitems
within a newsgroup as having been read by the user.

If the screen is displaying the newsitem directory, then
SKIP marks the 'current' newsitem as read, and advances the newsitem pointer
to the next newsitem.

If the screen is displaying the newsgroup directory screen, or the
/NEWSGROUP qualifier is specified, then ALL newsitems within
the 'current' newsgroup are marked as
having been read.

@subsection{SKIP/ALL}

This qualifier will mark ALL news items in ALL newsgroups as having been read
by the user.

@subsection{SKIP/POINTER}

This command marks all newsitems up to (and including) the 'current' item as
having been viewed by the user. This qualifier may only refer to the current
newsgroup.

@subsection{SKIP/BEFORE=date}

This command marks all items in the current newsgroup which were created on the
local system before the date specified as having been viewed by the user.

This qualifier may also be used with the /ALL qualifier to mark all items in
all newsgroups, created before the specified date, as having been viewed.

The date format is the standard VMS date-time format; e.g. SKIP/BEFORE=22-FEB.
"TODAY" and "YESTERDAY" are accepted as valid date strings.

@subsection{SKIP/FOLLOWUP}

All newsitems in the current newsgroup with a subject field the same as the
current newsitem will be marked as read.

This command is used to skip entire conversation streams: all newsitems with
related subject fields will be marked as having been read.

@subsection{SKIP/NEWSGROUP}

This qualifier will mark ALL items in the current newsgroup as read. If the
screen is displaying the newsgroup directory then /NEWSGROUP is the default
action - if the screen is displaying the newsitem directory then /NONEWSGROUP
is the default action, and only the current item will be marked

@newpage
@section{SPAWN}

Spawn  a  DCL  level  subprocess  from  NEWS (using LIB$SPAWN). LOGOUT from the
subprocess returns to NEWS.

@newpage
@section{UNMARK}

Format:
@begin{verbatim}
    UNMARK

    UNMARK tag
@end{verbatim}

UNMARK clears the mark from the current news item. If a tag is specified with
the command, then only those tag values will be cleared. If no tag is
specified, then all tags will be removed from the item. The tag may be
specified using wildcard characters.

@i{See Also} MARK, CLEAR MARK, SHOW MARK

@newpage
@section{UNREAD}

This command marks the current item as UNREAD - The item will be remarked again
as unread, and will be displayed at a later stage by the READ/NEW command (if
the item is in a registered newsgroup).

This command is useful to mark items for re-reading at a later stage.

@newpage
@section{UP}

Format:
@begin{verbatim}
    UP [number]
@end{verbatim}

In screen mode this moves the cursor up one line.  The  command  has  an
optional numeric parameter, the number of lines to move up.

This command is bound to the up arrow key on the terminal, and the command UP
18 is bound to the PREV SCREEN key.
@newpage
@section{VERSION}

This command displays the software version and creation date of the local
NEWS software.
@newpage
@section{WRITE}

WRITE is synonomous to the POST command, and is fully documented in the
section describing "POST".

@chapter{Moderated Newsgroups}

This chapter describes how moderated newsgroups are configured and maintained.

A moderated newsgroup is one where posting to the newsgroup is barred to all
users other than the nominated moderator. Only the moderator may post new items
into the newsgroup, and only the original sender, the moderator and the local
system manager may post a cancel referring to an item in a moderated newsgroup. 

Where users attempt to post to a moderated newsgroup, the posting is
automatically re-directed to the newsgroup moderator address as mail addressed
to the moderator's address. 

@section{Management of Moderated Newsgroups}

The local news manager is responsible for defining moderated newsgroups,
and also specifying the address of the moderator. The management commands
are the SET NEWSGROUP and the CREATE commands, specifying the qualifier
/MODERATOR, with the moderator's address as the value of this qualifier.

Some network-wide newsgroups are also moderated newsgroups. This is
managed by the "checkgroups" control message, which specifies
which newsgroups are moderated (but note that this message will not
specify the actual moderator address).

The local specification of moderated newsgroups is held in two areas
of the NEWS database: each newsgroup descriptor contains a flag
indicating whether the newsgroup is moderated or not, and a second file
(the MAILPATHS file) contains the addresses of all newsgroup moderators.

The format of the "mailpaths" file, containing the moderated newsgroup names,
and the internet address of the moderator. However this file does not contain a
comprehensive list of newsgroup moderators for the network-defined newsgroups:
when examining the support structures for the USENET news network, one of the
relevant aspects of the network is the presence on the net of a number of
"backbone" sites. These backbone sites contain an up-to-date list of the
moderators of all network newsgroups, and are also configured to forward all
moderated newsgroup postings on to the correct moderator. The scheme used in
addressing the moderator via a backbone site is one where a posting to the
moderated newsgroup "comp.animals" (say) is directed to the address
"comp-animals@@<backbone_node>". The reserved newsgroup name "backbone" matches
all newsgroups, and the address may contain the string "%s", which requires the
actual newsgroup name to be substituted, with '_' replacing all '.' characters
in the newsgroup name. The scan of the file is first match found.

Once the "mailpaths" file is initialized with the backbone entry, all
further modifications to the file can be performed within NEWS, using
the SET NEWSGROUP command.

@section{POST}

The POST command will normally re-direct all postings to a moderated newsgroup
to the moderator (as mail).

However if the user's internet address (built by using the logical name
translation of NEWS_ADDRESS in the format "<username>@>news_address>") matches
the moderator address, the posting is allowed, and the posted item is marked as
"Approved" so that the item will be distributed correctly through the network. 

@section{ADD BATCH/MODERATOR}

This is a variant of the ADD BATCH command, and is the method whereby a
newsgroup moderator may add new items into the newsgroup. This differs
from the POST command in so far as the "From:" address is preserved as the
original submitter when using the ADD command, whereas POST assumes the posting
was originated by the moderator.

If the orignal submitter posted to a number of moderated newsgroups, then the
procedure will request confirmation to forward the item to the next moderator
in turn, or if the item is already approved by all other moderators the posting
will then be placed in all the moderated newsgroups specified by the original
submitter.

Other optional qualifiers to the ADD command are documented in the
Manager's section of this manual, and are available with the /MODERATOR
qualifier.

@section{CANCEL}

The CANCEL command is also altered by a moderated newsgroup, in so far
as the moderator of the newsgroup may issue the CANCEL command (as well
as the original submitter).
