#module NEWS "V5.6"

/*
**++
**  FACILITY:
**
**      NEWS.C
**
**  ABSTRACT:
**
**      This module contains the main() entry point for the NEWS program.
**
**  AUTHOR:
**
**      Geoff Huston
**
**  COPYRIGHT:
**
**      Copyright  1988
**
**  MODIFICATION HISTORY:
**  Version History:
**      V1.0    17-Jul-1986
**      V2.0    31-Jan-1987
**      V3.0     6-Apr-1987
**      V4.0    30-Oct-1987
**      V4.02   17-Nov-1987
**      V4.3    11-Jan-1988
**      V5.0     2-Feb-1988
**      V5.1     9-Mar-1988
**      V5.2    26-Apr-1988
**      V5.3    16-Jun-1988     GIH
**      V5.5     7-Oct-1988     GIH
**          Check for existance of NEWS_INI keypad def'n file before attempting
**          a load of the file.
**      V5.6    11-Nov-1988     GIH
**          Correct the resetting of the screen following display of
**          data using NEWSDISPLAY routines - add deletion of shdid display.
**--
**/

#include "newsinclude.h"
#include "newsdefine.h"

#define extrnl
#define iev(v)  = v
#define iv(v)   v
#include "newsvariables.h"

$DESCRIPTOR(command,response);

globalref int newscmd;

/*----------------------------------------------------------------------
 *  m a i n
 *
 *  MAIN PROGRAM
 *----------------------------------------------------------------------
 */

main(argc,argv)
    int argc;
    char *argv[];
{
    unsigned short temp_len;
    char temp[132],
         mcommand[150];
    $DESCRIPTOR(tempdsc,temp);
    FILE *fpr;

    int cmd_status,
        one_pass = 0,
        cli_catch();

    do_version();
    nosysprv();
    printf("\tLinking to NEWS database...\n\n");
    site_get_env();
    VAXC$ESTABLISH(cli_catch);
    _c$cks(smg$create_virtual_keyboard(&kid,0,0,0));
    _c$cks(smg$create_key_table(&keytab));
    create_keydefs();

    if (fpr = fopen(News_ini,"r")) {
        fclose(fpr);
        smg$load_key_defs(&keytab,c$dsc(News_ini),0,c$rfi(1));
        }
    openfiles();
    *fp_open = '\0';

    lib$get_foreign(&tempdsc,0,&temp_len,0);
    temp[temp_len] = '\0';
    strcpy(mcommand,"INVOKENEWS ");
    strcat(mcommand,temp);
    cli$dcl_parse(c$dsc(mcommand),&newscmd);
    if (cli$present(c$dsc("SCREEN")) & 1) create_pb();
    if (pid_created) init_screen();
    reg_context();

    if (1 & cli$get_value(c$dsc("COMMAND"),&command,&response_length)) {
        one_pass = 1;
        status = 1;
        }

    for (;;) {
        cmd_status = setjmp(env);
        if ((one_pass) && (one_pass++ > 1)) break;
        c$cks(1);
        if (*fp_open) {
            fclose(fp);
            if (*fp_open > 1) while (!(delete(fp_open)));
            *fp_open = '\0';
            }
        if (screen_active) {
            smg$erase_display(&trailer_vd,c$rfi(1),c$rfi(6),c$rfi(2),c$rfi(80));
            brdcst_col = 7;
            display_brdcst(2);
            brdcst_line = 2;
            smg$set_cursor_abs(&trailer_vd,c$rfi(1),c$rfi(1));
            }
        if ((cmd_status != 2) && (!one_pass)) {
            if (screen_active) {
                if ((news_context == 1) && (cur_dir_type == DIR_NEW)) dirnew_check();
                smg$end_pasteboard_update(&pid);
                }
            cmd_status = smg$read_composed_line(&kid,&keytab,&command,c$dsc("NEWS> "),&response_length,((screen_active) ? (&trailer_vd) : (0)));
            if (cmd_status == SMG$_EOF) cmd_status = RMS$_EOF;
            if (screen_active) smg$begin_pasteboard_update(&pid);
            }
        else cmd_status = status;
        brdcst_line = 0;
        if (cmd_status == RMS$_EOF) break;
        response[response_length] = '\0';
        if ((response_length > 2) && (toupper(*response) == 'R') && (toupper(*(response + 1)) == 'E') && (toupper(*(response + 2)) == 'F')) do_refresh();
        else {
            old_context = news_context;
            if (news_context == 3) set_level(2);
            else if (text_displayed) {
                smg$unpaste_virtual_display(&sdid,&pid);
                smg$unpaste_virtual_display(&shdid,&pid);
                text_displayed = 0;
                }
            clear_err_line();
            if (do_parse(response)) break;
            }
        }
    closefiles();
}
